/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.GraphicsHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NestedBlockLayout
implements LayoutManager2,
Cloneable {
    private static final SAXException DONE = new SAXException("");
    private static final SAXParser PARSER = NestedBlockLayout.getSaxParser();
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private boolean invalidated = true;
    private Block root;
    private Set<Component> components = new HashSet<Component>();

    private static SAXParser getSaxParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException | SAXException t) {
            Logger.getLogger("ancestris.util.swing").log(Level.SEVERE, "Can't initialize SAX parser", t);
            throw new Error("Can't initialize SAX parser", t);
        }
    }

    private NestedBlockLayout(Block root) {
        this.root = root;
    }

    public NestedBlockLayout(String descriptor) {
        this.init(new StringReader(descriptor));
    }

    public NestedBlockLayout(Reader descriptor) {
        this.init(descriptor);
    }

    public NestedBlockLayout(InputStream descriptor) {
        this.init(new InputStreamReader(descriptor));
    }

    public Collection<Cell> getCells() {
        return this.root.getCells(new ArrayList<Cell>(10));
    }

    private void init(Reader descriptor) {
        try {
            PARSER.parse(new InputSource(descriptor), (DefaultHandler)new DescriptorHandler());
        }
        catch (SAXException sax) {
            if (DONE == sax) {
                return;
            }
            throw new RuntimeException(sax);
        }
        catch (IOException ioe) {
            LOG.log(Level.FINE, "Should not happen", ioe);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object key) {
        if (this.components.contains(comp)) {
            throw new IllegalArgumentException("already added");
        }
        List<Block> path = this.root.setContent(key, comp, new ArrayList<Block>());
        if (!path.isEmpty()) {
            this.components.add(comp);
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("no available descriptor element - element qualifier required");
        }
        throw new IllegalArgumentException("element qualifier doesn't match any descriptor element");
    }

    @Override
    public void addLayoutComponent(String element, Component comp) {
        this.addLayoutComponent(comp, element);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.root.removeContent(comp);
        this.components.remove(comp);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        if (!this.invalidated) {
            this.root.invalidate(true);
            this.invalidated = true;
            for (Component c : target.getComponents()) {
                if (this.components.contains(c)) continue;
                this.addLayoutComponent(c, null);
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension result = this.root.preferred();
        Insets insets = parent.getInsets();
        result.width += insets.left + insets.right;
        result.height += insets.top + insets.bottom;
        return result;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Rectangle in = new Rectangle(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
        this.root.layout(in);
        this.invalidated = false;
    }

    public NestedBlockLayout copy() {
        try {
            NestedBlockLayout clone = (NestedBlockLayout)super.clone();
            clone.root = clone.root.clone();
            clone.components = new HashSet<Component>();
            clone.invalidated = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    private static abstract class Block
    implements Cloneable {
        Insets padding = this instanceof Cell ? new Insets(1, 1, 1, 1) : new Insets(0, 0, 0, 0);
        private Dimension preferred;
        Point weight;
        Point grow = new Point();
        int cols = 1;

        Block(Attributes attributes) {
            String pad;
            String gy;
            String gx;
            if (attributes == null) {
                return;
            }
            String c = attributes.getValue("cols");
            if (c != null) {
                this.cols = Integer.parseInt(c);
                if (this.cols <= 0) {
                    throw new IllegalArgumentException("cols<=0");
                }
            }
            if ((gx = attributes.getValue("gx")) != null) {
                int n = this.grow.x = Integer.parseInt(gx) > 0 ? 1 : 0;
            }
            if ((gy = attributes.getValue("gy")) != null) {
                int n = this.grow.y = Integer.parseInt(gy) > 0 ? 1 : 0;
            }
            if ((pad = attributes.getValue("pad")) != null) {
                String[] pads = pad.split(",");
                switch (pads.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.padding.set(Integer.parseInt(pads[0]), Integer.parseInt(pads[0]), Integer.parseInt(pads[0]), Integer.parseInt(pads[0]));
                        break;
                    }
                    case 2: {
                        this.padding.set(Integer.parseInt(pads[0]), Integer.parseInt(pads[1]), Integer.parseInt(pads[0]), Integer.parseInt(pads[1]));
                        break;
                    }
                    case 3: {
                        this.padding.set(Integer.parseInt(pads[0]), Integer.parseInt(pads[1]), Integer.parseInt(pads[2]), Integer.parseInt(pads[1]));
                        break;
                    }
                    case 4: {
                        this.padding.set(Integer.parseInt(pads[0]), Integer.parseInt(pads[1]), Integer.parseInt(pads[2]), Integer.parseInt(pads[3]));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid padding " + pad + " given (" + attributes + ")");
                    }
                }
            }
        }

        protected Block clone() {
            try {
                return (Block)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new Error();
            }
        }

        abstract boolean removeContent(Component var1);

        abstract Block add(Block var1);

        void invalidate(boolean recurse) {
            this.preferred = null;
            this.weight = null;
        }

        abstract Point weight();

        Point grow() {
            return this.grow;
        }

        final Dimension preferred() {
            if (this.preferred == null) {
                this.preferred = this.preferredImpl();
                if (this.preferred.width > 0 && this.preferred.height > 0) {
                    this.preferred.width += this.padding.left + this.padding.right;
                    this.preferred.height += this.padding.top + this.padding.bottom;
                }
            }
            return this.preferred;
        }

        abstract Dimension preferredImpl();

        final void layout(Rectangle in) {
            Rectangle avail = new Rectangle(in);
            avail.x += this.padding.left;
            avail.width -= this.padding.left + this.padding.right;
            avail.y += this.padding.top;
            avail.height -= this.padding.top + this.padding.bottom;
            this.layoutImpl(avail);
        }

        abstract void layoutImpl(Rectangle var1);

        abstract Collection<Cell> getCells(Collection<Cell> var1);

        abstract List<Block> setContent(Object var1, Component var2, List<Block> var3);

        public String toString() {
            StringBuilder result = new StringBuilder();
            this.toString(result);
            return result.toString();
        }

        protected abstract void toString(StringBuilder var1);
    }

    private class DescriptorHandler
    extends DefaultHandler {
        private Stack<Block> stack = new Stack();

        private DescriptorHandler() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            throw new IllegalArgumentException("Request for resolveEntity " + publicId + "/" + systemId + " not allowed in layout descriptor");
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            boolean startsWithSpace = Character.isWhitespace(ch[start]);
            boolean endsWithSpace = Character.isWhitespace(ch[start + length - 1]);
            while (length > 0 && Character.isWhitespace(ch[start])) {
                ++start;
                --length;
            }
            while (length > 0 && Character.isWhitespace(ch[start + length - 1])) {
                --length;
            }
            if (length == 0) {
                return;
            }
            if (startsWithSpace) {
                --start;
                ++length;
            }
            if (endsWithSpace) {
                ++length;
            }
            String s = new String(ch, start, length);
            Block parent = this.stack.peek();
            parent.add(new Cell(s));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Block block = this.getBlock(qName, attributes);
            if (this.stack.isEmpty()) {
                NestedBlockLayout.this.root = block;
            } else {
                Block parent = this.stack.peek();
                parent.add(block);
            }
            this.stack.add(block);
        }

        private Block getBlock(String element, Attributes attrs) {
            if ("row".equals(element)) {
                return new Row(attrs);
            }
            if ("col".equals(element)) {
                return new Column(attrs);
            }
            if ("table".equals(element)) {
                return new Table(attrs);
            }
            return new Cell(element, attrs);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.stack == null || this.stack.isEmpty()) {
                throw new SAXException("unexpected /element");
            }
            this.stack.pop();
            if (this.stack.isEmpty()) {
                throw DONE;
            }
        }
    }

    public static class Expander
    extends JLabel {
        private String expandedLabel;
        private String collapsedLabel;
        private static final Icon FOLDED = GraphicsHelper.getIcon(8, Expander.collapsed(8));
        private static final Icon UNFOLDED = GraphicsHelper.getIcon(8, Expander.open(8));
        private boolean isCollapsed = false;
        private int indent = 1;

        private static Shape collapsed(int size) {
            GeneralPath shape = new GeneralPath();
            shape.moveTo(size / 4, 0.0f);
            shape.lineTo(size / 4, size + 1);
            shape.lineTo(size * 3 / 4, size / 2);
            shape.closePath();
            return shape;
        }

        private static Shape open(int size) {
            GeneralPath shape = new GeneralPath();
            shape.moveTo(0.0f, size / 4);
            shape.lineTo(size, size / 4);
            shape.lineTo(size / 2, size * 3 / 4);
            shape.closePath();
            return shape;
        }

        public Expander(String expandedLabel, String collapsedLabel) {
            this(expandedLabel, collapsedLabel, 1);
        }

        public Expander(String label) {
            this(label, 1);
        }

        public Expander(String label, int indent) {
            this(label, label, indent);
        }

        public Expander(String expandedLabel, String collapsedLabel, int indent) {
            super(expandedLabel);
            this.collapsedLabel = collapsedLabel;
            this.expandedLabel = expandedLabel;
            this.indent = Math.max(1, indent);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new Mouser());
        }

        public int getIndent() {
            return this.indent;
        }

        public void setCollapsed(boolean set) {
            this.isCollapsed = set;
            this.setText(this.isCollapsed ? this.collapsedLabel : this.expandedLabel);
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        @Override
        public Icon getIcon() {
            return this.isCollapsed ? FOLDED : UNFOLDED;
        }

        private class Mouser
        extends MouseAdapter {
            private Mouser() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Expander.this.setCollapsed(!Expander.this.isCollapsed);
                Expander.this.firePropertyChange("folded", !Expander.this.isCollapsed, Expander.this.isCollapsed);
                Container parent = Expander.this.getParent();
                if (parent instanceof JComponent) {
                    ((JComponent)parent).revalidate();
                } else {
                    ((Component)parent).invalidate();
                    ((Component)parent).validate();
                }
            }
        }
    }

    private static class Table
    extends Folder {
        private ArrayList<Integer> rowHeights;
        private ArrayList<Integer> colWidths;
        private ArrayList<Integer> rowWeights;
        private ArrayList<Integer> colWeights;

        Table(Attributes attrs) {
            super(attrs);
        }

        private void calcGrid() {
            Dimension d;
            int c;
            Block cell;
            List<Object> cells;
            Block row;
            int r;
            if (this.rowHeights != null) {
                return;
            }
            this.rowHeights = new ArrayList();
            this.colWidths = new ArrayList();
            this.rowWeights = new ArrayList();
            this.colWeights = new ArrayList();
            for (r = 0; r < this.subs.size(); ++r) {
                row = (Block)this.subs.get(r);
                cells = row instanceof Row ? ((Row)row).subs : Collections.singletonList(row);
                for (c = 0; c < cells.size(); c += cell.cols) {
                    cell = (Block)cells.get(c);
                    d = cell.preferred();
                    if (cell.cols == 1) {
                        this.grow(this.colWidths, c, d.width);
                    }
                    this.grow(this.rowHeights, r, d.height);
                    Point w = cell.weight();
                    if (cell.cols == 1) {
                        this.grow(this.colWeights, c, w.x);
                    }
                    this.grow(this.rowWeights, r, w.y);
                }
            }
            for (r = 0; r < this.subs.size(); ++r) {
                row = (Block)this.subs.get(r);
                cells = row instanceof Row ? ((Row)row).subs : Collections.singletonList(row);
                for (c = 0; c < cells.size(); c += cell.cols) {
                    cell = (Block)cells.get(c);
                    d = cell.preferred();
                    if (cell.cols == 1) continue;
                    int spannedWeight = 0;
                    int spannedWidth = 0;
                    if (c + cell.cols > this.colWidths.size()) {
                        throw new IllegalArgumentException("cols out of bounds for " + cell);
                    }
                    for (int j = 0; j < cell.cols; ++j) {
                        spannedWidth += this.colWidths.get(c + j).intValue();
                        spannedWeight += this.colWeights.get(c + j).intValue();
                    }
                    if (spannedWidth >= d.width) continue;
                    int missing = d.width - spannedWidth;
                    for (int j = 0; j < cell.cols; ++j) {
                        int share = spannedWeight > 0 ? missing * this.colWeights.get(c + j) / spannedWeight : missing / cell.cols;
                        this.grow(this.colWidths, c + j, this.colWidths.get(c + j) + share);
                    }
                }
            }
        }

        @Override
        void layoutFolder(Rectangle in) {
            Dimension preferred = this.preferred();
            this.calcGrid();
            float xWeightMultiplier = 0.0f;
            if (in.width > preferred.width) {
                int w = 0;
                for (int i = 0; i < this.colWeights.size(); ++i) {
                    w += this.colWeights.get(i).intValue();
                }
                xWeightMultiplier = (float)(in.width - preferred.width) / (float)w;
            }
            float yWeightMultiplier = 0.0f;
            if (in.height > preferred.height) {
                int h = 0;
                for (int i = 0; i < this.rowWeights.size(); ++i) {
                    h += this.rowWeights.get(i).intValue();
                }
                yWeightMultiplier = (float)(in.height - preferred.height) / (float)h;
            }
            Rectangle avail = new Rectangle(in.x, in.y, in.width, in.height);
            for (int r = 0; r < this.subs.size(); ++r) {
                Block row = (Block)this.subs.get(r);
                ArrayList cells = row instanceof Row ? ((Row)row).subs : Collections.singletonList(row);
                int x = avail.x;
                int h = this.rowHeights.get(r) + (int)((float)this.rowWeights.get(r).intValue() * yWeightMultiplier);
                int c = 0;
                while (c < cells.size()) {
                    Block sub = (Block)cells.get(c);
                    int w = 0;
                    int i = 0;
                    while (i < sub.cols) {
                        w += this.colWidths.get(c) + (int)((float)this.colWeights.get(c).intValue() * xWeightMultiplier);
                        ++i;
                        ++c;
                    }
                    w = Math.min(avail.x + avail.width - x, w);
                    sub.layout(new Rectangle(x, avail.y, w, h));
                    x += w;
                }
                avail.y += h;
            }
        }

        private void grow(ArrayList<Integer> values, int i, Integer value) {
            while (values.size() < i + 1) {
                values.add(0);
            }
            values.set(i, Math.max(values.get(i), value));
        }

        @Override
        Dimension preferredFolder() {
            this.calcGrid();
            Dimension result = new Dimension(0, 0);
            for (int c = 0; c < this.colWidths.size(); ++c) {
                result.width += this.colWidths.get(c).intValue();
            }
            for (int r = 0; r < this.rowHeights.size(); ++r) {
                result.height += this.rowHeights.get(r).intValue();
            }
            return result;
        }

        @Override
        Point weightFolder() {
            this.calcGrid();
            Point result = new Point(0, 0);
            for (int c = 0; c < this.colWeights.size(); ++c) {
                result.x += this.colWeights.get(c).intValue();
            }
            for (int r = 0; r < this.rowWeights.size(); ++r) {
                result.y += this.rowWeights.get(r).intValue();
            }
            return result;
        }

        @Override
        void invalidate(boolean recurse) {
            super.invalidate(recurse);
            this.rowHeights = null;
            this.colWidths = null;
            this.rowWeights = null;
            this.colWeights = null;
        }
    }

    public static class Cell
    extends Block {
        private String element;
        private Map<String, String> attrs = new HashMap<String, String>();
        private Component component;
        private Point cellWeight = new Point();
        private Point2D.Double cellAlign = new Point2D.Double(0.0, 0.5);

        private Cell(String text) {
            super(null);
            this.element = "text";
            this.attrs.put("value", text);
        }

        private Cell(String element, Attributes attributes) {
            super(attributes);
            String ay;
            String ax;
            String wy;
            this.element = element;
            int j = attributes.getLength();
            for (int i = 0; i < j; ++i) {
                this.attrs.put(attributes.getQName(i), attributes.getValue(i));
            }
            String wx = this.getAttribute("wx");
            if (wx != null) {
                this.cellWeight.x = Integer.parseInt(wx);
                if (attributes.getValue("gx") == null) {
                    this.grow.x = 1;
                }
            }
            if ((wy = this.getAttribute("wy")) != null) {
                this.cellWeight.y = Integer.parseInt(wy);
                if (attributes.getValue("gy") == null) {
                    this.grow.y = 1;
                }
            }
            if ((ax = this.getAttribute("ax")) != null) {
                this.cellAlign.x = Float.parseFloat(ax);
            }
            if ((ay = this.getAttribute("ay")) != null) {
                this.cellAlign.y = Float.parseFloat(ay);
            }
        }

        @Override
        protected Block clone() {
            Cell clone = (Cell)super.clone();
            clone.component = null;
            return clone;
        }

        public String getElement() {
            return this.element;
        }

        public boolean isAttribute(String attr) {
            return this.attrs.containsKey(attr);
        }

        public String getAttribute(String attr) {
            return this.attrs.get(attr);
        }

        @Override
        boolean removeContent(Component component) {
            if (this.component == component) {
                this.component = null;
                this.invalidate(false);
                return true;
            }
            return false;
        }

        @Override
        Dimension preferredImpl() {
            if (this.component == null || !this.component.isVisible()) {
                return new Dimension();
            }
            Dimension result = new Dimension(this.component.getPreferredSize());
            Dimension max = this.component.getMaximumSize();
            result.width = Math.min(max.width, result.width);
            result.height = Math.min(max.height, result.height);
            return result;
        }

        @Override
        protected void toString(StringBuilder result) {
            result.append("<cell ");
            result.append(this.attrs);
            result.append("/>");
        }

        @Override
        Point weight() {
            return this.component == null ? new Point() : this.cellWeight;
        }

        @Override
        void layoutImpl(Rectangle in) {
            if (this.component == null) {
                return;
            }
            Rectangle avail = new Rectangle(in.x, in.y, in.width, in.height);
            Dimension max = this.component.getMaximumSize();
            if (avail.width > max.width) {
                int extraX = avail.width - max.width;
                avail.x = (int)((double)avail.x + (double)extraX * this.cellAlign.x);
                avail.width = max.width;
            }
            if (avail.height > max.height) {
                int extraY = avail.height - max.height;
                avail.y = (int)((double)avail.y + (double)extraY * this.cellAlign.y);
                avail.height = max.height;
            }
            this.component.setBounds(avail);
        }

        @Override
        List<Block> setContent(Object key, Component component, List<Block> path) {
            if (key instanceof Cell && key != this || key instanceof String && (!this.element.equals(key) || this.component != null) || key == null && this.component != null) {
                return path;
            }
            if (this.component != null) {
                throw new IllegalArgumentException("can't set component twice");
            }
            this.component = component;
            path.add(this);
            return path;
        }

        @Override
        Collection<Cell> getCells(Collection<Cell> collect) {
            collect.add(this);
            return collect;
        }

        @Override
        Block add(Block block) {
            throw new IllegalArgumentException("cell.add() not supported");
        }
    }

    private static class Column
    extends Folder {
        Column(Attributes attr) {
            super(attr);
        }

        @Override
        Dimension preferredFolder() {
            Dimension result = new Dimension();
            for (int i = 0; i < this.subs.size(); ++i) {
                Dimension sub = ((Block)this.subs.get(i)).preferred();
                result.width = Math.max(result.width, sub.width);
                result.height += sub.height;
            }
            return result;
        }

        @Override
        Point weightFolder() {
            Point result = new Point();
            for (int i = 0; i < this.subs.size(); ++i) {
                Point sub = ((Block)this.subs.get(i)).weight();
                result.x = Math.max(result.x, sub.x);
                result.y += sub.y;
            }
            return result;
        }

        @Override
        void layoutFolder(Rectangle in) {
            double localWeight = 0.0;
            int spare = in.height;
            int localGrow = 0;
            for (Block sub : this.subs) {
                spare -= sub.preferred().height;
                localWeight += sub.weight().getY();
                localGrow += sub.grow().y;
            }
            double weightFactor = localWeight > 0.0 ? (double)spare / localWeight : 0.0;
            int growFactor = weightFactor == 0.0 && localGrow > 0 ? spare / localGrow : 0;
            Rectangle avail = new Rectangle(in.x, in.y, 0, 0);
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                avail.x = in.x;
                avail.width = in.width;
                avail.height = sub.preferred().height + (int)(sub.weight().getY() * weightFactor) + sub.grow().y * growFactor;
                sub.layout(avail);
                avail.y += avail.height;
            }
        }
    }

    private static abstract class Folder
    extends Block {
        protected transient Expander expander = null;
        ArrayList<Block> subs = new ArrayList(16);

        protected Folder(Attributes attr) {
            super(attr);
        }

        @Override
        Block add(Block block) {
            this.subs.add(block);
            this.invalidate(false);
            return block;
        }

        @Override
        protected void toString(StringBuilder result) {
            result.append('<').append(this.getClass().getSimpleName()).append('>');
            for (int i = 0; i < this.subs.size(); ++i) {
                this.subs.get(i).toString(result);
            }
            result.append("</").append(this.getClass().getSimpleName()).append('>');
        }

        @Override
        protected Folder clone() {
            Folder clone = (Folder)super.clone();
            clone.subs = new ArrayList(this.subs.size());
            for (int i = 0; i < this.subs.size(); ++i) {
                clone.subs.add(this.subs.get(i).clone());
            }
            return clone;
        }

        @Override
        boolean removeContent(Component component) {
            if (this.expander == component) {
                this.expander = null;
            }
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = this.subs.get(i);
                if (!sub.removeContent(component)) continue;
                this.invalidate(false);
                return true;
            }
            return false;
        }

        @Override
        void invalidate(boolean recurse) {
            super.invalidate(recurse);
            if (recurse) {
                for (int i = 0; i < this.subs.size(); ++i) {
                    this.subs.get(i).invalidate(true);
                }
            }
        }

        @Override
        Collection<Cell> getCells(Collection<Cell> collect) {
            for (int i = 0; i < this.subs.size(); ++i) {
                this.subs.get(i).getCells(collect);
            }
            return collect;
        }

        @Override
        List<Block> setContent(Object key, Component component, List<Block> path) {
            int lastKeyMatch = -1;
            for (int i = 0; i < this.subs.size(); ++i) {
                int indent;
                Block sub = this.subs.get(i);
                if (sub instanceof Cell && key instanceof String && key.equals(((Cell)sub).element)) {
                    lastKeyMatch = i;
                }
                if (sub.setContent(key, component, path).isEmpty()) continue;
                path.add(this);
                if (component instanceof Expander && (indent = ((Expander)component).getIndent()) < path.size() && path.get(indent) == this) {
                    this.expander = (Expander)component;
                }
                return path;
            }
            if (lastKeyMatch >= 0) {
                Block clone = this.subs.get(lastKeyMatch).clone();
                this.subs.add(lastKeyMatch + 1, clone);
                clone.setContent(key, component, path);
                path.add(this);
                return path;
            }
            return path;
        }

        @Override
        final Dimension preferredImpl() {
            if (this.expander != null && this.expander.isCollapsed) {
                return this.expander.getPreferredSize();
            }
            return this.preferredFolder();
        }

        abstract Dimension preferredFolder();

        @Override
        final Point grow() {
            return this.expander != null && this.expander.isCollapsed ? new Point() : this.grow;
        }

        @Override
        final Point weight() {
            if (this.expander != null && this.expander.isCollapsed) {
                return new Point();
            }
            if (this.weight != null) {
                return this.weight;
            }
            this.weight = this.weightFolder();
            return this.weight;
        }

        abstract Point weightFolder();

        @Override
        final void layoutImpl(Rectangle in) {
            if (this.expander != null && this.expander.isCollapsed) {
                for (Block sub : this.subs) {
                    sub.layout(new Rectangle(0, 0));
                }
                Dimension d = this.expander.getPreferredSize();
                this.expander.setBounds(in.x, in.y, d.width, d.height);
                return;
            }
            this.layoutFolder(in);
        }

        abstract void layoutFolder(Rectangle var1);
    }

    private static class Row
    extends Folder {
        Row(Attributes attr) {
            super(attr);
        }

        @Override
        Dimension preferredFolder() {
            Dimension result = new Dimension();
            for (int i = 0; i < this.subs.size(); ++i) {
                Dimension sub = ((Block)this.subs.get(i)).preferred();
                result.width += sub.width;
                result.height = Math.max(result.height, sub.height);
            }
            return result;
        }

        @Override
        Point weightFolder() {
            Point result = new Point();
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                result.x += sub.weight().x;
                result.y = Math.max(result.y, sub.weight().y);
            }
            return result;
        }

        @Override
        void layoutFolder(Rectangle in) {
            double localWeight = 0.0;
            int localGrow = 0;
            int spare = in.width;
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                spare -= sub.preferred().width;
                localWeight += sub.weight().getX();
                localGrow += sub.grow().x;
            }
            double weightFactor = localWeight > 0.0 ? (double)spare / localWeight : 0.0;
            int growFactor = weightFactor == 0.0 && localGrow > 0 ? spare / localGrow : 0;
            Rectangle avail = new Rectangle(in.x, in.y, 0, 0);
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                avail.width = sub.preferred().width + (int)(sub.weight().getX() * weightFactor) + sub.grow().x * growFactor;
                avail.height = in.height;
                sub.layout(avail);
                avail.x += avail.width;
            }
        }
    }
}

