/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.reports.gedart.GedartTemplate;
import genj.util.EnvironmentChecker;
import genj.util.PackageUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.openide.util.Exceptions;

class GedartTemplates
extends TreeMap<String, GedartTemplate> {
    public GedartTemplates() {
        File dir = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/gedart/contrib-templates", (String)"?", (String)"Looking for gedart/contrib-templates"));
        if (dir.exists()) {
            GedartTemplates.deleteFolder(dir);
            dir.mkdirs();
        } else {
            dir.mkdirs();
        }
        File dest = null;
        String PCKNAME = "ancestris.reports.gedart.templates";
        try {
            for (String res : PackageUtils.findInPackage((String)"ancestris.reports.gedart.templates", (Pattern)Pattern.compile("([^\\s]+((\\.(?i)(txt|properties|vm|jpg))$|\\/$))"))) {
                String name = res.substring("ancestris.reports.gedart.templates".length() + 1);
                if (name.endsWith(".")) {
                    File subdir = new File(dir + File.separator + name.substring(0, name.length() - 1));
                    if (subdir.exists()) continue;
                    subdir.mkdirs();
                    continue;
                }
                name = name.replaceFirst("\\.", "\\/");
                URL inputUrl = GedartTemplates.class.getResource("/" + "ancestris.reports.gedart.templates".replace('.', '/') + "/" + name);
                dest = new File(dir + File.separator + name);
                FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.putAll(new GedartTemplates(dir));
        dir = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/gedart/templates", (String)"?", (String)"Looking for gedart/templates"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.putAll(new GedartTemplates(dir));
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    GedartTemplates.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public GedartTemplates(File dir) {
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                GedartTemplate t = GedartTemplate.create(file);
                if (t == null) continue;
                this.put(t.getName(), t);
            }
        }
    }

    public GedartTemplate[] toArray() {
        return this.values().toArray(new GedartTemplate[0]);
    }

    public GedartTemplate[] toArray(Object context) {
        ArrayList<GedartTemplate> result = new ArrayList<GedartTemplate>(5);
        String ctx = context.getClass().getSimpleName();
        for (GedartTemplate ga : this.values()) {
            if (ga.getDescription(ctx) == null) continue;
            try {
                GedartTemplate _ga = ga.clone();
                _ga.setDescription(ga.getDescription(ctx));
                result.add(_ga);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return result.toArray(new GedartTemplate[0]);
    }
}

