/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class WebIndividuals
extends WebSection {
    final List<String> lastNames;

    public WebIndividuals(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
        this.lastNames = this.wh.getLastNames("_", this.sortLastnames);
    }

    public void init() {
        this.init(this.trs("TXT_Individualslist"), "persons", "persons_", this.formatFromSize(this.wh.getNbIndis()), 1, this.sizeIndiSection * 2);
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        this.calcLetters();
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        List<Indi> indis = this.wh.getIndividuals(this.wh.gedcom, this.sortIndividuals);
        char previousLetter = ' ';
        String previousLastName = "";
        Object previousListFile = "";
        PrintWriter out = null;
        boolean first = true;
        int iNames = -1;
        HashSet anchorNames = new HashSet();
        this.lastNames.forEach(name -> anchorNames.add(this.htmlAnchorText((String)name)));
        int nbNames = anchorNames.size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbNames / this.nbPerPage + 1;
        Object listfile = "";
        for (Indi indi : indis) {
            boolean writeLetter;
            boolean writeAnchor;
            String lastName = this.wh.getLastName(indi, "_");
            if (lastName.toUpperCase().compareTo(previousLastName) != 0) {
                previousLastName = lastName.toUpperCase();
                ++iNames;
                writeAnchor = true;
            } else {
                writeAnchor = false;
            }
            String anchorLastName = this.htmlAnchorText(lastName);
            char cLetter = anchorLastName.charAt(0);
            if (cLetter != previousLetter) {
                previousLetter = cLetter;
                writeLetter = true;
            } else {
                writeLetter = false;
            }
            currentPage = iNames / this.nbPerPage + 1;
            previousPage = currentPage == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            listfile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (((String)previousListFile).compareTo((String)listfile) != 0) {
                if (out != null) {
                    out.println("</p>");
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 1, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    this.wh.log.write((String)previousListFile + this.trs("EXEC_DONE"));
                    out.close();
                }
                previousListFile = listfile;
                File file = this.wh.getFileForName(dir, (String)listfile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Individualslist", this);
                out.println("<p class=\"letters\">");
                out.println("<br /><br />");
                for (WebSection.Letters l : WebSection.Letters.values()) {
                    if (this.checkLink(l.toString())) {
                        out.println("<a href=\"" + (String)this.linkForLetter.get(l.toString()) + "#" + l + "\">" + l + "</a>&nbsp;&nbsp;");
                        continue;
                    }
                    out.println(l + "&nbsp;&nbsp;");
                }
                if (this.checkLink("_")) {
                    out.println("<a href=\"" + (String)this.linkForLetter.get("_") + "#_\">_</a>&nbsp;&nbsp;");
                } else {
                    out.println("_&nbsp;&nbsp;");
                }
                out.println("<br /><br /></p>");
                if (!writeLetter) {
                    this.exportLinks(out, (String)listfile, 1, previousPage, nextPage, lastPage);
                    out.println("<p>");
                }
            }
            if (out == null) continue;
            if (writeLetter) {
                if (!first) {
                    out.println("</p>");
                }
                first = false;
                this.exportLinks(out, (String)listfile, 1, previousPage, nextPage, lastPage);
                String ancLet = String.valueOf(previousLetter);
                if (!ancLet.matches("[a-zA-Z]")) {
                    ancLet = "_";
                }
                out.println("<p class=\"letter\"><a id=\"" + ancLet + "\"></a>" + ancLet + "</p>");
                out.println("<p>");
            }
            if (writeAnchor) {
                out.println("<a id=\"" + this.htmlAnchorText(this.wh.getLastName(indi, "_")) + "\"></a>");
            }
            out.println(this.wrapEntity((Entity)indi));
            out.println("<br />");
        }
        if (out != null) {
            out.println("</p>");
            this.exportLinks(out, (String)listfile, 1, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write((String)previousListFile + this.trs("EXEC_DONE"));
            out.close();
        }
    }

    private void calcLetters() {
        this.linkForLetter.put("_", "0");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            this.linkForLetter.put(l.toString(), "0");
        }
        char letter = ' ';
        String name = "";
        int iNames = 0;
        for (String lastname : this.lastNames) {
            String str = this.htmlAnchorText(lastname);
            if (str == null || str.compareTo(name) == 0) continue;
            String listfile = this.sectionPrefix + String.format(this.formatNbrs, iNames / this.nbPerPage + 1) + this.sectionSuffix;
            this.namePage.put(str, listfile);
            name = str;
            ++iNames;
            char cLetter = str.charAt(0);
            if (cLetter == letter) continue;
            letter = cLetter;
            String l = String.valueOf(letter);
            this.linkForLetter.put(l, listfile);
        }
    }

    public Map<String, String> getPagesMap() {
        return this.namePage;
    }

    private boolean checkLink(String str) {
        String flag = (String)this.linkForLetter.get(str);
        return flag != null && flag.compareTo("0") != 0;
    }
}

