/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.transfer;

import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.WebBookStarter;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.transfer.FTPRegister;
import ancestris.modules.webbook.transfer.FTPUpload;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class FTPLoader {
    private Log log = null;
    private static RequestProcessor RP = null;
    private RequestProcessor.Task theTask = null;
    private FTPUpload ftpu = null;
    public String localfile;
    public String targetfile;
    private String host = "";
    private String user = "";
    private String password = "";
    private File localdir = null;
    private String targetdir = "";
    private FTPRegister uploadRegister = null;
    private String shell = "";

    public FTPLoader(WebBookParams wp, WebHelper wh, FTPRegister uploadRegister) {
        this.host = wp.param_FTP_site;
        this.user = wp.param_FTP_user;
        this.password = wp.param_FTP_password;
        this.localdir = wh.getDir();
        this.targetdir = wp.param_FTP_dir;
        this.uploadRegister = uploadRegister;
        this.shell = wp.param_FTP_exec;
        this.log = new Log(wp.param_FTP_log, NbBundle.getMessage(WebBookStarter.class, (String)"OpenIDE-Module-Name") + "_" + NbBundle.getMessage(FTPLoader.class, (String)"EXEC_uploading") + " " + wh.gedcom.getName());
    }

    public synchronized void run() {
        final ProgressHandle ph = ProgressHandle.createHandle((String)NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecution"), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return FTPLoader.this.handleCancel();
            }
        });
        Runnable runnable = () -> {
            ph.start();
            this.log.timeStamp();
            this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionStart"));
            List<File> localFiles = this.getFilesRecursively(this.localdir);
            Collections.sort(localFiles);
            this.ftpu = new FTPUpload(this.host, this.user, this.password, localFiles, this.localdir.getAbsolutePath(), this.targetdir, this.log, this.uploadRegister, ph);
            this.ftpu.run();
            if (this.log.endSuccessful) {
                this.runUserShell();
            }
            this.log.write(" ");
            this.log.write(" ");
            this.log.write(" ");
            this.log.timeStamp();
            if (this.log.endSuccessful) {
                this.log.write(this.log.NORMAL, NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionSuccess"));
            } else {
                this.log.write(this.log.ERROR, NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionFailed"));
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("FTPLoader", 1, true);
        }
        this.theTask = RP.create(runnable);
        this.theTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                ph.finish();
                FTPLoader.this.log.close();
            }
        });
        this.theTask.schedule(0);
    }

    private boolean handleCancel() {
        if (null == this.theTask) {
            return false;
        }
        this.log.write(this.log.ERROR, NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionStopped"));
        this.ftpu.cancel();
        this.theTask.cancel();
        return true;
    }

    protected List<File> getFilesRecursively(File dir) {
        ArrayList<File> filesRet = new ArrayList<File>();
        File[] strs = dir.listFiles();
        if (strs == null) {
            return null;
        }
        List<File> files = Arrays.asList(strs);
        for (File file : files) {
            if (file.isDirectory()) {
                filesRet.addAll(this.getFilesRecursively(file));
                continue;
            }
            filesRet.add(file);
        }
        return filesRet;
    }

    private void runUserShell() {
        this.log.write("   ");
        this.log.write("===========================");
        this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"upload_shell"));
        if (!this.shell.isEmpty()) {
            try {
                this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_launch", (Object)this.shell));
                Runtime.getRuntime().exec(this.shell);
                this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_cannotwait"));
            }
            catch (IOException e) {
                this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_error", (Object[])new String[]{this.shell, e.getMessage()}));
            }
        } else {
            this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_none"));
        }
    }
}

