/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.dnd.TransferableRecord;
import ancestris.modules.releve.merge.MergeLogger;
import ancestris.modules.releve.merge.MergeManager;
import ancestris.modules.releve.merge.MergePanel;
import ancestris.modules.releve.merge.MergeRecord;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MergeDialog
extends JFrame
implements ListDataListener {
    private final MergeManager m_mergeManager;
    private final JPopupMenu m_popupMenu = new JPopupMenu();
    boolean m_allowCopyRecordToEntity;
    private JLabel JLabelProposalList;
    private JButton jButtonCancel;
    private JButton jButtonMenu;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxShowOtherProposal;
    private JPanel jPanelButton;
    private JPanel jPanelToolbar;
    private JSplitPane jSplitPane0;
    private MergePanel mergePanel1;
    private MergePanel mergePanel2;

    public static void show(Component sourceComponent, Gedcom gedcom, Entity selectedEntity, TransferableRecord.TransferableData transferableData) throws Exception {
        MergeManager mergeManager = new MergeManager(transferableData, gedcom, selectedEntity);
        mergeManager.createProposals();
        MergeDialog mergeDialog = MergeDialog.show(sourceComponent, mergeManager, true);
    }

    public static MergeDialog show(Component sourceComponent, MergeManager mergeManager, boolean allowCopyRecordToEntity) {
        MergeDialog dialog = new MergeDialog(mergeManager, allowCopyRecordToEntity);
        try {
            dialog.initData();
            dialog.setVisible(true);
            return dialog;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            dialog.dispose();
            Toolkit.getDefaultToolkit().beep();
            String title = NbBundle.getMessage(MergeDialog.class, (String)"error.title.MergeDialog");
            String msg = NbBundle.getMessage(MergeDialog.class, (String)"error.msg.MergeDialog");
            if (ex.getMessage() == null) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(sourceComponent, ex.getClass().getName() + ". " + msg, title, 0);
            } else {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(sourceComponent, ex.getMessage(), title, 0);
            }
            return null;
        }
    }

    protected MergeDialog(MergeManager mergeManager, boolean allowCopyRecordToEntity) {
        this.m_mergeManager = mergeManager;
        this.m_allowCopyRecordToEntity = allowCopyRecordToEntity;
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MergeDialog.this.setVisible(false);
                MergeDialog.this.componentClosed();
                MergeDialog.this.dispose();
            }
        });
        JMenuItem menuItemShowLog = new JMenuItem(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.menu.showLog"));
        menuItemShowLog.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Log.png")));
        menuItemShowLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.generateLog(true);
            }
        });
        this.m_popupMenu.add(menuItemShowLog);
        JMenuItem menuItemCopyLogFileName = new JMenuItem(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.menu.copyLogFileName"));
        menuItemCopyLogFileName.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Copy.png")));
        menuItemCopyLogFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.generateLog(false);
            }
        });
        this.m_popupMenu.add(menuItemCopyLogFileName);
        JCheckBoxMenuItem menuItemShowAllParents = new JCheckBoxMenuItem(NbBundle.getMessage(MergeDialog.class, (String)"MergePanel.jToggleButtonShowAllParents.toolTipText"));
        menuItemShowAllParents.setState(MergeManager.getShowAllParents());
        menuItemShowAllParents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.updateOption(((JCheckBoxMenuItem)evt.getSource()).isSelected());
            }
        });
        this.m_popupMenu.add(menuItemShowAllParents);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        String size = NbPreferences.forModule(MergeDialog.class).get("MergeDialogSize", "560,600,0,0");
        String[] dimensions = size.split(",");
        if (dimensions.length >= 4) {
            int width = Integer.parseInt(dimensions[0]);
            int height = Integer.parseInt(dimensions[1]);
            int x = Integer.parseInt(dimensions[2]);
            int y = Integer.parseInt(dimensions[3]);
            if (width < 100) {
                width = 100;
            }
            if (height < 100) {
                height = 100;
            }
            if (x < 10 || x > screen.width - 10) {
                x = screen.width / 2 - width / 2;
            }
            if (y < 10 || y > screen.height - 10) {
                y = screen.height / 2 - height / 2;
            }
            this.setBounds(x, y, width, height);
        } else {
            this.setBounds(screen.width / 2 - 100, screen.height / 2 - 100, 300, 450);
        }
    }

    private void componentClosed() {
        this.mergePanel1.componentClosed();
        String size = String.valueOf(this.getWidth()) + "," + String.valueOf(this.getHeight()) + "," + String.valueOf(this.getLocation().x + "," + String.valueOf(this.getLocation().y));
        NbPreferences.forModule(MergeDialog.class).put("MergeDialogSize", size);
        NbPreferences.forModule(MergeDialog.class).put("MergeDialogSplitHeight", String.valueOf(this.jSplitPane0.getDividerLocation()));
        NbPreferences.forModule(MergeDialog.class).put("MergeDialogShowAllParents", String.valueOf(MergeManager.getShowAllParents()));
    }

    private void initData() throws Exception {
        ImageIcon icon = new ImageIcon(MergeDialog.class.getResource(switch (this.m_mergeManager.getMergeRecordType()) {
            case MergeRecord.RecordType.BIRTH -> "/ancestris/modules/releve/images/Birth.png";
            case MergeRecord.RecordType.MARRIAGE -> "/ancestris/modules/releve/images/Marriage.png";
            case MergeRecord.RecordType.DEATH -> "/ancestris/modules/releve/images/Death.png";
            default -> "/ancestris/modules/releve/images/misc.png";
        }));
        this.setIconImage(icon.getImage());
        this.setTitle(this.m_mergeManager.getMergeRecord().getTitle());
        if (this.m_mergeManager.getProposalList1().getNbAllProposal() > 0) {
            if (this.m_mergeManager.getSelectedEntity() == null) {
                this.JLabelProposalList.setText(NbBundle.getMessage(MergePanel.class, (String)"MergeDialog.ProposalList.all", (Object)this.m_mergeManager.getProposalList1().getSize()));
                this.jCheckBoxShowOtherProposal.setVisible(false);
            } else {
                this.JLabelProposalList.setText(NbBundle.getMessage(MergePanel.class, (String)"MergeDialog.ProposalList.selectedIndi", (Object)this.m_mergeManager.getProposalList1().getNbProposalWithSelectedEntity(), (Object)this.m_mergeManager.getSelectedEntity()));
                if (this.m_mergeManager.getProposalList1().getNbBestProposal() > 0) {
                    this.jCheckBoxShowOtherProposal.setVisible(true);
                    this.jCheckBoxShowOtherProposal.setSelected(false);
                    this.jCheckBoxShowOtherProposal.setText(NbBundle.getMessage(MergePanel.class, (String)"MergeDialog.ProposalList.better", (Object)(this.m_mergeManager.getProposalList1().getNbAllProposal() - this.m_mergeManager.getProposalList1().getNbProposalWithSelectedEntity()), (Object)this.m_mergeManager.getProposalList1().getNbBestProposal()));
                } else if (this.m_mergeManager.getProposalList1().getNbAllProposal() > this.m_mergeManager.getProposalList1().getNbProposalWithSelectedEntity()) {
                    this.jCheckBoxShowOtherProposal.setVisible(true);
                    this.jCheckBoxShowOtherProposal.setSelected(false);
                    this.jCheckBoxShowOtherProposal.setText(NbBundle.getMessage(MergePanel.class, (String)"MergeDialog.ProposalList.other", (Object)(this.m_mergeManager.getProposalList1().getNbAllProposal() - this.m_mergeManager.getProposalList1().getNbProposalWithSelectedEntity())));
                } else {
                    this.jCheckBoxShowOtherProposal.setVisible(false);
                }
            }
        } else {
            this.JLabelProposalList.setText("<html>" + NbBundle.getMessage(MergePanel.class, (String)"MergeDialog.ProposalList.empty") + "</html>");
            this.jButtonOK.setEnabled(false);
            this.jCheckBoxShowOtherProposal.setVisible(false);
        }
        this.m_mergeManager.getProposalList1().addListDataListener(this);
        this.m_mergeManager.getProposalList2().addListDataListener(this);
        this.m_mergeManager.getProposalList1().fireContentsChanged();
        this.m_mergeManager.getProposalList2().fireContentsChanged();
    }

    void updateData() {
        this.mergePanel2.initData(this.m_mergeManager.getProposalList2(), false);
        this.mergePanel1.initData(this.m_mergeManager.getProposalList1(), true);
        if (this.m_mergeManager.getProposalList2().getSize() > 0) {
            this.jSplitPane0.setDividerLocation((this.getHeight() - this.jPanelButton.getHeight() * 2) / 2);
        } else {
            this.jSplitPane0.setDividerLocation(this.getHeight());
            this.jSplitPane0.getBottomComponent().setVisible(false);
            this.jSplitPane0.setDividerSize(0);
        }
    }

    protected void updateOption(boolean showNewParents) {
        try {
            this.m_mergeManager.setShowAllParents(showNewParents);
            this.m_mergeManager.getProposalList1().fireContentsChanged();
            this.m_mergeManager.getProposalList2().fireContentsChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            Toolkit.getDefaultToolkit().beep();
            String title = "MergeDialog.updateData";
            if (ex.getMessage() == null) {
                JOptionPane.showMessageDialog(this, ex.getClass().getName() + " See console log", title, 0);
            }
            JOptionPane.showMessageDialog(this, ex.getMessage(), title, 0);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.updateData();
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.updateData();
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        this.updateData();
    }

    protected void generateLog(boolean showLog) {
        try {
            this.m_mergeManager.generateLog();
            MergeLogger.copyFileNameToClipboard();
            if (showLog) {
                MergeLogger.showLog();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            Toolkit.getDefaultToolkit().beep();
            String title = "MergeDialog.generateLog";
            if (ex.getMessage() == null) {
                JOptionPane.showMessageDialog(this, ex.getClass().getName() + " See console log", title, 0);
            }
            JOptionPane.showMessageDialog(this, ex.getMessage(), title, 0);
        }
    }

    private void showPopupMenu(Component invoker, int x, int y) {
        this.m_popupMenu.show(invoker, x, y);
    }

    private void initComponents() {
        this.jPanelToolbar = new JPanel();
        this.JLabelProposalList = new JLabel();
        this.jButtonMenu = new JButton();
        this.jCheckBoxShowOtherProposal = new JCheckBox();
        this.jSplitPane0 = new JSplitPane();
        this.mergePanel1 = new MergePanel();
        this.mergePanel2 = new MergePanel();
        this.jPanelButton = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanelToolbar.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanelToolbar.setLayout(new GridBagLayout());
        this.JLabelProposalList.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.ProposalList.all"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelToolbar.add((Component)this.JLabelProposalList, gridBagConstraints);
        this.jButtonMenu.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/hamb1-16.png")));
        this.jButtonMenu.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonMenu.setPreferredSize(new Dimension(20, 20));
        this.jButtonMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.jButtonMenuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanelToolbar.add((Component)this.jButtonMenu, gridBagConstraints);
        this.jCheckBoxShowOtherProposal.setFont(this.jCheckBoxShowOtherProposal.getFont().deriveFont(this.jCheckBoxShowOtherProposal.getFont().getStyle() | 2));
        this.jCheckBoxShowOtherProposal.setForeground(Color.blue);
        this.jCheckBoxShowOtherProposal.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.ProposalList.other"));
        this.jCheckBoxShowOtherProposal.setHideActionText(true);
        this.jCheckBoxShowOtherProposal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.jCheckBoxShowOtherProposalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanelToolbar.add((Component)this.jCheckBoxShowOtherProposal, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelToolbar, "North");
        this.jSplitPane0.setOrientation(0);
        this.jSplitPane0.setMaximumSize(null);
        this.mergePanel1.setPreferredSize(new Dimension(300, 100));
        this.jSplitPane0.setTopComponent(this.mergePanel1);
        this.mergePanel2.setPreferredSize(new Dimension(300, 100));
        this.jSplitPane0.setBottomComponent(this.mergePanel2);
        this.getContentPane().add((Component)this.jSplitPane0, "Center");
        this.jButtonOK.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.OK.text"));
        this.jButtonOK.setName("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonOK);
        this.jButtonCancel.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.jButtonCancel.text"));
        this.jButtonCancel.setRolloverEnabled(false);
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanelButton, "South");
        this.jPanelButton.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.componentClosed();
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.componentClosed();
        this.setVisible(false);
        this.dispose();
        try {
            if (this.m_allowCopyRecordToEntity) {
                this.m_mergeManager.copyRecordToEntity(this.mergePanel1.getCurrentProposal(), this.mergePanel2.getCurrentProposal());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            Toolkit.getDefaultToolkit().beep();
            String title = NbBundle.getMessage(MergeDialog.class, (String)"error.title.MergeDialog");
            String msg = NbBundle.getMessage(MergeDialog.class, (String)"error.msg.MergeDialog");
            if (ex.getMessage() == null) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(this, ex.getClass().getName() + ". " + msg, title, 0);
            }
            ex.printStackTrace(System.out);
            JOptionPane.showMessageDialog(this, ex.getMessage(), title, 0);
        }
    }

    private void jButtonMenuActionPerformed(ActionEvent evt) {
        this.showPopupMenu(this.jButtonMenu, 0, this.jButtonMenu.getHeight());
    }

    private void jCheckBoxShowOtherProposalActionPerformed(ActionEvent evt) {
        this.m_mergeManager.getProposalList1().showAllProposal(this.jCheckBoxShowOtherProposal.isSelected());
    }
}

