/* Generated by make_unicode.py DO NOT MODIFY */
/* Unicode version: 17.0.0 */

/*
 * Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/licenses/publicdomain/
 */

var BUGNUMBER = 1135377;
var summary = "Implement RegExp unicode flag -- ignoreCase flag.";

print(BUGNUMBER + ": " + summary);

function test(code, ...equivs) {
  var codeRe = new RegExp(String.fromCodePoint(code) + "+", "iu");
  var ans = String.fromCodePoint(code) + equivs.map(c => String.fromCodePoint(c)).join("");
  assertEqArray(codeRe.exec("<" + ans + ">"), [ans]);
  codeRe = new RegExp("[" + String.fromCodePoint(code) + "]+", "iu");
  assertEqArray(codeRe.exec("<" + ans + ">"), [ans]);
}
test(0x0041, 0x0061); // LATIN CAPITAL LETTER A, LATIN SMALL LETTER A
test(0x0042, 0x0062); // LATIN CAPITAL LETTER B, LATIN SMALL LETTER B
test(0x0043, 0x0063); // LATIN CAPITAL LETTER C, LATIN SMALL LETTER C
test(0x0044, 0x0064); // LATIN CAPITAL LETTER D, LATIN SMALL LETTER D
test(0x0045, 0x0065); // LATIN CAPITAL LETTER E, LATIN SMALL LETTER E
test(0x0046, 0x0066); // LATIN CAPITAL LETTER F, LATIN SMALL LETTER F
test(0x0047, 0x0067); // LATIN CAPITAL LETTER G, LATIN SMALL LETTER G
test(0x0048, 0x0068); // LATIN CAPITAL LETTER H, LATIN SMALL LETTER H
test(0x0049, 0x0069); // LATIN CAPITAL LETTER I, LATIN SMALL LETTER I
test(0x004A, 0x006A); // LATIN CAPITAL LETTER J, LATIN SMALL LETTER J
test(0x004B, 0x006B, 0x212A); // LATIN CAPITAL LETTER K, LATIN SMALL LETTER K, KELVIN SIGN (DEGREES KELVIN)
test(0x004C, 0x006C); // LATIN CAPITAL LETTER L, LATIN SMALL LETTER L
test(0x004D, 0x006D); // LATIN CAPITAL LETTER M, LATIN SMALL LETTER M
test(0x004E, 0x006E); // LATIN CAPITAL LETTER N, LATIN SMALL LETTER N
test(0x004F, 0x006F); // LATIN CAPITAL LETTER O, LATIN SMALL LETTER O
test(0x0050, 0x0070); // LATIN CAPITAL LETTER P, LATIN SMALL LETTER P
test(0x0051, 0x0071); // LATIN CAPITAL LETTER Q, LATIN SMALL LETTER Q
test(0x0052, 0x0072); // LATIN CAPITAL LETTER R, LATIN SMALL LETTER R
test(0x0053, 0x0073, 0x017F); // LATIN CAPITAL LETTER S, LATIN SMALL LETTER S, LATIN SMALL LETTER LONG S
test(0x0054, 0x0074); // LATIN CAPITAL LETTER T, LATIN SMALL LETTER T
test(0x0055, 0x0075); // LATIN CAPITAL LETTER U, LATIN SMALL LETTER U
test(0x0056, 0x0076); // LATIN CAPITAL LETTER V, LATIN SMALL LETTER V
test(0x0057, 0x0077); // LATIN CAPITAL LETTER W, LATIN SMALL LETTER W
test(0x0058, 0x0078); // LATIN CAPITAL LETTER X, LATIN SMALL LETTER X
test(0x0059, 0x0079); // LATIN CAPITAL LETTER Y, LATIN SMALL LETTER Y
test(0x005A, 0x007A); // LATIN CAPITAL LETTER Z, LATIN SMALL LETTER Z
test(0x0061, 0x0041); // LATIN SMALL LETTER A, LATIN CAPITAL LETTER A
test(0x0062, 0x0042); // LATIN SMALL LETTER B, LATIN CAPITAL LETTER B
test(0x0063, 0x0043); // LATIN SMALL LETTER C, LATIN CAPITAL LETTER C
test(0x0064, 0x0044); // LATIN SMALL LETTER D, LATIN CAPITAL LETTER D
test(0x0065, 0x0045); // LATIN SMALL LETTER E, LATIN CAPITAL LETTER E
test(0x0066, 0x0046); // LATIN SMALL LETTER F, LATIN CAPITAL LETTER F
test(0x0067, 0x0047); // LATIN SMALL LETTER G, LATIN CAPITAL LETTER G
test(0x0068, 0x0048); // LATIN SMALL LETTER H, LATIN CAPITAL LETTER H
test(0x0069, 0x0049); // LATIN SMALL LETTER I, LATIN CAPITAL LETTER I
test(0x006A, 0x004A); // LATIN SMALL LETTER J, LATIN CAPITAL LETTER J
test(0x006B, 0x004B, 0x212A); // LATIN SMALL LETTER K, LATIN CAPITAL LETTER K, KELVIN SIGN (DEGREES KELVIN)
test(0x006C, 0x004C); // LATIN SMALL LETTER L, LATIN CAPITAL LETTER L
test(0x006D, 0x004D); // LATIN SMALL LETTER M, LATIN CAPITAL LETTER M
test(0x006E, 0x004E); // LATIN SMALL LETTER N, LATIN CAPITAL LETTER N
test(0x006F, 0x004F); // LATIN SMALL LETTER O, LATIN CAPITAL LETTER O
test(0x0070, 0x0050); // LATIN SMALL LETTER P, LATIN CAPITAL LETTER P
test(0x0071, 0x0051); // LATIN SMALL LETTER Q, LATIN CAPITAL LETTER Q
test(0x0072, 0x0052); // LATIN SMALL LETTER R, LATIN CAPITAL LETTER R
test(0x0073, 0x0053, 0x017F); // LATIN SMALL LETTER S, LATIN CAPITAL LETTER S, LATIN SMALL LETTER LONG S
test(0x0074, 0x0054); // LATIN SMALL LETTER T, LATIN CAPITAL LETTER T
test(0x0075, 0x0055); // LATIN SMALL LETTER U, LATIN CAPITAL LETTER U
test(0x0076, 0x0056); // LATIN SMALL LETTER V, LATIN CAPITAL LETTER V
test(0x0077, 0x0057); // LATIN SMALL LETTER W, LATIN CAPITAL LETTER W
test(0x0078, 0x0058); // LATIN SMALL LETTER X, LATIN CAPITAL LETTER X
test(0x0079, 0x0059); // LATIN SMALL LETTER Y, LATIN CAPITAL LETTER Y
test(0x007A, 0x005A); // LATIN SMALL LETTER Z, LATIN CAPITAL LETTER Z
test(0x00B5, 0x03BC, 0x039C); // MICRO SIGN, GREEK SMALL LETTER MU, GREEK CAPITAL LETTER MU
test(0x00C0, 0x00E0); // LATIN CAPITAL LETTER A WITH GRAVE (LATIN CAPITAL LETTER A GRAVE), LATIN SMALL LETTER A WITH GRAVE (LATIN SMALL LETTER A GRAVE)
test(0x00C1, 0x00E1); // LATIN CAPITAL LETTER A WITH ACUTE (LATIN CAPITAL LETTER A ACUTE), LATIN SMALL LETTER A WITH ACUTE (LATIN SMALL LETTER A ACUTE)
test(0x00C2, 0x00E2); // LATIN CAPITAL LETTER A WITH CIRCUMFLEX (LATIN CAPITAL LETTER A CIRCUMFLEX), LATIN SMALL LETTER A WITH CIRCUMFLEX (LATIN SMALL LETTER A CIRCUMFLEX)
test(0x00C3, 0x00E3); // LATIN CAPITAL LETTER A WITH TILDE (LATIN CAPITAL LETTER A TILDE), LATIN SMALL LETTER A WITH TILDE (LATIN SMALL LETTER A TILDE)
test(0x00C4, 0x00E4); // LATIN CAPITAL LETTER A WITH DIAERESIS (LATIN CAPITAL LETTER A DIAERESIS), LATIN SMALL LETTER A WITH DIAERESIS (LATIN SMALL LETTER A DIAERESIS)
test(0x00C5, 0x00E5, 0x212B); // LATIN CAPITAL LETTER A WITH RING ABOVE (LATIN CAPITAL LETTER A RING), LATIN SMALL LETTER A WITH RING ABOVE (LATIN SMALL LETTER A RING), ANGSTROM SIGN (ANGSTROM UNIT)
test(0x00C6, 0x00E6); // LATIN CAPITAL LETTER AE (LATIN CAPITAL LETTER A E), LATIN SMALL LETTER AE (LATIN SMALL LETTER A E)
test(0x00C7, 0x00E7); // LATIN CAPITAL LETTER C WITH CEDILLA (LATIN CAPITAL LETTER C CEDILLA), LATIN SMALL LETTER C WITH CEDILLA (LATIN SMALL LETTER C CEDILLA)
test(0x00C8, 0x00E8); // LATIN CAPITAL LETTER E WITH GRAVE (LATIN CAPITAL LETTER E GRAVE), LATIN SMALL LETTER E WITH GRAVE (LATIN SMALL LETTER E GRAVE)
test(0x00C9, 0x00E9); // LATIN CAPITAL LETTER E WITH ACUTE (LATIN CAPITAL LETTER E ACUTE), LATIN SMALL LETTER E WITH ACUTE (LATIN SMALL LETTER E ACUTE)
test(0x00CA, 0x00EA); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX (LATIN CAPITAL LETTER E CIRCUMFLEX), LATIN SMALL LETTER E WITH CIRCUMFLEX (LATIN SMALL LETTER E CIRCUMFLEX)
test(0x00CB, 0x00EB); // LATIN CAPITAL LETTER E WITH DIAERESIS (LATIN CAPITAL LETTER E DIAERESIS), LATIN SMALL LETTER E WITH DIAERESIS (LATIN SMALL LETTER E DIAERESIS)
test(0x00CC, 0x00EC); // LATIN CAPITAL LETTER I WITH GRAVE (LATIN CAPITAL LETTER I GRAVE), LATIN SMALL LETTER I WITH GRAVE (LATIN SMALL LETTER I GRAVE)
test(0x00CD, 0x00ED); // LATIN CAPITAL LETTER I WITH ACUTE (LATIN CAPITAL LETTER I ACUTE), LATIN SMALL LETTER I WITH ACUTE (LATIN SMALL LETTER I ACUTE)
test(0x00CE, 0x00EE); // LATIN CAPITAL LETTER I WITH CIRCUMFLEX (LATIN CAPITAL LETTER I CIRCUMFLEX), LATIN SMALL LETTER I WITH CIRCUMFLEX (LATIN SMALL LETTER I CIRCUMFLEX)
test(0x00CF, 0x00EF); // LATIN CAPITAL LETTER I WITH DIAERESIS (LATIN CAPITAL LETTER I DIAERESIS), LATIN SMALL LETTER I WITH DIAERESIS (LATIN SMALL LETTER I DIAERESIS)
test(0x00D0, 0x00F0); // LATIN CAPITAL LETTER ETH, LATIN SMALL LETTER ETH
test(0x00D1, 0x00F1); // LATIN CAPITAL LETTER N WITH TILDE (LATIN CAPITAL LETTER N TILDE), LATIN SMALL LETTER N WITH TILDE (LATIN SMALL LETTER N TILDE)
test(0x00D2, 0x00F2); // LATIN CAPITAL LETTER O WITH GRAVE (LATIN CAPITAL LETTER O GRAVE), LATIN SMALL LETTER O WITH GRAVE (LATIN SMALL LETTER O GRAVE)
test(0x00D3, 0x00F3); // LATIN CAPITAL LETTER O WITH ACUTE (LATIN CAPITAL LETTER O ACUTE), LATIN SMALL LETTER O WITH ACUTE (LATIN SMALL LETTER O ACUTE)
test(0x00D4, 0x00F4); // LATIN CAPITAL LETTER O WITH CIRCUMFLEX (LATIN CAPITAL LETTER O CIRCUMFLEX), LATIN SMALL LETTER O WITH CIRCUMFLEX (LATIN SMALL LETTER O CIRCUMFLEX)
test(0x00D5, 0x00F5); // LATIN CAPITAL LETTER O WITH TILDE (LATIN CAPITAL LETTER O TILDE), LATIN SMALL LETTER O WITH TILDE (LATIN SMALL LETTER O TILDE)
test(0x00D6, 0x00F6); // LATIN CAPITAL LETTER O WITH DIAERESIS (LATIN CAPITAL LETTER O DIAERESIS), LATIN SMALL LETTER O WITH DIAERESIS (LATIN SMALL LETTER O DIAERESIS)
test(0x00D8, 0x00F8); // LATIN CAPITAL LETTER O WITH STROKE (LATIN CAPITAL LETTER O SLASH), LATIN SMALL LETTER O WITH STROKE (LATIN SMALL LETTER O SLASH)
test(0x00D9, 0x00F9); // LATIN CAPITAL LETTER U WITH GRAVE (LATIN CAPITAL LETTER U GRAVE), LATIN SMALL LETTER U WITH GRAVE (LATIN SMALL LETTER U GRAVE)
test(0x00DA, 0x00FA); // LATIN CAPITAL LETTER U WITH ACUTE (LATIN CAPITAL LETTER U ACUTE), LATIN SMALL LETTER U WITH ACUTE (LATIN SMALL LETTER U ACUTE)
test(0x00DB, 0x00FB); // LATIN CAPITAL LETTER U WITH CIRCUMFLEX (LATIN CAPITAL LETTER U CIRCUMFLEX), LATIN SMALL LETTER U WITH CIRCUMFLEX (LATIN SMALL LETTER U CIRCUMFLEX)
test(0x00DC, 0x00FC); // LATIN CAPITAL LETTER U WITH DIAERESIS (LATIN CAPITAL LETTER U DIAERESIS), LATIN SMALL LETTER U WITH DIAERESIS (LATIN SMALL LETTER U DIAERESIS)
test(0x00DD, 0x00FD); // LATIN CAPITAL LETTER Y WITH ACUTE (LATIN CAPITAL LETTER Y ACUTE), LATIN SMALL LETTER Y WITH ACUTE (LATIN SMALL LETTER Y ACUTE)
test(0x00DE, 0x00FE); // LATIN CAPITAL LETTER THORN, LATIN SMALL LETTER THORN
test(0x00DF, 0x1E9E); // LATIN SMALL LETTER SHARP S, LATIN CAPITAL LETTER SHARP S
test(0x00E0, 0x00C0); // LATIN SMALL LETTER A WITH GRAVE (LATIN SMALL LETTER A GRAVE), LATIN CAPITAL LETTER A WITH GRAVE (LATIN CAPITAL LETTER A GRAVE)
test(0x00E1, 0x00C1); // LATIN SMALL LETTER A WITH ACUTE (LATIN SMALL LETTER A ACUTE), LATIN CAPITAL LETTER A WITH ACUTE (LATIN CAPITAL LETTER A ACUTE)
test(0x00E2, 0x00C2); // LATIN SMALL LETTER A WITH CIRCUMFLEX (LATIN SMALL LETTER A CIRCUMFLEX), LATIN CAPITAL LETTER A WITH CIRCUMFLEX (LATIN CAPITAL LETTER A CIRCUMFLEX)
test(0x00E3, 0x00C3); // LATIN SMALL LETTER A WITH TILDE (LATIN SMALL LETTER A TILDE), LATIN CAPITAL LETTER A WITH TILDE (LATIN CAPITAL LETTER A TILDE)
test(0x00E4, 0x00C4); // LATIN SMALL LETTER A WITH DIAERESIS (LATIN SMALL LETTER A DIAERESIS), LATIN CAPITAL LETTER A WITH DIAERESIS (LATIN CAPITAL LETTER A DIAERESIS)
test(0x00E5, 0x00C5, 0x212B); // LATIN SMALL LETTER A WITH RING ABOVE (LATIN SMALL LETTER A RING), LATIN CAPITAL LETTER A WITH RING ABOVE (LATIN CAPITAL LETTER A RING), ANGSTROM SIGN (ANGSTROM UNIT)
test(0x00E6, 0x00C6); // LATIN SMALL LETTER AE (LATIN SMALL LETTER A E), LATIN CAPITAL LETTER AE (LATIN CAPITAL LETTER A E)
test(0x00E7, 0x00C7); // LATIN SMALL LETTER C WITH CEDILLA (LATIN SMALL LETTER C CEDILLA), LATIN CAPITAL LETTER C WITH CEDILLA (LATIN CAPITAL LETTER C CEDILLA)
test(0x00E8, 0x00C8); // LATIN SMALL LETTER E WITH GRAVE (LATIN SMALL LETTER E GRAVE), LATIN CAPITAL LETTER E WITH GRAVE (LATIN CAPITAL LETTER E GRAVE)
test(0x00E9, 0x00C9); // LATIN SMALL LETTER E WITH ACUTE (LATIN SMALL LETTER E ACUTE), LATIN CAPITAL LETTER E WITH ACUTE (LATIN CAPITAL LETTER E ACUTE)
test(0x00EA, 0x00CA); // LATIN SMALL LETTER E WITH CIRCUMFLEX (LATIN SMALL LETTER E CIRCUMFLEX), LATIN CAPITAL LETTER E WITH CIRCUMFLEX (LATIN CAPITAL LETTER E CIRCUMFLEX)
test(0x00EB, 0x00CB); // LATIN SMALL LETTER E WITH DIAERESIS (LATIN SMALL LETTER E DIAERESIS), LATIN CAPITAL LETTER E WITH DIAERESIS (LATIN CAPITAL LETTER E DIAERESIS)
test(0x00EC, 0x00CC); // LATIN SMALL LETTER I WITH GRAVE (LATIN SMALL LETTER I GRAVE), LATIN CAPITAL LETTER I WITH GRAVE (LATIN CAPITAL LETTER I GRAVE)
test(0x00ED, 0x00CD); // LATIN SMALL LETTER I WITH ACUTE (LATIN SMALL LETTER I ACUTE), LATIN CAPITAL LETTER I WITH ACUTE (LATIN CAPITAL LETTER I ACUTE)
test(0x00EE, 0x00CE); // LATIN SMALL LETTER I WITH CIRCUMFLEX (LATIN SMALL LETTER I CIRCUMFLEX), LATIN CAPITAL LETTER I WITH CIRCUMFLEX (LATIN CAPITAL LETTER I CIRCUMFLEX)
test(0x00EF, 0x00CF); // LATIN SMALL LETTER I WITH DIAERESIS (LATIN SMALL LETTER I DIAERESIS), LATIN CAPITAL LETTER I WITH DIAERESIS (LATIN CAPITAL LETTER I DIAERESIS)
test(0x00F0, 0x00D0); // LATIN SMALL LETTER ETH, LATIN CAPITAL LETTER ETH
test(0x00F1, 0x00D1); // LATIN SMALL LETTER N WITH TILDE (LATIN SMALL LETTER N TILDE), LATIN CAPITAL LETTER N WITH TILDE (LATIN CAPITAL LETTER N TILDE)
test(0x00F2, 0x00D2); // LATIN SMALL LETTER O WITH GRAVE (LATIN SMALL LETTER O GRAVE), LATIN CAPITAL LETTER O WITH GRAVE (LATIN CAPITAL LETTER O GRAVE)
test(0x00F3, 0x00D3); // LATIN SMALL LETTER O WITH ACUTE (LATIN SMALL LETTER O ACUTE), LATIN CAPITAL LETTER O WITH ACUTE (LATIN CAPITAL LETTER O ACUTE)
test(0x00F4, 0x00D4); // LATIN SMALL LETTER O WITH CIRCUMFLEX (LATIN SMALL LETTER O CIRCUMFLEX), LATIN CAPITAL LETTER O WITH CIRCUMFLEX (LATIN CAPITAL LETTER O CIRCUMFLEX)
test(0x00F5, 0x00D5); // LATIN SMALL LETTER O WITH TILDE (LATIN SMALL LETTER O TILDE), LATIN CAPITAL LETTER O WITH TILDE (LATIN CAPITAL LETTER O TILDE)
test(0x00F6, 0x00D6); // LATIN SMALL LETTER O WITH DIAERESIS (LATIN SMALL LETTER O DIAERESIS), LATIN CAPITAL LETTER O WITH DIAERESIS (LATIN CAPITAL LETTER O DIAERESIS)
test(0x00F8, 0x00D8); // LATIN SMALL LETTER O WITH STROKE (LATIN SMALL LETTER O SLASH), LATIN CAPITAL LETTER O WITH STROKE (LATIN CAPITAL LETTER O SLASH)
test(0x00F9, 0x00D9); // LATIN SMALL LETTER U WITH GRAVE (LATIN SMALL LETTER U GRAVE), LATIN CAPITAL LETTER U WITH GRAVE (LATIN CAPITAL LETTER U GRAVE)
test(0x00FA, 0x00DA); // LATIN SMALL LETTER U WITH ACUTE (LATIN SMALL LETTER U ACUTE), LATIN CAPITAL LETTER U WITH ACUTE (LATIN CAPITAL LETTER U ACUTE)
test(0x00FB, 0x00DB); // LATIN SMALL LETTER U WITH CIRCUMFLEX (LATIN SMALL LETTER U CIRCUMFLEX), LATIN CAPITAL LETTER U WITH CIRCUMFLEX (LATIN CAPITAL LETTER U CIRCUMFLEX)
test(0x00FC, 0x00DC); // LATIN SMALL LETTER U WITH DIAERESIS (LATIN SMALL LETTER U DIAERESIS), LATIN CAPITAL LETTER U WITH DIAERESIS (LATIN CAPITAL LETTER U DIAERESIS)
test(0x00FD, 0x00DD); // LATIN SMALL LETTER Y WITH ACUTE (LATIN SMALL LETTER Y ACUTE), LATIN CAPITAL LETTER Y WITH ACUTE (LATIN CAPITAL LETTER Y ACUTE)
test(0x00FE, 0x00DE); // LATIN SMALL LETTER THORN, LATIN CAPITAL LETTER THORN
test(0x00FF, 0x0178); // LATIN SMALL LETTER Y WITH DIAERESIS (LATIN SMALL LETTER Y DIAERESIS), LATIN CAPITAL LETTER Y WITH DIAERESIS (LATIN CAPITAL LETTER Y DIAERESIS)
test(0x0100, 0x0101); // LATIN CAPITAL LETTER A WITH MACRON (LATIN CAPITAL LETTER A MACRON), LATIN SMALL LETTER A WITH MACRON (LATIN SMALL LETTER A MACRON)
test(0x0101, 0x0100); // LATIN SMALL LETTER A WITH MACRON (LATIN SMALL LETTER A MACRON), LATIN CAPITAL LETTER A WITH MACRON (LATIN CAPITAL LETTER A MACRON)
test(0x0102, 0x0103); // LATIN CAPITAL LETTER A WITH BREVE (LATIN CAPITAL LETTER A BREVE), LATIN SMALL LETTER A WITH BREVE (LATIN SMALL LETTER A BREVE)
test(0x0103, 0x0102); // LATIN SMALL LETTER A WITH BREVE (LATIN SMALL LETTER A BREVE), LATIN CAPITAL LETTER A WITH BREVE (LATIN CAPITAL LETTER A BREVE)
test(0x0104, 0x0105); // LATIN CAPITAL LETTER A WITH OGONEK (LATIN CAPITAL LETTER A OGONEK), LATIN SMALL LETTER A WITH OGONEK (LATIN SMALL LETTER A OGONEK)
test(0x0105, 0x0104); // LATIN SMALL LETTER A WITH OGONEK (LATIN SMALL LETTER A OGONEK), LATIN CAPITAL LETTER A WITH OGONEK (LATIN CAPITAL LETTER A OGONEK)
test(0x0106, 0x0107); // LATIN CAPITAL LETTER C WITH ACUTE (LATIN CAPITAL LETTER C ACUTE), LATIN SMALL LETTER C WITH ACUTE (LATIN SMALL LETTER C ACUTE)
test(0x0107, 0x0106); // LATIN SMALL LETTER C WITH ACUTE (LATIN SMALL LETTER C ACUTE), LATIN CAPITAL LETTER C WITH ACUTE (LATIN CAPITAL LETTER C ACUTE)
test(0x0108, 0x0109); // LATIN CAPITAL LETTER C WITH CIRCUMFLEX (LATIN CAPITAL LETTER C CIRCUMFLEX), LATIN SMALL LETTER C WITH CIRCUMFLEX (LATIN SMALL LETTER C CIRCUMFLEX)
test(0x0109, 0x0108); // LATIN SMALL LETTER C WITH CIRCUMFLEX (LATIN SMALL LETTER C CIRCUMFLEX), LATIN CAPITAL LETTER C WITH CIRCUMFLEX (LATIN CAPITAL LETTER C CIRCUMFLEX)
test(0x010A, 0x010B); // LATIN CAPITAL LETTER C WITH DOT ABOVE (LATIN CAPITAL LETTER C DOT), LATIN SMALL LETTER C WITH DOT ABOVE (LATIN SMALL LETTER C DOT)
test(0x010B, 0x010A); // LATIN SMALL LETTER C WITH DOT ABOVE (LATIN SMALL LETTER C DOT), LATIN CAPITAL LETTER C WITH DOT ABOVE (LATIN CAPITAL LETTER C DOT)
test(0x010C, 0x010D); // LATIN CAPITAL LETTER C WITH CARON (LATIN CAPITAL LETTER C HACEK), LATIN SMALL LETTER C WITH CARON (LATIN SMALL LETTER C HACEK)
test(0x010D, 0x010C); // LATIN SMALL LETTER C WITH CARON (LATIN SMALL LETTER C HACEK), LATIN CAPITAL LETTER C WITH CARON (LATIN CAPITAL LETTER C HACEK)
test(0x010E, 0x010F); // LATIN CAPITAL LETTER D WITH CARON (LATIN CAPITAL LETTER D HACEK), LATIN SMALL LETTER D WITH CARON (LATIN SMALL LETTER D HACEK)
test(0x010F, 0x010E); // LATIN SMALL LETTER D WITH CARON (LATIN SMALL LETTER D HACEK), LATIN CAPITAL LETTER D WITH CARON (LATIN CAPITAL LETTER D HACEK)
test(0x0110, 0x0111); // LATIN CAPITAL LETTER D WITH STROKE (LATIN CAPITAL LETTER D BAR), LATIN SMALL LETTER D WITH STROKE (LATIN SMALL LETTER D BAR)
test(0x0111, 0x0110); // LATIN SMALL LETTER D WITH STROKE (LATIN SMALL LETTER D BAR), LATIN CAPITAL LETTER D WITH STROKE (LATIN CAPITAL LETTER D BAR)
test(0x0112, 0x0113); // LATIN CAPITAL LETTER E WITH MACRON (LATIN CAPITAL LETTER E MACRON), LATIN SMALL LETTER E WITH MACRON (LATIN SMALL LETTER E MACRON)
test(0x0113, 0x0112); // LATIN SMALL LETTER E WITH MACRON (LATIN SMALL LETTER E MACRON), LATIN CAPITAL LETTER E WITH MACRON (LATIN CAPITAL LETTER E MACRON)
test(0x0114, 0x0115); // LATIN CAPITAL LETTER E WITH BREVE (LATIN CAPITAL LETTER E BREVE), LATIN SMALL LETTER E WITH BREVE (LATIN SMALL LETTER E BREVE)
test(0x0115, 0x0114); // LATIN SMALL LETTER E WITH BREVE (LATIN SMALL LETTER E BREVE), LATIN CAPITAL LETTER E WITH BREVE (LATIN CAPITAL LETTER E BREVE)
test(0x0116, 0x0117); // LATIN CAPITAL LETTER E WITH DOT ABOVE (LATIN CAPITAL LETTER E DOT), LATIN SMALL LETTER E WITH DOT ABOVE (LATIN SMALL LETTER E DOT)
test(0x0117, 0x0116); // LATIN SMALL LETTER E WITH DOT ABOVE (LATIN SMALL LETTER E DOT), LATIN CAPITAL LETTER E WITH DOT ABOVE (LATIN CAPITAL LETTER E DOT)
test(0x0118, 0x0119); // LATIN CAPITAL LETTER E WITH OGONEK (LATIN CAPITAL LETTER E OGONEK), LATIN SMALL LETTER E WITH OGONEK (LATIN SMALL LETTER E OGONEK)
test(0x0119, 0x0118); // LATIN SMALL LETTER E WITH OGONEK (LATIN SMALL LETTER E OGONEK), LATIN CAPITAL LETTER E WITH OGONEK (LATIN CAPITAL LETTER E OGONEK)
test(0x011A, 0x011B); // LATIN CAPITAL LETTER E WITH CARON (LATIN CAPITAL LETTER E HACEK), LATIN SMALL LETTER E WITH CARON (LATIN SMALL LETTER E HACEK)
test(0x011B, 0x011A); // LATIN SMALL LETTER E WITH CARON (LATIN SMALL LETTER E HACEK), LATIN CAPITAL LETTER E WITH CARON (LATIN CAPITAL LETTER E HACEK)
test(0x011C, 0x011D); // LATIN CAPITAL LETTER G WITH CIRCUMFLEX (LATIN CAPITAL LETTER G CIRCUMFLEX), LATIN SMALL LETTER G WITH CIRCUMFLEX (LATIN SMALL LETTER G CIRCUMFLEX)
test(0x011D, 0x011C); // LATIN SMALL LETTER G WITH CIRCUMFLEX (LATIN SMALL LETTER G CIRCUMFLEX), LATIN CAPITAL LETTER G WITH CIRCUMFLEX (LATIN CAPITAL LETTER G CIRCUMFLEX)
test(0x011E, 0x011F); // LATIN CAPITAL LETTER G WITH BREVE (LATIN CAPITAL LETTER G BREVE), LATIN SMALL LETTER G WITH BREVE (LATIN SMALL LETTER G BREVE)
test(0x011F, 0x011E); // LATIN SMALL LETTER G WITH BREVE (LATIN SMALL LETTER G BREVE), LATIN CAPITAL LETTER G WITH BREVE (LATIN CAPITAL LETTER G BREVE)
test(0x0120, 0x0121); // LATIN CAPITAL LETTER G WITH DOT ABOVE (LATIN CAPITAL LETTER G DOT), LATIN SMALL LETTER G WITH DOT ABOVE (LATIN SMALL LETTER G DOT)
test(0x0121, 0x0120); // LATIN SMALL LETTER G WITH DOT ABOVE (LATIN SMALL LETTER G DOT), LATIN CAPITAL LETTER G WITH DOT ABOVE (LATIN CAPITAL LETTER G DOT)
test(0x0122, 0x0123); // LATIN CAPITAL LETTER G WITH CEDILLA (LATIN CAPITAL LETTER G CEDILLA), LATIN SMALL LETTER G WITH CEDILLA (LATIN SMALL LETTER G CEDILLA)
test(0x0123, 0x0122); // LATIN SMALL LETTER G WITH CEDILLA (LATIN SMALL LETTER G CEDILLA), LATIN CAPITAL LETTER G WITH CEDILLA (LATIN CAPITAL LETTER G CEDILLA)
test(0x0124, 0x0125); // LATIN CAPITAL LETTER H WITH CIRCUMFLEX (LATIN CAPITAL LETTER H CIRCUMFLEX), LATIN SMALL LETTER H WITH CIRCUMFLEX (LATIN SMALL LETTER H CIRCUMFLEX)
test(0x0125, 0x0124); // LATIN SMALL LETTER H WITH CIRCUMFLEX (LATIN SMALL LETTER H CIRCUMFLEX), LATIN CAPITAL LETTER H WITH CIRCUMFLEX (LATIN CAPITAL LETTER H CIRCUMFLEX)
test(0x0126, 0x0127); // LATIN CAPITAL LETTER H WITH STROKE (LATIN CAPITAL LETTER H BAR), LATIN SMALL LETTER H WITH STROKE (LATIN SMALL LETTER H BAR)
test(0x0127, 0x0126); // LATIN SMALL LETTER H WITH STROKE (LATIN SMALL LETTER H BAR), LATIN CAPITAL LETTER H WITH STROKE (LATIN CAPITAL LETTER H BAR)
test(0x0128, 0x0129); // LATIN CAPITAL LETTER I WITH TILDE (LATIN CAPITAL LETTER I TILDE), LATIN SMALL LETTER I WITH TILDE (LATIN SMALL LETTER I TILDE)
test(0x0129, 0x0128); // LATIN SMALL LETTER I WITH TILDE (LATIN SMALL LETTER I TILDE), LATIN CAPITAL LETTER I WITH TILDE (LATIN CAPITAL LETTER I TILDE)
test(0x012A, 0x012B); // LATIN CAPITAL LETTER I WITH MACRON (LATIN CAPITAL LETTER I MACRON), LATIN SMALL LETTER I WITH MACRON (LATIN SMALL LETTER I MACRON)
test(0x012B, 0x012A); // LATIN SMALL LETTER I WITH MACRON (LATIN SMALL LETTER I MACRON), LATIN CAPITAL LETTER I WITH MACRON (LATIN CAPITAL LETTER I MACRON)
test(0x012C, 0x012D); // LATIN CAPITAL LETTER I WITH BREVE (LATIN CAPITAL LETTER I BREVE), LATIN SMALL LETTER I WITH BREVE (LATIN SMALL LETTER I BREVE)
test(0x012D, 0x012C); // LATIN SMALL LETTER I WITH BREVE (LATIN SMALL LETTER I BREVE), LATIN CAPITAL LETTER I WITH BREVE (LATIN CAPITAL LETTER I BREVE)
test(0x012E, 0x012F); // LATIN CAPITAL LETTER I WITH OGONEK (LATIN CAPITAL LETTER I OGONEK), LATIN SMALL LETTER I WITH OGONEK (LATIN SMALL LETTER I OGONEK)
test(0x012F, 0x012E); // LATIN SMALL LETTER I WITH OGONEK (LATIN SMALL LETTER I OGONEK), LATIN CAPITAL LETTER I WITH OGONEK (LATIN CAPITAL LETTER I OGONEK)
test(0x0132, 0x0133); // LATIN CAPITAL LIGATURE IJ (LATIN CAPITAL LETTER I J), LATIN SMALL LIGATURE IJ (LATIN SMALL LETTER I J)
test(0x0133, 0x0132); // LATIN SMALL LIGATURE IJ (LATIN SMALL LETTER I J), LATIN CAPITAL LIGATURE IJ (LATIN CAPITAL LETTER I J)
test(0x0134, 0x0135); // LATIN CAPITAL LETTER J WITH CIRCUMFLEX (LATIN CAPITAL LETTER J CIRCUMFLEX), LATIN SMALL LETTER J WITH CIRCUMFLEX (LATIN SMALL LETTER J CIRCUMFLEX)
test(0x0135, 0x0134); // LATIN SMALL LETTER J WITH CIRCUMFLEX (LATIN SMALL LETTER J CIRCUMFLEX), LATIN CAPITAL LETTER J WITH CIRCUMFLEX (LATIN CAPITAL LETTER J CIRCUMFLEX)
test(0x0136, 0x0137); // LATIN CAPITAL LETTER K WITH CEDILLA (LATIN CAPITAL LETTER K CEDILLA), LATIN SMALL LETTER K WITH CEDILLA (LATIN SMALL LETTER K CEDILLA)
test(0x0137, 0x0136); // LATIN SMALL LETTER K WITH CEDILLA (LATIN SMALL LETTER K CEDILLA), LATIN CAPITAL LETTER K WITH CEDILLA (LATIN CAPITAL LETTER K CEDILLA)
test(0x0139, 0x013A); // LATIN CAPITAL LETTER L WITH ACUTE (LATIN CAPITAL LETTER L ACUTE), LATIN SMALL LETTER L WITH ACUTE (LATIN SMALL LETTER L ACUTE)
test(0x013A, 0x0139); // LATIN SMALL LETTER L WITH ACUTE (LATIN SMALL LETTER L ACUTE), LATIN CAPITAL LETTER L WITH ACUTE (LATIN CAPITAL LETTER L ACUTE)
test(0x013B, 0x013C); // LATIN CAPITAL LETTER L WITH CEDILLA (LATIN CAPITAL LETTER L CEDILLA), LATIN SMALL LETTER L WITH CEDILLA (LATIN SMALL LETTER L CEDILLA)
test(0x013C, 0x013B); // LATIN SMALL LETTER L WITH CEDILLA (LATIN SMALL LETTER L CEDILLA), LATIN CAPITAL LETTER L WITH CEDILLA (LATIN CAPITAL LETTER L CEDILLA)
test(0x013D, 0x013E); // LATIN CAPITAL LETTER L WITH CARON (LATIN CAPITAL LETTER L HACEK), LATIN SMALL LETTER L WITH CARON (LATIN SMALL LETTER L HACEK)
test(0x013E, 0x013D); // LATIN SMALL LETTER L WITH CARON (LATIN SMALL LETTER L HACEK), LATIN CAPITAL LETTER L WITH CARON (LATIN CAPITAL LETTER L HACEK)
test(0x013F, 0x0140); // LATIN CAPITAL LETTER L WITH MIDDLE DOT, LATIN SMALL LETTER L WITH MIDDLE DOT
test(0x0140, 0x013F); // LATIN SMALL LETTER L WITH MIDDLE DOT, LATIN CAPITAL LETTER L WITH MIDDLE DOT
test(0x0141, 0x0142); // LATIN CAPITAL LETTER L WITH STROKE (LATIN CAPITAL LETTER L SLASH), LATIN SMALL LETTER L WITH STROKE (LATIN SMALL LETTER L SLASH)
test(0x0142, 0x0141); // LATIN SMALL LETTER L WITH STROKE (LATIN SMALL LETTER L SLASH), LATIN CAPITAL LETTER L WITH STROKE (LATIN CAPITAL LETTER L SLASH)
test(0x0143, 0x0144); // LATIN CAPITAL LETTER N WITH ACUTE (LATIN CAPITAL LETTER N ACUTE), LATIN SMALL LETTER N WITH ACUTE (LATIN SMALL LETTER N ACUTE)
test(0x0144, 0x0143); // LATIN SMALL LETTER N WITH ACUTE (LATIN SMALL LETTER N ACUTE), LATIN CAPITAL LETTER N WITH ACUTE (LATIN CAPITAL LETTER N ACUTE)
test(0x0145, 0x0146); // LATIN CAPITAL LETTER N WITH CEDILLA (LATIN CAPITAL LETTER N CEDILLA), LATIN SMALL LETTER N WITH CEDILLA (LATIN SMALL LETTER N CEDILLA)
test(0x0146, 0x0145); // LATIN SMALL LETTER N WITH CEDILLA (LATIN SMALL LETTER N CEDILLA), LATIN CAPITAL LETTER N WITH CEDILLA (LATIN CAPITAL LETTER N CEDILLA)
test(0x0147, 0x0148); // LATIN CAPITAL LETTER N WITH CARON (LATIN CAPITAL LETTER N HACEK), LATIN SMALL LETTER N WITH CARON (LATIN SMALL LETTER N HACEK)
test(0x0148, 0x0147); // LATIN SMALL LETTER N WITH CARON (LATIN SMALL LETTER N HACEK), LATIN CAPITAL LETTER N WITH CARON (LATIN CAPITAL LETTER N HACEK)
test(0x014A, 0x014B); // LATIN CAPITAL LETTER ENG, LATIN SMALL LETTER ENG
test(0x014B, 0x014A); // LATIN SMALL LETTER ENG, LATIN CAPITAL LETTER ENG
test(0x014C, 0x014D); // LATIN CAPITAL LETTER O WITH MACRON (LATIN CAPITAL LETTER O MACRON), LATIN SMALL LETTER O WITH MACRON (LATIN SMALL LETTER O MACRON)
test(0x014D, 0x014C); // LATIN SMALL LETTER O WITH MACRON (LATIN SMALL LETTER O MACRON), LATIN CAPITAL LETTER O WITH MACRON (LATIN CAPITAL LETTER O MACRON)
test(0x014E, 0x014F); // LATIN CAPITAL LETTER O WITH BREVE (LATIN CAPITAL LETTER O BREVE), LATIN SMALL LETTER O WITH BREVE (LATIN SMALL LETTER O BREVE)
test(0x014F, 0x014E); // LATIN SMALL LETTER O WITH BREVE (LATIN SMALL LETTER O BREVE), LATIN CAPITAL LETTER O WITH BREVE (LATIN CAPITAL LETTER O BREVE)
test(0x0150, 0x0151); // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE (LATIN CAPITAL LETTER O DOUBLE ACUTE), LATIN SMALL LETTER O WITH DOUBLE ACUTE (LATIN SMALL LETTER O DOUBLE ACUTE)
test(0x0151, 0x0150); // LATIN SMALL LETTER O WITH DOUBLE ACUTE (LATIN SMALL LETTER O DOUBLE ACUTE), LATIN CAPITAL LETTER O WITH DOUBLE ACUTE (LATIN CAPITAL LETTER O DOUBLE ACUTE)
test(0x0152, 0x0153); // LATIN CAPITAL LIGATURE OE (LATIN CAPITAL LETTER O E), LATIN SMALL LIGATURE OE (LATIN SMALL LETTER O E)
test(0x0153, 0x0152); // LATIN SMALL LIGATURE OE (LATIN SMALL LETTER O E), LATIN CAPITAL LIGATURE OE (LATIN CAPITAL LETTER O E)
test(0x0154, 0x0155); // LATIN CAPITAL LETTER R WITH ACUTE (LATIN CAPITAL LETTER R ACUTE), LATIN SMALL LETTER R WITH ACUTE (LATIN SMALL LETTER R ACUTE)
test(0x0155, 0x0154); // LATIN SMALL LETTER R WITH ACUTE (LATIN SMALL LETTER R ACUTE), LATIN CAPITAL LETTER R WITH ACUTE (LATIN CAPITAL LETTER R ACUTE)
test(0x0156, 0x0157); // LATIN CAPITAL LETTER R WITH CEDILLA (LATIN CAPITAL LETTER R CEDILLA), LATIN SMALL LETTER R WITH CEDILLA (LATIN SMALL LETTER R CEDILLA)
test(0x0157, 0x0156); // LATIN SMALL LETTER R WITH CEDILLA (LATIN SMALL LETTER R CEDILLA), LATIN CAPITAL LETTER R WITH CEDILLA (LATIN CAPITAL LETTER R CEDILLA)
test(0x0158, 0x0159); // LATIN CAPITAL LETTER R WITH CARON (LATIN CAPITAL LETTER R HACEK), LATIN SMALL LETTER R WITH CARON (LATIN SMALL LETTER R HACEK)
test(0x0159, 0x0158); // LATIN SMALL LETTER R WITH CARON (LATIN SMALL LETTER R HACEK), LATIN CAPITAL LETTER R WITH CARON (LATIN CAPITAL LETTER R HACEK)
test(0x015A, 0x015B); // LATIN CAPITAL LETTER S WITH ACUTE (LATIN CAPITAL LETTER S ACUTE), LATIN SMALL LETTER S WITH ACUTE (LATIN SMALL LETTER S ACUTE)
test(0x015B, 0x015A); // LATIN SMALL LETTER S WITH ACUTE (LATIN SMALL LETTER S ACUTE), LATIN CAPITAL LETTER S WITH ACUTE (LATIN CAPITAL LETTER S ACUTE)
test(0x015C, 0x015D); // LATIN CAPITAL LETTER S WITH CIRCUMFLEX (LATIN CAPITAL LETTER S CIRCUMFLEX), LATIN SMALL LETTER S WITH CIRCUMFLEX (LATIN SMALL LETTER S CIRCUMFLEX)
test(0x015D, 0x015C); // LATIN SMALL LETTER S WITH CIRCUMFLEX (LATIN SMALL LETTER S CIRCUMFLEX), LATIN CAPITAL LETTER S WITH CIRCUMFLEX (LATIN CAPITAL LETTER S CIRCUMFLEX)
test(0x015E, 0x015F); // LATIN CAPITAL LETTER S WITH CEDILLA (LATIN CAPITAL LETTER S CEDILLA), LATIN SMALL LETTER S WITH CEDILLA (LATIN SMALL LETTER S CEDILLA)
test(0x015F, 0x015E); // LATIN SMALL LETTER S WITH CEDILLA (LATIN SMALL LETTER S CEDILLA), LATIN CAPITAL LETTER S WITH CEDILLA (LATIN CAPITAL LETTER S CEDILLA)
test(0x0160, 0x0161); // LATIN CAPITAL LETTER S WITH CARON (LATIN CAPITAL LETTER S HACEK), LATIN SMALL LETTER S WITH CARON (LATIN SMALL LETTER S HACEK)
test(0x0161, 0x0160); // LATIN SMALL LETTER S WITH CARON (LATIN SMALL LETTER S HACEK), LATIN CAPITAL LETTER S WITH CARON (LATIN CAPITAL LETTER S HACEK)
test(0x0162, 0x0163); // LATIN CAPITAL LETTER T WITH CEDILLA (LATIN CAPITAL LETTER T CEDILLA), LATIN SMALL LETTER T WITH CEDILLA (LATIN SMALL LETTER T CEDILLA)
test(0x0163, 0x0162); // LATIN SMALL LETTER T WITH CEDILLA (LATIN SMALL LETTER T CEDILLA), LATIN CAPITAL LETTER T WITH CEDILLA (LATIN CAPITAL LETTER T CEDILLA)
test(0x0164, 0x0165); // LATIN CAPITAL LETTER T WITH CARON (LATIN CAPITAL LETTER T HACEK), LATIN SMALL LETTER T WITH CARON (LATIN SMALL LETTER T HACEK)
test(0x0165, 0x0164); // LATIN SMALL LETTER T WITH CARON (LATIN SMALL LETTER T HACEK), LATIN CAPITAL LETTER T WITH CARON (LATIN CAPITAL LETTER T HACEK)
test(0x0166, 0x0167); // LATIN CAPITAL LETTER T WITH STROKE (LATIN CAPITAL LETTER T BAR), LATIN SMALL LETTER T WITH STROKE (LATIN SMALL LETTER T BAR)
test(0x0167, 0x0166); // LATIN SMALL LETTER T WITH STROKE (LATIN SMALL LETTER T BAR), LATIN CAPITAL LETTER T WITH STROKE (LATIN CAPITAL LETTER T BAR)
test(0x0168, 0x0169); // LATIN CAPITAL LETTER U WITH TILDE (LATIN CAPITAL LETTER U TILDE), LATIN SMALL LETTER U WITH TILDE (LATIN SMALL LETTER U TILDE)
test(0x0169, 0x0168); // LATIN SMALL LETTER U WITH TILDE (LATIN SMALL LETTER U TILDE), LATIN CAPITAL LETTER U WITH TILDE (LATIN CAPITAL LETTER U TILDE)
test(0x016A, 0x016B); // LATIN CAPITAL LETTER U WITH MACRON (LATIN CAPITAL LETTER U MACRON), LATIN SMALL LETTER U WITH MACRON (LATIN SMALL LETTER U MACRON)
test(0x016B, 0x016A); // LATIN SMALL LETTER U WITH MACRON (LATIN SMALL LETTER U MACRON), LATIN CAPITAL LETTER U WITH MACRON (LATIN CAPITAL LETTER U MACRON)
test(0x016C, 0x016D); // LATIN CAPITAL LETTER U WITH BREVE (LATIN CAPITAL LETTER U BREVE), LATIN SMALL LETTER U WITH BREVE (LATIN SMALL LETTER U BREVE)
test(0x016D, 0x016C); // LATIN SMALL LETTER U WITH BREVE (LATIN SMALL LETTER U BREVE), LATIN CAPITAL LETTER U WITH BREVE (LATIN CAPITAL LETTER U BREVE)
test(0x016E, 0x016F); // LATIN CAPITAL LETTER U WITH RING ABOVE (LATIN CAPITAL LETTER U RING), LATIN SMALL LETTER U WITH RING ABOVE (LATIN SMALL LETTER U RING)
test(0x016F, 0x016E); // LATIN SMALL LETTER U WITH RING ABOVE (LATIN SMALL LETTER U RING), LATIN CAPITAL LETTER U WITH RING ABOVE (LATIN CAPITAL LETTER U RING)
test(0x0170, 0x0171); // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE (LATIN CAPITAL LETTER U DOUBLE ACUTE), LATIN SMALL LETTER U WITH DOUBLE ACUTE (LATIN SMALL LETTER U DOUBLE ACUTE)
test(0x0171, 0x0170); // LATIN SMALL LETTER U WITH DOUBLE ACUTE (LATIN SMALL LETTER U DOUBLE ACUTE), LATIN CAPITAL LETTER U WITH DOUBLE ACUTE (LATIN CAPITAL LETTER U DOUBLE ACUTE)
test(0x0172, 0x0173); // LATIN CAPITAL LETTER U WITH OGONEK (LATIN CAPITAL LETTER U OGONEK), LATIN SMALL LETTER U WITH OGONEK (LATIN SMALL LETTER U OGONEK)
test(0x0173, 0x0172); // LATIN SMALL LETTER U WITH OGONEK (LATIN SMALL LETTER U OGONEK), LATIN CAPITAL LETTER U WITH OGONEK (LATIN CAPITAL LETTER U OGONEK)
test(0x0174, 0x0175); // LATIN CAPITAL LETTER W WITH CIRCUMFLEX (LATIN CAPITAL LETTER W CIRCUMFLEX), LATIN SMALL LETTER W WITH CIRCUMFLEX (LATIN SMALL LETTER W CIRCUMFLEX)
test(0x0175, 0x0174); // LATIN SMALL LETTER W WITH CIRCUMFLEX (LATIN SMALL LETTER W CIRCUMFLEX), LATIN CAPITAL LETTER W WITH CIRCUMFLEX (LATIN CAPITAL LETTER W CIRCUMFLEX)
test(0x0176, 0x0177); // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX (LATIN CAPITAL LETTER Y CIRCUMFLEX), LATIN SMALL LETTER Y WITH CIRCUMFLEX (LATIN SMALL LETTER Y CIRCUMFLEX)
test(0x0177, 0x0176); // LATIN SMALL LETTER Y WITH CIRCUMFLEX (LATIN SMALL LETTER Y CIRCUMFLEX), LATIN CAPITAL LETTER Y WITH CIRCUMFLEX (LATIN CAPITAL LETTER Y CIRCUMFLEX)
test(0x0178, 0x00FF); // LATIN CAPITAL LETTER Y WITH DIAERESIS (LATIN CAPITAL LETTER Y DIAERESIS), LATIN SMALL LETTER Y WITH DIAERESIS (LATIN SMALL LETTER Y DIAERESIS)
test(0x0179, 0x017A); // LATIN CAPITAL LETTER Z WITH ACUTE (LATIN CAPITAL LETTER Z ACUTE), LATIN SMALL LETTER Z WITH ACUTE (LATIN SMALL LETTER Z ACUTE)
test(0x017A, 0x0179); // LATIN SMALL LETTER Z WITH ACUTE (LATIN SMALL LETTER Z ACUTE), LATIN CAPITAL LETTER Z WITH ACUTE (LATIN CAPITAL LETTER Z ACUTE)
test(0x017B, 0x017C); // LATIN CAPITAL LETTER Z WITH DOT ABOVE (LATIN CAPITAL LETTER Z DOT), LATIN SMALL LETTER Z WITH DOT ABOVE (LATIN SMALL LETTER Z DOT)
test(0x017C, 0x017B); // LATIN SMALL LETTER Z WITH DOT ABOVE (LATIN SMALL LETTER Z DOT), LATIN CAPITAL LETTER Z WITH DOT ABOVE (LATIN CAPITAL LETTER Z DOT)
test(0x017D, 0x017E); // LATIN CAPITAL LETTER Z WITH CARON (LATIN CAPITAL LETTER Z HACEK), LATIN SMALL LETTER Z WITH CARON (LATIN SMALL LETTER Z HACEK)
test(0x017E, 0x017D); // LATIN SMALL LETTER Z WITH CARON (LATIN SMALL LETTER Z HACEK), LATIN CAPITAL LETTER Z WITH CARON (LATIN CAPITAL LETTER Z HACEK)
test(0x017F, 0x0073, 0x0053); // LATIN SMALL LETTER LONG S, LATIN SMALL LETTER S, LATIN CAPITAL LETTER S
test(0x0180, 0x0243); // LATIN SMALL LETTER B WITH STROKE (LATIN SMALL LETTER B BAR), LATIN CAPITAL LETTER B WITH STROKE
test(0x0181, 0x0253); // LATIN CAPITAL LETTER B WITH HOOK (LATIN CAPITAL LETTER B HOOK), LATIN SMALL LETTER B WITH HOOK (LATIN SMALL LETTER B HOOK)
test(0x0182, 0x0183); // LATIN CAPITAL LETTER B WITH TOPBAR (LATIN CAPITAL LETTER B TOPBAR), LATIN SMALL LETTER B WITH TOPBAR (LATIN SMALL LETTER B TOPBAR)
test(0x0183, 0x0182); // LATIN SMALL LETTER B WITH TOPBAR (LATIN SMALL LETTER B TOPBAR), LATIN CAPITAL LETTER B WITH TOPBAR (LATIN CAPITAL LETTER B TOPBAR)
test(0x0184, 0x0185); // LATIN CAPITAL LETTER TONE SIX, LATIN SMALL LETTER TONE SIX
test(0x0185, 0x0184); // LATIN SMALL LETTER TONE SIX, LATIN CAPITAL LETTER TONE SIX
test(0x0186, 0x0254); // LATIN CAPITAL LETTER OPEN O, LATIN SMALL LETTER OPEN O
test(0x0187, 0x0188); // LATIN CAPITAL LETTER C WITH HOOK (LATIN CAPITAL LETTER C HOOK), LATIN SMALL LETTER C WITH HOOK (LATIN SMALL LETTER C HOOK)
test(0x0188, 0x0187); // LATIN SMALL LETTER C WITH HOOK (LATIN SMALL LETTER C HOOK), LATIN CAPITAL LETTER C WITH HOOK (LATIN CAPITAL LETTER C HOOK)
test(0x0189, 0x0256); // LATIN CAPITAL LETTER AFRICAN D, LATIN SMALL LETTER D WITH TAIL (LATIN SMALL LETTER D RETROFLEX HOOK)
test(0x018A, 0x0257); // LATIN CAPITAL LETTER D WITH HOOK (LATIN CAPITAL LETTER D HOOK), LATIN SMALL LETTER D WITH HOOK (LATIN SMALL LETTER D HOOK)
test(0x018B, 0x018C); // LATIN CAPITAL LETTER D WITH TOPBAR (LATIN CAPITAL LETTER D TOPBAR), LATIN SMALL LETTER D WITH TOPBAR (LATIN SMALL LETTER D TOPBAR)
test(0x018C, 0x018B); // LATIN SMALL LETTER D WITH TOPBAR (LATIN SMALL LETTER D TOPBAR), LATIN CAPITAL LETTER D WITH TOPBAR (LATIN CAPITAL LETTER D TOPBAR)
test(0x018E, 0x01DD); // LATIN CAPITAL LETTER REVERSED E (LATIN CAPITAL LETTER TURNED E), LATIN SMALL LETTER TURNED E
test(0x018F, 0x0259); // LATIN CAPITAL LETTER SCHWA, LATIN SMALL LETTER SCHWA
test(0x0190, 0x025B); // LATIN CAPITAL LETTER OPEN E (LATIN CAPITAL LETTER EPSILON), LATIN SMALL LETTER OPEN E (LATIN SMALL LETTER EPSILON)
test(0x0191, 0x0192); // LATIN CAPITAL LETTER F WITH HOOK (LATIN CAPITAL LETTER F HOOK), LATIN SMALL LETTER F WITH HOOK (LATIN SMALL LETTER SCRIPT F)
test(0x0192, 0x0191); // LATIN SMALL LETTER F WITH HOOK (LATIN SMALL LETTER SCRIPT F), LATIN CAPITAL LETTER F WITH HOOK (LATIN CAPITAL LETTER F HOOK)
test(0x0193, 0x0260); // LATIN CAPITAL LETTER G WITH HOOK (LATIN CAPITAL LETTER G HOOK), LATIN SMALL LETTER G WITH HOOK (LATIN SMALL LETTER G HOOK)
test(0x0194, 0x0263); // LATIN CAPITAL LETTER GAMMA, LATIN SMALL LETTER GAMMA
test(0x0195, 0x01F6); // LATIN SMALL LETTER HV (LATIN SMALL LETTER H V), LATIN CAPITAL LETTER HWAIR
test(0x0196, 0x0269); // LATIN CAPITAL LETTER IOTA, LATIN SMALL LETTER IOTA
test(0x0197, 0x0268); // LATIN CAPITAL LETTER I WITH STROKE (LATIN CAPITAL LETTER BARRED I), LATIN SMALL LETTER I WITH STROKE (LATIN SMALL LETTER BARRED I)
test(0x0198, 0x0199); // LATIN CAPITAL LETTER K WITH HOOK (LATIN CAPITAL LETTER K HOOK), LATIN SMALL LETTER K WITH HOOK (LATIN SMALL LETTER K HOOK)
test(0x0199, 0x0198); // LATIN SMALL LETTER K WITH HOOK (LATIN SMALL LETTER K HOOK), LATIN CAPITAL LETTER K WITH HOOK (LATIN CAPITAL LETTER K HOOK)
test(0x019A, 0x023D); // LATIN SMALL LETTER L WITH BAR (LATIN SMALL LETTER BARRED L), LATIN CAPITAL LETTER L WITH BAR
test(0x019B, 0xA7DC); // LATIN SMALL LETTER LAMBDA WITH STROKE (LATIN SMALL LETTER BARRED LAMBDA), LATIN CAPITAL LETTER LAMBDA WITH STROKE
test(0x019C, 0x026F); // LATIN CAPITAL LETTER TURNED M, LATIN SMALL LETTER TURNED M
test(0x019D, 0x0272); // LATIN CAPITAL LETTER N WITH LEFT HOOK (LATIN CAPITAL LETTER N HOOK), LATIN SMALL LETTER N WITH LEFT HOOK (LATIN SMALL LETTER N HOOK)
test(0x019E, 0x0220); // LATIN SMALL LETTER N WITH LONG RIGHT LEG, LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
test(0x019F, 0x0275); // LATIN CAPITAL LETTER O WITH MIDDLE TILDE (LATIN CAPITAL LETTER BARRED O), LATIN SMALL LETTER BARRED O
test(0x01A0, 0x01A1); // LATIN CAPITAL LETTER O WITH HORN (LATIN CAPITAL LETTER O HORN), LATIN SMALL LETTER O WITH HORN (LATIN SMALL LETTER O HORN)
test(0x01A1, 0x01A0); // LATIN SMALL LETTER O WITH HORN (LATIN SMALL LETTER O HORN), LATIN CAPITAL LETTER O WITH HORN (LATIN CAPITAL LETTER O HORN)
test(0x01A2, 0x01A3); // LATIN CAPITAL LETTER OI (LATIN CAPITAL LETTER O I), LATIN SMALL LETTER OI (LATIN SMALL LETTER O I)
test(0x01A3, 0x01A2); // LATIN SMALL LETTER OI (LATIN SMALL LETTER O I), LATIN CAPITAL LETTER OI (LATIN CAPITAL LETTER O I)
test(0x01A4, 0x01A5); // LATIN CAPITAL LETTER P WITH HOOK (LATIN CAPITAL LETTER P HOOK), LATIN SMALL LETTER P WITH HOOK (LATIN SMALL LETTER P HOOK)
test(0x01A5, 0x01A4); // LATIN SMALL LETTER P WITH HOOK (LATIN SMALL LETTER P HOOK), LATIN CAPITAL LETTER P WITH HOOK (LATIN CAPITAL LETTER P HOOK)
test(0x01A6, 0x0280); // LATIN LETTER YR (LATIN LETTER Y R), LATIN LETTER SMALL CAPITAL R
test(0x01A7, 0x01A8); // LATIN CAPITAL LETTER TONE TWO, LATIN SMALL LETTER TONE TWO
test(0x01A8, 0x01A7); // LATIN SMALL LETTER TONE TWO, LATIN CAPITAL LETTER TONE TWO
test(0x01A9, 0x0283); // LATIN CAPITAL LETTER ESH, LATIN SMALL LETTER ESH
test(0x01AC, 0x01AD); // LATIN CAPITAL LETTER T WITH HOOK (LATIN CAPITAL LETTER T HOOK), LATIN SMALL LETTER T WITH HOOK (LATIN SMALL LETTER T HOOK)
test(0x01AD, 0x01AC); // LATIN SMALL LETTER T WITH HOOK (LATIN SMALL LETTER T HOOK), LATIN CAPITAL LETTER T WITH HOOK (LATIN CAPITAL LETTER T HOOK)
test(0x01AE, 0x0288); // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK (LATIN CAPITAL LETTER T RETROFLEX HOOK), LATIN SMALL LETTER T WITH RETROFLEX HOOK (LATIN SMALL LETTER T RETROFLEX HOOK)
test(0x01AF, 0x01B0); // LATIN CAPITAL LETTER U WITH HORN (LATIN CAPITAL LETTER U HORN), LATIN SMALL LETTER U WITH HORN (LATIN SMALL LETTER U HORN)
test(0x01B0, 0x01AF); // LATIN SMALL LETTER U WITH HORN (LATIN SMALL LETTER U HORN), LATIN CAPITAL LETTER U WITH HORN (LATIN CAPITAL LETTER U HORN)
test(0x01B1, 0x028A); // LATIN CAPITAL LETTER UPSILON, LATIN SMALL LETTER UPSILON
test(0x01B2, 0x028B); // LATIN CAPITAL LETTER V WITH HOOK (LATIN CAPITAL LETTER SCRIPT V), LATIN SMALL LETTER V WITH HOOK (LATIN SMALL LETTER SCRIPT V)
test(0x01B3, 0x01B4); // LATIN CAPITAL LETTER Y WITH HOOK (LATIN CAPITAL LETTER Y HOOK), LATIN SMALL LETTER Y WITH HOOK (LATIN SMALL LETTER Y HOOK)
test(0x01B4, 0x01B3); // LATIN SMALL LETTER Y WITH HOOK (LATIN SMALL LETTER Y HOOK), LATIN CAPITAL LETTER Y WITH HOOK (LATIN CAPITAL LETTER Y HOOK)
test(0x01B5, 0x01B6); // LATIN CAPITAL LETTER Z WITH STROKE (LATIN CAPITAL LETTER Z BAR), LATIN SMALL LETTER Z WITH STROKE (LATIN SMALL LETTER Z BAR)
test(0x01B6, 0x01B5); // LATIN SMALL LETTER Z WITH STROKE (LATIN SMALL LETTER Z BAR), LATIN CAPITAL LETTER Z WITH STROKE (LATIN CAPITAL LETTER Z BAR)
test(0x01B7, 0x0292); // LATIN CAPITAL LETTER EZH (LATIN CAPITAL LETTER YOGH), LATIN SMALL LETTER EZH (LATIN SMALL LETTER YOGH)
test(0x01B8, 0x01B9); // LATIN CAPITAL LETTER EZH REVERSED (LATIN CAPITAL LETTER REVERSED YOGH), LATIN SMALL LETTER EZH REVERSED (LATIN SMALL LETTER REVERSED YOGH)
test(0x01B9, 0x01B8); // LATIN SMALL LETTER EZH REVERSED (LATIN SMALL LETTER REVERSED YOGH), LATIN CAPITAL LETTER EZH REVERSED (LATIN CAPITAL LETTER REVERSED YOGH)
test(0x01BC, 0x01BD); // LATIN CAPITAL LETTER TONE FIVE, LATIN SMALL LETTER TONE FIVE
test(0x01BD, 0x01BC); // LATIN SMALL LETTER TONE FIVE, LATIN CAPITAL LETTER TONE FIVE
test(0x01BF, 0x01F7); // LATIN LETTER WYNN, LATIN CAPITAL LETTER WYNN
test(0x01C4, 0x01C6, 0x01C5); // LATIN CAPITAL LETTER DZ WITH CARON (LATIN CAPITAL LETTER D Z HACEK), LATIN SMALL LETTER DZ WITH CARON (LATIN SMALL LETTER D Z HACEK), LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON (LATIN LETTER CAPITAL D SMALL Z HACEK)
test(0x01C5, 0x01C6, 0x01C4); // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON (LATIN LETTER CAPITAL D SMALL Z HACEK), LATIN SMALL LETTER DZ WITH CARON (LATIN SMALL LETTER D Z HACEK), LATIN CAPITAL LETTER DZ WITH CARON (LATIN CAPITAL LETTER D Z HACEK)
test(0x01C6, 0x01C4, 0x01C5); // LATIN SMALL LETTER DZ WITH CARON (LATIN SMALL LETTER D Z HACEK), LATIN CAPITAL LETTER DZ WITH CARON (LATIN CAPITAL LETTER D Z HACEK), LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON (LATIN LETTER CAPITAL D SMALL Z HACEK)
test(0x01C7, 0x01C9, 0x01C8); // LATIN CAPITAL LETTER LJ (LATIN CAPITAL LETTER L J), LATIN SMALL LETTER LJ (LATIN SMALL LETTER L J), LATIN CAPITAL LETTER L WITH SMALL LETTER J (LATIN LETTER CAPITAL L SMALL J)
test(0x01C8, 0x01C9, 0x01C7); // LATIN CAPITAL LETTER L WITH SMALL LETTER J (LATIN LETTER CAPITAL L SMALL J), LATIN SMALL LETTER LJ (LATIN SMALL LETTER L J), LATIN CAPITAL LETTER LJ (LATIN CAPITAL LETTER L J)
test(0x01C9, 0x01C7, 0x01C8); // LATIN SMALL LETTER LJ (LATIN SMALL LETTER L J), LATIN CAPITAL LETTER LJ (LATIN CAPITAL LETTER L J), LATIN CAPITAL LETTER L WITH SMALL LETTER J (LATIN LETTER CAPITAL L SMALL J)
test(0x01CA, 0x01CC, 0x01CB); // LATIN CAPITAL LETTER NJ (LATIN CAPITAL LETTER N J), LATIN SMALL LETTER NJ (LATIN SMALL LETTER N J), LATIN CAPITAL LETTER N WITH SMALL LETTER J (LATIN LETTER CAPITAL N SMALL J)
test(0x01CB, 0x01CC, 0x01CA); // LATIN CAPITAL LETTER N WITH SMALL LETTER J (LATIN LETTER CAPITAL N SMALL J), LATIN SMALL LETTER NJ (LATIN SMALL LETTER N J), LATIN CAPITAL LETTER NJ (LATIN CAPITAL LETTER N J)
test(0x01CC, 0x01CA, 0x01CB); // LATIN SMALL LETTER NJ (LATIN SMALL LETTER N J), LATIN CAPITAL LETTER NJ (LATIN CAPITAL LETTER N J), LATIN CAPITAL LETTER N WITH SMALL LETTER J (LATIN LETTER CAPITAL N SMALL J)
test(0x01CD, 0x01CE); // LATIN CAPITAL LETTER A WITH CARON (LATIN CAPITAL LETTER A HACEK), LATIN SMALL LETTER A WITH CARON (LATIN SMALL LETTER A HACEK)
test(0x01CE, 0x01CD); // LATIN SMALL LETTER A WITH CARON (LATIN SMALL LETTER A HACEK), LATIN CAPITAL LETTER A WITH CARON (LATIN CAPITAL LETTER A HACEK)
test(0x01CF, 0x01D0); // LATIN CAPITAL LETTER I WITH CARON (LATIN CAPITAL LETTER I HACEK), LATIN SMALL LETTER I WITH CARON (LATIN SMALL LETTER I HACEK)
test(0x01D0, 0x01CF); // LATIN SMALL LETTER I WITH CARON (LATIN SMALL LETTER I HACEK), LATIN CAPITAL LETTER I WITH CARON (LATIN CAPITAL LETTER I HACEK)
test(0x01D1, 0x01D2); // LATIN CAPITAL LETTER O WITH CARON (LATIN CAPITAL LETTER O HACEK), LATIN SMALL LETTER O WITH CARON (LATIN SMALL LETTER O HACEK)
test(0x01D2, 0x01D1); // LATIN SMALL LETTER O WITH CARON (LATIN SMALL LETTER O HACEK), LATIN CAPITAL LETTER O WITH CARON (LATIN CAPITAL LETTER O HACEK)
test(0x01D3, 0x01D4); // LATIN CAPITAL LETTER U WITH CARON (LATIN CAPITAL LETTER U HACEK), LATIN SMALL LETTER U WITH CARON (LATIN SMALL LETTER U HACEK)
test(0x01D4, 0x01D3); // LATIN SMALL LETTER U WITH CARON (LATIN SMALL LETTER U HACEK), LATIN CAPITAL LETTER U WITH CARON (LATIN CAPITAL LETTER U HACEK)
test(0x01D5, 0x01D6); // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON (LATIN CAPITAL LETTER U DIAERESIS MACRON), LATIN SMALL LETTER U WITH DIAERESIS AND MACRON (LATIN SMALL LETTER U DIAERESIS MACRON)
test(0x01D6, 0x01D5); // LATIN SMALL LETTER U WITH DIAERESIS AND MACRON (LATIN SMALL LETTER U DIAERESIS MACRON), LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON (LATIN CAPITAL LETTER U DIAERESIS MACRON)
test(0x01D7, 0x01D8); // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE (LATIN CAPITAL LETTER U DIAERESIS ACUTE), LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE (LATIN SMALL LETTER U DIAERESIS ACUTE)
test(0x01D8, 0x01D7); // LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE (LATIN SMALL LETTER U DIAERESIS ACUTE), LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE (LATIN CAPITAL LETTER U DIAERESIS ACUTE)
test(0x01D9, 0x01DA); // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON (LATIN CAPITAL LETTER U DIAERESIS HACEK), LATIN SMALL LETTER U WITH DIAERESIS AND CARON (LATIN SMALL LETTER U DIAERESIS HACEK)
test(0x01DA, 0x01D9); // LATIN SMALL LETTER U WITH DIAERESIS AND CARON (LATIN SMALL LETTER U DIAERESIS HACEK), LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON (LATIN CAPITAL LETTER U DIAERESIS HACEK)
test(0x01DB, 0x01DC); // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE (LATIN CAPITAL LETTER U DIAERESIS GRAVE), LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE (LATIN SMALL LETTER U DIAERESIS GRAVE)
test(0x01DC, 0x01DB); // LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE (LATIN SMALL LETTER U DIAERESIS GRAVE), LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE (LATIN CAPITAL LETTER U DIAERESIS GRAVE)
test(0x01DD, 0x018E); // LATIN SMALL LETTER TURNED E, LATIN CAPITAL LETTER REVERSED E (LATIN CAPITAL LETTER TURNED E)
test(0x01DE, 0x01DF); // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON (LATIN CAPITAL LETTER A DIAERESIS MACRON), LATIN SMALL LETTER A WITH DIAERESIS AND MACRON (LATIN SMALL LETTER A DIAERESIS MACRON)
test(0x01DF, 0x01DE); // LATIN SMALL LETTER A WITH DIAERESIS AND MACRON (LATIN SMALL LETTER A DIAERESIS MACRON), LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON (LATIN CAPITAL LETTER A DIAERESIS MACRON)
test(0x01E0, 0x01E1); // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON (LATIN CAPITAL LETTER A DOT MACRON), LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON (LATIN SMALL LETTER A DOT MACRON)
test(0x01E1, 0x01E0); // LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON (LATIN SMALL LETTER A DOT MACRON), LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON (LATIN CAPITAL LETTER A DOT MACRON)
test(0x01E2, 0x01E3); // LATIN CAPITAL LETTER AE WITH MACRON (LATIN CAPITAL LETTER A E MACRON), LATIN SMALL LETTER AE WITH MACRON (LATIN SMALL LETTER A E MACRON)
test(0x01E3, 0x01E2); // LATIN SMALL LETTER AE WITH MACRON (LATIN SMALL LETTER A E MACRON), LATIN CAPITAL LETTER AE WITH MACRON (LATIN CAPITAL LETTER A E MACRON)
test(0x01E4, 0x01E5); // LATIN CAPITAL LETTER G WITH STROKE (LATIN CAPITAL LETTER G BAR), LATIN SMALL LETTER G WITH STROKE (LATIN SMALL LETTER G BAR)
test(0x01E5, 0x01E4); // LATIN SMALL LETTER G WITH STROKE (LATIN SMALL LETTER G BAR), LATIN CAPITAL LETTER G WITH STROKE (LATIN CAPITAL LETTER G BAR)
test(0x01E6, 0x01E7); // LATIN CAPITAL LETTER G WITH CARON (LATIN CAPITAL LETTER G HACEK), LATIN SMALL LETTER G WITH CARON (LATIN SMALL LETTER G HACEK)
test(0x01E7, 0x01E6); // LATIN SMALL LETTER G WITH CARON (LATIN SMALL LETTER G HACEK), LATIN CAPITAL LETTER G WITH CARON (LATIN CAPITAL LETTER G HACEK)
test(0x01E8, 0x01E9); // LATIN CAPITAL LETTER K WITH CARON (LATIN CAPITAL LETTER K HACEK), LATIN SMALL LETTER K WITH CARON (LATIN SMALL LETTER K HACEK)
test(0x01E9, 0x01E8); // LATIN SMALL LETTER K WITH CARON (LATIN SMALL LETTER K HACEK), LATIN CAPITAL LETTER K WITH CARON (LATIN CAPITAL LETTER K HACEK)
test(0x01EA, 0x01EB); // LATIN CAPITAL LETTER O WITH OGONEK (LATIN CAPITAL LETTER O OGONEK), LATIN SMALL LETTER O WITH OGONEK (LATIN SMALL LETTER O OGONEK)
test(0x01EB, 0x01EA); // LATIN SMALL LETTER O WITH OGONEK (LATIN SMALL LETTER O OGONEK), LATIN CAPITAL LETTER O WITH OGONEK (LATIN CAPITAL LETTER O OGONEK)
test(0x01EC, 0x01ED); // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON (LATIN CAPITAL LETTER O OGONEK MACRON), LATIN SMALL LETTER O WITH OGONEK AND MACRON (LATIN SMALL LETTER O OGONEK MACRON)
test(0x01ED, 0x01EC); // LATIN SMALL LETTER O WITH OGONEK AND MACRON (LATIN SMALL LETTER O OGONEK MACRON), LATIN CAPITAL LETTER O WITH OGONEK AND MACRON (LATIN CAPITAL LETTER O OGONEK MACRON)
test(0x01EE, 0x01EF); // LATIN CAPITAL LETTER EZH WITH CARON (LATIN CAPITAL LETTER YOGH HACEK), LATIN SMALL LETTER EZH WITH CARON (LATIN SMALL LETTER YOGH HACEK)
test(0x01EF, 0x01EE); // LATIN SMALL LETTER EZH WITH CARON (LATIN SMALL LETTER YOGH HACEK), LATIN CAPITAL LETTER EZH WITH CARON (LATIN CAPITAL LETTER YOGH HACEK)
test(0x01F1, 0x01F3, 0x01F2); // LATIN CAPITAL LETTER DZ, LATIN SMALL LETTER DZ, LATIN CAPITAL LETTER D WITH SMALL LETTER Z
test(0x01F2, 0x01F3, 0x01F1); // LATIN CAPITAL LETTER D WITH SMALL LETTER Z, LATIN SMALL LETTER DZ, LATIN CAPITAL LETTER DZ
test(0x01F3, 0x01F1, 0x01F2); // LATIN SMALL LETTER DZ, LATIN CAPITAL LETTER DZ, LATIN CAPITAL LETTER D WITH SMALL LETTER Z
test(0x01F4, 0x01F5); // LATIN CAPITAL LETTER G WITH ACUTE, LATIN SMALL LETTER G WITH ACUTE
test(0x01F5, 0x01F4); // LATIN SMALL LETTER G WITH ACUTE, LATIN CAPITAL LETTER G WITH ACUTE
test(0x01F6, 0x0195); // LATIN CAPITAL LETTER HWAIR, LATIN SMALL LETTER HV (LATIN SMALL LETTER H V)
test(0x01F7, 0x01BF); // LATIN CAPITAL LETTER WYNN, LATIN LETTER WYNN
test(0x01F8, 0x01F9); // LATIN CAPITAL LETTER N WITH GRAVE, LATIN SMALL LETTER N WITH GRAVE
test(0x01F9, 0x01F8); // LATIN SMALL LETTER N WITH GRAVE, LATIN CAPITAL LETTER N WITH GRAVE
test(0x01FA, 0x01FB); // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE, LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
test(0x01FB, 0x01FA); // LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE, LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
test(0x01FC, 0x01FD); // LATIN CAPITAL LETTER AE WITH ACUTE, LATIN SMALL LETTER AE WITH ACUTE
test(0x01FD, 0x01FC); // LATIN SMALL LETTER AE WITH ACUTE, LATIN CAPITAL LETTER AE WITH ACUTE
test(0x01FE, 0x01FF); // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE, LATIN SMALL LETTER O WITH STROKE AND ACUTE
test(0x01FF, 0x01FE); // LATIN SMALL LETTER O WITH STROKE AND ACUTE, LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
test(0x0200, 0x0201); // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE, LATIN SMALL LETTER A WITH DOUBLE GRAVE
test(0x0201, 0x0200); // LATIN SMALL LETTER A WITH DOUBLE GRAVE, LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
test(0x0202, 0x0203); // LATIN CAPITAL LETTER A WITH INVERTED BREVE, LATIN SMALL LETTER A WITH INVERTED BREVE
test(0x0203, 0x0202); // LATIN SMALL LETTER A WITH INVERTED BREVE, LATIN CAPITAL LETTER A WITH INVERTED BREVE
test(0x0204, 0x0205); // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE, LATIN SMALL LETTER E WITH DOUBLE GRAVE
test(0x0205, 0x0204); // LATIN SMALL LETTER E WITH DOUBLE GRAVE, LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
test(0x0206, 0x0207); // LATIN CAPITAL LETTER E WITH INVERTED BREVE, LATIN SMALL LETTER E WITH INVERTED BREVE
test(0x0207, 0x0206); // LATIN SMALL LETTER E WITH INVERTED BREVE, LATIN CAPITAL LETTER E WITH INVERTED BREVE
test(0x0208, 0x0209); // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE, LATIN SMALL LETTER I WITH DOUBLE GRAVE
test(0x0209, 0x0208); // LATIN SMALL LETTER I WITH DOUBLE GRAVE, LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
test(0x020A, 0x020B); // LATIN CAPITAL LETTER I WITH INVERTED BREVE, LATIN SMALL LETTER I WITH INVERTED BREVE
test(0x020B, 0x020A); // LATIN SMALL LETTER I WITH INVERTED BREVE, LATIN CAPITAL LETTER I WITH INVERTED BREVE
test(0x020C, 0x020D); // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE, LATIN SMALL LETTER O WITH DOUBLE GRAVE
test(0x020D, 0x020C); // LATIN SMALL LETTER O WITH DOUBLE GRAVE, LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
test(0x020E, 0x020F); // LATIN CAPITAL LETTER O WITH INVERTED BREVE, LATIN SMALL LETTER O WITH INVERTED BREVE
test(0x020F, 0x020E); // LATIN SMALL LETTER O WITH INVERTED BREVE, LATIN CAPITAL LETTER O WITH INVERTED BREVE
test(0x0210, 0x0211); // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE, LATIN SMALL LETTER R WITH DOUBLE GRAVE
test(0x0211, 0x0210); // LATIN SMALL LETTER R WITH DOUBLE GRAVE, LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
test(0x0212, 0x0213); // LATIN CAPITAL LETTER R WITH INVERTED BREVE, LATIN SMALL LETTER R WITH INVERTED BREVE
test(0x0213, 0x0212); // LATIN SMALL LETTER R WITH INVERTED BREVE, LATIN CAPITAL LETTER R WITH INVERTED BREVE
test(0x0214, 0x0215); // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE, LATIN SMALL LETTER U WITH DOUBLE GRAVE
test(0x0215, 0x0214); // LATIN SMALL LETTER U WITH DOUBLE GRAVE, LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
test(0x0216, 0x0217); // LATIN CAPITAL LETTER U WITH INVERTED BREVE, LATIN SMALL LETTER U WITH INVERTED BREVE
test(0x0217, 0x0216); // LATIN SMALL LETTER U WITH INVERTED BREVE, LATIN CAPITAL LETTER U WITH INVERTED BREVE
test(0x0218, 0x0219); // LATIN CAPITAL LETTER S WITH COMMA BELOW, LATIN SMALL LETTER S WITH COMMA BELOW
test(0x0219, 0x0218); // LATIN SMALL LETTER S WITH COMMA BELOW, LATIN CAPITAL LETTER S WITH COMMA BELOW
test(0x021A, 0x021B); // LATIN CAPITAL LETTER T WITH COMMA BELOW, LATIN SMALL LETTER T WITH COMMA BELOW
test(0x021B, 0x021A); // LATIN SMALL LETTER T WITH COMMA BELOW, LATIN CAPITAL LETTER T WITH COMMA BELOW
test(0x021C, 0x021D); // LATIN CAPITAL LETTER YOGH, LATIN SMALL LETTER YOGH
test(0x021D, 0x021C); // LATIN SMALL LETTER YOGH, LATIN CAPITAL LETTER YOGH
test(0x021E, 0x021F); // LATIN CAPITAL LETTER H WITH CARON, LATIN SMALL LETTER H WITH CARON
test(0x021F, 0x021E); // LATIN SMALL LETTER H WITH CARON, LATIN CAPITAL LETTER H WITH CARON
test(0x0220, 0x019E); // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG, LATIN SMALL LETTER N WITH LONG RIGHT LEG
test(0x0222, 0x0223); // LATIN CAPITAL LETTER OU, LATIN SMALL LETTER OU
test(0x0223, 0x0222); // LATIN SMALL LETTER OU, LATIN CAPITAL LETTER OU
test(0x0224, 0x0225); // LATIN CAPITAL LETTER Z WITH HOOK, LATIN SMALL LETTER Z WITH HOOK
test(0x0225, 0x0224); // LATIN SMALL LETTER Z WITH HOOK, LATIN CAPITAL LETTER Z WITH HOOK
test(0x0226, 0x0227); // LATIN CAPITAL LETTER A WITH DOT ABOVE, LATIN SMALL LETTER A WITH DOT ABOVE
test(0x0227, 0x0226); // LATIN SMALL LETTER A WITH DOT ABOVE, LATIN CAPITAL LETTER A WITH DOT ABOVE
test(0x0228, 0x0229); // LATIN CAPITAL LETTER E WITH CEDILLA, LATIN SMALL LETTER E WITH CEDILLA
test(0x0229, 0x0228); // LATIN SMALL LETTER E WITH CEDILLA, LATIN CAPITAL LETTER E WITH CEDILLA
test(0x022A, 0x022B); // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON, LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
test(0x022B, 0x022A); // LATIN SMALL LETTER O WITH DIAERESIS AND MACRON, LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
test(0x022C, 0x022D); // LATIN CAPITAL LETTER O WITH TILDE AND MACRON, LATIN SMALL LETTER O WITH TILDE AND MACRON
test(0x022D, 0x022C); // LATIN SMALL LETTER O WITH TILDE AND MACRON, LATIN CAPITAL LETTER O WITH TILDE AND MACRON
test(0x022E, 0x022F); // LATIN CAPITAL LETTER O WITH DOT ABOVE, LATIN SMALL LETTER O WITH DOT ABOVE
test(0x022F, 0x022E); // LATIN SMALL LETTER O WITH DOT ABOVE, LATIN CAPITAL LETTER O WITH DOT ABOVE
test(0x0230, 0x0231); // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON, LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
test(0x0231, 0x0230); // LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON, LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
test(0x0232, 0x0233); // LATIN CAPITAL LETTER Y WITH MACRON, LATIN SMALL LETTER Y WITH MACRON
test(0x0233, 0x0232); // LATIN SMALL LETTER Y WITH MACRON, LATIN CAPITAL LETTER Y WITH MACRON
test(0x023A, 0x2C65); // LATIN CAPITAL LETTER A WITH STROKE, LATIN SMALL LETTER A WITH STROKE
test(0x023B, 0x023C); // LATIN CAPITAL LETTER C WITH STROKE, LATIN SMALL LETTER C WITH STROKE
test(0x023C, 0x023B); // LATIN SMALL LETTER C WITH STROKE, LATIN CAPITAL LETTER C WITH STROKE
test(0x023D, 0x019A); // LATIN CAPITAL LETTER L WITH BAR, LATIN SMALL LETTER L WITH BAR (LATIN SMALL LETTER BARRED L)
test(0x023E, 0x2C66); // LATIN CAPITAL LETTER T WITH DIAGONAL STROKE, LATIN SMALL LETTER T WITH DIAGONAL STROKE
test(0x023F, 0x2C7E); // LATIN SMALL LETTER S WITH SWASH TAIL, LATIN CAPITAL LETTER S WITH SWASH TAIL
test(0x0240, 0x2C7F); // LATIN SMALL LETTER Z WITH SWASH TAIL, LATIN CAPITAL LETTER Z WITH SWASH TAIL
test(0x0241, 0x0242); // LATIN CAPITAL LETTER GLOTTAL STOP, LATIN SMALL LETTER GLOTTAL STOP
test(0x0242, 0x0241); // LATIN SMALL LETTER GLOTTAL STOP, LATIN CAPITAL LETTER GLOTTAL STOP
test(0x0243, 0x0180); // LATIN CAPITAL LETTER B WITH STROKE, LATIN SMALL LETTER B WITH STROKE (LATIN SMALL LETTER B BAR)
test(0x0244, 0x0289); // LATIN CAPITAL LETTER U BAR, LATIN SMALL LETTER U BAR
test(0x0245, 0x028C); // LATIN CAPITAL LETTER TURNED V, LATIN SMALL LETTER TURNED V
test(0x0246, 0x0247); // LATIN CAPITAL LETTER E WITH STROKE, LATIN SMALL LETTER E WITH STROKE
test(0x0247, 0x0246); // LATIN SMALL LETTER E WITH STROKE, LATIN CAPITAL LETTER E WITH STROKE
test(0x0248, 0x0249); // LATIN CAPITAL LETTER J WITH STROKE, LATIN SMALL LETTER J WITH STROKE
test(0x0249, 0x0248); // LATIN SMALL LETTER J WITH STROKE, LATIN CAPITAL LETTER J WITH STROKE
test(0x024A, 0x024B); // LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL, LATIN SMALL LETTER Q WITH HOOK TAIL
test(0x024B, 0x024A); // LATIN SMALL LETTER Q WITH HOOK TAIL, LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
test(0x024C, 0x024D); // LATIN CAPITAL LETTER R WITH STROKE, LATIN SMALL LETTER R WITH STROKE
test(0x024D, 0x024C); // LATIN SMALL LETTER R WITH STROKE, LATIN CAPITAL LETTER R WITH STROKE
test(0x024E, 0x024F); // LATIN CAPITAL LETTER Y WITH STROKE, LATIN SMALL LETTER Y WITH STROKE
test(0x024F, 0x024E); // LATIN SMALL LETTER Y WITH STROKE, LATIN CAPITAL LETTER Y WITH STROKE
test(0x0250, 0x2C6F); // LATIN SMALL LETTER TURNED A, LATIN CAPITAL LETTER TURNED A
test(0x0251, 0x2C6D); // LATIN SMALL LETTER ALPHA (LATIN SMALL LETTER SCRIPT A), LATIN CAPITAL LETTER ALPHA
test(0x0252, 0x2C70); // LATIN SMALL LETTER TURNED ALPHA (LATIN SMALL LETTER TURNED SCRIPT A), LATIN CAPITAL LETTER TURNED ALPHA
test(0x0253, 0x0181); // LATIN SMALL LETTER B WITH HOOK (LATIN SMALL LETTER B HOOK), LATIN CAPITAL LETTER B WITH HOOK (LATIN CAPITAL LETTER B HOOK)
test(0x0254, 0x0186); // LATIN SMALL LETTER OPEN O, LATIN CAPITAL LETTER OPEN O
test(0x0256, 0x0189); // LATIN SMALL LETTER D WITH TAIL (LATIN SMALL LETTER D RETROFLEX HOOK), LATIN CAPITAL LETTER AFRICAN D
test(0x0257, 0x018A); // LATIN SMALL LETTER D WITH HOOK (LATIN SMALL LETTER D HOOK), LATIN CAPITAL LETTER D WITH HOOK (LATIN CAPITAL LETTER D HOOK)
test(0x0259, 0x018F); // LATIN SMALL LETTER SCHWA, LATIN CAPITAL LETTER SCHWA
test(0x025B, 0x0190); // LATIN SMALL LETTER OPEN E (LATIN SMALL LETTER EPSILON), LATIN CAPITAL LETTER OPEN E (LATIN CAPITAL LETTER EPSILON)
test(0x025C, 0xA7AB); // LATIN SMALL LETTER REVERSED OPEN E (LATIN SMALL LETTER REVERSED EPSILON), LATIN CAPITAL LETTER REVERSED OPEN E
test(0x0260, 0x0193); // LATIN SMALL LETTER G WITH HOOK (LATIN SMALL LETTER G HOOK), LATIN CAPITAL LETTER G WITH HOOK (LATIN CAPITAL LETTER G HOOK)
test(0x0261, 0xA7AC); // LATIN SMALL LETTER SCRIPT G, LATIN CAPITAL LETTER SCRIPT G
test(0x0263, 0x0194); // LATIN SMALL LETTER GAMMA, LATIN CAPITAL LETTER GAMMA
test(0x0264, 0xA7CB); // LATIN SMALL LETTER RAMS HORN (LATIN SMALL LETTER BABY GAMMA), LATIN CAPITAL LETTER RAMS HORN
test(0x0265, 0xA78D); // LATIN SMALL LETTER TURNED H, LATIN CAPITAL LETTER TURNED H
test(0x0266, 0xA7AA); // LATIN SMALL LETTER H WITH HOOK (LATIN SMALL LETTER H HOOK), LATIN CAPITAL LETTER H WITH HOOK
test(0x0268, 0x0197); // LATIN SMALL LETTER I WITH STROKE (LATIN SMALL LETTER BARRED I), LATIN CAPITAL LETTER I WITH STROKE (LATIN CAPITAL LETTER BARRED I)
test(0x0269, 0x0196); // LATIN SMALL LETTER IOTA, LATIN CAPITAL LETTER IOTA
test(0x026A, 0xA7AE); // LATIN LETTER SMALL CAPITAL I, LATIN CAPITAL LETTER SMALL CAPITAL I
test(0x026B, 0x2C62); // LATIN SMALL LETTER L WITH MIDDLE TILDE, LATIN CAPITAL LETTER L WITH MIDDLE TILDE
test(0x026C, 0xA7AD); // LATIN SMALL LETTER L WITH BELT (LATIN SMALL LETTER L BELT), LATIN CAPITAL LETTER L WITH BELT
test(0x026F, 0x019C); // LATIN SMALL LETTER TURNED M, LATIN CAPITAL LETTER TURNED M
test(0x0271, 0x2C6E); // LATIN SMALL LETTER M WITH HOOK (LATIN SMALL LETTER M HOOK), LATIN CAPITAL LETTER M WITH HOOK
test(0x0272, 0x019D); // LATIN SMALL LETTER N WITH LEFT HOOK (LATIN SMALL LETTER N HOOK), LATIN CAPITAL LETTER N WITH LEFT HOOK (LATIN CAPITAL LETTER N HOOK)
test(0x0275, 0x019F); // LATIN SMALL LETTER BARRED O, LATIN CAPITAL LETTER O WITH MIDDLE TILDE (LATIN CAPITAL LETTER BARRED O)
test(0x027D, 0x2C64); // LATIN SMALL LETTER R WITH TAIL (LATIN SMALL LETTER R HOOK), LATIN CAPITAL LETTER R WITH TAIL
test(0x0280, 0x01A6); // LATIN LETTER SMALL CAPITAL R, LATIN LETTER YR (LATIN LETTER Y R)
test(0x0282, 0xA7C5); // LATIN SMALL LETTER S WITH HOOK (LATIN SMALL LETTER S HOOK), LATIN CAPITAL LETTER S WITH HOOK
test(0x0283, 0x01A9); // LATIN SMALL LETTER ESH, LATIN CAPITAL LETTER ESH
test(0x0287, 0xA7B1); // LATIN SMALL LETTER TURNED T, LATIN CAPITAL LETTER TURNED T
test(0x0288, 0x01AE); // LATIN SMALL LETTER T WITH RETROFLEX HOOK (LATIN SMALL LETTER T RETROFLEX HOOK), LATIN CAPITAL LETTER T WITH RETROFLEX HOOK (LATIN CAPITAL LETTER T RETROFLEX HOOK)
test(0x0289, 0x0244); // LATIN SMALL LETTER U BAR, LATIN CAPITAL LETTER U BAR
test(0x028A, 0x01B1); // LATIN SMALL LETTER UPSILON, LATIN CAPITAL LETTER UPSILON
test(0x028B, 0x01B2); // LATIN SMALL LETTER V WITH HOOK (LATIN SMALL LETTER SCRIPT V), LATIN CAPITAL LETTER V WITH HOOK (LATIN CAPITAL LETTER SCRIPT V)
test(0x028C, 0x0245); // LATIN SMALL LETTER TURNED V, LATIN CAPITAL LETTER TURNED V
test(0x0292, 0x01B7); // LATIN SMALL LETTER EZH (LATIN SMALL LETTER YOGH), LATIN CAPITAL LETTER EZH (LATIN CAPITAL LETTER YOGH)
test(0x029D, 0xA7B2); // LATIN SMALL LETTER J WITH CROSSED-TAIL (LATIN SMALL LETTER CROSSED-TAIL J), LATIN CAPITAL LETTER J WITH CROSSED-TAIL
test(0x029E, 0xA7B0); // LATIN SMALL LETTER TURNED K, LATIN CAPITAL LETTER TURNED K
test(0x0345, 0x03B9, 0x0399, 0x1FBE); // COMBINING GREEK YPOGEGRAMMENI (GREEK NON-SPACING IOTA BELOW), GREEK SMALL LETTER IOTA, GREEK CAPITAL LETTER IOTA, GREEK PROSGEGRAMMENI
test(0x0370, 0x0371); // GREEK CAPITAL LETTER HETA, GREEK SMALL LETTER HETA
test(0x0371, 0x0370); // GREEK SMALL LETTER HETA, GREEK CAPITAL LETTER HETA
test(0x0372, 0x0373); // GREEK CAPITAL LETTER ARCHAIC SAMPI, GREEK SMALL LETTER ARCHAIC SAMPI
test(0x0373, 0x0372); // GREEK SMALL LETTER ARCHAIC SAMPI, GREEK CAPITAL LETTER ARCHAIC SAMPI
test(0x0376, 0x0377); // GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA, GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
test(0x0377, 0x0376); // GREEK SMALL LETTER PAMPHYLIAN DIGAMMA, GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
test(0x037B, 0x03FD); // GREEK SMALL REVERSED LUNATE SIGMA SYMBOL, GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL
test(0x037C, 0x03FE); // GREEK SMALL DOTTED LUNATE SIGMA SYMBOL, GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL
test(0x037D, 0x03FF); // GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL, GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
test(0x037F, 0x03F3); // GREEK CAPITAL LETTER YOT, GREEK LETTER YOT
test(0x0386, 0x03AC); // GREEK CAPITAL LETTER ALPHA WITH TONOS (GREEK CAPITAL LETTER ALPHA TONOS), GREEK SMALL LETTER ALPHA WITH TONOS (GREEK SMALL LETTER ALPHA TONOS)
test(0x0388, 0x03AD); // GREEK CAPITAL LETTER EPSILON WITH TONOS (GREEK CAPITAL LETTER EPSILON TONOS), GREEK SMALL LETTER EPSILON WITH TONOS (GREEK SMALL LETTER EPSILON TONOS)
test(0x0389, 0x03AE); // GREEK CAPITAL LETTER ETA WITH TONOS (GREEK CAPITAL LETTER ETA TONOS), GREEK SMALL LETTER ETA WITH TONOS (GREEK SMALL LETTER ETA TONOS)
test(0x038A, 0x03AF); // GREEK CAPITAL LETTER IOTA WITH TONOS (GREEK CAPITAL LETTER IOTA TONOS), GREEK SMALL LETTER IOTA WITH TONOS (GREEK SMALL LETTER IOTA TONOS)
test(0x038C, 0x03CC); // GREEK CAPITAL LETTER OMICRON WITH TONOS (GREEK CAPITAL LETTER OMICRON TONOS), GREEK SMALL LETTER OMICRON WITH TONOS (GREEK SMALL LETTER OMICRON TONOS)
test(0x038E, 0x03CD); // GREEK CAPITAL LETTER UPSILON WITH TONOS (GREEK CAPITAL LETTER UPSILON TONOS), GREEK SMALL LETTER UPSILON WITH TONOS (GREEK SMALL LETTER UPSILON TONOS)
test(0x038F, 0x03CE); // GREEK CAPITAL LETTER OMEGA WITH TONOS (GREEK CAPITAL LETTER OMEGA TONOS), GREEK SMALL LETTER OMEGA WITH TONOS (GREEK SMALL LETTER OMEGA TONOS)
test(0x0390, 0x1FD3); // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER IOTA DIAERESIS TONOS), GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
test(0x0391, 0x03B1); // GREEK CAPITAL LETTER ALPHA, GREEK SMALL LETTER ALPHA
test(0x0392, 0x03B2, 0x03D0); // GREEK CAPITAL LETTER BETA, GREEK SMALL LETTER BETA, GREEK BETA SYMBOL (GREEK SMALL LETTER CURLED BETA)
test(0x0393, 0x03B3); // GREEK CAPITAL LETTER GAMMA, GREEK SMALL LETTER GAMMA
test(0x0394, 0x03B4); // GREEK CAPITAL LETTER DELTA, GREEK SMALL LETTER DELTA
test(0x0395, 0x03B5, 0x03F5); // GREEK CAPITAL LETTER EPSILON, GREEK SMALL LETTER EPSILON, GREEK LUNATE EPSILON SYMBOL
test(0x0396, 0x03B6); // GREEK CAPITAL LETTER ZETA, GREEK SMALL LETTER ZETA
test(0x0397, 0x03B7); // GREEK CAPITAL LETTER ETA, GREEK SMALL LETTER ETA
test(0x0398, 0x03B8, 0x03D1, 0x03F4); // GREEK CAPITAL LETTER THETA, GREEK SMALL LETTER THETA, GREEK THETA SYMBOL (GREEK SMALL LETTER SCRIPT THETA), GREEK CAPITAL THETA SYMBOL
test(0x0399, 0x03B9, 0x0345, 0x1FBE); // GREEK CAPITAL LETTER IOTA, GREEK SMALL LETTER IOTA, COMBINING GREEK YPOGEGRAMMENI (GREEK NON-SPACING IOTA BELOW), GREEK PROSGEGRAMMENI
test(0x039A, 0x03BA, 0x03F0); // GREEK CAPITAL LETTER KAPPA, GREEK SMALL LETTER KAPPA, GREEK KAPPA SYMBOL (GREEK SMALL LETTER SCRIPT KAPPA)
test(0x039B, 0x03BB); // GREEK CAPITAL LETTER LAMDA (GREEK CAPITAL LETTER LAMBDA), GREEK SMALL LETTER LAMDA (GREEK SMALL LETTER LAMBDA)
test(0x039C, 0x03BC, 0x00B5); // GREEK CAPITAL LETTER MU, GREEK SMALL LETTER MU, MICRO SIGN
test(0x039D, 0x03BD); // GREEK CAPITAL LETTER NU, GREEK SMALL LETTER NU
test(0x039E, 0x03BE); // GREEK CAPITAL LETTER XI, GREEK SMALL LETTER XI
test(0x039F, 0x03BF); // GREEK CAPITAL LETTER OMICRON, GREEK SMALL LETTER OMICRON
test(0x03A0, 0x03C0, 0x03D6); // GREEK CAPITAL LETTER PI, GREEK SMALL LETTER PI, GREEK PI SYMBOL (GREEK SMALL LETTER OMEGA PI)
test(0x03A1, 0x03C1, 0x03F1); // GREEK CAPITAL LETTER RHO, GREEK SMALL LETTER RHO, GREEK RHO SYMBOL (GREEK SMALL LETTER TAILED RHO)
test(0x03A3, 0x03C3, 0x03C2); // GREEK CAPITAL LETTER SIGMA, GREEK SMALL LETTER SIGMA, GREEK SMALL LETTER FINAL SIGMA
test(0x03A4, 0x03C4); // GREEK CAPITAL LETTER TAU, GREEK SMALL LETTER TAU
test(0x03A5, 0x03C5); // GREEK CAPITAL LETTER UPSILON, GREEK SMALL LETTER UPSILON
test(0x03A6, 0x03C6, 0x03D5); // GREEK CAPITAL LETTER PHI, GREEK SMALL LETTER PHI, GREEK PHI SYMBOL (GREEK SMALL LETTER SCRIPT PHI)
test(0x03A7, 0x03C7); // GREEK CAPITAL LETTER CHI, GREEK SMALL LETTER CHI
test(0x03A8, 0x03C8); // GREEK CAPITAL LETTER PSI, GREEK SMALL LETTER PSI
test(0x03A9, 0x03C9, 0x2126); // GREEK CAPITAL LETTER OMEGA, GREEK SMALL LETTER OMEGA, OHM SIGN (OHM)
test(0x03AA, 0x03CA); // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA (GREEK CAPITAL LETTER IOTA DIAERESIS), GREEK SMALL LETTER IOTA WITH DIALYTIKA (GREEK SMALL LETTER IOTA DIAERESIS)
test(0x03AB, 0x03CB); // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA (GREEK CAPITAL LETTER UPSILON DIAERESIS), GREEK SMALL LETTER UPSILON WITH DIALYTIKA (GREEK SMALL LETTER UPSILON DIAERESIS)
test(0x03AC, 0x0386); // GREEK SMALL LETTER ALPHA WITH TONOS (GREEK SMALL LETTER ALPHA TONOS), GREEK CAPITAL LETTER ALPHA WITH TONOS (GREEK CAPITAL LETTER ALPHA TONOS)
test(0x03AD, 0x0388); // GREEK SMALL LETTER EPSILON WITH TONOS (GREEK SMALL LETTER EPSILON TONOS), GREEK CAPITAL LETTER EPSILON WITH TONOS (GREEK CAPITAL LETTER EPSILON TONOS)
test(0x03AE, 0x0389); // GREEK SMALL LETTER ETA WITH TONOS (GREEK SMALL LETTER ETA TONOS), GREEK CAPITAL LETTER ETA WITH TONOS (GREEK CAPITAL LETTER ETA TONOS)
test(0x03AF, 0x038A); // GREEK SMALL LETTER IOTA WITH TONOS (GREEK SMALL LETTER IOTA TONOS), GREEK CAPITAL LETTER IOTA WITH TONOS (GREEK CAPITAL LETTER IOTA TONOS)
test(0x03B0, 0x1FE3); // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER UPSILON DIAERESIS TONOS), GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
test(0x03B1, 0x0391); // GREEK SMALL LETTER ALPHA, GREEK CAPITAL LETTER ALPHA
test(0x03B2, 0x0392, 0x03D0); // GREEK SMALL LETTER BETA, GREEK CAPITAL LETTER BETA, GREEK BETA SYMBOL (GREEK SMALL LETTER CURLED BETA)
test(0x03B3, 0x0393); // GREEK SMALL LETTER GAMMA, GREEK CAPITAL LETTER GAMMA
test(0x03B4, 0x0394); // GREEK SMALL LETTER DELTA, GREEK CAPITAL LETTER DELTA
test(0x03B5, 0x0395, 0x03F5); // GREEK SMALL LETTER EPSILON, GREEK CAPITAL LETTER EPSILON, GREEK LUNATE EPSILON SYMBOL
test(0x03B6, 0x0396); // GREEK SMALL LETTER ZETA, GREEK CAPITAL LETTER ZETA
test(0x03B7, 0x0397); // GREEK SMALL LETTER ETA, GREEK CAPITAL LETTER ETA
test(0x03B8, 0x0398, 0x03D1, 0x03F4); // GREEK SMALL LETTER THETA, GREEK CAPITAL LETTER THETA, GREEK THETA SYMBOL (GREEK SMALL LETTER SCRIPT THETA), GREEK CAPITAL THETA SYMBOL
test(0x03B9, 0x0345, 0x0399, 0x1FBE); // GREEK SMALL LETTER IOTA, COMBINING GREEK YPOGEGRAMMENI (GREEK NON-SPACING IOTA BELOW), GREEK CAPITAL LETTER IOTA, GREEK PROSGEGRAMMENI
test(0x03BA, 0x039A, 0x03F0); // GREEK SMALL LETTER KAPPA, GREEK CAPITAL LETTER KAPPA, GREEK KAPPA SYMBOL (GREEK SMALL LETTER SCRIPT KAPPA)
test(0x03BB, 0x039B); // GREEK SMALL LETTER LAMDA (GREEK SMALL LETTER LAMBDA), GREEK CAPITAL LETTER LAMDA (GREEK CAPITAL LETTER LAMBDA)
test(0x03BC, 0x00B5, 0x039C); // GREEK SMALL LETTER MU, MICRO SIGN, GREEK CAPITAL LETTER MU
test(0x03BD, 0x039D); // GREEK SMALL LETTER NU, GREEK CAPITAL LETTER NU
test(0x03BE, 0x039E); // GREEK SMALL LETTER XI, GREEK CAPITAL LETTER XI
test(0x03BF, 0x039F); // GREEK SMALL LETTER OMICRON, GREEK CAPITAL LETTER OMICRON
test(0x03C0, 0x03A0, 0x03D6); // GREEK SMALL LETTER PI, GREEK CAPITAL LETTER PI, GREEK PI SYMBOL (GREEK SMALL LETTER OMEGA PI)
test(0x03C1, 0x03A1, 0x03F1); // GREEK SMALL LETTER RHO, GREEK CAPITAL LETTER RHO, GREEK RHO SYMBOL (GREEK SMALL LETTER TAILED RHO)
test(0x03C2, 0x03C3, 0x03A3); // GREEK SMALL LETTER FINAL SIGMA, GREEK SMALL LETTER SIGMA, GREEK CAPITAL LETTER SIGMA
test(0x03C3, 0x03A3, 0x03C2); // GREEK SMALL LETTER SIGMA, GREEK CAPITAL LETTER SIGMA, GREEK SMALL LETTER FINAL SIGMA
test(0x03C4, 0x03A4); // GREEK SMALL LETTER TAU, GREEK CAPITAL LETTER TAU
test(0x03C5, 0x03A5); // GREEK SMALL LETTER UPSILON, GREEK CAPITAL LETTER UPSILON
test(0x03C6, 0x03A6, 0x03D5); // GREEK SMALL LETTER PHI, GREEK CAPITAL LETTER PHI, GREEK PHI SYMBOL (GREEK SMALL LETTER SCRIPT PHI)
test(0x03C7, 0x03A7); // GREEK SMALL LETTER CHI, GREEK CAPITAL LETTER CHI
test(0x03C8, 0x03A8); // GREEK SMALL LETTER PSI, GREEK CAPITAL LETTER PSI
test(0x03C9, 0x03A9, 0x2126); // GREEK SMALL LETTER OMEGA, GREEK CAPITAL LETTER OMEGA, OHM SIGN (OHM)
test(0x03CA, 0x03AA); // GREEK SMALL LETTER IOTA WITH DIALYTIKA (GREEK SMALL LETTER IOTA DIAERESIS), GREEK CAPITAL LETTER IOTA WITH DIALYTIKA (GREEK CAPITAL LETTER IOTA DIAERESIS)
test(0x03CB, 0x03AB); // GREEK SMALL LETTER UPSILON WITH DIALYTIKA (GREEK SMALL LETTER UPSILON DIAERESIS), GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA (GREEK CAPITAL LETTER UPSILON DIAERESIS)
test(0x03CC, 0x038C); // GREEK SMALL LETTER OMICRON WITH TONOS (GREEK SMALL LETTER OMICRON TONOS), GREEK CAPITAL LETTER OMICRON WITH TONOS (GREEK CAPITAL LETTER OMICRON TONOS)
test(0x03CD, 0x038E); // GREEK SMALL LETTER UPSILON WITH TONOS (GREEK SMALL LETTER UPSILON TONOS), GREEK CAPITAL LETTER UPSILON WITH TONOS (GREEK CAPITAL LETTER UPSILON TONOS)
test(0x03CE, 0x038F); // GREEK SMALL LETTER OMEGA WITH TONOS (GREEK SMALL LETTER OMEGA TONOS), GREEK CAPITAL LETTER OMEGA WITH TONOS (GREEK CAPITAL LETTER OMEGA TONOS)
test(0x03CF, 0x03D7); // GREEK CAPITAL KAI SYMBOL, GREEK KAI SYMBOL
test(0x03D0, 0x03B2, 0x0392); // GREEK BETA SYMBOL (GREEK SMALL LETTER CURLED BETA), GREEK SMALL LETTER BETA, GREEK CAPITAL LETTER BETA
test(0x03D1, 0x03B8, 0x0398, 0x03F4); // GREEK THETA SYMBOL (GREEK SMALL LETTER SCRIPT THETA), GREEK SMALL LETTER THETA, GREEK CAPITAL LETTER THETA, GREEK CAPITAL THETA SYMBOL
test(0x03D5, 0x03C6, 0x03A6); // GREEK PHI SYMBOL (GREEK SMALL LETTER SCRIPT PHI), GREEK SMALL LETTER PHI, GREEK CAPITAL LETTER PHI
test(0x03D6, 0x03C0, 0x03A0); // GREEK PI SYMBOL (GREEK SMALL LETTER OMEGA PI), GREEK SMALL LETTER PI, GREEK CAPITAL LETTER PI
test(0x03D7, 0x03CF); // GREEK KAI SYMBOL, GREEK CAPITAL KAI SYMBOL
test(0x03D8, 0x03D9); // GREEK LETTER ARCHAIC KOPPA, GREEK SMALL LETTER ARCHAIC KOPPA
test(0x03D9, 0x03D8); // GREEK SMALL LETTER ARCHAIC KOPPA, GREEK LETTER ARCHAIC KOPPA
test(0x03DA, 0x03DB); // GREEK LETTER STIGMA (GREEK CAPITAL LETTER STIGMA), GREEK SMALL LETTER STIGMA
test(0x03DB, 0x03DA); // GREEK SMALL LETTER STIGMA, GREEK LETTER STIGMA (GREEK CAPITAL LETTER STIGMA)
test(0x03DC, 0x03DD); // GREEK LETTER DIGAMMA (GREEK CAPITAL LETTER DIGAMMA), GREEK SMALL LETTER DIGAMMA
test(0x03DD, 0x03DC); // GREEK SMALL LETTER DIGAMMA, GREEK LETTER DIGAMMA (GREEK CAPITAL LETTER DIGAMMA)
test(0x03DE, 0x03DF); // GREEK LETTER KOPPA (GREEK CAPITAL LETTER KOPPA), GREEK SMALL LETTER KOPPA
test(0x03DF, 0x03DE); // GREEK SMALL LETTER KOPPA, GREEK LETTER KOPPA (GREEK CAPITAL LETTER KOPPA)
test(0x03E0, 0x03E1); // GREEK LETTER SAMPI (GREEK CAPITAL LETTER SAMPI), GREEK SMALL LETTER SAMPI
test(0x03E1, 0x03E0); // GREEK SMALL LETTER SAMPI, GREEK LETTER SAMPI (GREEK CAPITAL LETTER SAMPI)
test(0x03E2, 0x03E3); // COPTIC CAPITAL LETTER SHEI (GREEK CAPITAL LETTER SHEI), COPTIC SMALL LETTER SHEI (GREEK SMALL LETTER SHEI)
test(0x03E3, 0x03E2); // COPTIC SMALL LETTER SHEI (GREEK SMALL LETTER SHEI), COPTIC CAPITAL LETTER SHEI (GREEK CAPITAL LETTER SHEI)
test(0x03E4, 0x03E5); // COPTIC CAPITAL LETTER FEI (GREEK CAPITAL LETTER FEI), COPTIC SMALL LETTER FEI (GREEK SMALL LETTER FEI)
test(0x03E5, 0x03E4); // COPTIC SMALL LETTER FEI (GREEK SMALL LETTER FEI), COPTIC CAPITAL LETTER FEI (GREEK CAPITAL LETTER FEI)
test(0x03E6, 0x03E7); // COPTIC CAPITAL LETTER KHEI (GREEK CAPITAL LETTER KHEI), COPTIC SMALL LETTER KHEI (GREEK SMALL LETTER KHEI)
test(0x03E7, 0x03E6); // COPTIC SMALL LETTER KHEI (GREEK SMALL LETTER KHEI), COPTIC CAPITAL LETTER KHEI (GREEK CAPITAL LETTER KHEI)
test(0x03E8, 0x03E9); // COPTIC CAPITAL LETTER HORI (GREEK CAPITAL LETTER HORI), COPTIC SMALL LETTER HORI (GREEK SMALL LETTER HORI)
test(0x03E9, 0x03E8); // COPTIC SMALL LETTER HORI (GREEK SMALL LETTER HORI), COPTIC CAPITAL LETTER HORI (GREEK CAPITAL LETTER HORI)
test(0x03EA, 0x03EB); // COPTIC CAPITAL LETTER GANGIA (GREEK CAPITAL LETTER GANGIA), COPTIC SMALL LETTER GANGIA (GREEK SMALL LETTER GANGIA)
test(0x03EB, 0x03EA); // COPTIC SMALL LETTER GANGIA (GREEK SMALL LETTER GANGIA), COPTIC CAPITAL LETTER GANGIA (GREEK CAPITAL LETTER GANGIA)
test(0x03EC, 0x03ED); // COPTIC CAPITAL LETTER SHIMA (GREEK CAPITAL LETTER SHIMA), COPTIC SMALL LETTER SHIMA (GREEK SMALL LETTER SHIMA)
test(0x03ED, 0x03EC); // COPTIC SMALL LETTER SHIMA (GREEK SMALL LETTER SHIMA), COPTIC CAPITAL LETTER SHIMA (GREEK CAPITAL LETTER SHIMA)
test(0x03EE, 0x03EF); // COPTIC CAPITAL LETTER DEI (GREEK CAPITAL LETTER DEI), COPTIC SMALL LETTER DEI (GREEK SMALL LETTER DEI)
test(0x03EF, 0x03EE); // COPTIC SMALL LETTER DEI (GREEK SMALL LETTER DEI), COPTIC CAPITAL LETTER DEI (GREEK CAPITAL LETTER DEI)
test(0x03F0, 0x03BA, 0x039A); // GREEK KAPPA SYMBOL (GREEK SMALL LETTER SCRIPT KAPPA), GREEK SMALL LETTER KAPPA, GREEK CAPITAL LETTER KAPPA
test(0x03F1, 0x03C1, 0x03A1); // GREEK RHO SYMBOL (GREEK SMALL LETTER TAILED RHO), GREEK SMALL LETTER RHO, GREEK CAPITAL LETTER RHO
test(0x03F2, 0x03F9); // GREEK LUNATE SIGMA SYMBOL (GREEK SMALL LETTER LUNATE SIGMA), GREEK CAPITAL LUNATE SIGMA SYMBOL
test(0x03F3, 0x037F); // GREEK LETTER YOT, GREEK CAPITAL LETTER YOT
test(0x03F4, 0x03B8, 0x0398, 0x03D1); // GREEK CAPITAL THETA SYMBOL, GREEK SMALL LETTER THETA, GREEK CAPITAL LETTER THETA, GREEK THETA SYMBOL (GREEK SMALL LETTER SCRIPT THETA)
test(0x03F5, 0x03B5, 0x0395); // GREEK LUNATE EPSILON SYMBOL, GREEK SMALL LETTER EPSILON, GREEK CAPITAL LETTER EPSILON
test(0x03F7, 0x03F8); // GREEK CAPITAL LETTER SHO, GREEK SMALL LETTER SHO
test(0x03F8, 0x03F7); // GREEK SMALL LETTER SHO, GREEK CAPITAL LETTER SHO
test(0x03F9, 0x03F2); // GREEK CAPITAL LUNATE SIGMA SYMBOL, GREEK LUNATE SIGMA SYMBOL (GREEK SMALL LETTER LUNATE SIGMA)
test(0x03FA, 0x03FB); // GREEK CAPITAL LETTER SAN, GREEK SMALL LETTER SAN
test(0x03FB, 0x03FA); // GREEK SMALL LETTER SAN, GREEK CAPITAL LETTER SAN
test(0x03FD, 0x037B); // GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL, GREEK SMALL REVERSED LUNATE SIGMA SYMBOL
test(0x03FE, 0x037C); // GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL, GREEK SMALL DOTTED LUNATE SIGMA SYMBOL
test(0x03FF, 0x037D); // GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL, GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
test(0x0400, 0x0450); // CYRILLIC CAPITAL LETTER IE WITH GRAVE, CYRILLIC SMALL LETTER IE WITH GRAVE
test(0x0401, 0x0451); // CYRILLIC CAPITAL LETTER IO, CYRILLIC SMALL LETTER IO
test(0x0402, 0x0452); // CYRILLIC CAPITAL LETTER DJE, CYRILLIC SMALL LETTER DJE
test(0x0403, 0x0453); // CYRILLIC CAPITAL LETTER GJE, CYRILLIC SMALL LETTER GJE
test(0x0404, 0x0454); // CYRILLIC CAPITAL LETTER UKRAINIAN IE (CYRILLIC CAPITAL LETTER E), CYRILLIC SMALL LETTER UKRAINIAN IE (CYRILLIC SMALL LETTER E)
test(0x0405, 0x0455); // CYRILLIC CAPITAL LETTER DZE, CYRILLIC SMALL LETTER DZE
test(0x0406, 0x0456); // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I (CYRILLIC CAPITAL LETTER I), CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I (CYRILLIC SMALL LETTER I)
test(0x0407, 0x0457); // CYRILLIC CAPITAL LETTER YI, CYRILLIC SMALL LETTER YI
test(0x0408, 0x0458); // CYRILLIC CAPITAL LETTER JE, CYRILLIC SMALL LETTER JE
test(0x0409, 0x0459); // CYRILLIC CAPITAL LETTER LJE, CYRILLIC SMALL LETTER LJE
test(0x040A, 0x045A); // CYRILLIC CAPITAL LETTER NJE, CYRILLIC SMALL LETTER NJE
test(0x040B, 0x045B); // CYRILLIC CAPITAL LETTER TSHE, CYRILLIC SMALL LETTER TSHE
test(0x040C, 0x045C); // CYRILLIC CAPITAL LETTER KJE, CYRILLIC SMALL LETTER KJE
test(0x040D, 0x045D); // CYRILLIC CAPITAL LETTER I WITH GRAVE, CYRILLIC SMALL LETTER I WITH GRAVE
test(0x040E, 0x045E); // CYRILLIC CAPITAL LETTER SHORT U, CYRILLIC SMALL LETTER SHORT U
test(0x040F, 0x045F); // CYRILLIC CAPITAL LETTER DZHE, CYRILLIC SMALL LETTER DZHE
test(0x0410, 0x0430); // CYRILLIC CAPITAL LETTER A, CYRILLIC SMALL LETTER A
test(0x0411, 0x0431); // CYRILLIC CAPITAL LETTER BE, CYRILLIC SMALL LETTER BE
test(0x0412, 0x0432, 0x1C80); // CYRILLIC CAPITAL LETTER VE, CYRILLIC SMALL LETTER VE, CYRILLIC SMALL LETTER ROUNDED VE
test(0x0413, 0x0433); // CYRILLIC CAPITAL LETTER GHE (CYRILLIC CAPITAL LETTER GE), CYRILLIC SMALL LETTER GHE (CYRILLIC SMALL LETTER GE)
test(0x0414, 0x0434, 0x1C81); // CYRILLIC CAPITAL LETTER DE, CYRILLIC SMALL LETTER DE, CYRILLIC SMALL LETTER LONG-LEGGED DE
test(0x0415, 0x0435); // CYRILLIC CAPITAL LETTER IE, CYRILLIC SMALL LETTER IE
test(0x0416, 0x0436); // CYRILLIC CAPITAL LETTER ZHE, CYRILLIC SMALL LETTER ZHE
test(0x0417, 0x0437); // CYRILLIC CAPITAL LETTER ZE, CYRILLIC SMALL LETTER ZE
test(0x0418, 0x0438); // CYRILLIC CAPITAL LETTER I (CYRILLIC CAPITAL LETTER II), CYRILLIC SMALL LETTER I (CYRILLIC SMALL LETTER II)
test(0x0419, 0x0439); // CYRILLIC CAPITAL LETTER SHORT I (CYRILLIC CAPITAL LETTER SHORT II), CYRILLIC SMALL LETTER SHORT I (CYRILLIC SMALL LETTER SHORT II)
test(0x041A, 0x043A); // CYRILLIC CAPITAL LETTER KA, CYRILLIC SMALL LETTER KA
test(0x041B, 0x043B); // CYRILLIC CAPITAL LETTER EL, CYRILLIC SMALL LETTER EL
test(0x041C, 0x043C); // CYRILLIC CAPITAL LETTER EM, CYRILLIC SMALL LETTER EM
test(0x041D, 0x043D); // CYRILLIC CAPITAL LETTER EN, CYRILLIC SMALL LETTER EN
test(0x041E, 0x043E, 0x1C82); // CYRILLIC CAPITAL LETTER O, CYRILLIC SMALL LETTER O, CYRILLIC SMALL LETTER NARROW O
test(0x041F, 0x043F); // CYRILLIC CAPITAL LETTER PE, CYRILLIC SMALL LETTER PE
test(0x0420, 0x0440); // CYRILLIC CAPITAL LETTER ER, CYRILLIC SMALL LETTER ER
test(0x0421, 0x0441, 0x1C83); // CYRILLIC CAPITAL LETTER ES, CYRILLIC SMALL LETTER ES, CYRILLIC SMALL LETTER WIDE ES
test(0x0422, 0x0442, 0x1C84, 0x1C85); // CYRILLIC CAPITAL LETTER TE, CYRILLIC SMALL LETTER TE, CYRILLIC SMALL LETTER TALL TE, CYRILLIC SMALL LETTER THREE-LEGGED TE
test(0x0423, 0x0443); // CYRILLIC CAPITAL LETTER U, CYRILLIC SMALL LETTER U
test(0x0424, 0x0444); // CYRILLIC CAPITAL LETTER EF, CYRILLIC SMALL LETTER EF
test(0x0425, 0x0445); // CYRILLIC CAPITAL LETTER HA (CYRILLIC CAPITAL LETTER KHA), CYRILLIC SMALL LETTER HA (CYRILLIC SMALL LETTER KHA)
test(0x0426, 0x0446); // CYRILLIC CAPITAL LETTER TSE, CYRILLIC SMALL LETTER TSE
test(0x0427, 0x0447); // CYRILLIC CAPITAL LETTER CHE, CYRILLIC SMALL LETTER CHE
test(0x0428, 0x0448); // CYRILLIC CAPITAL LETTER SHA, CYRILLIC SMALL LETTER SHA
test(0x0429, 0x0449); // CYRILLIC CAPITAL LETTER SHCHA, CYRILLIC SMALL LETTER SHCHA
test(0x042A, 0x044A, 0x1C86); // CYRILLIC CAPITAL LETTER HARD SIGN, CYRILLIC SMALL LETTER HARD SIGN, CYRILLIC SMALL LETTER TALL HARD SIGN
test(0x042B, 0x044B); // CYRILLIC CAPITAL LETTER YERU (CYRILLIC CAPITAL LETTER YERI), CYRILLIC SMALL LETTER YERU (CYRILLIC SMALL LETTER YERI)
test(0x042C, 0x044C); // CYRILLIC CAPITAL LETTER SOFT SIGN, CYRILLIC SMALL LETTER SOFT SIGN
test(0x042D, 0x044D); // CYRILLIC CAPITAL LETTER E (CYRILLIC CAPITAL LETTER REVERSED E), CYRILLIC SMALL LETTER E (CYRILLIC SMALL LETTER REVERSED E)
test(0x042E, 0x044E); // CYRILLIC CAPITAL LETTER YU (CYRILLIC CAPITAL LETTER IU), CYRILLIC SMALL LETTER YU (CYRILLIC SMALL LETTER IU)
test(0x042F, 0x044F); // CYRILLIC CAPITAL LETTER YA (CYRILLIC CAPITAL LETTER IA), CYRILLIC SMALL LETTER YA (CYRILLIC SMALL LETTER IA)
test(0x0430, 0x0410); // CYRILLIC SMALL LETTER A, CYRILLIC CAPITAL LETTER A
test(0x0431, 0x0411); // CYRILLIC SMALL LETTER BE, CYRILLIC CAPITAL LETTER BE
test(0x0432, 0x0412, 0x1C80); // CYRILLIC SMALL LETTER VE, CYRILLIC CAPITAL LETTER VE, CYRILLIC SMALL LETTER ROUNDED VE
test(0x0433, 0x0413); // CYRILLIC SMALL LETTER GHE (CYRILLIC SMALL LETTER GE), CYRILLIC CAPITAL LETTER GHE (CYRILLIC CAPITAL LETTER GE)
test(0x0434, 0x0414, 0x1C81); // CYRILLIC SMALL LETTER DE, CYRILLIC CAPITAL LETTER DE, CYRILLIC SMALL LETTER LONG-LEGGED DE
test(0x0435, 0x0415); // CYRILLIC SMALL LETTER IE, CYRILLIC CAPITAL LETTER IE
test(0x0436, 0x0416); // CYRILLIC SMALL LETTER ZHE, CYRILLIC CAPITAL LETTER ZHE
test(0x0437, 0x0417); // CYRILLIC SMALL LETTER ZE, CYRILLIC CAPITAL LETTER ZE
test(0x0438, 0x0418); // CYRILLIC SMALL LETTER I (CYRILLIC SMALL LETTER II), CYRILLIC CAPITAL LETTER I (CYRILLIC CAPITAL LETTER II)
test(0x0439, 0x0419); // CYRILLIC SMALL LETTER SHORT I (CYRILLIC SMALL LETTER SHORT II), CYRILLIC CAPITAL LETTER SHORT I (CYRILLIC CAPITAL LETTER SHORT II)
test(0x043A, 0x041A); // CYRILLIC SMALL LETTER KA, CYRILLIC CAPITAL LETTER KA
test(0x043B, 0x041B); // CYRILLIC SMALL LETTER EL, CYRILLIC CAPITAL LETTER EL
test(0x043C, 0x041C); // CYRILLIC SMALL LETTER EM, CYRILLIC CAPITAL LETTER EM
test(0x043D, 0x041D); // CYRILLIC SMALL LETTER EN, CYRILLIC CAPITAL LETTER EN
test(0x043E, 0x041E, 0x1C82); // CYRILLIC SMALL LETTER O, CYRILLIC CAPITAL LETTER O, CYRILLIC SMALL LETTER NARROW O
test(0x043F, 0x041F); // CYRILLIC SMALL LETTER PE, CYRILLIC CAPITAL LETTER PE
test(0x0440, 0x0420); // CYRILLIC SMALL LETTER ER, CYRILLIC CAPITAL LETTER ER
test(0x0441, 0x0421, 0x1C83); // CYRILLIC SMALL LETTER ES, CYRILLIC CAPITAL LETTER ES, CYRILLIC SMALL LETTER WIDE ES
test(0x0442, 0x0422, 0x1C84, 0x1C85); // CYRILLIC SMALL LETTER TE, CYRILLIC CAPITAL LETTER TE, CYRILLIC SMALL LETTER TALL TE, CYRILLIC SMALL LETTER THREE-LEGGED TE
test(0x0443, 0x0423); // CYRILLIC SMALL LETTER U, CYRILLIC CAPITAL LETTER U
test(0x0444, 0x0424); // CYRILLIC SMALL LETTER EF, CYRILLIC CAPITAL LETTER EF
test(0x0445, 0x0425); // CYRILLIC SMALL LETTER HA (CYRILLIC SMALL LETTER KHA), CYRILLIC CAPITAL LETTER HA (CYRILLIC CAPITAL LETTER KHA)
test(0x0446, 0x0426); // CYRILLIC SMALL LETTER TSE, CYRILLIC CAPITAL LETTER TSE
test(0x0447, 0x0427); // CYRILLIC SMALL LETTER CHE, CYRILLIC CAPITAL LETTER CHE
test(0x0448, 0x0428); // CYRILLIC SMALL LETTER SHA, CYRILLIC CAPITAL LETTER SHA
test(0x0449, 0x0429); // CYRILLIC SMALL LETTER SHCHA, CYRILLIC CAPITAL LETTER SHCHA
test(0x044A, 0x042A, 0x1C86); // CYRILLIC SMALL LETTER HARD SIGN, CYRILLIC CAPITAL LETTER HARD SIGN, CYRILLIC SMALL LETTER TALL HARD SIGN
test(0x044B, 0x042B); // CYRILLIC SMALL LETTER YERU (CYRILLIC SMALL LETTER YERI), CYRILLIC CAPITAL LETTER YERU (CYRILLIC CAPITAL LETTER YERI)
test(0x044C, 0x042C); // CYRILLIC SMALL LETTER SOFT SIGN, CYRILLIC CAPITAL LETTER SOFT SIGN
test(0x044D, 0x042D); // CYRILLIC SMALL LETTER E (CYRILLIC SMALL LETTER REVERSED E), CYRILLIC CAPITAL LETTER E (CYRILLIC CAPITAL LETTER REVERSED E)
test(0x044E, 0x042E); // CYRILLIC SMALL LETTER YU (CYRILLIC SMALL LETTER IU), CYRILLIC CAPITAL LETTER YU (CYRILLIC CAPITAL LETTER IU)
test(0x044F, 0x042F); // CYRILLIC SMALL LETTER YA (CYRILLIC SMALL LETTER IA), CYRILLIC CAPITAL LETTER YA (CYRILLIC CAPITAL LETTER IA)
test(0x0450, 0x0400); // CYRILLIC SMALL LETTER IE WITH GRAVE, CYRILLIC CAPITAL LETTER IE WITH GRAVE
test(0x0451, 0x0401); // CYRILLIC SMALL LETTER IO, CYRILLIC CAPITAL LETTER IO
test(0x0452, 0x0402); // CYRILLIC SMALL LETTER DJE, CYRILLIC CAPITAL LETTER DJE
test(0x0453, 0x0403); // CYRILLIC SMALL LETTER GJE, CYRILLIC CAPITAL LETTER GJE
test(0x0454, 0x0404); // CYRILLIC SMALL LETTER UKRAINIAN IE (CYRILLIC SMALL LETTER E), CYRILLIC CAPITAL LETTER UKRAINIAN IE (CYRILLIC CAPITAL LETTER E)
test(0x0455, 0x0405); // CYRILLIC SMALL LETTER DZE, CYRILLIC CAPITAL LETTER DZE
test(0x0456, 0x0406); // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I (CYRILLIC SMALL LETTER I), CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I (CYRILLIC CAPITAL LETTER I)
test(0x0457, 0x0407); // CYRILLIC SMALL LETTER YI, CYRILLIC CAPITAL LETTER YI
test(0x0458, 0x0408); // CYRILLIC SMALL LETTER JE, CYRILLIC CAPITAL LETTER JE
test(0x0459, 0x0409); // CYRILLIC SMALL LETTER LJE, CYRILLIC CAPITAL LETTER LJE
test(0x045A, 0x040A); // CYRILLIC SMALL LETTER NJE, CYRILLIC CAPITAL LETTER NJE
test(0x045B, 0x040B); // CYRILLIC SMALL LETTER TSHE, CYRILLIC CAPITAL LETTER TSHE
test(0x045C, 0x040C); // CYRILLIC SMALL LETTER KJE, CYRILLIC CAPITAL LETTER KJE
test(0x045D, 0x040D); // CYRILLIC SMALL LETTER I WITH GRAVE, CYRILLIC CAPITAL LETTER I WITH GRAVE
test(0x045E, 0x040E); // CYRILLIC SMALL LETTER SHORT U, CYRILLIC CAPITAL LETTER SHORT U
test(0x045F, 0x040F); // CYRILLIC SMALL LETTER DZHE, CYRILLIC CAPITAL LETTER DZHE
test(0x0460, 0x0461); // CYRILLIC CAPITAL LETTER OMEGA, CYRILLIC SMALL LETTER OMEGA
test(0x0461, 0x0460); // CYRILLIC SMALL LETTER OMEGA, CYRILLIC CAPITAL LETTER OMEGA
test(0x0462, 0x0463, 0x1C87); // CYRILLIC CAPITAL LETTER YAT, CYRILLIC SMALL LETTER YAT, CYRILLIC SMALL LETTER TALL YAT
test(0x0463, 0x0462, 0x1C87); // CYRILLIC SMALL LETTER YAT, CYRILLIC CAPITAL LETTER YAT, CYRILLIC SMALL LETTER TALL YAT
test(0x0464, 0x0465); // CYRILLIC CAPITAL LETTER IOTIFIED E, CYRILLIC SMALL LETTER IOTIFIED E
test(0x0465, 0x0464); // CYRILLIC SMALL LETTER IOTIFIED E, CYRILLIC CAPITAL LETTER IOTIFIED E
test(0x0466, 0x0467); // CYRILLIC CAPITAL LETTER LITTLE YUS, CYRILLIC SMALL LETTER LITTLE YUS
test(0x0467, 0x0466); // CYRILLIC SMALL LETTER LITTLE YUS, CYRILLIC CAPITAL LETTER LITTLE YUS
test(0x0468, 0x0469); // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS, CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
test(0x0469, 0x0468); // CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS, CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
test(0x046A, 0x046B); // CYRILLIC CAPITAL LETTER BIG YUS, CYRILLIC SMALL LETTER BIG YUS
test(0x046B, 0x046A); // CYRILLIC SMALL LETTER BIG YUS, CYRILLIC CAPITAL LETTER BIG YUS
test(0x046C, 0x046D); // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS, CYRILLIC SMALL LETTER IOTIFIED BIG YUS
test(0x046D, 0x046C); // CYRILLIC SMALL LETTER IOTIFIED BIG YUS, CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
test(0x046E, 0x046F); // CYRILLIC CAPITAL LETTER KSI, CYRILLIC SMALL LETTER KSI
test(0x046F, 0x046E); // CYRILLIC SMALL LETTER KSI, CYRILLIC CAPITAL LETTER KSI
test(0x0470, 0x0471); // CYRILLIC CAPITAL LETTER PSI, CYRILLIC SMALL LETTER PSI
test(0x0471, 0x0470); // CYRILLIC SMALL LETTER PSI, CYRILLIC CAPITAL LETTER PSI
test(0x0472, 0x0473); // CYRILLIC CAPITAL LETTER FITA, CYRILLIC SMALL LETTER FITA
test(0x0473, 0x0472); // CYRILLIC SMALL LETTER FITA, CYRILLIC CAPITAL LETTER FITA
test(0x0474, 0x0475); // CYRILLIC CAPITAL LETTER IZHITSA, CYRILLIC SMALL LETTER IZHITSA
test(0x0475, 0x0474); // CYRILLIC SMALL LETTER IZHITSA, CYRILLIC CAPITAL LETTER IZHITSA
test(0x0476, 0x0477); // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT (CYRILLIC CAPITAL LETTER IZHITSA DOUBLE GRAVE), CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT (CYRILLIC SMALL LETTER IZHITSA DOUBLE GRAVE)
test(0x0477, 0x0476); // CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT (CYRILLIC SMALL LETTER IZHITSA DOUBLE GRAVE), CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT (CYRILLIC CAPITAL LETTER IZHITSA DOUBLE GRAVE)
test(0x0478, 0x0479); // CYRILLIC CAPITAL LETTER UK (CYRILLIC CAPITAL LETTER UK DIGRAPH), CYRILLIC SMALL LETTER UK (CYRILLIC SMALL LETTER UK DIGRAPH)
test(0x0479, 0x0478); // CYRILLIC SMALL LETTER UK (CYRILLIC SMALL LETTER UK DIGRAPH), CYRILLIC CAPITAL LETTER UK (CYRILLIC CAPITAL LETTER UK DIGRAPH)
test(0x047A, 0x047B); // CYRILLIC CAPITAL LETTER ROUND OMEGA, CYRILLIC SMALL LETTER ROUND OMEGA
test(0x047B, 0x047A); // CYRILLIC SMALL LETTER ROUND OMEGA, CYRILLIC CAPITAL LETTER ROUND OMEGA
test(0x047C, 0x047D); // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO (CYRILLIC CAPITAL LETTER OMEGA TITLO), CYRILLIC SMALL LETTER OMEGA WITH TITLO (CYRILLIC SMALL LETTER OMEGA TITLO)
test(0x047D, 0x047C); // CYRILLIC SMALL LETTER OMEGA WITH TITLO (CYRILLIC SMALL LETTER OMEGA TITLO), CYRILLIC CAPITAL LETTER OMEGA WITH TITLO (CYRILLIC CAPITAL LETTER OMEGA TITLO)
test(0x047E, 0x047F); // CYRILLIC CAPITAL LETTER OT, CYRILLIC SMALL LETTER OT
test(0x047F, 0x047E); // CYRILLIC SMALL LETTER OT, CYRILLIC CAPITAL LETTER OT
test(0x0480, 0x0481); // CYRILLIC CAPITAL LETTER KOPPA, CYRILLIC SMALL LETTER KOPPA
test(0x0481, 0x0480); // CYRILLIC SMALL LETTER KOPPA, CYRILLIC CAPITAL LETTER KOPPA
test(0x048A, 0x048B); // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL, CYRILLIC SMALL LETTER SHORT I WITH TAIL
test(0x048B, 0x048A); // CYRILLIC SMALL LETTER SHORT I WITH TAIL, CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
test(0x048C, 0x048D); // CYRILLIC CAPITAL LETTER SEMISOFT SIGN, CYRILLIC SMALL LETTER SEMISOFT SIGN
test(0x048D, 0x048C); // CYRILLIC SMALL LETTER SEMISOFT SIGN, CYRILLIC CAPITAL LETTER SEMISOFT SIGN
test(0x048E, 0x048F); // CYRILLIC CAPITAL LETTER ER WITH TICK, CYRILLIC SMALL LETTER ER WITH TICK
test(0x048F, 0x048E); // CYRILLIC SMALL LETTER ER WITH TICK, CYRILLIC CAPITAL LETTER ER WITH TICK
test(0x0490, 0x0491); // CYRILLIC CAPITAL LETTER GHE WITH UPTURN (CYRILLIC CAPITAL LETTER GE WITH UPTURN), CYRILLIC SMALL LETTER GHE WITH UPTURN (CYRILLIC SMALL LETTER GE WITH UPTURN)
test(0x0491, 0x0490); // CYRILLIC SMALL LETTER GHE WITH UPTURN (CYRILLIC SMALL LETTER GE WITH UPTURN), CYRILLIC CAPITAL LETTER GHE WITH UPTURN (CYRILLIC CAPITAL LETTER GE WITH UPTURN)
test(0x0492, 0x0493); // CYRILLIC CAPITAL LETTER GHE WITH STROKE (CYRILLIC CAPITAL LETTER GE BAR), CYRILLIC SMALL LETTER GHE WITH STROKE (CYRILLIC SMALL LETTER GE BAR)
test(0x0493, 0x0492); // CYRILLIC SMALL LETTER GHE WITH STROKE (CYRILLIC SMALL LETTER GE BAR), CYRILLIC CAPITAL LETTER GHE WITH STROKE (CYRILLIC CAPITAL LETTER GE BAR)
test(0x0494, 0x0495); // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK (CYRILLIC CAPITAL LETTER GE HOOK), CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK (CYRILLIC SMALL LETTER GE HOOK)
test(0x0495, 0x0494); // CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK (CYRILLIC SMALL LETTER GE HOOK), CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK (CYRILLIC CAPITAL LETTER GE HOOK)
test(0x0496, 0x0497); // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER (CYRILLIC CAPITAL LETTER ZHE WITH RIGHT DESCENDER), CYRILLIC SMALL LETTER ZHE WITH DESCENDER (CYRILLIC SMALL LETTER ZHE WITH RIGHT DESCENDER)
test(0x0497, 0x0496); // CYRILLIC SMALL LETTER ZHE WITH DESCENDER (CYRILLIC SMALL LETTER ZHE WITH RIGHT DESCENDER), CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER (CYRILLIC CAPITAL LETTER ZHE WITH RIGHT DESCENDER)
test(0x0498, 0x0499); // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER (CYRILLIC CAPITAL LETTER ZE CEDILLA), CYRILLIC SMALL LETTER ZE WITH DESCENDER (CYRILLIC SMALL LETTER ZE CEDILLA)
test(0x0499, 0x0498); // CYRILLIC SMALL LETTER ZE WITH DESCENDER (CYRILLIC SMALL LETTER ZE CEDILLA), CYRILLIC CAPITAL LETTER ZE WITH DESCENDER (CYRILLIC CAPITAL LETTER ZE CEDILLA)
test(0x049A, 0x049B); // CYRILLIC CAPITAL LETTER KA WITH DESCENDER (CYRILLIC CAPITAL LETTER KA WITH RIGHT DESCENDER), CYRILLIC SMALL LETTER KA WITH DESCENDER (CYRILLIC SMALL LETTER KA WITH RIGHT DESCENDER)
test(0x049B, 0x049A); // CYRILLIC SMALL LETTER KA WITH DESCENDER (CYRILLIC SMALL LETTER KA WITH RIGHT DESCENDER), CYRILLIC CAPITAL LETTER KA WITH DESCENDER (CYRILLIC CAPITAL LETTER KA WITH RIGHT DESCENDER)
test(0x049C, 0x049D); // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE (CYRILLIC CAPITAL LETTER KA VERTICAL BAR), CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE (CYRILLIC SMALL LETTER KA VERTICAL BAR)
test(0x049D, 0x049C); // CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE (CYRILLIC SMALL LETTER KA VERTICAL BAR), CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE (CYRILLIC CAPITAL LETTER KA VERTICAL BAR)
test(0x049E, 0x049F); // CYRILLIC CAPITAL LETTER KA WITH STROKE (CYRILLIC CAPITAL LETTER KA BAR), CYRILLIC SMALL LETTER KA WITH STROKE (CYRILLIC SMALL LETTER KA BAR)
test(0x049F, 0x049E); // CYRILLIC SMALL LETTER KA WITH STROKE (CYRILLIC SMALL LETTER KA BAR), CYRILLIC CAPITAL LETTER KA WITH STROKE (CYRILLIC CAPITAL LETTER KA BAR)
test(0x04A0, 0x04A1); // CYRILLIC CAPITAL LETTER BASHKIR KA (CYRILLIC CAPITAL LETTER REVERSED GE KA), CYRILLIC SMALL LETTER BASHKIR KA (CYRILLIC SMALL LETTER REVERSED GE KA)
test(0x04A1, 0x04A0); // CYRILLIC SMALL LETTER BASHKIR KA (CYRILLIC SMALL LETTER REVERSED GE KA), CYRILLIC CAPITAL LETTER BASHKIR KA (CYRILLIC CAPITAL LETTER REVERSED GE KA)
test(0x04A2, 0x04A3); // CYRILLIC CAPITAL LETTER EN WITH DESCENDER (CYRILLIC CAPITAL LETTER EN WITH RIGHT DESCENDER), CYRILLIC SMALL LETTER EN WITH DESCENDER (CYRILLIC SMALL LETTER EN WITH RIGHT DESCENDER)
test(0x04A3, 0x04A2); // CYRILLIC SMALL LETTER EN WITH DESCENDER (CYRILLIC SMALL LETTER EN WITH RIGHT DESCENDER), CYRILLIC CAPITAL LETTER EN WITH DESCENDER (CYRILLIC CAPITAL LETTER EN WITH RIGHT DESCENDER)
test(0x04A4, 0x04A5); // CYRILLIC CAPITAL LIGATURE EN GHE (CYRILLIC CAPITAL LETTER EN GE), CYRILLIC SMALL LIGATURE EN GHE (CYRILLIC SMALL LETTER EN GE)
test(0x04A5, 0x04A4); // CYRILLIC SMALL LIGATURE EN GHE (CYRILLIC SMALL LETTER EN GE), CYRILLIC CAPITAL LIGATURE EN GHE (CYRILLIC CAPITAL LETTER EN GE)
test(0x04A6, 0x04A7); // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK (CYRILLIC CAPITAL LETTER PE HOOK), CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK (CYRILLIC SMALL LETTER PE HOOK)
test(0x04A7, 0x04A6); // CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK (CYRILLIC SMALL LETTER PE HOOK), CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK (CYRILLIC CAPITAL LETTER PE HOOK)
test(0x04A8, 0x04A9); // CYRILLIC CAPITAL LETTER ABKHASIAN HA (CYRILLIC CAPITAL LETTER O HOOK), CYRILLIC SMALL LETTER ABKHASIAN HA (CYRILLIC SMALL LETTER O HOOK)
test(0x04A9, 0x04A8); // CYRILLIC SMALL LETTER ABKHASIAN HA (CYRILLIC SMALL LETTER O HOOK), CYRILLIC CAPITAL LETTER ABKHASIAN HA (CYRILLIC CAPITAL LETTER O HOOK)
test(0x04AA, 0x04AB); // CYRILLIC CAPITAL LETTER ES WITH DESCENDER (CYRILLIC CAPITAL LETTER ES CEDILLA), CYRILLIC SMALL LETTER ES WITH DESCENDER (CYRILLIC SMALL LETTER ES CEDILLA)
test(0x04AB, 0x04AA); // CYRILLIC SMALL LETTER ES WITH DESCENDER (CYRILLIC SMALL LETTER ES CEDILLA), CYRILLIC CAPITAL LETTER ES WITH DESCENDER (CYRILLIC CAPITAL LETTER ES CEDILLA)
test(0x04AC, 0x04AD); // CYRILLIC CAPITAL LETTER TE WITH DESCENDER (CYRILLIC CAPITAL LETTER TE WITH RIGHT DESCENDER), CYRILLIC SMALL LETTER TE WITH DESCENDER (CYRILLIC SMALL LETTER TE WITH RIGHT DESCENDER)
test(0x04AD, 0x04AC); // CYRILLIC SMALL LETTER TE WITH DESCENDER (CYRILLIC SMALL LETTER TE WITH RIGHT DESCENDER), CYRILLIC CAPITAL LETTER TE WITH DESCENDER (CYRILLIC CAPITAL LETTER TE WITH RIGHT DESCENDER)
test(0x04AE, 0x04AF); // CYRILLIC CAPITAL LETTER STRAIGHT U, CYRILLIC SMALL LETTER STRAIGHT U
test(0x04AF, 0x04AE); // CYRILLIC SMALL LETTER STRAIGHT U, CYRILLIC CAPITAL LETTER STRAIGHT U
test(0x04B0, 0x04B1); // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE (CYRILLIC CAPITAL LETTER STRAIGHT U BAR), CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE (CYRILLIC SMALL LETTER STRAIGHT U BAR)
test(0x04B1, 0x04B0); // CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE (CYRILLIC SMALL LETTER STRAIGHT U BAR), CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE (CYRILLIC CAPITAL LETTER STRAIGHT U BAR)
test(0x04B2, 0x04B3); // CYRILLIC CAPITAL LETTER HA WITH DESCENDER (CYRILLIC CAPITAL LETTER KHA WITH RIGHT DESCENDER), CYRILLIC SMALL LETTER HA WITH DESCENDER (CYRILLIC SMALL LETTER KHA WITH RIGHT DESCENDER)
test(0x04B3, 0x04B2); // CYRILLIC SMALL LETTER HA WITH DESCENDER (CYRILLIC SMALL LETTER KHA WITH RIGHT DESCENDER), CYRILLIC CAPITAL LETTER HA WITH DESCENDER (CYRILLIC CAPITAL LETTER KHA WITH RIGHT DESCENDER)
test(0x04B4, 0x04B5); // CYRILLIC CAPITAL LIGATURE TE TSE (CYRILLIC CAPITAL LETTER TE TSE), CYRILLIC SMALL LIGATURE TE TSE (CYRILLIC SMALL LETTER TE TSE)
test(0x04B5, 0x04B4); // CYRILLIC SMALL LIGATURE TE TSE (CYRILLIC SMALL LETTER TE TSE), CYRILLIC CAPITAL LIGATURE TE TSE (CYRILLIC CAPITAL LETTER TE TSE)
test(0x04B6, 0x04B7); // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER (CYRILLIC CAPITAL LETTER CHE WITH RIGHT DESCENDER), CYRILLIC SMALL LETTER CHE WITH DESCENDER (CYRILLIC SMALL LETTER CHE WITH RIGHT DESCENDER)
test(0x04B7, 0x04B6); // CYRILLIC SMALL LETTER CHE WITH DESCENDER (CYRILLIC SMALL LETTER CHE WITH RIGHT DESCENDER), CYRILLIC CAPITAL LETTER CHE WITH DESCENDER (CYRILLIC CAPITAL LETTER CHE WITH RIGHT DESCENDER)
test(0x04B8, 0x04B9); // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE (CYRILLIC CAPITAL LETTER CHE VERTICAL BAR), CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE (CYRILLIC SMALL LETTER CHE VERTICAL BAR)
test(0x04B9, 0x04B8); // CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE (CYRILLIC SMALL LETTER CHE VERTICAL BAR), CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE (CYRILLIC CAPITAL LETTER CHE VERTICAL BAR)
test(0x04BA, 0x04BB); // CYRILLIC CAPITAL LETTER SHHA (CYRILLIC CAPITAL LETTER H), CYRILLIC SMALL LETTER SHHA (CYRILLIC SMALL LETTER H)
test(0x04BB, 0x04BA); // CYRILLIC SMALL LETTER SHHA (CYRILLIC SMALL LETTER H), CYRILLIC CAPITAL LETTER SHHA (CYRILLIC CAPITAL LETTER H)
test(0x04BC, 0x04BD); // CYRILLIC CAPITAL LETTER ABKHASIAN CHE (CYRILLIC CAPITAL LETTER IE HOOK), CYRILLIC SMALL LETTER ABKHASIAN CHE (CYRILLIC SMALL LETTER IE HOOK)
test(0x04BD, 0x04BC); // CYRILLIC SMALL LETTER ABKHASIAN CHE (CYRILLIC SMALL LETTER IE HOOK), CYRILLIC CAPITAL LETTER ABKHASIAN CHE (CYRILLIC CAPITAL LETTER IE HOOK)
test(0x04BE, 0x04BF); // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER (CYRILLIC CAPITAL LETTER IE HOOK OGONEK), CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER (CYRILLIC SMALL LETTER IE HOOK OGONEK)
test(0x04BF, 0x04BE); // CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER (CYRILLIC SMALL LETTER IE HOOK OGONEK), CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER (CYRILLIC CAPITAL LETTER IE HOOK OGONEK)
test(0x04C0, 0x04CF); // CYRILLIC LETTER PALOCHKA (CYRILLIC LETTER I), CYRILLIC SMALL LETTER PALOCHKA
test(0x04C1, 0x04C2); // CYRILLIC CAPITAL LETTER ZHE WITH BREVE (CYRILLIC CAPITAL LETTER SHORT ZHE), CYRILLIC SMALL LETTER ZHE WITH BREVE (CYRILLIC SMALL LETTER SHORT ZHE)
test(0x04C2, 0x04C1); // CYRILLIC SMALL LETTER ZHE WITH BREVE (CYRILLIC SMALL LETTER SHORT ZHE), CYRILLIC CAPITAL LETTER ZHE WITH BREVE (CYRILLIC CAPITAL LETTER SHORT ZHE)
test(0x04C3, 0x04C4); // CYRILLIC CAPITAL LETTER KA WITH HOOK (CYRILLIC CAPITAL LETTER KA HOOK), CYRILLIC SMALL LETTER KA WITH HOOK (CYRILLIC SMALL LETTER KA HOOK)
test(0x04C4, 0x04C3); // CYRILLIC SMALL LETTER KA WITH HOOK (CYRILLIC SMALL LETTER KA HOOK), CYRILLIC CAPITAL LETTER KA WITH HOOK (CYRILLIC CAPITAL LETTER KA HOOK)
test(0x04C5, 0x04C6); // CYRILLIC CAPITAL LETTER EL WITH TAIL, CYRILLIC SMALL LETTER EL WITH TAIL
test(0x04C6, 0x04C5); // CYRILLIC SMALL LETTER EL WITH TAIL, CYRILLIC CAPITAL LETTER EL WITH TAIL
test(0x04C7, 0x04C8); // CYRILLIC CAPITAL LETTER EN WITH HOOK (CYRILLIC CAPITAL LETTER EN HOOK), CYRILLIC SMALL LETTER EN WITH HOOK (CYRILLIC SMALL LETTER EN HOOK)
test(0x04C8, 0x04C7); // CYRILLIC SMALL LETTER EN WITH HOOK (CYRILLIC SMALL LETTER EN HOOK), CYRILLIC CAPITAL LETTER EN WITH HOOK (CYRILLIC CAPITAL LETTER EN HOOK)
test(0x04C9, 0x04CA); // CYRILLIC CAPITAL LETTER EN WITH TAIL, CYRILLIC SMALL LETTER EN WITH TAIL
test(0x04CA, 0x04C9); // CYRILLIC SMALL LETTER EN WITH TAIL, CYRILLIC CAPITAL LETTER EN WITH TAIL
test(0x04CB, 0x04CC); // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE (CYRILLIC CAPITAL LETTER CHE WITH LEFT DESCENDER), CYRILLIC SMALL LETTER KHAKASSIAN CHE (CYRILLIC SMALL LETTER CHE WITH LEFT DESCENDER)
test(0x04CC, 0x04CB); // CYRILLIC SMALL LETTER KHAKASSIAN CHE (CYRILLIC SMALL LETTER CHE WITH LEFT DESCENDER), CYRILLIC CAPITAL LETTER KHAKASSIAN CHE (CYRILLIC CAPITAL LETTER CHE WITH LEFT DESCENDER)
test(0x04CD, 0x04CE); // CYRILLIC CAPITAL LETTER EM WITH TAIL, CYRILLIC SMALL LETTER EM WITH TAIL
test(0x04CE, 0x04CD); // CYRILLIC SMALL LETTER EM WITH TAIL, CYRILLIC CAPITAL LETTER EM WITH TAIL
test(0x04CF, 0x04C0); // CYRILLIC SMALL LETTER PALOCHKA, CYRILLIC LETTER PALOCHKA (CYRILLIC LETTER I)
test(0x04D0, 0x04D1); // CYRILLIC CAPITAL LETTER A WITH BREVE, CYRILLIC SMALL LETTER A WITH BREVE
test(0x04D1, 0x04D0); // CYRILLIC SMALL LETTER A WITH BREVE, CYRILLIC CAPITAL LETTER A WITH BREVE
test(0x04D2, 0x04D3); // CYRILLIC CAPITAL LETTER A WITH DIAERESIS, CYRILLIC SMALL LETTER A WITH DIAERESIS
test(0x04D3, 0x04D2); // CYRILLIC SMALL LETTER A WITH DIAERESIS, CYRILLIC CAPITAL LETTER A WITH DIAERESIS
test(0x04D4, 0x04D5); // CYRILLIC CAPITAL LIGATURE A IE, CYRILLIC SMALL LIGATURE A IE
test(0x04D5, 0x04D4); // CYRILLIC SMALL LIGATURE A IE, CYRILLIC CAPITAL LIGATURE A IE
test(0x04D6, 0x04D7); // CYRILLIC CAPITAL LETTER IE WITH BREVE, CYRILLIC SMALL LETTER IE WITH BREVE
test(0x04D7, 0x04D6); // CYRILLIC SMALL LETTER IE WITH BREVE, CYRILLIC CAPITAL LETTER IE WITH BREVE
test(0x04D8, 0x04D9); // CYRILLIC CAPITAL LETTER SCHWA, CYRILLIC SMALL LETTER SCHWA
test(0x04D9, 0x04D8); // CYRILLIC SMALL LETTER SCHWA, CYRILLIC CAPITAL LETTER SCHWA
test(0x04DA, 0x04DB); // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS, CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
test(0x04DB, 0x04DA); // CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS, CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
test(0x04DC, 0x04DD); // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS, CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
test(0x04DD, 0x04DC); // CYRILLIC SMALL LETTER ZHE WITH DIAERESIS, CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
test(0x04DE, 0x04DF); // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS, CYRILLIC SMALL LETTER ZE WITH DIAERESIS
test(0x04DF, 0x04DE); // CYRILLIC SMALL LETTER ZE WITH DIAERESIS, CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
test(0x04E0, 0x04E1); // CYRILLIC CAPITAL LETTER ABKHASIAN DZE, CYRILLIC SMALL LETTER ABKHASIAN DZE
test(0x04E1, 0x04E0); // CYRILLIC SMALL LETTER ABKHASIAN DZE, CYRILLIC CAPITAL LETTER ABKHASIAN DZE
test(0x04E2, 0x04E3); // CYRILLIC CAPITAL LETTER I WITH MACRON, CYRILLIC SMALL LETTER I WITH MACRON
test(0x04E3, 0x04E2); // CYRILLIC SMALL LETTER I WITH MACRON, CYRILLIC CAPITAL LETTER I WITH MACRON
test(0x04E4, 0x04E5); // CYRILLIC CAPITAL LETTER I WITH DIAERESIS, CYRILLIC SMALL LETTER I WITH DIAERESIS
test(0x04E5, 0x04E4); // CYRILLIC SMALL LETTER I WITH DIAERESIS, CYRILLIC CAPITAL LETTER I WITH DIAERESIS
test(0x04E6, 0x04E7); // CYRILLIC CAPITAL LETTER O WITH DIAERESIS, CYRILLIC SMALL LETTER O WITH DIAERESIS
test(0x04E7, 0x04E6); // CYRILLIC SMALL LETTER O WITH DIAERESIS, CYRILLIC CAPITAL LETTER O WITH DIAERESIS
test(0x04E8, 0x04E9); // CYRILLIC CAPITAL LETTER BARRED O, CYRILLIC SMALL LETTER BARRED O
test(0x04E9, 0x04E8); // CYRILLIC SMALL LETTER BARRED O, CYRILLIC CAPITAL LETTER BARRED O
test(0x04EA, 0x04EB); // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS, CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
test(0x04EB, 0x04EA); // CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS, CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
test(0x04EC, 0x04ED); // CYRILLIC CAPITAL LETTER E WITH DIAERESIS, CYRILLIC SMALL LETTER E WITH DIAERESIS
test(0x04ED, 0x04EC); // CYRILLIC SMALL LETTER E WITH DIAERESIS, CYRILLIC CAPITAL LETTER E WITH DIAERESIS
test(0x04EE, 0x04EF); // CYRILLIC CAPITAL LETTER U WITH MACRON, CYRILLIC SMALL LETTER U WITH MACRON
test(0x04EF, 0x04EE); // CYRILLIC SMALL LETTER U WITH MACRON, CYRILLIC CAPITAL LETTER U WITH MACRON
test(0x04F0, 0x04F1); // CYRILLIC CAPITAL LETTER U WITH DIAERESIS, CYRILLIC SMALL LETTER U WITH DIAERESIS
test(0x04F1, 0x04F0); // CYRILLIC SMALL LETTER U WITH DIAERESIS, CYRILLIC CAPITAL LETTER U WITH DIAERESIS
test(0x04F2, 0x04F3); // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE, CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
test(0x04F3, 0x04F2); // CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE, CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
test(0x04F4, 0x04F5); // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS, CYRILLIC SMALL LETTER CHE WITH DIAERESIS
test(0x04F5, 0x04F4); // CYRILLIC SMALL LETTER CHE WITH DIAERESIS, CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
test(0x04F6, 0x04F7); // CYRILLIC CAPITAL LETTER GHE WITH DESCENDER, CYRILLIC SMALL LETTER GHE WITH DESCENDER
test(0x04F7, 0x04F6); // CYRILLIC SMALL LETTER GHE WITH DESCENDER, CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
test(0x04F8, 0x04F9); // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS, CYRILLIC SMALL LETTER YERU WITH DIAERESIS
test(0x04F9, 0x04F8); // CYRILLIC SMALL LETTER YERU WITH DIAERESIS, CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
test(0x04FA, 0x04FB); // CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK, CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
test(0x04FB, 0x04FA); // CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK, CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
test(0x04FC, 0x04FD); // CYRILLIC CAPITAL LETTER HA WITH HOOK, CYRILLIC SMALL LETTER HA WITH HOOK
test(0x04FD, 0x04FC); // CYRILLIC SMALL LETTER HA WITH HOOK, CYRILLIC CAPITAL LETTER HA WITH HOOK
test(0x04FE, 0x04FF); // CYRILLIC CAPITAL LETTER HA WITH STROKE, CYRILLIC SMALL LETTER HA WITH STROKE
test(0x04FF, 0x04FE); // CYRILLIC SMALL LETTER HA WITH STROKE, CYRILLIC CAPITAL LETTER HA WITH STROKE
test(0x0500, 0x0501); // CYRILLIC CAPITAL LETTER KOMI DE, CYRILLIC SMALL LETTER KOMI DE
test(0x0501, 0x0500); // CYRILLIC SMALL LETTER KOMI DE, CYRILLIC CAPITAL LETTER KOMI DE
test(0x0502, 0x0503); // CYRILLIC CAPITAL LETTER KOMI DJE, CYRILLIC SMALL LETTER KOMI DJE
test(0x0503, 0x0502); // CYRILLIC SMALL LETTER KOMI DJE, CYRILLIC CAPITAL LETTER KOMI DJE
test(0x0504, 0x0505); // CYRILLIC CAPITAL LETTER KOMI ZJE, CYRILLIC SMALL LETTER KOMI ZJE
test(0x0505, 0x0504); // CYRILLIC SMALL LETTER KOMI ZJE, CYRILLIC CAPITAL LETTER KOMI ZJE
test(0x0506, 0x0507); // CYRILLIC CAPITAL LETTER KOMI DZJE, CYRILLIC SMALL LETTER KOMI DZJE
test(0x0507, 0x0506); // CYRILLIC SMALL LETTER KOMI DZJE, CYRILLIC CAPITAL LETTER KOMI DZJE
test(0x0508, 0x0509); // CYRILLIC CAPITAL LETTER KOMI LJE, CYRILLIC SMALL LETTER KOMI LJE
test(0x0509, 0x0508); // CYRILLIC SMALL LETTER KOMI LJE, CYRILLIC CAPITAL LETTER KOMI LJE
test(0x050A, 0x050B); // CYRILLIC CAPITAL LETTER KOMI NJE, CYRILLIC SMALL LETTER KOMI NJE
test(0x050B, 0x050A); // CYRILLIC SMALL LETTER KOMI NJE, CYRILLIC CAPITAL LETTER KOMI NJE
test(0x050C, 0x050D); // CYRILLIC CAPITAL LETTER KOMI SJE, CYRILLIC SMALL LETTER KOMI SJE
test(0x050D, 0x050C); // CYRILLIC SMALL LETTER KOMI SJE, CYRILLIC CAPITAL LETTER KOMI SJE
test(0x050E, 0x050F); // CYRILLIC CAPITAL LETTER KOMI TJE, CYRILLIC SMALL LETTER KOMI TJE
test(0x050F, 0x050E); // CYRILLIC SMALL LETTER KOMI TJE, CYRILLIC CAPITAL LETTER KOMI TJE
test(0x0510, 0x0511); // CYRILLIC CAPITAL LETTER REVERSED ZE, CYRILLIC SMALL LETTER REVERSED ZE
test(0x0511, 0x0510); // CYRILLIC SMALL LETTER REVERSED ZE, CYRILLIC CAPITAL LETTER REVERSED ZE
test(0x0512, 0x0513); // CYRILLIC CAPITAL LETTER EL WITH HOOK, CYRILLIC SMALL LETTER EL WITH HOOK
test(0x0513, 0x0512); // CYRILLIC SMALL LETTER EL WITH HOOK, CYRILLIC CAPITAL LETTER EL WITH HOOK
test(0x0514, 0x0515); // CYRILLIC CAPITAL LETTER LHA, CYRILLIC SMALL LETTER LHA
test(0x0515, 0x0514); // CYRILLIC SMALL LETTER LHA, CYRILLIC CAPITAL LETTER LHA
test(0x0516, 0x0517); // CYRILLIC CAPITAL LETTER RHA, CYRILLIC SMALL LETTER RHA
test(0x0517, 0x0516); // CYRILLIC SMALL LETTER RHA, CYRILLIC CAPITAL LETTER RHA
test(0x0518, 0x0519); // CYRILLIC CAPITAL LETTER YAE, CYRILLIC SMALL LETTER YAE
test(0x0519, 0x0518); // CYRILLIC SMALL LETTER YAE, CYRILLIC CAPITAL LETTER YAE
test(0x051A, 0x051B); // CYRILLIC CAPITAL LETTER QA, CYRILLIC SMALL LETTER QA
test(0x051B, 0x051A); // CYRILLIC SMALL LETTER QA, CYRILLIC CAPITAL LETTER QA
test(0x051C, 0x051D); // CYRILLIC CAPITAL LETTER WE, CYRILLIC SMALL LETTER WE
test(0x051D, 0x051C); // CYRILLIC SMALL LETTER WE, CYRILLIC CAPITAL LETTER WE
test(0x051E, 0x051F); // CYRILLIC CAPITAL LETTER ALEUT KA, CYRILLIC SMALL LETTER ALEUT KA
test(0x051F, 0x051E); // CYRILLIC SMALL LETTER ALEUT KA, CYRILLIC CAPITAL LETTER ALEUT KA
test(0x0520, 0x0521); // CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK, CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK
test(0x0521, 0x0520); // CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK, CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
test(0x0522, 0x0523); // CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK, CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK
test(0x0523, 0x0522); // CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK, CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
test(0x0524, 0x0525); // CYRILLIC CAPITAL LETTER PE WITH DESCENDER, CYRILLIC SMALL LETTER PE WITH DESCENDER
test(0x0525, 0x0524); // CYRILLIC SMALL LETTER PE WITH DESCENDER, CYRILLIC CAPITAL LETTER PE WITH DESCENDER
test(0x0526, 0x0527); // CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER, CYRILLIC SMALL LETTER SHHA WITH DESCENDER
test(0x0527, 0x0526); // CYRILLIC SMALL LETTER SHHA WITH DESCENDER, CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
test(0x0528, 0x0529); // CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK, CYRILLIC SMALL LETTER EN WITH LEFT HOOK
test(0x0529, 0x0528); // CYRILLIC SMALL LETTER EN WITH LEFT HOOK, CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK
test(0x052A, 0x052B); // CYRILLIC CAPITAL LETTER DZZHE, CYRILLIC SMALL LETTER DZZHE
test(0x052B, 0x052A); // CYRILLIC SMALL LETTER DZZHE, CYRILLIC CAPITAL LETTER DZZHE
test(0x052C, 0x052D); // CYRILLIC CAPITAL LETTER DCHE, CYRILLIC SMALL LETTER DCHE
test(0x052D, 0x052C); // CYRILLIC SMALL LETTER DCHE, CYRILLIC CAPITAL LETTER DCHE
test(0x052E, 0x052F); // CYRILLIC CAPITAL LETTER EL WITH DESCENDER, CYRILLIC SMALL LETTER EL WITH DESCENDER
test(0x052F, 0x052E); // CYRILLIC SMALL LETTER EL WITH DESCENDER, CYRILLIC CAPITAL LETTER EL WITH DESCENDER
test(0x0531, 0x0561); // ARMENIAN CAPITAL LETTER AYB, ARMENIAN SMALL LETTER AYB
test(0x0532, 0x0562); // ARMENIAN CAPITAL LETTER BEN, ARMENIAN SMALL LETTER BEN
test(0x0533, 0x0563); // ARMENIAN CAPITAL LETTER GIM, ARMENIAN SMALL LETTER GIM
test(0x0534, 0x0564); // ARMENIAN CAPITAL LETTER DA, ARMENIAN SMALL LETTER DA
test(0x0535, 0x0565); // ARMENIAN CAPITAL LETTER ECH, ARMENIAN SMALL LETTER ECH
test(0x0536, 0x0566); // ARMENIAN CAPITAL LETTER ZA, ARMENIAN SMALL LETTER ZA
test(0x0537, 0x0567); // ARMENIAN CAPITAL LETTER EH, ARMENIAN SMALL LETTER EH
test(0x0538, 0x0568); // ARMENIAN CAPITAL LETTER ET, ARMENIAN SMALL LETTER ET
test(0x0539, 0x0569); // ARMENIAN CAPITAL LETTER TO, ARMENIAN SMALL LETTER TO
test(0x053A, 0x056A); // ARMENIAN CAPITAL LETTER ZHE, ARMENIAN SMALL LETTER ZHE
test(0x053B, 0x056B); // ARMENIAN CAPITAL LETTER INI, ARMENIAN SMALL LETTER INI
test(0x053C, 0x056C); // ARMENIAN CAPITAL LETTER LIWN, ARMENIAN SMALL LETTER LIWN
test(0x053D, 0x056D); // ARMENIAN CAPITAL LETTER XEH, ARMENIAN SMALL LETTER XEH
test(0x053E, 0x056E); // ARMENIAN CAPITAL LETTER CA, ARMENIAN SMALL LETTER CA
test(0x053F, 0x056F); // ARMENIAN CAPITAL LETTER KEN, ARMENIAN SMALL LETTER KEN
test(0x0540, 0x0570); // ARMENIAN CAPITAL LETTER HO, ARMENIAN SMALL LETTER HO
test(0x0541, 0x0571); // ARMENIAN CAPITAL LETTER JA, ARMENIAN SMALL LETTER JA
test(0x0542, 0x0572); // ARMENIAN CAPITAL LETTER GHAD (ARMENIAN CAPITAL LETTER LAD), ARMENIAN SMALL LETTER GHAD (ARMENIAN SMALL LETTER LAD)
test(0x0543, 0x0573); // ARMENIAN CAPITAL LETTER CHEH, ARMENIAN SMALL LETTER CHEH
test(0x0544, 0x0574); // ARMENIAN CAPITAL LETTER MEN, ARMENIAN SMALL LETTER MEN
test(0x0545, 0x0575); // ARMENIAN CAPITAL LETTER YI, ARMENIAN SMALL LETTER YI
test(0x0546, 0x0576); // ARMENIAN CAPITAL LETTER NOW, ARMENIAN SMALL LETTER NOW
test(0x0547, 0x0577); // ARMENIAN CAPITAL LETTER SHA, ARMENIAN SMALL LETTER SHA
test(0x0548, 0x0578); // ARMENIAN CAPITAL LETTER VO, ARMENIAN SMALL LETTER VO
test(0x0549, 0x0579); // ARMENIAN CAPITAL LETTER CHA, ARMENIAN SMALL LETTER CHA
test(0x054A, 0x057A); // ARMENIAN CAPITAL LETTER PEH, ARMENIAN SMALL LETTER PEH
test(0x054B, 0x057B); // ARMENIAN CAPITAL LETTER JHEH, ARMENIAN SMALL LETTER JHEH
test(0x054C, 0x057C); // ARMENIAN CAPITAL LETTER RA, ARMENIAN SMALL LETTER RA
test(0x054D, 0x057D); // ARMENIAN CAPITAL LETTER SEH, ARMENIAN SMALL LETTER SEH
test(0x054E, 0x057E); // ARMENIAN CAPITAL LETTER VEW, ARMENIAN SMALL LETTER VEW
test(0x054F, 0x057F); // ARMENIAN CAPITAL LETTER TIWN, ARMENIAN SMALL LETTER TIWN
test(0x0550, 0x0580); // ARMENIAN CAPITAL LETTER REH, ARMENIAN SMALL LETTER REH
test(0x0551, 0x0581); // ARMENIAN CAPITAL LETTER CO, ARMENIAN SMALL LETTER CO
test(0x0552, 0x0582); // ARMENIAN CAPITAL LETTER YIWN, ARMENIAN SMALL LETTER YIWN
test(0x0553, 0x0583); // ARMENIAN CAPITAL LETTER PIWR, ARMENIAN SMALL LETTER PIWR
test(0x0554, 0x0584); // ARMENIAN CAPITAL LETTER KEH, ARMENIAN SMALL LETTER KEH
test(0x0555, 0x0585); // ARMENIAN CAPITAL LETTER OH, ARMENIAN SMALL LETTER OH
test(0x0556, 0x0586); // ARMENIAN CAPITAL LETTER FEH, ARMENIAN SMALL LETTER FEH
test(0x0561, 0x0531); // ARMENIAN SMALL LETTER AYB, ARMENIAN CAPITAL LETTER AYB
test(0x0562, 0x0532); // ARMENIAN SMALL LETTER BEN, ARMENIAN CAPITAL LETTER BEN
test(0x0563, 0x0533); // ARMENIAN SMALL LETTER GIM, ARMENIAN CAPITAL LETTER GIM
test(0x0564, 0x0534); // ARMENIAN SMALL LETTER DA, ARMENIAN CAPITAL LETTER DA
test(0x0565, 0x0535); // ARMENIAN SMALL LETTER ECH, ARMENIAN CAPITAL LETTER ECH
test(0x0566, 0x0536); // ARMENIAN SMALL LETTER ZA, ARMENIAN CAPITAL LETTER ZA
test(0x0567, 0x0537); // ARMENIAN SMALL LETTER EH, ARMENIAN CAPITAL LETTER EH
test(0x0568, 0x0538); // ARMENIAN SMALL LETTER ET, ARMENIAN CAPITAL LETTER ET
test(0x0569, 0x0539); // ARMENIAN SMALL LETTER TO, ARMENIAN CAPITAL LETTER TO
test(0x056A, 0x053A); // ARMENIAN SMALL LETTER ZHE, ARMENIAN CAPITAL LETTER ZHE
test(0x056B, 0x053B); // ARMENIAN SMALL LETTER INI, ARMENIAN CAPITAL LETTER INI
test(0x056C, 0x053C); // ARMENIAN SMALL LETTER LIWN, ARMENIAN CAPITAL LETTER LIWN
test(0x056D, 0x053D); // ARMENIAN SMALL LETTER XEH, ARMENIAN CAPITAL LETTER XEH
test(0x056E, 0x053E); // ARMENIAN SMALL LETTER CA, ARMENIAN CAPITAL LETTER CA
test(0x056F, 0x053F); // ARMENIAN SMALL LETTER KEN, ARMENIAN CAPITAL LETTER KEN
test(0x0570, 0x0540); // ARMENIAN SMALL LETTER HO, ARMENIAN CAPITAL LETTER HO
test(0x0571, 0x0541); // ARMENIAN SMALL LETTER JA, ARMENIAN CAPITAL LETTER JA
test(0x0572, 0x0542); // ARMENIAN SMALL LETTER GHAD (ARMENIAN SMALL LETTER LAD), ARMENIAN CAPITAL LETTER GHAD (ARMENIAN CAPITAL LETTER LAD)
test(0x0573, 0x0543); // ARMENIAN SMALL LETTER CHEH, ARMENIAN CAPITAL LETTER CHEH
test(0x0574, 0x0544); // ARMENIAN SMALL LETTER MEN, ARMENIAN CAPITAL LETTER MEN
test(0x0575, 0x0545); // ARMENIAN SMALL LETTER YI, ARMENIAN CAPITAL LETTER YI
test(0x0576, 0x0546); // ARMENIAN SMALL LETTER NOW, ARMENIAN CAPITAL LETTER NOW
test(0x0577, 0x0547); // ARMENIAN SMALL LETTER SHA, ARMENIAN CAPITAL LETTER SHA
test(0x0578, 0x0548); // ARMENIAN SMALL LETTER VO, ARMENIAN CAPITAL LETTER VO
test(0x0579, 0x0549); // ARMENIAN SMALL LETTER CHA, ARMENIAN CAPITAL LETTER CHA
test(0x057A, 0x054A); // ARMENIAN SMALL LETTER PEH, ARMENIAN CAPITAL LETTER PEH
test(0x057B, 0x054B); // ARMENIAN SMALL LETTER JHEH, ARMENIAN CAPITAL LETTER JHEH
test(0x057C, 0x054C); // ARMENIAN SMALL LETTER RA, ARMENIAN CAPITAL LETTER RA
test(0x057D, 0x054D); // ARMENIAN SMALL LETTER SEH, ARMENIAN CAPITAL LETTER SEH
test(0x057E, 0x054E); // ARMENIAN SMALL LETTER VEW, ARMENIAN CAPITAL LETTER VEW
test(0x057F, 0x054F); // ARMENIAN SMALL LETTER TIWN, ARMENIAN CAPITAL LETTER TIWN
test(0x0580, 0x0550); // ARMENIAN SMALL LETTER REH, ARMENIAN CAPITAL LETTER REH
test(0x0581, 0x0551); // ARMENIAN SMALL LETTER CO, ARMENIAN CAPITAL LETTER CO
test(0x0582, 0x0552); // ARMENIAN SMALL LETTER YIWN, ARMENIAN CAPITAL LETTER YIWN
test(0x0583, 0x0553); // ARMENIAN SMALL LETTER PIWR, ARMENIAN CAPITAL LETTER PIWR
test(0x0584, 0x0554); // ARMENIAN SMALL LETTER KEH, ARMENIAN CAPITAL LETTER KEH
test(0x0585, 0x0555); // ARMENIAN SMALL LETTER OH, ARMENIAN CAPITAL LETTER OH
test(0x0586, 0x0556); // ARMENIAN SMALL LETTER FEH, ARMENIAN CAPITAL LETTER FEH
test(0x10A0, 0x2D00); // GEORGIAN CAPITAL LETTER AN, GEORGIAN SMALL LETTER AN
test(0x10A1, 0x2D01); // GEORGIAN CAPITAL LETTER BAN, GEORGIAN SMALL LETTER BAN
test(0x10A2, 0x2D02); // GEORGIAN CAPITAL LETTER GAN, GEORGIAN SMALL LETTER GAN
test(0x10A3, 0x2D03); // GEORGIAN CAPITAL LETTER DON, GEORGIAN SMALL LETTER DON
test(0x10A4, 0x2D04); // GEORGIAN CAPITAL LETTER EN, GEORGIAN SMALL LETTER EN
test(0x10A5, 0x2D05); // GEORGIAN CAPITAL LETTER VIN, GEORGIAN SMALL LETTER VIN
test(0x10A6, 0x2D06); // GEORGIAN CAPITAL LETTER ZEN, GEORGIAN SMALL LETTER ZEN
test(0x10A7, 0x2D07); // GEORGIAN CAPITAL LETTER TAN, GEORGIAN SMALL LETTER TAN
test(0x10A8, 0x2D08); // GEORGIAN CAPITAL LETTER IN, GEORGIAN SMALL LETTER IN
test(0x10A9, 0x2D09); // GEORGIAN CAPITAL LETTER KAN, GEORGIAN SMALL LETTER KAN
test(0x10AA, 0x2D0A); // GEORGIAN CAPITAL LETTER LAS, GEORGIAN SMALL LETTER LAS
test(0x10AB, 0x2D0B); // GEORGIAN CAPITAL LETTER MAN, GEORGIAN SMALL LETTER MAN
test(0x10AC, 0x2D0C); // GEORGIAN CAPITAL LETTER NAR, GEORGIAN SMALL LETTER NAR
test(0x10AD, 0x2D0D); // GEORGIAN CAPITAL LETTER ON, GEORGIAN SMALL LETTER ON
test(0x10AE, 0x2D0E); // GEORGIAN CAPITAL LETTER PAR, GEORGIAN SMALL LETTER PAR
test(0x10AF, 0x2D0F); // GEORGIAN CAPITAL LETTER ZHAR, GEORGIAN SMALL LETTER ZHAR
test(0x10B0, 0x2D10); // GEORGIAN CAPITAL LETTER RAE, GEORGIAN SMALL LETTER RAE
test(0x10B1, 0x2D11); // GEORGIAN CAPITAL LETTER SAN, GEORGIAN SMALL LETTER SAN
test(0x10B2, 0x2D12); // GEORGIAN CAPITAL LETTER TAR, GEORGIAN SMALL LETTER TAR
test(0x10B3, 0x2D13); // GEORGIAN CAPITAL LETTER UN, GEORGIAN SMALL LETTER UN
test(0x10B4, 0x2D14); // GEORGIAN CAPITAL LETTER PHAR, GEORGIAN SMALL LETTER PHAR
test(0x10B5, 0x2D15); // GEORGIAN CAPITAL LETTER KHAR, GEORGIAN SMALL LETTER KHAR
test(0x10B6, 0x2D16); // GEORGIAN CAPITAL LETTER GHAN, GEORGIAN SMALL LETTER GHAN
test(0x10B7, 0x2D17); // GEORGIAN CAPITAL LETTER QAR, GEORGIAN SMALL LETTER QAR
test(0x10B8, 0x2D18); // GEORGIAN CAPITAL LETTER SHIN, GEORGIAN SMALL LETTER SHIN
test(0x10B9, 0x2D19); // GEORGIAN CAPITAL LETTER CHIN, GEORGIAN SMALL LETTER CHIN
test(0x10BA, 0x2D1A); // GEORGIAN CAPITAL LETTER CAN, GEORGIAN SMALL LETTER CAN
test(0x10BB, 0x2D1B); // GEORGIAN CAPITAL LETTER JIL, GEORGIAN SMALL LETTER JIL
test(0x10BC, 0x2D1C); // GEORGIAN CAPITAL LETTER CIL, GEORGIAN SMALL LETTER CIL
test(0x10BD, 0x2D1D); // GEORGIAN CAPITAL LETTER CHAR, GEORGIAN SMALL LETTER CHAR
test(0x10BE, 0x2D1E); // GEORGIAN CAPITAL LETTER XAN, GEORGIAN SMALL LETTER XAN
test(0x10BF, 0x2D1F); // GEORGIAN CAPITAL LETTER JHAN, GEORGIAN SMALL LETTER JHAN
test(0x10C0, 0x2D20); // GEORGIAN CAPITAL LETTER HAE, GEORGIAN SMALL LETTER HAE
test(0x10C1, 0x2D21); // GEORGIAN CAPITAL LETTER HE, GEORGIAN SMALL LETTER HE
test(0x10C2, 0x2D22); // GEORGIAN CAPITAL LETTER HIE, GEORGIAN SMALL LETTER HIE
test(0x10C3, 0x2D23); // GEORGIAN CAPITAL LETTER WE, GEORGIAN SMALL LETTER WE
test(0x10C4, 0x2D24); // GEORGIAN CAPITAL LETTER HAR, GEORGIAN SMALL LETTER HAR
test(0x10C5, 0x2D25); // GEORGIAN CAPITAL LETTER HOE, GEORGIAN SMALL LETTER HOE
test(0x10C7, 0x2D27); // GEORGIAN CAPITAL LETTER YN, GEORGIAN SMALL LETTER YN
test(0x10CD, 0x2D2D); // GEORGIAN CAPITAL LETTER AEN, GEORGIAN SMALL LETTER AEN
test(0x10D0, 0x1C90); // GEORGIAN LETTER AN (GEORGIAN SMALL LETTER AN), GEORGIAN MTAVRULI CAPITAL LETTER AN
test(0x10D1, 0x1C91); // GEORGIAN LETTER BAN (GEORGIAN SMALL LETTER BAN), GEORGIAN MTAVRULI CAPITAL LETTER BAN
test(0x10D2, 0x1C92); // GEORGIAN LETTER GAN (GEORGIAN SMALL LETTER GAN), GEORGIAN MTAVRULI CAPITAL LETTER GAN
test(0x10D3, 0x1C93); // GEORGIAN LETTER DON (GEORGIAN SMALL LETTER DON), GEORGIAN MTAVRULI CAPITAL LETTER DON
test(0x10D4, 0x1C94); // GEORGIAN LETTER EN (GEORGIAN SMALL LETTER EN), GEORGIAN MTAVRULI CAPITAL LETTER EN
test(0x10D5, 0x1C95); // GEORGIAN LETTER VIN (GEORGIAN SMALL LETTER VIN), GEORGIAN MTAVRULI CAPITAL LETTER VIN
test(0x10D6, 0x1C96); // GEORGIAN LETTER ZEN (GEORGIAN SMALL LETTER ZEN), GEORGIAN MTAVRULI CAPITAL LETTER ZEN
test(0x10D7, 0x1C97); // GEORGIAN LETTER TAN (GEORGIAN SMALL LETTER TAN), GEORGIAN MTAVRULI CAPITAL LETTER TAN
test(0x10D8, 0x1C98); // GEORGIAN LETTER IN (GEORGIAN SMALL LETTER IN), GEORGIAN MTAVRULI CAPITAL LETTER IN
test(0x10D9, 0x1C99); // GEORGIAN LETTER KAN (GEORGIAN SMALL LETTER KAN), GEORGIAN MTAVRULI CAPITAL LETTER KAN
test(0x10DA, 0x1C9A); // GEORGIAN LETTER LAS (GEORGIAN SMALL LETTER LAS), GEORGIAN MTAVRULI CAPITAL LETTER LAS
test(0x10DB, 0x1C9B); // GEORGIAN LETTER MAN (GEORGIAN SMALL LETTER MAN), GEORGIAN MTAVRULI CAPITAL LETTER MAN
test(0x10DC, 0x1C9C); // GEORGIAN LETTER NAR (GEORGIAN SMALL LETTER NAR), GEORGIAN MTAVRULI CAPITAL LETTER NAR
test(0x10DD, 0x1C9D); // GEORGIAN LETTER ON (GEORGIAN SMALL LETTER ON), GEORGIAN MTAVRULI CAPITAL LETTER ON
test(0x10DE, 0x1C9E); // GEORGIAN LETTER PAR (GEORGIAN SMALL LETTER PAR), GEORGIAN MTAVRULI CAPITAL LETTER PAR
test(0x10DF, 0x1C9F); // GEORGIAN LETTER ZHAR (GEORGIAN SMALL LETTER ZHAR), GEORGIAN MTAVRULI CAPITAL LETTER ZHAR
test(0x10E0, 0x1CA0); // GEORGIAN LETTER RAE (GEORGIAN SMALL LETTER RAE), GEORGIAN MTAVRULI CAPITAL LETTER RAE
test(0x10E1, 0x1CA1); // GEORGIAN LETTER SAN (GEORGIAN SMALL LETTER SAN), GEORGIAN MTAVRULI CAPITAL LETTER SAN
test(0x10E2, 0x1CA2); // GEORGIAN LETTER TAR (GEORGIAN SMALL LETTER TAR), GEORGIAN MTAVRULI CAPITAL LETTER TAR
test(0x10E3, 0x1CA3); // GEORGIAN LETTER UN (GEORGIAN SMALL LETTER UN), GEORGIAN MTAVRULI CAPITAL LETTER UN
test(0x10E4, 0x1CA4); // GEORGIAN LETTER PHAR (GEORGIAN SMALL LETTER PHAR), GEORGIAN MTAVRULI CAPITAL LETTER PHAR
test(0x10E5, 0x1CA5); // GEORGIAN LETTER KHAR (GEORGIAN SMALL LETTER KHAR), GEORGIAN MTAVRULI CAPITAL LETTER KHAR
test(0x10E6, 0x1CA6); // GEORGIAN LETTER GHAN (GEORGIAN SMALL LETTER GHAN), GEORGIAN MTAVRULI CAPITAL LETTER GHAN
test(0x10E7, 0x1CA7); // GEORGIAN LETTER QAR (GEORGIAN SMALL LETTER QAR), GEORGIAN MTAVRULI CAPITAL LETTER QAR
test(0x10E8, 0x1CA8); // GEORGIAN LETTER SHIN (GEORGIAN SMALL LETTER SHIN), GEORGIAN MTAVRULI CAPITAL LETTER SHIN
test(0x10E9, 0x1CA9); // GEORGIAN LETTER CHIN (GEORGIAN SMALL LETTER CHIN), GEORGIAN MTAVRULI CAPITAL LETTER CHIN
test(0x10EA, 0x1CAA); // GEORGIAN LETTER CAN (GEORGIAN SMALL LETTER CAN), GEORGIAN MTAVRULI CAPITAL LETTER CAN
test(0x10EB, 0x1CAB); // GEORGIAN LETTER JIL (GEORGIAN SMALL LETTER JIL), GEORGIAN MTAVRULI CAPITAL LETTER JIL
test(0x10EC, 0x1CAC); // GEORGIAN LETTER CIL (GEORGIAN SMALL LETTER CIL), GEORGIAN MTAVRULI CAPITAL LETTER CIL
test(0x10ED, 0x1CAD); // GEORGIAN LETTER CHAR (GEORGIAN SMALL LETTER CHAR), GEORGIAN MTAVRULI CAPITAL LETTER CHAR
test(0x10EE, 0x1CAE); // GEORGIAN LETTER XAN (GEORGIAN SMALL LETTER XAN), GEORGIAN MTAVRULI CAPITAL LETTER XAN
test(0x10EF, 0x1CAF); // GEORGIAN LETTER JHAN (GEORGIAN SMALL LETTER JHAN), GEORGIAN MTAVRULI CAPITAL LETTER JHAN
test(0x10F0, 0x1CB0); // GEORGIAN LETTER HAE (GEORGIAN SMALL LETTER HAE), GEORGIAN MTAVRULI CAPITAL LETTER HAE
test(0x10F1, 0x1CB1); // GEORGIAN LETTER HE (GEORGIAN SMALL LETTER HE), GEORGIAN MTAVRULI CAPITAL LETTER HE
test(0x10F2, 0x1CB2); // GEORGIAN LETTER HIE (GEORGIAN SMALL LETTER HIE), GEORGIAN MTAVRULI CAPITAL LETTER HIE
test(0x10F3, 0x1CB3); // GEORGIAN LETTER WE (GEORGIAN SMALL LETTER WE), GEORGIAN MTAVRULI CAPITAL LETTER WE
test(0x10F4, 0x1CB4); // GEORGIAN LETTER HAR (GEORGIAN SMALL LETTER HAR), GEORGIAN MTAVRULI CAPITAL LETTER HAR
test(0x10F5, 0x1CB5); // GEORGIAN LETTER HOE (GEORGIAN SMALL LETTER HOE), GEORGIAN MTAVRULI CAPITAL LETTER HOE
test(0x10F6, 0x1CB6); // GEORGIAN LETTER FI (GEORGIAN SMALL LETTER FI), GEORGIAN MTAVRULI CAPITAL LETTER FI
test(0x10F7, 0x1CB7); // GEORGIAN LETTER YN, GEORGIAN MTAVRULI CAPITAL LETTER YN
test(0x10F8, 0x1CB8); // GEORGIAN LETTER ELIFI, GEORGIAN MTAVRULI CAPITAL LETTER ELIFI
test(0x10F9, 0x1CB9); // GEORGIAN LETTER TURNED GAN, GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN
test(0x10FA, 0x1CBA); // GEORGIAN LETTER AIN, GEORGIAN MTAVRULI CAPITAL LETTER AIN
test(0x10FD, 0x1CBD); // GEORGIAN LETTER AEN, GEORGIAN MTAVRULI CAPITAL LETTER AEN
test(0x10FE, 0x1CBE); // GEORGIAN LETTER HARD SIGN, GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN
test(0x10FF, 0x1CBF); // GEORGIAN LETTER LABIAL SIGN, GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
test(0x13A0, 0xAB70); // CHEROKEE LETTER A, CHEROKEE SMALL LETTER A
test(0x13A1, 0xAB71); // CHEROKEE LETTER E, CHEROKEE SMALL LETTER E
test(0x13A2, 0xAB72); // CHEROKEE LETTER I, CHEROKEE SMALL LETTER I
test(0x13A3, 0xAB73); // CHEROKEE LETTER O, CHEROKEE SMALL LETTER O
test(0x13A4, 0xAB74); // CHEROKEE LETTER U, CHEROKEE SMALL LETTER U
test(0x13A5, 0xAB75); // CHEROKEE LETTER V, CHEROKEE SMALL LETTER V
test(0x13A6, 0xAB76); // CHEROKEE LETTER GA, CHEROKEE SMALL LETTER GA
test(0x13A7, 0xAB77); // CHEROKEE LETTER KA, CHEROKEE SMALL LETTER KA
test(0x13A8, 0xAB78); // CHEROKEE LETTER GE, CHEROKEE SMALL LETTER GE
test(0x13A9, 0xAB79); // CHEROKEE LETTER GI, CHEROKEE SMALL LETTER GI
test(0x13AA, 0xAB7A); // CHEROKEE LETTER GO, CHEROKEE SMALL LETTER GO
test(0x13AB, 0xAB7B); // CHEROKEE LETTER GU, CHEROKEE SMALL LETTER GU
test(0x13AC, 0xAB7C); // CHEROKEE LETTER GV, CHEROKEE SMALL LETTER GV
test(0x13AD, 0xAB7D); // CHEROKEE LETTER HA, CHEROKEE SMALL LETTER HA
test(0x13AE, 0xAB7E); // CHEROKEE LETTER HE, CHEROKEE SMALL LETTER HE
test(0x13AF, 0xAB7F); // CHEROKEE LETTER HI, CHEROKEE SMALL LETTER HI
test(0x13B0, 0xAB80); // CHEROKEE LETTER HO, CHEROKEE SMALL LETTER HO
test(0x13B1, 0xAB81); // CHEROKEE LETTER HU, CHEROKEE SMALL LETTER HU
test(0x13B2, 0xAB82); // CHEROKEE LETTER HV, CHEROKEE SMALL LETTER HV
test(0x13B3, 0xAB83); // CHEROKEE LETTER LA, CHEROKEE SMALL LETTER LA
test(0x13B4, 0xAB84); // CHEROKEE LETTER LE, CHEROKEE SMALL LETTER LE
test(0x13B5, 0xAB85); // CHEROKEE LETTER LI, CHEROKEE SMALL LETTER LI
test(0x13B6, 0xAB86); // CHEROKEE LETTER LO, CHEROKEE SMALL LETTER LO
test(0x13B7, 0xAB87); // CHEROKEE LETTER LU, CHEROKEE SMALL LETTER LU
test(0x13B8, 0xAB88); // CHEROKEE LETTER LV, CHEROKEE SMALL LETTER LV
test(0x13B9, 0xAB89); // CHEROKEE LETTER MA, CHEROKEE SMALL LETTER MA
test(0x13BA, 0xAB8A); // CHEROKEE LETTER ME, CHEROKEE SMALL LETTER ME
test(0x13BB, 0xAB8B); // CHEROKEE LETTER MI, CHEROKEE SMALL LETTER MI
test(0x13BC, 0xAB8C); // CHEROKEE LETTER MO, CHEROKEE SMALL LETTER MO
test(0x13BD, 0xAB8D); // CHEROKEE LETTER MU, CHEROKEE SMALL LETTER MU
test(0x13BE, 0xAB8E); // CHEROKEE LETTER NA, CHEROKEE SMALL LETTER NA
test(0x13BF, 0xAB8F); // CHEROKEE LETTER HNA, CHEROKEE SMALL LETTER HNA
test(0x13C0, 0xAB90); // CHEROKEE LETTER NAH, CHEROKEE SMALL LETTER NAH
test(0x13C1, 0xAB91); // CHEROKEE LETTER NE, CHEROKEE SMALL LETTER NE
test(0x13C2, 0xAB92); // CHEROKEE LETTER NI, CHEROKEE SMALL LETTER NI
test(0x13C3, 0xAB93); // CHEROKEE LETTER NO, CHEROKEE SMALL LETTER NO
test(0x13C4, 0xAB94); // CHEROKEE LETTER NU, CHEROKEE SMALL LETTER NU
test(0x13C5, 0xAB95); // CHEROKEE LETTER NV, CHEROKEE SMALL LETTER NV
test(0x13C6, 0xAB96); // CHEROKEE LETTER QUA, CHEROKEE SMALL LETTER QUA
test(0x13C7, 0xAB97); // CHEROKEE LETTER QUE, CHEROKEE SMALL LETTER QUE
test(0x13C8, 0xAB98); // CHEROKEE LETTER QUI, CHEROKEE SMALL LETTER QUI
test(0x13C9, 0xAB99); // CHEROKEE LETTER QUO, CHEROKEE SMALL LETTER QUO
test(0x13CA, 0xAB9A); // CHEROKEE LETTER QUU, CHEROKEE SMALL LETTER QUU
test(0x13CB, 0xAB9B); // CHEROKEE LETTER QUV, CHEROKEE SMALL LETTER QUV
test(0x13CC, 0xAB9C); // CHEROKEE LETTER SA, CHEROKEE SMALL LETTER SA
test(0x13CD, 0xAB9D); // CHEROKEE LETTER S, CHEROKEE SMALL LETTER S
test(0x13CE, 0xAB9E); // CHEROKEE LETTER SE, CHEROKEE SMALL LETTER SE
test(0x13CF, 0xAB9F); // CHEROKEE LETTER SI, CHEROKEE SMALL LETTER SI
test(0x13D0, 0xABA0); // CHEROKEE LETTER SO, CHEROKEE SMALL LETTER SO
test(0x13D1, 0xABA1); // CHEROKEE LETTER SU, CHEROKEE SMALL LETTER SU
test(0x13D2, 0xABA2); // CHEROKEE LETTER SV, CHEROKEE SMALL LETTER SV
test(0x13D3, 0xABA3); // CHEROKEE LETTER DA, CHEROKEE SMALL LETTER DA
test(0x13D4, 0xABA4); // CHEROKEE LETTER TA, CHEROKEE SMALL LETTER TA
test(0x13D5, 0xABA5); // CHEROKEE LETTER DE, CHEROKEE SMALL LETTER DE
test(0x13D6, 0xABA6); // CHEROKEE LETTER TE, CHEROKEE SMALL LETTER TE
test(0x13D7, 0xABA7); // CHEROKEE LETTER DI, CHEROKEE SMALL LETTER DI
test(0x13D8, 0xABA8); // CHEROKEE LETTER TI, CHEROKEE SMALL LETTER TI
test(0x13D9, 0xABA9); // CHEROKEE LETTER DO, CHEROKEE SMALL LETTER DO
test(0x13DA, 0xABAA); // CHEROKEE LETTER DU, CHEROKEE SMALL LETTER DU
test(0x13DB, 0xABAB); // CHEROKEE LETTER DV, CHEROKEE SMALL LETTER DV
test(0x13DC, 0xABAC); // CHEROKEE LETTER DLA, CHEROKEE SMALL LETTER DLA
test(0x13DD, 0xABAD); // CHEROKEE LETTER TLA, CHEROKEE SMALL LETTER TLA
test(0x13DE, 0xABAE); // CHEROKEE LETTER TLE, CHEROKEE SMALL LETTER TLE
test(0x13DF, 0xABAF); // CHEROKEE LETTER TLI, CHEROKEE SMALL LETTER TLI
test(0x13E0, 0xABB0); // CHEROKEE LETTER TLO, CHEROKEE SMALL LETTER TLO
test(0x13E1, 0xABB1); // CHEROKEE LETTER TLU, CHEROKEE SMALL LETTER TLU
test(0x13E2, 0xABB2); // CHEROKEE LETTER TLV, CHEROKEE SMALL LETTER TLV
test(0x13E3, 0xABB3); // CHEROKEE LETTER TSA, CHEROKEE SMALL LETTER TSA
test(0x13E4, 0xABB4); // CHEROKEE LETTER TSE, CHEROKEE SMALL LETTER TSE
test(0x13E5, 0xABB5); // CHEROKEE LETTER TSI, CHEROKEE SMALL LETTER TSI
test(0x13E6, 0xABB6); // CHEROKEE LETTER TSO, CHEROKEE SMALL LETTER TSO
test(0x13E7, 0xABB7); // CHEROKEE LETTER TSU, CHEROKEE SMALL LETTER TSU
test(0x13E8, 0xABB8); // CHEROKEE LETTER TSV, CHEROKEE SMALL LETTER TSV
test(0x13E9, 0xABB9); // CHEROKEE LETTER WA, CHEROKEE SMALL LETTER WA
test(0x13EA, 0xABBA); // CHEROKEE LETTER WE, CHEROKEE SMALL LETTER WE
test(0x13EB, 0xABBB); // CHEROKEE LETTER WI, CHEROKEE SMALL LETTER WI
test(0x13EC, 0xABBC); // CHEROKEE LETTER WO, CHEROKEE SMALL LETTER WO
test(0x13ED, 0xABBD); // CHEROKEE LETTER WU, CHEROKEE SMALL LETTER WU
test(0x13EE, 0xABBE); // CHEROKEE LETTER WV, CHEROKEE SMALL LETTER WV
test(0x13EF, 0xABBF); // CHEROKEE LETTER YA, CHEROKEE SMALL LETTER YA
test(0x13F0, 0x13F8); // CHEROKEE LETTER YE, CHEROKEE SMALL LETTER YE
test(0x13F1, 0x13F9); // CHEROKEE LETTER YI, CHEROKEE SMALL LETTER YI
test(0x13F2, 0x13FA); // CHEROKEE LETTER YO, CHEROKEE SMALL LETTER YO
test(0x13F3, 0x13FB); // CHEROKEE LETTER YU, CHEROKEE SMALL LETTER YU
test(0x13F4, 0x13FC); // CHEROKEE LETTER YV, CHEROKEE SMALL LETTER YV
test(0x13F5, 0x13FD); // CHEROKEE LETTER MV, CHEROKEE SMALL LETTER MV
test(0x13F8, 0x13F0); // CHEROKEE SMALL LETTER YE, CHEROKEE LETTER YE
test(0x13F9, 0x13F1); // CHEROKEE SMALL LETTER YI, CHEROKEE LETTER YI
test(0x13FA, 0x13F2); // CHEROKEE SMALL LETTER YO, CHEROKEE LETTER YO
test(0x13FB, 0x13F3); // CHEROKEE SMALL LETTER YU, CHEROKEE LETTER YU
test(0x13FC, 0x13F4); // CHEROKEE SMALL LETTER YV, CHEROKEE LETTER YV
test(0x13FD, 0x13F5); // CHEROKEE SMALL LETTER MV, CHEROKEE LETTER MV
test(0x1C80, 0x0432, 0x0412); // CYRILLIC SMALL LETTER ROUNDED VE, CYRILLIC SMALL LETTER VE, CYRILLIC CAPITAL LETTER VE
test(0x1C81, 0x0434, 0x0414); // CYRILLIC SMALL LETTER LONG-LEGGED DE, CYRILLIC SMALL LETTER DE, CYRILLIC CAPITAL LETTER DE
test(0x1C82, 0x043E, 0x041E); // CYRILLIC SMALL LETTER NARROW O, CYRILLIC SMALL LETTER O, CYRILLIC CAPITAL LETTER O
test(0x1C83, 0x0441, 0x0421); // CYRILLIC SMALL LETTER WIDE ES, CYRILLIC SMALL LETTER ES, CYRILLIC CAPITAL LETTER ES
test(0x1C84, 0x0442, 0x0422, 0x1C85); // CYRILLIC SMALL LETTER TALL TE, CYRILLIC SMALL LETTER TE, CYRILLIC CAPITAL LETTER TE, CYRILLIC SMALL LETTER THREE-LEGGED TE
test(0x1C85, 0x0442, 0x0422, 0x1C84); // CYRILLIC SMALL LETTER THREE-LEGGED TE, CYRILLIC SMALL LETTER TE, CYRILLIC CAPITAL LETTER TE, CYRILLIC SMALL LETTER TALL TE
test(0x1C86, 0x044A, 0x042A); // CYRILLIC SMALL LETTER TALL HARD SIGN, CYRILLIC SMALL LETTER HARD SIGN, CYRILLIC CAPITAL LETTER HARD SIGN
test(0x1C87, 0x0463, 0x0462); // CYRILLIC SMALL LETTER TALL YAT, CYRILLIC SMALL LETTER YAT, CYRILLIC CAPITAL LETTER YAT
test(0x1C88, 0xA64B, 0xA64A); // CYRILLIC SMALL LETTER UNBLENDED UK, CYRILLIC SMALL LETTER MONOGRAPH UK, CYRILLIC CAPITAL LETTER MONOGRAPH UK
test(0x1C89, 0x1C8A); // CYRILLIC CAPITAL LETTER TJE, CYRILLIC SMALL LETTER TJE
test(0x1C8A, 0x1C89); // CYRILLIC SMALL LETTER TJE, CYRILLIC CAPITAL LETTER TJE
test(0x1C90, 0x10D0); // GEORGIAN MTAVRULI CAPITAL LETTER AN, GEORGIAN LETTER AN (GEORGIAN SMALL LETTER AN)
test(0x1C91, 0x10D1); // GEORGIAN MTAVRULI CAPITAL LETTER BAN, GEORGIAN LETTER BAN (GEORGIAN SMALL LETTER BAN)
test(0x1C92, 0x10D2); // GEORGIAN MTAVRULI CAPITAL LETTER GAN, GEORGIAN LETTER GAN (GEORGIAN SMALL LETTER GAN)
test(0x1C93, 0x10D3); // GEORGIAN MTAVRULI CAPITAL LETTER DON, GEORGIAN LETTER DON (GEORGIAN SMALL LETTER DON)
test(0x1C94, 0x10D4); // GEORGIAN MTAVRULI CAPITAL LETTER EN, GEORGIAN LETTER EN (GEORGIAN SMALL LETTER EN)
test(0x1C95, 0x10D5); // GEORGIAN MTAVRULI CAPITAL LETTER VIN, GEORGIAN LETTER VIN (GEORGIAN SMALL LETTER VIN)
test(0x1C96, 0x10D6); // GEORGIAN MTAVRULI CAPITAL LETTER ZEN, GEORGIAN LETTER ZEN (GEORGIAN SMALL LETTER ZEN)
test(0x1C97, 0x10D7); // GEORGIAN MTAVRULI CAPITAL LETTER TAN, GEORGIAN LETTER TAN (GEORGIAN SMALL LETTER TAN)
test(0x1C98, 0x10D8); // GEORGIAN MTAVRULI CAPITAL LETTER IN, GEORGIAN LETTER IN (GEORGIAN SMALL LETTER IN)
test(0x1C99, 0x10D9); // GEORGIAN MTAVRULI CAPITAL LETTER KAN, GEORGIAN LETTER KAN (GEORGIAN SMALL LETTER KAN)
test(0x1C9A, 0x10DA); // GEORGIAN MTAVRULI CAPITAL LETTER LAS, GEORGIAN LETTER LAS (GEORGIAN SMALL LETTER LAS)
test(0x1C9B, 0x10DB); // GEORGIAN MTAVRULI CAPITAL LETTER MAN, GEORGIAN LETTER MAN (GEORGIAN SMALL LETTER MAN)
test(0x1C9C, 0x10DC); // GEORGIAN MTAVRULI CAPITAL LETTER NAR, GEORGIAN LETTER NAR (GEORGIAN SMALL LETTER NAR)
test(0x1C9D, 0x10DD); // GEORGIAN MTAVRULI CAPITAL LETTER ON, GEORGIAN LETTER ON (GEORGIAN SMALL LETTER ON)
test(0x1C9E, 0x10DE); // GEORGIAN MTAVRULI CAPITAL LETTER PAR, GEORGIAN LETTER PAR (GEORGIAN SMALL LETTER PAR)
test(0x1C9F, 0x10DF); // GEORGIAN MTAVRULI CAPITAL LETTER ZHAR, GEORGIAN LETTER ZHAR (GEORGIAN SMALL LETTER ZHAR)
test(0x1CA0, 0x10E0); // GEORGIAN MTAVRULI CAPITAL LETTER RAE, GEORGIAN LETTER RAE (GEORGIAN SMALL LETTER RAE)
test(0x1CA1, 0x10E1); // GEORGIAN MTAVRULI CAPITAL LETTER SAN, GEORGIAN LETTER SAN (GEORGIAN SMALL LETTER SAN)
test(0x1CA2, 0x10E2); // GEORGIAN MTAVRULI CAPITAL LETTER TAR, GEORGIAN LETTER TAR (GEORGIAN SMALL LETTER TAR)
test(0x1CA3, 0x10E3); // GEORGIAN MTAVRULI CAPITAL LETTER UN, GEORGIAN LETTER UN (GEORGIAN SMALL LETTER UN)
test(0x1CA4, 0x10E4); // GEORGIAN MTAVRULI CAPITAL LETTER PHAR, GEORGIAN LETTER PHAR (GEORGIAN SMALL LETTER PHAR)
test(0x1CA5, 0x10E5); // GEORGIAN MTAVRULI CAPITAL LETTER KHAR, GEORGIAN LETTER KHAR (GEORGIAN SMALL LETTER KHAR)
test(0x1CA6, 0x10E6); // GEORGIAN MTAVRULI CAPITAL LETTER GHAN, GEORGIAN LETTER GHAN (GEORGIAN SMALL LETTER GHAN)
test(0x1CA7, 0x10E7); // GEORGIAN MTAVRULI CAPITAL LETTER QAR, GEORGIAN LETTER QAR (GEORGIAN SMALL LETTER QAR)
test(0x1CA8, 0x10E8); // GEORGIAN MTAVRULI CAPITAL LETTER SHIN, GEORGIAN LETTER SHIN (GEORGIAN SMALL LETTER SHIN)
test(0x1CA9, 0x10E9); // GEORGIAN MTAVRULI CAPITAL LETTER CHIN, GEORGIAN LETTER CHIN (GEORGIAN SMALL LETTER CHIN)
test(0x1CAA, 0x10EA); // GEORGIAN MTAVRULI CAPITAL LETTER CAN, GEORGIAN LETTER CAN (GEORGIAN SMALL LETTER CAN)
test(0x1CAB, 0x10EB); // GEORGIAN MTAVRULI CAPITAL LETTER JIL, GEORGIAN LETTER JIL (GEORGIAN SMALL LETTER JIL)
test(0x1CAC, 0x10EC); // GEORGIAN MTAVRULI CAPITAL LETTER CIL, GEORGIAN LETTER CIL (GEORGIAN SMALL LETTER CIL)
test(0x1CAD, 0x10ED); // GEORGIAN MTAVRULI CAPITAL LETTER CHAR, GEORGIAN LETTER CHAR (GEORGIAN SMALL LETTER CHAR)
test(0x1CAE, 0x10EE); // GEORGIAN MTAVRULI CAPITAL LETTER XAN, GEORGIAN LETTER XAN (GEORGIAN SMALL LETTER XAN)
test(0x1CAF, 0x10EF); // GEORGIAN MTAVRULI CAPITAL LETTER JHAN, GEORGIAN LETTER JHAN (GEORGIAN SMALL LETTER JHAN)
test(0x1CB0, 0x10F0); // GEORGIAN MTAVRULI CAPITAL LETTER HAE, GEORGIAN LETTER HAE (GEORGIAN SMALL LETTER HAE)
test(0x1CB1, 0x10F1); // GEORGIAN MTAVRULI CAPITAL LETTER HE, GEORGIAN LETTER HE (GEORGIAN SMALL LETTER HE)
test(0x1CB2, 0x10F2); // GEORGIAN MTAVRULI CAPITAL LETTER HIE, GEORGIAN LETTER HIE (GEORGIAN SMALL LETTER HIE)
test(0x1CB3, 0x10F3); // GEORGIAN MTAVRULI CAPITAL LETTER WE, GEORGIAN LETTER WE (GEORGIAN SMALL LETTER WE)
test(0x1CB4, 0x10F4); // GEORGIAN MTAVRULI CAPITAL LETTER HAR, GEORGIAN LETTER HAR (GEORGIAN SMALL LETTER HAR)
test(0x1CB5, 0x10F5); // GEORGIAN MTAVRULI CAPITAL LETTER HOE, GEORGIAN LETTER HOE (GEORGIAN SMALL LETTER HOE)
test(0x1CB6, 0x10F6); // GEORGIAN MTAVRULI CAPITAL LETTER FI, GEORGIAN LETTER FI (GEORGIAN SMALL LETTER FI)
test(0x1CB7, 0x10F7); // GEORGIAN MTAVRULI CAPITAL LETTER YN, GEORGIAN LETTER YN
test(0x1CB8, 0x10F8); // GEORGIAN MTAVRULI CAPITAL LETTER ELIFI, GEORGIAN LETTER ELIFI
test(0x1CB9, 0x10F9); // GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN, GEORGIAN LETTER TURNED GAN
test(0x1CBA, 0x10FA); // GEORGIAN MTAVRULI CAPITAL LETTER AIN, GEORGIAN LETTER AIN
test(0x1CBD, 0x10FD); // GEORGIAN MTAVRULI CAPITAL LETTER AEN, GEORGIAN LETTER AEN
test(0x1CBE, 0x10FE); // GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN, GEORGIAN LETTER HARD SIGN
test(0x1CBF, 0x10FF); // GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN, GEORGIAN LETTER LABIAL SIGN
test(0x1D79, 0xA77D); // LATIN SMALL LETTER INSULAR G, LATIN CAPITAL LETTER INSULAR G
test(0x1D7D, 0x2C63); // LATIN SMALL LETTER P WITH STROKE, LATIN CAPITAL LETTER P WITH STROKE
test(0x1D8E, 0xA7C6); // LATIN SMALL LETTER Z WITH PALATAL HOOK, LATIN CAPITAL LETTER Z WITH PALATAL HOOK
test(0x1E00, 0x1E01); // LATIN CAPITAL LETTER A WITH RING BELOW, LATIN SMALL LETTER A WITH RING BELOW
test(0x1E01, 0x1E00); // LATIN SMALL LETTER A WITH RING BELOW, LATIN CAPITAL LETTER A WITH RING BELOW
test(0x1E02, 0x1E03); // LATIN CAPITAL LETTER B WITH DOT ABOVE, LATIN SMALL LETTER B WITH DOT ABOVE
test(0x1E03, 0x1E02); // LATIN SMALL LETTER B WITH DOT ABOVE, LATIN CAPITAL LETTER B WITH DOT ABOVE
test(0x1E04, 0x1E05); // LATIN CAPITAL LETTER B WITH DOT BELOW, LATIN SMALL LETTER B WITH DOT BELOW
test(0x1E05, 0x1E04); // LATIN SMALL LETTER B WITH DOT BELOW, LATIN CAPITAL LETTER B WITH DOT BELOW
test(0x1E06, 0x1E07); // LATIN CAPITAL LETTER B WITH LINE BELOW, LATIN SMALL LETTER B WITH LINE BELOW
test(0x1E07, 0x1E06); // LATIN SMALL LETTER B WITH LINE BELOW, LATIN CAPITAL LETTER B WITH LINE BELOW
test(0x1E08, 0x1E09); // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE, LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
test(0x1E09, 0x1E08); // LATIN SMALL LETTER C WITH CEDILLA AND ACUTE, LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
test(0x1E0A, 0x1E0B); // LATIN CAPITAL LETTER D WITH DOT ABOVE, LATIN SMALL LETTER D WITH DOT ABOVE
test(0x1E0B, 0x1E0A); // LATIN SMALL LETTER D WITH DOT ABOVE, LATIN CAPITAL LETTER D WITH DOT ABOVE
test(0x1E0C, 0x1E0D); // LATIN CAPITAL LETTER D WITH DOT BELOW, LATIN SMALL LETTER D WITH DOT BELOW
test(0x1E0D, 0x1E0C); // LATIN SMALL LETTER D WITH DOT BELOW, LATIN CAPITAL LETTER D WITH DOT BELOW
test(0x1E0E, 0x1E0F); // LATIN CAPITAL LETTER D WITH LINE BELOW, LATIN SMALL LETTER D WITH LINE BELOW
test(0x1E0F, 0x1E0E); // LATIN SMALL LETTER D WITH LINE BELOW, LATIN CAPITAL LETTER D WITH LINE BELOW
test(0x1E10, 0x1E11); // LATIN CAPITAL LETTER D WITH CEDILLA, LATIN SMALL LETTER D WITH CEDILLA
test(0x1E11, 0x1E10); // LATIN SMALL LETTER D WITH CEDILLA, LATIN CAPITAL LETTER D WITH CEDILLA
test(0x1E12, 0x1E13); // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW, LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
test(0x1E13, 0x1E12); // LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW, LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
test(0x1E14, 0x1E15); // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE, LATIN SMALL LETTER E WITH MACRON AND GRAVE
test(0x1E15, 0x1E14); // LATIN SMALL LETTER E WITH MACRON AND GRAVE, LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
test(0x1E16, 0x1E17); // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE, LATIN SMALL LETTER E WITH MACRON AND ACUTE
test(0x1E17, 0x1E16); // LATIN SMALL LETTER E WITH MACRON AND ACUTE, LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
test(0x1E18, 0x1E19); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW, LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
test(0x1E19, 0x1E18); // LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW, LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
test(0x1E1A, 0x1E1B); // LATIN CAPITAL LETTER E WITH TILDE BELOW, LATIN SMALL LETTER E WITH TILDE BELOW
test(0x1E1B, 0x1E1A); // LATIN SMALL LETTER E WITH TILDE BELOW, LATIN CAPITAL LETTER E WITH TILDE BELOW
test(0x1E1C, 0x1E1D); // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE, LATIN SMALL LETTER E WITH CEDILLA AND BREVE
test(0x1E1D, 0x1E1C); // LATIN SMALL LETTER E WITH CEDILLA AND BREVE, LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
test(0x1E1E, 0x1E1F); // LATIN CAPITAL LETTER F WITH DOT ABOVE, LATIN SMALL LETTER F WITH DOT ABOVE
test(0x1E1F, 0x1E1E); // LATIN SMALL LETTER F WITH DOT ABOVE, LATIN CAPITAL LETTER F WITH DOT ABOVE
test(0x1E20, 0x1E21); // LATIN CAPITAL LETTER G WITH MACRON, LATIN SMALL LETTER G WITH MACRON
test(0x1E21, 0x1E20); // LATIN SMALL LETTER G WITH MACRON, LATIN CAPITAL LETTER G WITH MACRON
test(0x1E22, 0x1E23); // LATIN CAPITAL LETTER H WITH DOT ABOVE, LATIN SMALL LETTER H WITH DOT ABOVE
test(0x1E23, 0x1E22); // LATIN SMALL LETTER H WITH DOT ABOVE, LATIN CAPITAL LETTER H WITH DOT ABOVE
test(0x1E24, 0x1E25); // LATIN CAPITAL LETTER H WITH DOT BELOW, LATIN SMALL LETTER H WITH DOT BELOW
test(0x1E25, 0x1E24); // LATIN SMALL LETTER H WITH DOT BELOW, LATIN CAPITAL LETTER H WITH DOT BELOW
test(0x1E26, 0x1E27); // LATIN CAPITAL LETTER H WITH DIAERESIS, LATIN SMALL LETTER H WITH DIAERESIS
test(0x1E27, 0x1E26); // LATIN SMALL LETTER H WITH DIAERESIS, LATIN CAPITAL LETTER H WITH DIAERESIS
test(0x1E28, 0x1E29); // LATIN CAPITAL LETTER H WITH CEDILLA, LATIN SMALL LETTER H WITH CEDILLA
test(0x1E29, 0x1E28); // LATIN SMALL LETTER H WITH CEDILLA, LATIN CAPITAL LETTER H WITH CEDILLA
test(0x1E2A, 0x1E2B); // LATIN CAPITAL LETTER H WITH BREVE BELOW, LATIN SMALL LETTER H WITH BREVE BELOW
test(0x1E2B, 0x1E2A); // LATIN SMALL LETTER H WITH BREVE BELOW, LATIN CAPITAL LETTER H WITH BREVE BELOW
test(0x1E2C, 0x1E2D); // LATIN CAPITAL LETTER I WITH TILDE BELOW, LATIN SMALL LETTER I WITH TILDE BELOW
test(0x1E2D, 0x1E2C); // LATIN SMALL LETTER I WITH TILDE BELOW, LATIN CAPITAL LETTER I WITH TILDE BELOW
test(0x1E2E, 0x1E2F); // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE, LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
test(0x1E2F, 0x1E2E); // LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE, LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
test(0x1E30, 0x1E31); // LATIN CAPITAL LETTER K WITH ACUTE, LATIN SMALL LETTER K WITH ACUTE
test(0x1E31, 0x1E30); // LATIN SMALL LETTER K WITH ACUTE, LATIN CAPITAL LETTER K WITH ACUTE
test(0x1E32, 0x1E33); // LATIN CAPITAL LETTER K WITH DOT BELOW, LATIN SMALL LETTER K WITH DOT BELOW
test(0x1E33, 0x1E32); // LATIN SMALL LETTER K WITH DOT BELOW, LATIN CAPITAL LETTER K WITH DOT BELOW
test(0x1E34, 0x1E35); // LATIN CAPITAL LETTER K WITH LINE BELOW, LATIN SMALL LETTER K WITH LINE BELOW
test(0x1E35, 0x1E34); // LATIN SMALL LETTER K WITH LINE BELOW, LATIN CAPITAL LETTER K WITH LINE BELOW
test(0x1E36, 0x1E37); // LATIN CAPITAL LETTER L WITH DOT BELOW, LATIN SMALL LETTER L WITH DOT BELOW
test(0x1E37, 0x1E36); // LATIN SMALL LETTER L WITH DOT BELOW, LATIN CAPITAL LETTER L WITH DOT BELOW
test(0x1E38, 0x1E39); // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON, LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
test(0x1E39, 0x1E38); // LATIN SMALL LETTER L WITH DOT BELOW AND MACRON, LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
test(0x1E3A, 0x1E3B); // LATIN CAPITAL LETTER L WITH LINE BELOW, LATIN SMALL LETTER L WITH LINE BELOW
test(0x1E3B, 0x1E3A); // LATIN SMALL LETTER L WITH LINE BELOW, LATIN CAPITAL LETTER L WITH LINE BELOW
test(0x1E3C, 0x1E3D); // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW, LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
test(0x1E3D, 0x1E3C); // LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW, LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
test(0x1E3E, 0x1E3F); // LATIN CAPITAL LETTER M WITH ACUTE, LATIN SMALL LETTER M WITH ACUTE
test(0x1E3F, 0x1E3E); // LATIN SMALL LETTER M WITH ACUTE, LATIN CAPITAL LETTER M WITH ACUTE
test(0x1E40, 0x1E41); // LATIN CAPITAL LETTER M WITH DOT ABOVE, LATIN SMALL LETTER M WITH DOT ABOVE
test(0x1E41, 0x1E40); // LATIN SMALL LETTER M WITH DOT ABOVE, LATIN CAPITAL LETTER M WITH DOT ABOVE
test(0x1E42, 0x1E43); // LATIN CAPITAL LETTER M WITH DOT BELOW, LATIN SMALL LETTER M WITH DOT BELOW
test(0x1E43, 0x1E42); // LATIN SMALL LETTER M WITH DOT BELOW, LATIN CAPITAL LETTER M WITH DOT BELOW
test(0x1E44, 0x1E45); // LATIN CAPITAL LETTER N WITH DOT ABOVE, LATIN SMALL LETTER N WITH DOT ABOVE
test(0x1E45, 0x1E44); // LATIN SMALL LETTER N WITH DOT ABOVE, LATIN CAPITAL LETTER N WITH DOT ABOVE
test(0x1E46, 0x1E47); // LATIN CAPITAL LETTER N WITH DOT BELOW, LATIN SMALL LETTER N WITH DOT BELOW
test(0x1E47, 0x1E46); // LATIN SMALL LETTER N WITH DOT BELOW, LATIN CAPITAL LETTER N WITH DOT BELOW
test(0x1E48, 0x1E49); // LATIN CAPITAL LETTER N WITH LINE BELOW, LATIN SMALL LETTER N WITH LINE BELOW
test(0x1E49, 0x1E48); // LATIN SMALL LETTER N WITH LINE BELOW, LATIN CAPITAL LETTER N WITH LINE BELOW
test(0x1E4A, 0x1E4B); // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW, LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
test(0x1E4B, 0x1E4A); // LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW, LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
test(0x1E4C, 0x1E4D); // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE, LATIN SMALL LETTER O WITH TILDE AND ACUTE
test(0x1E4D, 0x1E4C); // LATIN SMALL LETTER O WITH TILDE AND ACUTE, LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
test(0x1E4E, 0x1E4F); // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS, LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
test(0x1E4F, 0x1E4E); // LATIN SMALL LETTER O WITH TILDE AND DIAERESIS, LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
test(0x1E50, 0x1E51); // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE, LATIN SMALL LETTER O WITH MACRON AND GRAVE
test(0x1E51, 0x1E50); // LATIN SMALL LETTER O WITH MACRON AND GRAVE, LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
test(0x1E52, 0x1E53); // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE, LATIN SMALL LETTER O WITH MACRON AND ACUTE
test(0x1E53, 0x1E52); // LATIN SMALL LETTER O WITH MACRON AND ACUTE, LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
test(0x1E54, 0x1E55); // LATIN CAPITAL LETTER P WITH ACUTE, LATIN SMALL LETTER P WITH ACUTE
test(0x1E55, 0x1E54); // LATIN SMALL LETTER P WITH ACUTE, LATIN CAPITAL LETTER P WITH ACUTE
test(0x1E56, 0x1E57); // LATIN CAPITAL LETTER P WITH DOT ABOVE, LATIN SMALL LETTER P WITH DOT ABOVE
test(0x1E57, 0x1E56); // LATIN SMALL LETTER P WITH DOT ABOVE, LATIN CAPITAL LETTER P WITH DOT ABOVE
test(0x1E58, 0x1E59); // LATIN CAPITAL LETTER R WITH DOT ABOVE, LATIN SMALL LETTER R WITH DOT ABOVE
test(0x1E59, 0x1E58); // LATIN SMALL LETTER R WITH DOT ABOVE, LATIN CAPITAL LETTER R WITH DOT ABOVE
test(0x1E5A, 0x1E5B); // LATIN CAPITAL LETTER R WITH DOT BELOW, LATIN SMALL LETTER R WITH DOT BELOW
test(0x1E5B, 0x1E5A); // LATIN SMALL LETTER R WITH DOT BELOW, LATIN CAPITAL LETTER R WITH DOT BELOW
test(0x1E5C, 0x1E5D); // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON, LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
test(0x1E5D, 0x1E5C); // LATIN SMALL LETTER R WITH DOT BELOW AND MACRON, LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
test(0x1E5E, 0x1E5F); // LATIN CAPITAL LETTER R WITH LINE BELOW, LATIN SMALL LETTER R WITH LINE BELOW
test(0x1E5F, 0x1E5E); // LATIN SMALL LETTER R WITH LINE BELOW, LATIN CAPITAL LETTER R WITH LINE BELOW
test(0x1E60, 0x1E61, 0x1E9B); // LATIN CAPITAL LETTER S WITH DOT ABOVE, LATIN SMALL LETTER S WITH DOT ABOVE, LATIN SMALL LETTER LONG S WITH DOT ABOVE
test(0x1E61, 0x1E60, 0x1E9B); // LATIN SMALL LETTER S WITH DOT ABOVE, LATIN CAPITAL LETTER S WITH DOT ABOVE, LATIN SMALL LETTER LONG S WITH DOT ABOVE
test(0x1E62, 0x1E63); // LATIN CAPITAL LETTER S WITH DOT BELOW, LATIN SMALL LETTER S WITH DOT BELOW
test(0x1E63, 0x1E62); // LATIN SMALL LETTER S WITH DOT BELOW, LATIN CAPITAL LETTER S WITH DOT BELOW
test(0x1E64, 0x1E65); // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE, LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
test(0x1E65, 0x1E64); // LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE, LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
test(0x1E66, 0x1E67); // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE, LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
test(0x1E67, 0x1E66); // LATIN SMALL LETTER S WITH CARON AND DOT ABOVE, LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
test(0x1E68, 0x1E69); // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE, LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
test(0x1E69, 0x1E68); // LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE, LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
test(0x1E6A, 0x1E6B); // LATIN CAPITAL LETTER T WITH DOT ABOVE, LATIN SMALL LETTER T WITH DOT ABOVE
test(0x1E6B, 0x1E6A); // LATIN SMALL LETTER T WITH DOT ABOVE, LATIN CAPITAL LETTER T WITH DOT ABOVE
test(0x1E6C, 0x1E6D); // LATIN CAPITAL LETTER T WITH DOT BELOW, LATIN SMALL LETTER T WITH DOT BELOW
test(0x1E6D, 0x1E6C); // LATIN SMALL LETTER T WITH DOT BELOW, LATIN CAPITAL LETTER T WITH DOT BELOW
test(0x1E6E, 0x1E6F); // LATIN CAPITAL LETTER T WITH LINE BELOW, LATIN SMALL LETTER T WITH LINE BELOW
test(0x1E6F, 0x1E6E); // LATIN SMALL LETTER T WITH LINE BELOW, LATIN CAPITAL LETTER T WITH LINE BELOW
test(0x1E70, 0x1E71); // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW, LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
test(0x1E71, 0x1E70); // LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW, LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
test(0x1E72, 0x1E73); // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW, LATIN SMALL LETTER U WITH DIAERESIS BELOW
test(0x1E73, 0x1E72); // LATIN SMALL LETTER U WITH DIAERESIS BELOW, LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
test(0x1E74, 0x1E75); // LATIN CAPITAL LETTER U WITH TILDE BELOW, LATIN SMALL LETTER U WITH TILDE BELOW
test(0x1E75, 0x1E74); // LATIN SMALL LETTER U WITH TILDE BELOW, LATIN CAPITAL LETTER U WITH TILDE BELOW
test(0x1E76, 0x1E77); // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW, LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
test(0x1E77, 0x1E76); // LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW, LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
test(0x1E78, 0x1E79); // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE, LATIN SMALL LETTER U WITH TILDE AND ACUTE
test(0x1E79, 0x1E78); // LATIN SMALL LETTER U WITH TILDE AND ACUTE, LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
test(0x1E7A, 0x1E7B); // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS, LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
test(0x1E7B, 0x1E7A); // LATIN SMALL LETTER U WITH MACRON AND DIAERESIS, LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
test(0x1E7C, 0x1E7D); // LATIN CAPITAL LETTER V WITH TILDE, LATIN SMALL LETTER V WITH TILDE
test(0x1E7D, 0x1E7C); // LATIN SMALL LETTER V WITH TILDE, LATIN CAPITAL LETTER V WITH TILDE
test(0x1E7E, 0x1E7F); // LATIN CAPITAL LETTER V WITH DOT BELOW, LATIN SMALL LETTER V WITH DOT BELOW
test(0x1E7F, 0x1E7E); // LATIN SMALL LETTER V WITH DOT BELOW, LATIN CAPITAL LETTER V WITH DOT BELOW
test(0x1E80, 0x1E81); // LATIN CAPITAL LETTER W WITH GRAVE, LATIN SMALL LETTER W WITH GRAVE
test(0x1E81, 0x1E80); // LATIN SMALL LETTER W WITH GRAVE, LATIN CAPITAL LETTER W WITH GRAVE
test(0x1E82, 0x1E83); // LATIN CAPITAL LETTER W WITH ACUTE, LATIN SMALL LETTER W WITH ACUTE
test(0x1E83, 0x1E82); // LATIN SMALL LETTER W WITH ACUTE, LATIN CAPITAL LETTER W WITH ACUTE
test(0x1E84, 0x1E85); // LATIN CAPITAL LETTER W WITH DIAERESIS, LATIN SMALL LETTER W WITH DIAERESIS
test(0x1E85, 0x1E84); // LATIN SMALL LETTER W WITH DIAERESIS, LATIN CAPITAL LETTER W WITH DIAERESIS
test(0x1E86, 0x1E87); // LATIN CAPITAL LETTER W WITH DOT ABOVE, LATIN SMALL LETTER W WITH DOT ABOVE
test(0x1E87, 0x1E86); // LATIN SMALL LETTER W WITH DOT ABOVE, LATIN CAPITAL LETTER W WITH DOT ABOVE
test(0x1E88, 0x1E89); // LATIN CAPITAL LETTER W WITH DOT BELOW, LATIN SMALL LETTER W WITH DOT BELOW
test(0x1E89, 0x1E88); // LATIN SMALL LETTER W WITH DOT BELOW, LATIN CAPITAL LETTER W WITH DOT BELOW
test(0x1E8A, 0x1E8B); // LATIN CAPITAL LETTER X WITH DOT ABOVE, LATIN SMALL LETTER X WITH DOT ABOVE
test(0x1E8B, 0x1E8A); // LATIN SMALL LETTER X WITH DOT ABOVE, LATIN CAPITAL LETTER X WITH DOT ABOVE
test(0x1E8C, 0x1E8D); // LATIN CAPITAL LETTER X WITH DIAERESIS, LATIN SMALL LETTER X WITH DIAERESIS
test(0x1E8D, 0x1E8C); // LATIN SMALL LETTER X WITH DIAERESIS, LATIN CAPITAL LETTER X WITH DIAERESIS
test(0x1E8E, 0x1E8F); // LATIN CAPITAL LETTER Y WITH DOT ABOVE, LATIN SMALL LETTER Y WITH DOT ABOVE
test(0x1E8F, 0x1E8E); // LATIN SMALL LETTER Y WITH DOT ABOVE, LATIN CAPITAL LETTER Y WITH DOT ABOVE
test(0x1E90, 0x1E91); // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX, LATIN SMALL LETTER Z WITH CIRCUMFLEX
test(0x1E91, 0x1E90); // LATIN SMALL LETTER Z WITH CIRCUMFLEX, LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
test(0x1E92, 0x1E93); // LATIN CAPITAL LETTER Z WITH DOT BELOW, LATIN SMALL LETTER Z WITH DOT BELOW
test(0x1E93, 0x1E92); // LATIN SMALL LETTER Z WITH DOT BELOW, LATIN CAPITAL LETTER Z WITH DOT BELOW
test(0x1E94, 0x1E95); // LATIN CAPITAL LETTER Z WITH LINE BELOW, LATIN SMALL LETTER Z WITH LINE BELOW
test(0x1E95, 0x1E94); // LATIN SMALL LETTER Z WITH LINE BELOW, LATIN CAPITAL LETTER Z WITH LINE BELOW
test(0x1E9B, 0x1E61, 0x1E60); // LATIN SMALL LETTER LONG S WITH DOT ABOVE, LATIN SMALL LETTER S WITH DOT ABOVE, LATIN CAPITAL LETTER S WITH DOT ABOVE
test(0x1E9E, 0x00DF); // LATIN CAPITAL LETTER SHARP S, LATIN SMALL LETTER SHARP S
test(0x1EA0, 0x1EA1); // LATIN CAPITAL LETTER A WITH DOT BELOW, LATIN SMALL LETTER A WITH DOT BELOW
test(0x1EA1, 0x1EA0); // LATIN SMALL LETTER A WITH DOT BELOW, LATIN CAPITAL LETTER A WITH DOT BELOW
test(0x1EA2, 0x1EA3); // LATIN CAPITAL LETTER A WITH HOOK ABOVE, LATIN SMALL LETTER A WITH HOOK ABOVE
test(0x1EA3, 0x1EA2); // LATIN SMALL LETTER A WITH HOOK ABOVE, LATIN CAPITAL LETTER A WITH HOOK ABOVE
test(0x1EA4, 0x1EA5); // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE, LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
test(0x1EA5, 0x1EA4); // LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE, LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
test(0x1EA6, 0x1EA7); // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE, LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
test(0x1EA7, 0x1EA6); // LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE, LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
test(0x1EA8, 0x1EA9); // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE, LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
test(0x1EA9, 0x1EA8); // LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE, LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
test(0x1EAA, 0x1EAB); // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE, LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
test(0x1EAB, 0x1EAA); // LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE, LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
test(0x1EAC, 0x1EAD); // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW, LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
test(0x1EAD, 0x1EAC); // LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW, LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
test(0x1EAE, 0x1EAF); // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE, LATIN SMALL LETTER A WITH BREVE AND ACUTE
test(0x1EAF, 0x1EAE); // LATIN SMALL LETTER A WITH BREVE AND ACUTE, LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
test(0x1EB0, 0x1EB1); // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE, LATIN SMALL LETTER A WITH BREVE AND GRAVE
test(0x1EB1, 0x1EB0); // LATIN SMALL LETTER A WITH BREVE AND GRAVE, LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
test(0x1EB2, 0x1EB3); // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE, LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
test(0x1EB3, 0x1EB2); // LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE, LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
test(0x1EB4, 0x1EB5); // LATIN CAPITAL LETTER A WITH BREVE AND TILDE, LATIN SMALL LETTER A WITH BREVE AND TILDE
test(0x1EB5, 0x1EB4); // LATIN SMALL LETTER A WITH BREVE AND TILDE, LATIN CAPITAL LETTER A WITH BREVE AND TILDE
test(0x1EB6, 0x1EB7); // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW, LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
test(0x1EB7, 0x1EB6); // LATIN SMALL LETTER A WITH BREVE AND DOT BELOW, LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
test(0x1EB8, 0x1EB9); // LATIN CAPITAL LETTER E WITH DOT BELOW, LATIN SMALL LETTER E WITH DOT BELOW
test(0x1EB9, 0x1EB8); // LATIN SMALL LETTER E WITH DOT BELOW, LATIN CAPITAL LETTER E WITH DOT BELOW
test(0x1EBA, 0x1EBB); // LATIN CAPITAL LETTER E WITH HOOK ABOVE, LATIN SMALL LETTER E WITH HOOK ABOVE
test(0x1EBB, 0x1EBA); // LATIN SMALL LETTER E WITH HOOK ABOVE, LATIN CAPITAL LETTER E WITH HOOK ABOVE
test(0x1EBC, 0x1EBD); // LATIN CAPITAL LETTER E WITH TILDE, LATIN SMALL LETTER E WITH TILDE
test(0x1EBD, 0x1EBC); // LATIN SMALL LETTER E WITH TILDE, LATIN CAPITAL LETTER E WITH TILDE
test(0x1EBE, 0x1EBF); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE, LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
test(0x1EBF, 0x1EBE); // LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE, LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
test(0x1EC0, 0x1EC1); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE, LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
test(0x1EC1, 0x1EC0); // LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE, LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
test(0x1EC2, 0x1EC3); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE, LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
test(0x1EC3, 0x1EC2); // LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE, LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
test(0x1EC4, 0x1EC5); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE, LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
test(0x1EC5, 0x1EC4); // LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE, LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
test(0x1EC6, 0x1EC7); // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW, LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
test(0x1EC7, 0x1EC6); // LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW, LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
test(0x1EC8, 0x1EC9); // LATIN CAPITAL LETTER I WITH HOOK ABOVE, LATIN SMALL LETTER I WITH HOOK ABOVE
test(0x1EC9, 0x1EC8); // LATIN SMALL LETTER I WITH HOOK ABOVE, LATIN CAPITAL LETTER I WITH HOOK ABOVE
test(0x1ECA, 0x1ECB); // LATIN CAPITAL LETTER I WITH DOT BELOW, LATIN SMALL LETTER I WITH DOT BELOW
test(0x1ECB, 0x1ECA); // LATIN SMALL LETTER I WITH DOT BELOW, LATIN CAPITAL LETTER I WITH DOT BELOW
test(0x1ECC, 0x1ECD); // LATIN CAPITAL LETTER O WITH DOT BELOW, LATIN SMALL LETTER O WITH DOT BELOW
test(0x1ECD, 0x1ECC); // LATIN SMALL LETTER O WITH DOT BELOW, LATIN CAPITAL LETTER O WITH DOT BELOW
test(0x1ECE, 0x1ECF); // LATIN CAPITAL LETTER O WITH HOOK ABOVE, LATIN SMALL LETTER O WITH HOOK ABOVE
test(0x1ECF, 0x1ECE); // LATIN SMALL LETTER O WITH HOOK ABOVE, LATIN CAPITAL LETTER O WITH HOOK ABOVE
test(0x1ED0, 0x1ED1); // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE, LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
test(0x1ED1, 0x1ED0); // LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE, LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
test(0x1ED2, 0x1ED3); // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE, LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
test(0x1ED3, 0x1ED2); // LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE, LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
test(0x1ED4, 0x1ED5); // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE, LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
test(0x1ED5, 0x1ED4); // LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE, LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
test(0x1ED6, 0x1ED7); // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE, LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
test(0x1ED7, 0x1ED6); // LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE, LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
test(0x1ED8, 0x1ED9); // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW, LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
test(0x1ED9, 0x1ED8); // LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW, LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
test(0x1EDA, 0x1EDB); // LATIN CAPITAL LETTER O WITH HORN AND ACUTE, LATIN SMALL LETTER O WITH HORN AND ACUTE
test(0x1EDB, 0x1EDA); // LATIN SMALL LETTER O WITH HORN AND ACUTE, LATIN CAPITAL LETTER O WITH HORN AND ACUTE
test(0x1EDC, 0x1EDD); // LATIN CAPITAL LETTER O WITH HORN AND GRAVE, LATIN SMALL LETTER O WITH HORN AND GRAVE
test(0x1EDD, 0x1EDC); // LATIN SMALL LETTER O WITH HORN AND GRAVE, LATIN CAPITAL LETTER O WITH HORN AND GRAVE
test(0x1EDE, 0x1EDF); // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE, LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
test(0x1EDF, 0x1EDE); // LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE, LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
test(0x1EE0, 0x1EE1); // LATIN CAPITAL LETTER O WITH HORN AND TILDE, LATIN SMALL LETTER O WITH HORN AND TILDE
test(0x1EE1, 0x1EE0); // LATIN SMALL LETTER O WITH HORN AND TILDE, LATIN CAPITAL LETTER O WITH HORN AND TILDE
test(0x1EE2, 0x1EE3); // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW, LATIN SMALL LETTER O WITH HORN AND DOT BELOW
test(0x1EE3, 0x1EE2); // LATIN SMALL LETTER O WITH HORN AND DOT BELOW, LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
test(0x1EE4, 0x1EE5); // LATIN CAPITAL LETTER U WITH DOT BELOW, LATIN SMALL LETTER U WITH DOT BELOW
test(0x1EE5, 0x1EE4); // LATIN SMALL LETTER U WITH DOT BELOW, LATIN CAPITAL LETTER U WITH DOT BELOW
test(0x1EE6, 0x1EE7); // LATIN CAPITAL LETTER U WITH HOOK ABOVE, LATIN SMALL LETTER U WITH HOOK ABOVE
test(0x1EE7, 0x1EE6); // LATIN SMALL LETTER U WITH HOOK ABOVE, LATIN CAPITAL LETTER U WITH HOOK ABOVE
test(0x1EE8, 0x1EE9); // LATIN CAPITAL LETTER U WITH HORN AND ACUTE, LATIN SMALL LETTER U WITH HORN AND ACUTE
test(0x1EE9, 0x1EE8); // LATIN SMALL LETTER U WITH HORN AND ACUTE, LATIN CAPITAL LETTER U WITH HORN AND ACUTE
test(0x1EEA, 0x1EEB); // LATIN CAPITAL LETTER U WITH HORN AND GRAVE, LATIN SMALL LETTER U WITH HORN AND GRAVE
test(0x1EEB, 0x1EEA); // LATIN SMALL LETTER U WITH HORN AND GRAVE, LATIN CAPITAL LETTER U WITH HORN AND GRAVE
test(0x1EEC, 0x1EED); // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE, LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
test(0x1EED, 0x1EEC); // LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE, LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
test(0x1EEE, 0x1EEF); // LATIN CAPITAL LETTER U WITH HORN AND TILDE, LATIN SMALL LETTER U WITH HORN AND TILDE
test(0x1EEF, 0x1EEE); // LATIN SMALL LETTER U WITH HORN AND TILDE, LATIN CAPITAL LETTER U WITH HORN AND TILDE
test(0x1EF0, 0x1EF1); // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW, LATIN SMALL LETTER U WITH HORN AND DOT BELOW
test(0x1EF1, 0x1EF0); // LATIN SMALL LETTER U WITH HORN AND DOT BELOW, LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
test(0x1EF2, 0x1EF3); // LATIN CAPITAL LETTER Y WITH GRAVE, LATIN SMALL LETTER Y WITH GRAVE
test(0x1EF3, 0x1EF2); // LATIN SMALL LETTER Y WITH GRAVE, LATIN CAPITAL LETTER Y WITH GRAVE
test(0x1EF4, 0x1EF5); // LATIN CAPITAL LETTER Y WITH DOT BELOW, LATIN SMALL LETTER Y WITH DOT BELOW
test(0x1EF5, 0x1EF4); // LATIN SMALL LETTER Y WITH DOT BELOW, LATIN CAPITAL LETTER Y WITH DOT BELOW
test(0x1EF6, 0x1EF7); // LATIN CAPITAL LETTER Y WITH HOOK ABOVE, LATIN SMALL LETTER Y WITH HOOK ABOVE
test(0x1EF7, 0x1EF6); // LATIN SMALL LETTER Y WITH HOOK ABOVE, LATIN CAPITAL LETTER Y WITH HOOK ABOVE
test(0x1EF8, 0x1EF9); // LATIN CAPITAL LETTER Y WITH TILDE, LATIN SMALL LETTER Y WITH TILDE
test(0x1EF9, 0x1EF8); // LATIN SMALL LETTER Y WITH TILDE, LATIN CAPITAL LETTER Y WITH TILDE
test(0x1EFA, 0x1EFB); // LATIN CAPITAL LETTER MIDDLE-WELSH LL, LATIN SMALL LETTER MIDDLE-WELSH LL
test(0x1EFB, 0x1EFA); // LATIN SMALL LETTER MIDDLE-WELSH LL, LATIN CAPITAL LETTER MIDDLE-WELSH LL
test(0x1EFC, 0x1EFD); // LATIN CAPITAL LETTER MIDDLE-WELSH V, LATIN SMALL LETTER MIDDLE-WELSH V
test(0x1EFD, 0x1EFC); // LATIN SMALL LETTER MIDDLE-WELSH V, LATIN CAPITAL LETTER MIDDLE-WELSH V
test(0x1EFE, 0x1EFF); // LATIN CAPITAL LETTER Y WITH LOOP, LATIN SMALL LETTER Y WITH LOOP
test(0x1EFF, 0x1EFE); // LATIN SMALL LETTER Y WITH LOOP, LATIN CAPITAL LETTER Y WITH LOOP
test(0x1F00, 0x1F08); // GREEK SMALL LETTER ALPHA WITH PSILI, GREEK CAPITAL LETTER ALPHA WITH PSILI
test(0x1F01, 0x1F09); // GREEK SMALL LETTER ALPHA WITH DASIA, GREEK CAPITAL LETTER ALPHA WITH DASIA
test(0x1F02, 0x1F0A); // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA, GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
test(0x1F03, 0x1F0B); // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA, GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
test(0x1F04, 0x1F0C); // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA, GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
test(0x1F05, 0x1F0D); // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA, GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
test(0x1F06, 0x1F0E); // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI, GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
test(0x1F07, 0x1F0F); // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI, GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
test(0x1F08, 0x1F00); // GREEK CAPITAL LETTER ALPHA WITH PSILI, GREEK SMALL LETTER ALPHA WITH PSILI
test(0x1F09, 0x1F01); // GREEK CAPITAL LETTER ALPHA WITH DASIA, GREEK SMALL LETTER ALPHA WITH DASIA
test(0x1F0A, 0x1F02); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA, GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
test(0x1F0B, 0x1F03); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA, GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
test(0x1F0C, 0x1F04); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA, GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
test(0x1F0D, 0x1F05); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA, GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
test(0x1F0E, 0x1F06); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI, GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
test(0x1F0F, 0x1F07); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI, GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
test(0x1F10, 0x1F18); // GREEK SMALL LETTER EPSILON WITH PSILI, GREEK CAPITAL LETTER EPSILON WITH PSILI
test(0x1F11, 0x1F19); // GREEK SMALL LETTER EPSILON WITH DASIA, GREEK CAPITAL LETTER EPSILON WITH DASIA
test(0x1F12, 0x1F1A); // GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA, GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
test(0x1F13, 0x1F1B); // GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA, GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
test(0x1F14, 0x1F1C); // GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA, GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
test(0x1F15, 0x1F1D); // GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA, GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
test(0x1F18, 0x1F10); // GREEK CAPITAL LETTER EPSILON WITH PSILI, GREEK SMALL LETTER EPSILON WITH PSILI
test(0x1F19, 0x1F11); // GREEK CAPITAL LETTER EPSILON WITH DASIA, GREEK SMALL LETTER EPSILON WITH DASIA
test(0x1F1A, 0x1F12); // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA, GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
test(0x1F1B, 0x1F13); // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA, GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
test(0x1F1C, 0x1F14); // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA, GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
test(0x1F1D, 0x1F15); // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA, GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
test(0x1F20, 0x1F28); // GREEK SMALL LETTER ETA WITH PSILI, GREEK CAPITAL LETTER ETA WITH PSILI
test(0x1F21, 0x1F29); // GREEK SMALL LETTER ETA WITH DASIA, GREEK CAPITAL LETTER ETA WITH DASIA
test(0x1F22, 0x1F2A); // GREEK SMALL LETTER ETA WITH PSILI AND VARIA, GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
test(0x1F23, 0x1F2B); // GREEK SMALL LETTER ETA WITH DASIA AND VARIA, GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
test(0x1F24, 0x1F2C); // GREEK SMALL LETTER ETA WITH PSILI AND OXIA, GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
test(0x1F25, 0x1F2D); // GREEK SMALL LETTER ETA WITH DASIA AND OXIA, GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
test(0x1F26, 0x1F2E); // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI, GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
test(0x1F27, 0x1F2F); // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI, GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
test(0x1F28, 0x1F20); // GREEK CAPITAL LETTER ETA WITH PSILI, GREEK SMALL LETTER ETA WITH PSILI
test(0x1F29, 0x1F21); // GREEK CAPITAL LETTER ETA WITH DASIA, GREEK SMALL LETTER ETA WITH DASIA
test(0x1F2A, 0x1F22); // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA, GREEK SMALL LETTER ETA WITH PSILI AND VARIA
test(0x1F2B, 0x1F23); // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA, GREEK SMALL LETTER ETA WITH DASIA AND VARIA
test(0x1F2C, 0x1F24); // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA, GREEK SMALL LETTER ETA WITH PSILI AND OXIA
test(0x1F2D, 0x1F25); // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA, GREEK SMALL LETTER ETA WITH DASIA AND OXIA
test(0x1F2E, 0x1F26); // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI, GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
test(0x1F2F, 0x1F27); // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI, GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
test(0x1F30, 0x1F38); // GREEK SMALL LETTER IOTA WITH PSILI, GREEK CAPITAL LETTER IOTA WITH PSILI
test(0x1F31, 0x1F39); // GREEK SMALL LETTER IOTA WITH DASIA, GREEK CAPITAL LETTER IOTA WITH DASIA
test(0x1F32, 0x1F3A); // GREEK SMALL LETTER IOTA WITH PSILI AND VARIA, GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
test(0x1F33, 0x1F3B); // GREEK SMALL LETTER IOTA WITH DASIA AND VARIA, GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
test(0x1F34, 0x1F3C); // GREEK SMALL LETTER IOTA WITH PSILI AND OXIA, GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
test(0x1F35, 0x1F3D); // GREEK SMALL LETTER IOTA WITH DASIA AND OXIA, GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
test(0x1F36, 0x1F3E); // GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI, GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
test(0x1F37, 0x1F3F); // GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI, GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
test(0x1F38, 0x1F30); // GREEK CAPITAL LETTER IOTA WITH PSILI, GREEK SMALL LETTER IOTA WITH PSILI
test(0x1F39, 0x1F31); // GREEK CAPITAL LETTER IOTA WITH DASIA, GREEK SMALL LETTER IOTA WITH DASIA
test(0x1F3A, 0x1F32); // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA, GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
test(0x1F3B, 0x1F33); // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA, GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
test(0x1F3C, 0x1F34); // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA, GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
test(0x1F3D, 0x1F35); // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA, GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
test(0x1F3E, 0x1F36); // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI, GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
test(0x1F3F, 0x1F37); // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI, GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
test(0x1F40, 0x1F48); // GREEK SMALL LETTER OMICRON WITH PSILI, GREEK CAPITAL LETTER OMICRON WITH PSILI
test(0x1F41, 0x1F49); // GREEK SMALL LETTER OMICRON WITH DASIA, GREEK CAPITAL LETTER OMICRON WITH DASIA
test(0x1F42, 0x1F4A); // GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA, GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
test(0x1F43, 0x1F4B); // GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA, GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
test(0x1F44, 0x1F4C); // GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA, GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
test(0x1F45, 0x1F4D); // GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA, GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
test(0x1F48, 0x1F40); // GREEK CAPITAL LETTER OMICRON WITH PSILI, GREEK SMALL LETTER OMICRON WITH PSILI
test(0x1F49, 0x1F41); // GREEK CAPITAL LETTER OMICRON WITH DASIA, GREEK SMALL LETTER OMICRON WITH DASIA
test(0x1F4A, 0x1F42); // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA, GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
test(0x1F4B, 0x1F43); // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA, GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
test(0x1F4C, 0x1F44); // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA, GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
test(0x1F4D, 0x1F45); // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA, GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
test(0x1F51, 0x1F59); // GREEK SMALL LETTER UPSILON WITH DASIA, GREEK CAPITAL LETTER UPSILON WITH DASIA
test(0x1F53, 0x1F5B); // GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA, GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
test(0x1F55, 0x1F5D); // GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA, GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
test(0x1F57, 0x1F5F); // GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI, GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
test(0x1F59, 0x1F51); // GREEK CAPITAL LETTER UPSILON WITH DASIA, GREEK SMALL LETTER UPSILON WITH DASIA
test(0x1F5B, 0x1F53); // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA, GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
test(0x1F5D, 0x1F55); // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA, GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
test(0x1F5F, 0x1F57); // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI, GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
test(0x1F60, 0x1F68); // GREEK SMALL LETTER OMEGA WITH PSILI, GREEK CAPITAL LETTER OMEGA WITH PSILI
test(0x1F61, 0x1F69); // GREEK SMALL LETTER OMEGA WITH DASIA, GREEK CAPITAL LETTER OMEGA WITH DASIA
test(0x1F62, 0x1F6A); // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA, GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
test(0x1F63, 0x1F6B); // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA, GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
test(0x1F64, 0x1F6C); // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA, GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
test(0x1F65, 0x1F6D); // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA, GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
test(0x1F66, 0x1F6E); // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI, GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
test(0x1F67, 0x1F6F); // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI, GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
test(0x1F68, 0x1F60); // GREEK CAPITAL LETTER OMEGA WITH PSILI, GREEK SMALL LETTER OMEGA WITH PSILI
test(0x1F69, 0x1F61); // GREEK CAPITAL LETTER OMEGA WITH DASIA, GREEK SMALL LETTER OMEGA WITH DASIA
test(0x1F6A, 0x1F62); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA, GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
test(0x1F6B, 0x1F63); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA, GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
test(0x1F6C, 0x1F64); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA, GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
test(0x1F6D, 0x1F65); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA, GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
test(0x1F6E, 0x1F66); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI, GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
test(0x1F6F, 0x1F67); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI, GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
test(0x1F70, 0x1FBA); // GREEK SMALL LETTER ALPHA WITH VARIA, GREEK CAPITAL LETTER ALPHA WITH VARIA
test(0x1F71, 0x1FBB); // GREEK SMALL LETTER ALPHA WITH OXIA, GREEK CAPITAL LETTER ALPHA WITH OXIA
test(0x1F72, 0x1FC8); // GREEK SMALL LETTER EPSILON WITH VARIA, GREEK CAPITAL LETTER EPSILON WITH VARIA
test(0x1F73, 0x1FC9); // GREEK SMALL LETTER EPSILON WITH OXIA, GREEK CAPITAL LETTER EPSILON WITH OXIA
test(0x1F74, 0x1FCA); // GREEK SMALL LETTER ETA WITH VARIA, GREEK CAPITAL LETTER ETA WITH VARIA
test(0x1F75, 0x1FCB); // GREEK SMALL LETTER ETA WITH OXIA, GREEK CAPITAL LETTER ETA WITH OXIA
test(0x1F76, 0x1FDA); // GREEK SMALL LETTER IOTA WITH VARIA, GREEK CAPITAL LETTER IOTA WITH VARIA
test(0x1F77, 0x1FDB); // GREEK SMALL LETTER IOTA WITH OXIA, GREEK CAPITAL LETTER IOTA WITH OXIA
test(0x1F78, 0x1FF8); // GREEK SMALL LETTER OMICRON WITH VARIA, GREEK CAPITAL LETTER OMICRON WITH VARIA
test(0x1F79, 0x1FF9); // GREEK SMALL LETTER OMICRON WITH OXIA, GREEK CAPITAL LETTER OMICRON WITH OXIA
test(0x1F7A, 0x1FEA); // GREEK SMALL LETTER UPSILON WITH VARIA, GREEK CAPITAL LETTER UPSILON WITH VARIA
test(0x1F7B, 0x1FEB); // GREEK SMALL LETTER UPSILON WITH OXIA, GREEK CAPITAL LETTER UPSILON WITH OXIA
test(0x1F7C, 0x1FFA); // GREEK SMALL LETTER OMEGA WITH VARIA, GREEK CAPITAL LETTER OMEGA WITH VARIA
test(0x1F7D, 0x1FFB); // GREEK SMALL LETTER OMEGA WITH OXIA, GREEK CAPITAL LETTER OMEGA WITH OXIA
test(0x1F80, 0x1F88); // GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
test(0x1F81, 0x1F89); // GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
test(0x1F82, 0x1F8A); // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
test(0x1F83, 0x1F8B); // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
test(0x1F84, 0x1F8C); // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
test(0x1F85, 0x1F8D); // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
test(0x1F86, 0x1F8E); // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
test(0x1F87, 0x1F8F); // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
test(0x1F88, 0x1F80); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
test(0x1F89, 0x1F81); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
test(0x1F8A, 0x1F82); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
test(0x1F8B, 0x1F83); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
test(0x1F8C, 0x1F84); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
test(0x1F8D, 0x1F85); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
test(0x1F8E, 0x1F86); // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
test(0x1F8F, 0x1F87); // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
test(0x1F90, 0x1F98); // GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
test(0x1F91, 0x1F99); // GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
test(0x1F92, 0x1F9A); // GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
test(0x1F93, 0x1F9B); // GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
test(0x1F94, 0x1F9C); // GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
test(0x1F95, 0x1F9D); // GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
test(0x1F96, 0x1F9E); // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
test(0x1F97, 0x1F9F); // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
test(0x1F98, 0x1F90); // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
test(0x1F99, 0x1F91); // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
test(0x1F9A, 0x1F92); // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
test(0x1F9B, 0x1F93); // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
test(0x1F9C, 0x1F94); // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
test(0x1F9D, 0x1F95); // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
test(0x1F9E, 0x1F96); // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
test(0x1F9F, 0x1F97); // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
test(0x1FA0, 0x1FA8); // GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
test(0x1FA1, 0x1FA9); // GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
test(0x1FA2, 0x1FAA); // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
test(0x1FA3, 0x1FAB); // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
test(0x1FA4, 0x1FAC); // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
test(0x1FA5, 0x1FAD); // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
test(0x1FA6, 0x1FAE); // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
test(0x1FA7, 0x1FAF); // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
test(0x1FA8, 0x1FA0); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
test(0x1FA9, 0x1FA1); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
test(0x1FAA, 0x1FA2); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
test(0x1FAB, 0x1FA3); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
test(0x1FAC, 0x1FA4); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
test(0x1FAD, 0x1FA5); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
test(0x1FAE, 0x1FA6); // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
test(0x1FAF, 0x1FA7); // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
test(0x1FB0, 0x1FB8); // GREEK SMALL LETTER ALPHA WITH VRACHY, GREEK CAPITAL LETTER ALPHA WITH VRACHY
test(0x1FB1, 0x1FB9); // GREEK SMALL LETTER ALPHA WITH MACRON, GREEK CAPITAL LETTER ALPHA WITH MACRON
test(0x1FB3, 0x1FBC); // GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI, GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
test(0x1FB8, 0x1FB0); // GREEK CAPITAL LETTER ALPHA WITH VRACHY, GREEK SMALL LETTER ALPHA WITH VRACHY
test(0x1FB9, 0x1FB1); // GREEK CAPITAL LETTER ALPHA WITH MACRON, GREEK SMALL LETTER ALPHA WITH MACRON
test(0x1FBA, 0x1F70); // GREEK CAPITAL LETTER ALPHA WITH VARIA, GREEK SMALL LETTER ALPHA WITH VARIA
test(0x1FBB, 0x1F71); // GREEK CAPITAL LETTER ALPHA WITH OXIA, GREEK SMALL LETTER ALPHA WITH OXIA
test(0x1FBC, 0x1FB3); // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI, GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
test(0x1FBE, 0x03B9, 0x0345, 0x0399); // GREEK PROSGEGRAMMENI, GREEK SMALL LETTER IOTA, COMBINING GREEK YPOGEGRAMMENI (GREEK NON-SPACING IOTA BELOW), GREEK CAPITAL LETTER IOTA
test(0x1FC3, 0x1FCC); // GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI, GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
test(0x1FC8, 0x1F72); // GREEK CAPITAL LETTER EPSILON WITH VARIA, GREEK SMALL LETTER EPSILON WITH VARIA
test(0x1FC9, 0x1F73); // GREEK CAPITAL LETTER EPSILON WITH OXIA, GREEK SMALL LETTER EPSILON WITH OXIA
test(0x1FCA, 0x1F74); // GREEK CAPITAL LETTER ETA WITH VARIA, GREEK SMALL LETTER ETA WITH VARIA
test(0x1FCB, 0x1F75); // GREEK CAPITAL LETTER ETA WITH OXIA, GREEK SMALL LETTER ETA WITH OXIA
test(0x1FCC, 0x1FC3); // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI, GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
test(0x1FD0, 0x1FD8); // GREEK SMALL LETTER IOTA WITH VRACHY, GREEK CAPITAL LETTER IOTA WITH VRACHY
test(0x1FD1, 0x1FD9); // GREEK SMALL LETTER IOTA WITH MACRON, GREEK CAPITAL LETTER IOTA WITH MACRON
test(0x1FD3, 0x0390); // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA, GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER IOTA DIAERESIS TONOS)
test(0x1FD8, 0x1FD0); // GREEK CAPITAL LETTER IOTA WITH VRACHY, GREEK SMALL LETTER IOTA WITH VRACHY
test(0x1FD9, 0x1FD1); // GREEK CAPITAL LETTER IOTA WITH MACRON, GREEK SMALL LETTER IOTA WITH MACRON
test(0x1FDA, 0x1F76); // GREEK CAPITAL LETTER IOTA WITH VARIA, GREEK SMALL LETTER IOTA WITH VARIA
test(0x1FDB, 0x1F77); // GREEK CAPITAL LETTER IOTA WITH OXIA, GREEK SMALL LETTER IOTA WITH OXIA
test(0x1FE0, 0x1FE8); // GREEK SMALL LETTER UPSILON WITH VRACHY, GREEK CAPITAL LETTER UPSILON WITH VRACHY
test(0x1FE1, 0x1FE9); // GREEK SMALL LETTER UPSILON WITH MACRON, GREEK CAPITAL LETTER UPSILON WITH MACRON
test(0x1FE3, 0x03B0); // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA, GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER UPSILON DIAERESIS TONOS)
test(0x1FE5, 0x1FEC); // GREEK SMALL LETTER RHO WITH DASIA, GREEK CAPITAL LETTER RHO WITH DASIA
test(0x1FE8, 0x1FE0); // GREEK CAPITAL LETTER UPSILON WITH VRACHY, GREEK SMALL LETTER UPSILON WITH VRACHY
test(0x1FE9, 0x1FE1); // GREEK CAPITAL LETTER UPSILON WITH MACRON, GREEK SMALL LETTER UPSILON WITH MACRON
test(0x1FEA, 0x1F7A); // GREEK CAPITAL LETTER UPSILON WITH VARIA, GREEK SMALL LETTER UPSILON WITH VARIA
test(0x1FEB, 0x1F7B); // GREEK CAPITAL LETTER UPSILON WITH OXIA, GREEK SMALL LETTER UPSILON WITH OXIA
test(0x1FEC, 0x1FE5); // GREEK CAPITAL LETTER RHO WITH DASIA, GREEK SMALL LETTER RHO WITH DASIA
test(0x1FF3, 0x1FFC); // GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI, GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
test(0x1FF8, 0x1F78); // GREEK CAPITAL LETTER OMICRON WITH VARIA, GREEK SMALL LETTER OMICRON WITH VARIA
test(0x1FF9, 0x1F79); // GREEK CAPITAL LETTER OMICRON WITH OXIA, GREEK SMALL LETTER OMICRON WITH OXIA
test(0x1FFA, 0x1F7C); // GREEK CAPITAL LETTER OMEGA WITH VARIA, GREEK SMALL LETTER OMEGA WITH VARIA
test(0x1FFB, 0x1F7D); // GREEK CAPITAL LETTER OMEGA WITH OXIA, GREEK SMALL LETTER OMEGA WITH OXIA
test(0x1FFC, 0x1FF3); // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI, GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
test(0x2126, 0x03C9, 0x03A9); // OHM SIGN (OHM), GREEK SMALL LETTER OMEGA, GREEK CAPITAL LETTER OMEGA
test(0x212A, 0x006B, 0x004B); // KELVIN SIGN (DEGREES KELVIN), LATIN SMALL LETTER K, LATIN CAPITAL LETTER K
test(0x212B, 0x00E5, 0x00C5); // ANGSTROM SIGN (ANGSTROM UNIT), LATIN SMALL LETTER A WITH RING ABOVE (LATIN SMALL LETTER A RING), LATIN CAPITAL LETTER A WITH RING ABOVE (LATIN CAPITAL LETTER A RING)
test(0x2132, 0x214E); // TURNED CAPITAL F (TURNED F), TURNED SMALL F
test(0x214E, 0x2132); // TURNED SMALL F, TURNED CAPITAL F (TURNED F)
test(0x2160, 0x2170); // ROMAN NUMERAL ONE, SMALL ROMAN NUMERAL ONE
test(0x2161, 0x2171); // ROMAN NUMERAL TWO, SMALL ROMAN NUMERAL TWO
test(0x2162, 0x2172); // ROMAN NUMERAL THREE, SMALL ROMAN NUMERAL THREE
test(0x2163, 0x2173); // ROMAN NUMERAL FOUR, SMALL ROMAN NUMERAL FOUR
test(0x2164, 0x2174); // ROMAN NUMERAL FIVE, SMALL ROMAN NUMERAL FIVE
test(0x2165, 0x2175); // ROMAN NUMERAL SIX, SMALL ROMAN NUMERAL SIX
test(0x2166, 0x2176); // ROMAN NUMERAL SEVEN, SMALL ROMAN NUMERAL SEVEN
test(0x2167, 0x2177); // ROMAN NUMERAL EIGHT, SMALL ROMAN NUMERAL EIGHT
test(0x2168, 0x2178); // ROMAN NUMERAL NINE, SMALL ROMAN NUMERAL NINE
test(0x2169, 0x2179); // ROMAN NUMERAL TEN, SMALL ROMAN NUMERAL TEN
test(0x216A, 0x217A); // ROMAN NUMERAL ELEVEN, SMALL ROMAN NUMERAL ELEVEN
test(0x216B, 0x217B); // ROMAN NUMERAL TWELVE, SMALL ROMAN NUMERAL TWELVE
test(0x216C, 0x217C); // ROMAN NUMERAL FIFTY, SMALL ROMAN NUMERAL FIFTY
test(0x216D, 0x217D); // ROMAN NUMERAL ONE HUNDRED, SMALL ROMAN NUMERAL ONE HUNDRED
test(0x216E, 0x217E); // ROMAN NUMERAL FIVE HUNDRED, SMALL ROMAN NUMERAL FIVE HUNDRED
test(0x216F, 0x217F); // ROMAN NUMERAL ONE THOUSAND, SMALL ROMAN NUMERAL ONE THOUSAND
test(0x2170, 0x2160); // SMALL ROMAN NUMERAL ONE, ROMAN NUMERAL ONE
test(0x2171, 0x2161); // SMALL ROMAN NUMERAL TWO, ROMAN NUMERAL TWO
test(0x2172, 0x2162); // SMALL ROMAN NUMERAL THREE, ROMAN NUMERAL THREE
test(0x2173, 0x2163); // SMALL ROMAN NUMERAL FOUR, ROMAN NUMERAL FOUR
test(0x2174, 0x2164); // SMALL ROMAN NUMERAL FIVE, ROMAN NUMERAL FIVE
test(0x2175, 0x2165); // SMALL ROMAN NUMERAL SIX, ROMAN NUMERAL SIX
test(0x2176, 0x2166); // SMALL ROMAN NUMERAL SEVEN, ROMAN NUMERAL SEVEN
test(0x2177, 0x2167); // SMALL ROMAN NUMERAL EIGHT, ROMAN NUMERAL EIGHT
test(0x2178, 0x2168); // SMALL ROMAN NUMERAL NINE, ROMAN NUMERAL NINE
test(0x2179, 0x2169); // SMALL ROMAN NUMERAL TEN, ROMAN NUMERAL TEN
test(0x217A, 0x216A); // SMALL ROMAN NUMERAL ELEVEN, ROMAN NUMERAL ELEVEN
test(0x217B, 0x216B); // SMALL ROMAN NUMERAL TWELVE, ROMAN NUMERAL TWELVE
test(0x217C, 0x216C); // SMALL ROMAN NUMERAL FIFTY, ROMAN NUMERAL FIFTY
test(0x217D, 0x216D); // SMALL ROMAN NUMERAL ONE HUNDRED, ROMAN NUMERAL ONE HUNDRED
test(0x217E, 0x216E); // SMALL ROMAN NUMERAL FIVE HUNDRED, ROMAN NUMERAL FIVE HUNDRED
test(0x217F, 0x216F); // SMALL ROMAN NUMERAL ONE THOUSAND, ROMAN NUMERAL ONE THOUSAND
test(0x2183, 0x2184); // ROMAN NUMERAL REVERSED ONE HUNDRED, LATIN SMALL LETTER REVERSED C
test(0x2184, 0x2183); // LATIN SMALL LETTER REVERSED C, ROMAN NUMERAL REVERSED ONE HUNDRED
test(0x24B6, 0x24D0); // CIRCLED LATIN CAPITAL LETTER A, CIRCLED LATIN SMALL LETTER A
test(0x24B7, 0x24D1); // CIRCLED LATIN CAPITAL LETTER B, CIRCLED LATIN SMALL LETTER B
test(0x24B8, 0x24D2); // CIRCLED LATIN CAPITAL LETTER C, CIRCLED LATIN SMALL LETTER C
test(0x24B9, 0x24D3); // CIRCLED LATIN CAPITAL LETTER D, CIRCLED LATIN SMALL LETTER D
test(0x24BA, 0x24D4); // CIRCLED LATIN CAPITAL LETTER E, CIRCLED LATIN SMALL LETTER E
test(0x24BB, 0x24D5); // CIRCLED LATIN CAPITAL LETTER F, CIRCLED LATIN SMALL LETTER F
test(0x24BC, 0x24D6); // CIRCLED LATIN CAPITAL LETTER G, CIRCLED LATIN SMALL LETTER G
test(0x24BD, 0x24D7); // CIRCLED LATIN CAPITAL LETTER H, CIRCLED LATIN SMALL LETTER H
test(0x24BE, 0x24D8); // CIRCLED LATIN CAPITAL LETTER I, CIRCLED LATIN SMALL LETTER I
test(0x24BF, 0x24D9); // CIRCLED LATIN CAPITAL LETTER J, CIRCLED LATIN SMALL LETTER J
test(0x24C0, 0x24DA); // CIRCLED LATIN CAPITAL LETTER K, CIRCLED LATIN SMALL LETTER K
test(0x24C1, 0x24DB); // CIRCLED LATIN CAPITAL LETTER L, CIRCLED LATIN SMALL LETTER L
test(0x24C2, 0x24DC); // CIRCLED LATIN CAPITAL LETTER M, CIRCLED LATIN SMALL LETTER M
test(0x24C3, 0x24DD); // CIRCLED LATIN CAPITAL LETTER N, CIRCLED LATIN SMALL LETTER N
test(0x24C4, 0x24DE); // CIRCLED LATIN CAPITAL LETTER O, CIRCLED LATIN SMALL LETTER O
test(0x24C5, 0x24DF); // CIRCLED LATIN CAPITAL LETTER P, CIRCLED LATIN SMALL LETTER P
test(0x24C6, 0x24E0); // CIRCLED LATIN CAPITAL LETTER Q, CIRCLED LATIN SMALL LETTER Q
test(0x24C7, 0x24E1); // CIRCLED LATIN CAPITAL LETTER R, CIRCLED LATIN SMALL LETTER R
test(0x24C8, 0x24E2); // CIRCLED LATIN CAPITAL LETTER S, CIRCLED LATIN SMALL LETTER S
test(0x24C9, 0x24E3); // CIRCLED LATIN CAPITAL LETTER T, CIRCLED LATIN SMALL LETTER T
test(0x24CA, 0x24E4); // CIRCLED LATIN CAPITAL LETTER U, CIRCLED LATIN SMALL LETTER U
test(0x24CB, 0x24E5); // CIRCLED LATIN CAPITAL LETTER V, CIRCLED LATIN SMALL LETTER V
test(0x24CC, 0x24E6); // CIRCLED LATIN CAPITAL LETTER W, CIRCLED LATIN SMALL LETTER W
test(0x24CD, 0x24E7); // CIRCLED LATIN CAPITAL LETTER X, CIRCLED LATIN SMALL LETTER X
test(0x24CE, 0x24E8); // CIRCLED LATIN CAPITAL LETTER Y, CIRCLED LATIN SMALL LETTER Y
test(0x24CF, 0x24E9); // CIRCLED LATIN CAPITAL LETTER Z, CIRCLED LATIN SMALL LETTER Z
test(0x24D0, 0x24B6); // CIRCLED LATIN SMALL LETTER A, CIRCLED LATIN CAPITAL LETTER A
test(0x24D1, 0x24B7); // CIRCLED LATIN SMALL LETTER B, CIRCLED LATIN CAPITAL LETTER B
test(0x24D2, 0x24B8); // CIRCLED LATIN SMALL LETTER C, CIRCLED LATIN CAPITAL LETTER C
test(0x24D3, 0x24B9); // CIRCLED LATIN SMALL LETTER D, CIRCLED LATIN CAPITAL LETTER D
test(0x24D4, 0x24BA); // CIRCLED LATIN SMALL LETTER E, CIRCLED LATIN CAPITAL LETTER E
test(0x24D5, 0x24BB); // CIRCLED LATIN SMALL LETTER F, CIRCLED LATIN CAPITAL LETTER F
test(0x24D6, 0x24BC); // CIRCLED LATIN SMALL LETTER G, CIRCLED LATIN CAPITAL LETTER G
test(0x24D7, 0x24BD); // CIRCLED LATIN SMALL LETTER H, CIRCLED LATIN CAPITAL LETTER H
test(0x24D8, 0x24BE); // CIRCLED LATIN SMALL LETTER I, CIRCLED LATIN CAPITAL LETTER I
test(0x24D9, 0x24BF); // CIRCLED LATIN SMALL LETTER J, CIRCLED LATIN CAPITAL LETTER J
test(0x24DA, 0x24C0); // CIRCLED LATIN SMALL LETTER K, CIRCLED LATIN CAPITAL LETTER K
test(0x24DB, 0x24C1); // CIRCLED LATIN SMALL LETTER L, CIRCLED LATIN CAPITAL LETTER L
test(0x24DC, 0x24C2); // CIRCLED LATIN SMALL LETTER M, CIRCLED LATIN CAPITAL LETTER M
test(0x24DD, 0x24C3); // CIRCLED LATIN SMALL LETTER N, CIRCLED LATIN CAPITAL LETTER N
test(0x24DE, 0x24C4); // CIRCLED LATIN SMALL LETTER O, CIRCLED LATIN CAPITAL LETTER O
test(0x24DF, 0x24C5); // CIRCLED LATIN SMALL LETTER P, CIRCLED LATIN CAPITAL LETTER P
test(0x24E0, 0x24C6); // CIRCLED LATIN SMALL LETTER Q, CIRCLED LATIN CAPITAL LETTER Q
test(0x24E1, 0x24C7); // CIRCLED LATIN SMALL LETTER R, CIRCLED LATIN CAPITAL LETTER R
test(0x24E2, 0x24C8); // CIRCLED LATIN SMALL LETTER S, CIRCLED LATIN CAPITAL LETTER S
test(0x24E3, 0x24C9); // CIRCLED LATIN SMALL LETTER T, CIRCLED LATIN CAPITAL LETTER T
test(0x24E4, 0x24CA); // CIRCLED LATIN SMALL LETTER U, CIRCLED LATIN CAPITAL LETTER U
test(0x24E5, 0x24CB); // CIRCLED LATIN SMALL LETTER V, CIRCLED LATIN CAPITAL LETTER V
test(0x24E6, 0x24CC); // CIRCLED LATIN SMALL LETTER W, CIRCLED LATIN CAPITAL LETTER W
test(0x24E7, 0x24CD); // CIRCLED LATIN SMALL LETTER X, CIRCLED LATIN CAPITAL LETTER X
test(0x24E8, 0x24CE); // CIRCLED LATIN SMALL LETTER Y, CIRCLED LATIN CAPITAL LETTER Y
test(0x24E9, 0x24CF); // CIRCLED LATIN SMALL LETTER Z, CIRCLED LATIN CAPITAL LETTER Z
test(0x2C00, 0x2C30); // GLAGOLITIC CAPITAL LETTER AZU, GLAGOLITIC SMALL LETTER AZU
test(0x2C01, 0x2C31); // GLAGOLITIC CAPITAL LETTER BUKY, GLAGOLITIC SMALL LETTER BUKY
test(0x2C02, 0x2C32); // GLAGOLITIC CAPITAL LETTER VEDE, GLAGOLITIC SMALL LETTER VEDE
test(0x2C03, 0x2C33); // GLAGOLITIC CAPITAL LETTER GLAGOLI, GLAGOLITIC SMALL LETTER GLAGOLI
test(0x2C04, 0x2C34); // GLAGOLITIC CAPITAL LETTER DOBRO, GLAGOLITIC SMALL LETTER DOBRO
test(0x2C05, 0x2C35); // GLAGOLITIC CAPITAL LETTER YESTU, GLAGOLITIC SMALL LETTER YESTU
test(0x2C06, 0x2C36); // GLAGOLITIC CAPITAL LETTER ZHIVETE, GLAGOLITIC SMALL LETTER ZHIVETE
test(0x2C07, 0x2C37); // GLAGOLITIC CAPITAL LETTER DZELO, GLAGOLITIC SMALL LETTER DZELO
test(0x2C08, 0x2C38); // GLAGOLITIC CAPITAL LETTER ZEMLJA, GLAGOLITIC SMALL LETTER ZEMLJA
test(0x2C09, 0x2C39); // GLAGOLITIC CAPITAL LETTER IZHE, GLAGOLITIC SMALL LETTER IZHE
test(0x2C0A, 0x2C3A); // GLAGOLITIC CAPITAL LETTER INITIAL IZHE, GLAGOLITIC SMALL LETTER INITIAL IZHE
test(0x2C0B, 0x2C3B); // GLAGOLITIC CAPITAL LETTER I, GLAGOLITIC SMALL LETTER I
test(0x2C0C, 0x2C3C); // GLAGOLITIC CAPITAL LETTER DJERVI, GLAGOLITIC SMALL LETTER DJERVI
test(0x2C0D, 0x2C3D); // GLAGOLITIC CAPITAL LETTER KAKO, GLAGOLITIC SMALL LETTER KAKO
test(0x2C0E, 0x2C3E); // GLAGOLITIC CAPITAL LETTER LJUDIJE, GLAGOLITIC SMALL LETTER LJUDIJE
test(0x2C0F, 0x2C3F); // GLAGOLITIC CAPITAL LETTER MYSLITE, GLAGOLITIC SMALL LETTER MYSLITE
test(0x2C10, 0x2C40); // GLAGOLITIC CAPITAL LETTER NASHI, GLAGOLITIC SMALL LETTER NASHI
test(0x2C11, 0x2C41); // GLAGOLITIC CAPITAL LETTER ONU, GLAGOLITIC SMALL LETTER ONU
test(0x2C12, 0x2C42); // GLAGOLITIC CAPITAL LETTER POKOJI, GLAGOLITIC SMALL LETTER POKOJI
test(0x2C13, 0x2C43); // GLAGOLITIC CAPITAL LETTER RITSI, GLAGOLITIC SMALL LETTER RITSI
test(0x2C14, 0x2C44); // GLAGOLITIC CAPITAL LETTER SLOVO, GLAGOLITIC SMALL LETTER SLOVO
test(0x2C15, 0x2C45); // GLAGOLITIC CAPITAL LETTER TVRIDO, GLAGOLITIC SMALL LETTER TVRIDO
test(0x2C16, 0x2C46); // GLAGOLITIC CAPITAL LETTER UKU, GLAGOLITIC SMALL LETTER UKU
test(0x2C17, 0x2C47); // GLAGOLITIC CAPITAL LETTER FRITU, GLAGOLITIC SMALL LETTER FRITU
test(0x2C18, 0x2C48); // GLAGOLITIC CAPITAL LETTER HERU, GLAGOLITIC SMALL LETTER HERU
test(0x2C19, 0x2C49); // GLAGOLITIC CAPITAL LETTER OTU, GLAGOLITIC SMALL LETTER OTU
test(0x2C1A, 0x2C4A); // GLAGOLITIC CAPITAL LETTER PE, GLAGOLITIC SMALL LETTER PE
test(0x2C1B, 0x2C4B); // GLAGOLITIC CAPITAL LETTER SHTA, GLAGOLITIC SMALL LETTER SHTA
test(0x2C1C, 0x2C4C); // GLAGOLITIC CAPITAL LETTER TSI, GLAGOLITIC SMALL LETTER TSI
test(0x2C1D, 0x2C4D); // GLAGOLITIC CAPITAL LETTER CHRIVI, GLAGOLITIC SMALL LETTER CHRIVI
test(0x2C1E, 0x2C4E); // GLAGOLITIC CAPITAL LETTER SHA, GLAGOLITIC SMALL LETTER SHA
test(0x2C1F, 0x2C4F); // GLAGOLITIC CAPITAL LETTER YERU, GLAGOLITIC SMALL LETTER YERU
test(0x2C20, 0x2C50); // GLAGOLITIC CAPITAL LETTER YERI, GLAGOLITIC SMALL LETTER YERI
test(0x2C21, 0x2C51); // GLAGOLITIC CAPITAL LETTER YATI, GLAGOLITIC SMALL LETTER YATI
test(0x2C22, 0x2C52); // GLAGOLITIC CAPITAL LETTER SPIDERY HA, GLAGOLITIC SMALL LETTER SPIDERY HA
test(0x2C23, 0x2C53); // GLAGOLITIC CAPITAL LETTER YU, GLAGOLITIC SMALL LETTER YU
test(0x2C24, 0x2C54); // GLAGOLITIC CAPITAL LETTER SMALL YUS, GLAGOLITIC SMALL LETTER SMALL YUS
test(0x2C25, 0x2C55); // GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL, GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL
test(0x2C26, 0x2C56); // GLAGOLITIC CAPITAL LETTER YO, GLAGOLITIC SMALL LETTER YO
test(0x2C27, 0x2C57); // GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS, GLAGOLITIC SMALL LETTER IOTATED SMALL YUS
test(0x2C28, 0x2C58); // GLAGOLITIC CAPITAL LETTER BIG YUS, GLAGOLITIC SMALL LETTER BIG YUS
test(0x2C29, 0x2C59); // GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS, GLAGOLITIC SMALL LETTER IOTATED BIG YUS
test(0x2C2A, 0x2C5A); // GLAGOLITIC CAPITAL LETTER FITA, GLAGOLITIC SMALL LETTER FITA
test(0x2C2B, 0x2C5B); // GLAGOLITIC CAPITAL LETTER IZHITSA, GLAGOLITIC SMALL LETTER IZHITSA
test(0x2C2C, 0x2C5C); // GLAGOLITIC CAPITAL LETTER SHTAPIC, GLAGOLITIC SMALL LETTER SHTAPIC
test(0x2C2D, 0x2C5D); // GLAGOLITIC CAPITAL LETTER TROKUTASTI A, GLAGOLITIC SMALL LETTER TROKUTASTI A
test(0x2C2E, 0x2C5E); // GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE, GLAGOLITIC SMALL LETTER LATINATE MYSLITE
test(0x2C2F, 0x2C5F); // GLAGOLITIC CAPITAL LETTER CAUDATE CHRIVI, GLAGOLITIC SMALL LETTER CAUDATE CHRIVI
test(0x2C30, 0x2C00); // GLAGOLITIC SMALL LETTER AZU, GLAGOLITIC CAPITAL LETTER AZU
test(0x2C31, 0x2C01); // GLAGOLITIC SMALL LETTER BUKY, GLAGOLITIC CAPITAL LETTER BUKY
test(0x2C32, 0x2C02); // GLAGOLITIC SMALL LETTER VEDE, GLAGOLITIC CAPITAL LETTER VEDE
test(0x2C33, 0x2C03); // GLAGOLITIC SMALL LETTER GLAGOLI, GLAGOLITIC CAPITAL LETTER GLAGOLI
test(0x2C34, 0x2C04); // GLAGOLITIC SMALL LETTER DOBRO, GLAGOLITIC CAPITAL LETTER DOBRO
test(0x2C35, 0x2C05); // GLAGOLITIC SMALL LETTER YESTU, GLAGOLITIC CAPITAL LETTER YESTU
test(0x2C36, 0x2C06); // GLAGOLITIC SMALL LETTER ZHIVETE, GLAGOLITIC CAPITAL LETTER ZHIVETE
test(0x2C37, 0x2C07); // GLAGOLITIC SMALL LETTER DZELO, GLAGOLITIC CAPITAL LETTER DZELO
test(0x2C38, 0x2C08); // GLAGOLITIC SMALL LETTER ZEMLJA, GLAGOLITIC CAPITAL LETTER ZEMLJA
test(0x2C39, 0x2C09); // GLAGOLITIC SMALL LETTER IZHE, GLAGOLITIC CAPITAL LETTER IZHE
test(0x2C3A, 0x2C0A); // GLAGOLITIC SMALL LETTER INITIAL IZHE, GLAGOLITIC CAPITAL LETTER INITIAL IZHE
test(0x2C3B, 0x2C0B); // GLAGOLITIC SMALL LETTER I, GLAGOLITIC CAPITAL LETTER I
test(0x2C3C, 0x2C0C); // GLAGOLITIC SMALL LETTER DJERVI, GLAGOLITIC CAPITAL LETTER DJERVI
test(0x2C3D, 0x2C0D); // GLAGOLITIC SMALL LETTER KAKO, GLAGOLITIC CAPITAL LETTER KAKO
test(0x2C3E, 0x2C0E); // GLAGOLITIC SMALL LETTER LJUDIJE, GLAGOLITIC CAPITAL LETTER LJUDIJE
test(0x2C3F, 0x2C0F); // GLAGOLITIC SMALL LETTER MYSLITE, GLAGOLITIC CAPITAL LETTER MYSLITE
test(0x2C40, 0x2C10); // GLAGOLITIC SMALL LETTER NASHI, GLAGOLITIC CAPITAL LETTER NASHI
test(0x2C41, 0x2C11); // GLAGOLITIC SMALL LETTER ONU, GLAGOLITIC CAPITAL LETTER ONU
test(0x2C42, 0x2C12); // GLAGOLITIC SMALL LETTER POKOJI, GLAGOLITIC CAPITAL LETTER POKOJI
test(0x2C43, 0x2C13); // GLAGOLITIC SMALL LETTER RITSI, GLAGOLITIC CAPITAL LETTER RITSI
test(0x2C44, 0x2C14); // GLAGOLITIC SMALL LETTER SLOVO, GLAGOLITIC CAPITAL LETTER SLOVO
test(0x2C45, 0x2C15); // GLAGOLITIC SMALL LETTER TVRIDO, GLAGOLITIC CAPITAL LETTER TVRIDO
test(0x2C46, 0x2C16); // GLAGOLITIC SMALL LETTER UKU, GLAGOLITIC CAPITAL LETTER UKU
test(0x2C47, 0x2C17); // GLAGOLITIC SMALL LETTER FRITU, GLAGOLITIC CAPITAL LETTER FRITU
test(0x2C48, 0x2C18); // GLAGOLITIC SMALL LETTER HERU, GLAGOLITIC CAPITAL LETTER HERU
test(0x2C49, 0x2C19); // GLAGOLITIC SMALL LETTER OTU, GLAGOLITIC CAPITAL LETTER OTU
test(0x2C4A, 0x2C1A); // GLAGOLITIC SMALL LETTER PE, GLAGOLITIC CAPITAL LETTER PE
test(0x2C4B, 0x2C1B); // GLAGOLITIC SMALL LETTER SHTA, GLAGOLITIC CAPITAL LETTER SHTA
test(0x2C4C, 0x2C1C); // GLAGOLITIC SMALL LETTER TSI, GLAGOLITIC CAPITAL LETTER TSI
test(0x2C4D, 0x2C1D); // GLAGOLITIC SMALL LETTER CHRIVI, GLAGOLITIC CAPITAL LETTER CHRIVI
test(0x2C4E, 0x2C1E); // GLAGOLITIC SMALL LETTER SHA, GLAGOLITIC CAPITAL LETTER SHA
test(0x2C4F, 0x2C1F); // GLAGOLITIC SMALL LETTER YERU, GLAGOLITIC CAPITAL LETTER YERU
test(0x2C50, 0x2C20); // GLAGOLITIC SMALL LETTER YERI, GLAGOLITIC CAPITAL LETTER YERI
test(0x2C51, 0x2C21); // GLAGOLITIC SMALL LETTER YATI, GLAGOLITIC CAPITAL LETTER YATI
test(0x2C52, 0x2C22); // GLAGOLITIC SMALL LETTER SPIDERY HA, GLAGOLITIC CAPITAL LETTER SPIDERY HA
test(0x2C53, 0x2C23); // GLAGOLITIC SMALL LETTER YU, GLAGOLITIC CAPITAL LETTER YU
test(0x2C54, 0x2C24); // GLAGOLITIC SMALL LETTER SMALL YUS, GLAGOLITIC CAPITAL LETTER SMALL YUS
test(0x2C55, 0x2C25); // GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL, GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL
test(0x2C56, 0x2C26); // GLAGOLITIC SMALL LETTER YO, GLAGOLITIC CAPITAL LETTER YO
test(0x2C57, 0x2C27); // GLAGOLITIC SMALL LETTER IOTATED SMALL YUS, GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS
test(0x2C58, 0x2C28); // GLAGOLITIC SMALL LETTER BIG YUS, GLAGOLITIC CAPITAL LETTER BIG YUS
test(0x2C59, 0x2C29); // GLAGOLITIC SMALL LETTER IOTATED BIG YUS, GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS
test(0x2C5A, 0x2C2A); // GLAGOLITIC SMALL LETTER FITA, GLAGOLITIC CAPITAL LETTER FITA
test(0x2C5B, 0x2C2B); // GLAGOLITIC SMALL LETTER IZHITSA, GLAGOLITIC CAPITAL LETTER IZHITSA
test(0x2C5C, 0x2C2C); // GLAGOLITIC SMALL LETTER SHTAPIC, GLAGOLITIC CAPITAL LETTER SHTAPIC
test(0x2C5D, 0x2C2D); // GLAGOLITIC SMALL LETTER TROKUTASTI A, GLAGOLITIC CAPITAL LETTER TROKUTASTI A
test(0x2C5E, 0x2C2E); // GLAGOLITIC SMALL LETTER LATINATE MYSLITE, GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
test(0x2C5F, 0x2C2F); // GLAGOLITIC SMALL LETTER CAUDATE CHRIVI, GLAGOLITIC CAPITAL LETTER CAUDATE CHRIVI
test(0x2C60, 0x2C61); // LATIN CAPITAL LETTER L WITH DOUBLE BAR, LATIN SMALL LETTER L WITH DOUBLE BAR
test(0x2C61, 0x2C60); // LATIN SMALL LETTER L WITH DOUBLE BAR, LATIN CAPITAL LETTER L WITH DOUBLE BAR
test(0x2C62, 0x026B); // LATIN CAPITAL LETTER L WITH MIDDLE TILDE, LATIN SMALL LETTER L WITH MIDDLE TILDE
test(0x2C63, 0x1D7D); // LATIN CAPITAL LETTER P WITH STROKE, LATIN SMALL LETTER P WITH STROKE
test(0x2C64, 0x027D); // LATIN CAPITAL LETTER R WITH TAIL, LATIN SMALL LETTER R WITH TAIL (LATIN SMALL LETTER R HOOK)
test(0x2C65, 0x023A); // LATIN SMALL LETTER A WITH STROKE, LATIN CAPITAL LETTER A WITH STROKE
test(0x2C66, 0x023E); // LATIN SMALL LETTER T WITH DIAGONAL STROKE, LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
test(0x2C67, 0x2C68); // LATIN CAPITAL LETTER H WITH DESCENDER, LATIN SMALL LETTER H WITH DESCENDER
test(0x2C68, 0x2C67); // LATIN SMALL LETTER H WITH DESCENDER, LATIN CAPITAL LETTER H WITH DESCENDER
test(0x2C69, 0x2C6A); // LATIN CAPITAL LETTER K WITH DESCENDER, LATIN SMALL LETTER K WITH DESCENDER
test(0x2C6A, 0x2C69); // LATIN SMALL LETTER K WITH DESCENDER, LATIN CAPITAL LETTER K WITH DESCENDER
test(0x2C6B, 0x2C6C); // LATIN CAPITAL LETTER Z WITH DESCENDER, LATIN SMALL LETTER Z WITH DESCENDER
test(0x2C6C, 0x2C6B); // LATIN SMALL LETTER Z WITH DESCENDER, LATIN CAPITAL LETTER Z WITH DESCENDER
test(0x2C6D, 0x0251); // LATIN CAPITAL LETTER ALPHA, LATIN SMALL LETTER ALPHA (LATIN SMALL LETTER SCRIPT A)
test(0x2C6E, 0x0271); // LATIN CAPITAL LETTER M WITH HOOK, LATIN SMALL LETTER M WITH HOOK (LATIN SMALL LETTER M HOOK)
test(0x2C6F, 0x0250); // LATIN CAPITAL LETTER TURNED A, LATIN SMALL LETTER TURNED A
test(0x2C70, 0x0252); // LATIN CAPITAL LETTER TURNED ALPHA, LATIN SMALL LETTER TURNED ALPHA (LATIN SMALL LETTER TURNED SCRIPT A)
test(0x2C72, 0x2C73); // LATIN CAPITAL LETTER W WITH HOOK, LATIN SMALL LETTER W WITH HOOK
test(0x2C73, 0x2C72); // LATIN SMALL LETTER W WITH HOOK, LATIN CAPITAL LETTER W WITH HOOK
test(0x2C75, 0x2C76); // LATIN CAPITAL LETTER HALF H, LATIN SMALL LETTER HALF H
test(0x2C76, 0x2C75); // LATIN SMALL LETTER HALF H, LATIN CAPITAL LETTER HALF H
test(0x2C7E, 0x023F); // LATIN CAPITAL LETTER S WITH SWASH TAIL, LATIN SMALL LETTER S WITH SWASH TAIL
test(0x2C7F, 0x0240); // LATIN CAPITAL LETTER Z WITH SWASH TAIL, LATIN SMALL LETTER Z WITH SWASH TAIL
test(0x2C80, 0x2C81); // COPTIC CAPITAL LETTER ALFA, COPTIC SMALL LETTER ALFA
test(0x2C81, 0x2C80); // COPTIC SMALL LETTER ALFA, COPTIC CAPITAL LETTER ALFA
test(0x2C82, 0x2C83); // COPTIC CAPITAL LETTER VIDA, COPTIC SMALL LETTER VIDA
test(0x2C83, 0x2C82); // COPTIC SMALL LETTER VIDA, COPTIC CAPITAL LETTER VIDA
test(0x2C84, 0x2C85); // COPTIC CAPITAL LETTER GAMMA, COPTIC SMALL LETTER GAMMA
test(0x2C85, 0x2C84); // COPTIC SMALL LETTER GAMMA, COPTIC CAPITAL LETTER GAMMA
test(0x2C86, 0x2C87); // COPTIC CAPITAL LETTER DALDA, COPTIC SMALL LETTER DALDA
test(0x2C87, 0x2C86); // COPTIC SMALL LETTER DALDA, COPTIC CAPITAL LETTER DALDA
test(0x2C88, 0x2C89); // COPTIC CAPITAL LETTER EIE, COPTIC SMALL LETTER EIE
test(0x2C89, 0x2C88); // COPTIC SMALL LETTER EIE, COPTIC CAPITAL LETTER EIE
test(0x2C8A, 0x2C8B); // COPTIC CAPITAL LETTER SOU, COPTIC SMALL LETTER SOU
test(0x2C8B, 0x2C8A); // COPTIC SMALL LETTER SOU, COPTIC CAPITAL LETTER SOU
test(0x2C8C, 0x2C8D); // COPTIC CAPITAL LETTER ZATA, COPTIC SMALL LETTER ZATA
test(0x2C8D, 0x2C8C); // COPTIC SMALL LETTER ZATA, COPTIC CAPITAL LETTER ZATA
test(0x2C8E, 0x2C8F); // COPTIC CAPITAL LETTER HATE, COPTIC SMALL LETTER HATE
test(0x2C8F, 0x2C8E); // COPTIC SMALL LETTER HATE, COPTIC CAPITAL LETTER HATE
test(0x2C90, 0x2C91); // COPTIC CAPITAL LETTER THETHE, COPTIC SMALL LETTER THETHE
test(0x2C91, 0x2C90); // COPTIC SMALL LETTER THETHE, COPTIC CAPITAL LETTER THETHE
test(0x2C92, 0x2C93); // COPTIC CAPITAL LETTER IAUDA, COPTIC SMALL LETTER IAUDA
test(0x2C93, 0x2C92); // COPTIC SMALL LETTER IAUDA, COPTIC CAPITAL LETTER IAUDA
test(0x2C94, 0x2C95); // COPTIC CAPITAL LETTER KAPA, COPTIC SMALL LETTER KAPA
test(0x2C95, 0x2C94); // COPTIC SMALL LETTER KAPA, COPTIC CAPITAL LETTER KAPA
test(0x2C96, 0x2C97); // COPTIC CAPITAL LETTER LAULA, COPTIC SMALL LETTER LAULA
test(0x2C97, 0x2C96); // COPTIC SMALL LETTER LAULA, COPTIC CAPITAL LETTER LAULA
test(0x2C98, 0x2C99); // COPTIC CAPITAL LETTER MI, COPTIC SMALL LETTER MI
test(0x2C99, 0x2C98); // COPTIC SMALL LETTER MI, COPTIC CAPITAL LETTER MI
test(0x2C9A, 0x2C9B); // COPTIC CAPITAL LETTER NI, COPTIC SMALL LETTER NI
test(0x2C9B, 0x2C9A); // COPTIC SMALL LETTER NI, COPTIC CAPITAL LETTER NI
test(0x2C9C, 0x2C9D); // COPTIC CAPITAL LETTER KSI, COPTIC SMALL LETTER KSI
test(0x2C9D, 0x2C9C); // COPTIC SMALL LETTER KSI, COPTIC CAPITAL LETTER KSI
test(0x2C9E, 0x2C9F); // COPTIC CAPITAL LETTER O, COPTIC SMALL LETTER O
test(0x2C9F, 0x2C9E); // COPTIC SMALL LETTER O, COPTIC CAPITAL LETTER O
test(0x2CA0, 0x2CA1); // COPTIC CAPITAL LETTER PI, COPTIC SMALL LETTER PI
test(0x2CA1, 0x2CA0); // COPTIC SMALL LETTER PI, COPTIC CAPITAL LETTER PI
test(0x2CA2, 0x2CA3); // COPTIC CAPITAL LETTER RO, COPTIC SMALL LETTER RO
test(0x2CA3, 0x2CA2); // COPTIC SMALL LETTER RO, COPTIC CAPITAL LETTER RO
test(0x2CA4, 0x2CA5); // COPTIC CAPITAL LETTER SIMA, COPTIC SMALL LETTER SIMA
test(0x2CA5, 0x2CA4); // COPTIC SMALL LETTER SIMA, COPTIC CAPITAL LETTER SIMA
test(0x2CA6, 0x2CA7); // COPTIC CAPITAL LETTER TAU, COPTIC SMALL LETTER TAU
test(0x2CA7, 0x2CA6); // COPTIC SMALL LETTER TAU, COPTIC CAPITAL LETTER TAU
test(0x2CA8, 0x2CA9); // COPTIC CAPITAL LETTER UA, COPTIC SMALL LETTER UA
test(0x2CA9, 0x2CA8); // COPTIC SMALL LETTER UA, COPTIC CAPITAL LETTER UA
test(0x2CAA, 0x2CAB); // COPTIC CAPITAL LETTER FI, COPTIC SMALL LETTER FI
test(0x2CAB, 0x2CAA); // COPTIC SMALL LETTER FI, COPTIC CAPITAL LETTER FI
test(0x2CAC, 0x2CAD); // COPTIC CAPITAL LETTER KHI, COPTIC SMALL LETTER KHI
test(0x2CAD, 0x2CAC); // COPTIC SMALL LETTER KHI, COPTIC CAPITAL LETTER KHI
test(0x2CAE, 0x2CAF); // COPTIC CAPITAL LETTER PSI, COPTIC SMALL LETTER PSI
test(0x2CAF, 0x2CAE); // COPTIC SMALL LETTER PSI, COPTIC CAPITAL LETTER PSI
test(0x2CB0, 0x2CB1); // COPTIC CAPITAL LETTER OOU, COPTIC SMALL LETTER OOU
test(0x2CB1, 0x2CB0); // COPTIC SMALL LETTER OOU, COPTIC CAPITAL LETTER OOU
test(0x2CB2, 0x2CB3); // COPTIC CAPITAL LETTER DIALECT-P ALEF, COPTIC SMALL LETTER DIALECT-P ALEF
test(0x2CB3, 0x2CB2); // COPTIC SMALL LETTER DIALECT-P ALEF, COPTIC CAPITAL LETTER DIALECT-P ALEF
test(0x2CB4, 0x2CB5); // COPTIC CAPITAL LETTER OLD COPTIC AIN, COPTIC SMALL LETTER OLD COPTIC AIN
test(0x2CB5, 0x2CB4); // COPTIC SMALL LETTER OLD COPTIC AIN, COPTIC CAPITAL LETTER OLD COPTIC AIN
test(0x2CB6, 0x2CB7); // COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE, COPTIC SMALL LETTER CRYPTOGRAMMIC EIE
test(0x2CB7, 0x2CB6); // COPTIC SMALL LETTER CRYPTOGRAMMIC EIE, COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
test(0x2CB8, 0x2CB9); // COPTIC CAPITAL LETTER DIALECT-P KAPA, COPTIC SMALL LETTER DIALECT-P KAPA
test(0x2CB9, 0x2CB8); // COPTIC SMALL LETTER DIALECT-P KAPA, COPTIC CAPITAL LETTER DIALECT-P KAPA
test(0x2CBA, 0x2CBB); // COPTIC CAPITAL LETTER DIALECT-P NI, COPTIC SMALL LETTER DIALECT-P NI
test(0x2CBB, 0x2CBA); // COPTIC SMALL LETTER DIALECT-P NI, COPTIC CAPITAL LETTER DIALECT-P NI
test(0x2CBC, 0x2CBD); // COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI, COPTIC SMALL LETTER CRYPTOGRAMMIC NI
test(0x2CBD, 0x2CBC); // COPTIC SMALL LETTER CRYPTOGRAMMIC NI, COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
test(0x2CBE, 0x2CBF); // COPTIC CAPITAL LETTER OLD COPTIC OOU, COPTIC SMALL LETTER OLD COPTIC OOU
test(0x2CBF, 0x2CBE); // COPTIC SMALL LETTER OLD COPTIC OOU, COPTIC CAPITAL LETTER OLD COPTIC OOU
test(0x2CC0, 0x2CC1); // COPTIC CAPITAL LETTER SAMPI, COPTIC SMALL LETTER SAMPI
test(0x2CC1, 0x2CC0); // COPTIC SMALL LETTER SAMPI, COPTIC CAPITAL LETTER SAMPI
test(0x2CC2, 0x2CC3); // COPTIC CAPITAL LETTER CROSSED SHEI, COPTIC SMALL LETTER CROSSED SHEI
test(0x2CC3, 0x2CC2); // COPTIC SMALL LETTER CROSSED SHEI, COPTIC CAPITAL LETTER CROSSED SHEI
test(0x2CC4, 0x2CC5); // COPTIC CAPITAL LETTER OLD COPTIC SHEI, COPTIC SMALL LETTER OLD COPTIC SHEI
test(0x2CC5, 0x2CC4); // COPTIC SMALL LETTER OLD COPTIC SHEI, COPTIC CAPITAL LETTER OLD COPTIC SHEI
test(0x2CC6, 0x2CC7); // COPTIC CAPITAL LETTER OLD COPTIC ESH, COPTIC SMALL LETTER OLD COPTIC ESH
test(0x2CC7, 0x2CC6); // COPTIC SMALL LETTER OLD COPTIC ESH, COPTIC CAPITAL LETTER OLD COPTIC ESH
test(0x2CC8, 0x2CC9); // COPTIC CAPITAL LETTER AKHMIMIC KHEI, COPTIC SMALL LETTER AKHMIMIC KHEI
test(0x2CC9, 0x2CC8); // COPTIC SMALL LETTER AKHMIMIC KHEI, COPTIC CAPITAL LETTER AKHMIMIC KHEI
test(0x2CCA, 0x2CCB); // COPTIC CAPITAL LETTER DIALECT-P HORI, COPTIC SMALL LETTER DIALECT-P HORI
test(0x2CCB, 0x2CCA); // COPTIC SMALL LETTER DIALECT-P HORI, COPTIC CAPITAL LETTER DIALECT-P HORI
test(0x2CCC, 0x2CCD); // COPTIC CAPITAL LETTER OLD COPTIC HORI, COPTIC SMALL LETTER OLD COPTIC HORI
test(0x2CCD, 0x2CCC); // COPTIC SMALL LETTER OLD COPTIC HORI, COPTIC CAPITAL LETTER OLD COPTIC HORI
test(0x2CCE, 0x2CCF); // COPTIC CAPITAL LETTER OLD COPTIC HA, COPTIC SMALL LETTER OLD COPTIC HA
test(0x2CCF, 0x2CCE); // COPTIC SMALL LETTER OLD COPTIC HA, COPTIC CAPITAL LETTER OLD COPTIC HA
test(0x2CD0, 0x2CD1); // COPTIC CAPITAL LETTER L-SHAPED HA, COPTIC SMALL LETTER L-SHAPED HA
test(0x2CD1, 0x2CD0); // COPTIC SMALL LETTER L-SHAPED HA, COPTIC CAPITAL LETTER L-SHAPED HA
test(0x2CD2, 0x2CD3); // COPTIC CAPITAL LETTER OLD COPTIC HEI, COPTIC SMALL LETTER OLD COPTIC HEI
test(0x2CD3, 0x2CD2); // COPTIC SMALL LETTER OLD COPTIC HEI, COPTIC CAPITAL LETTER OLD COPTIC HEI
test(0x2CD4, 0x2CD5); // COPTIC CAPITAL LETTER OLD COPTIC HAT, COPTIC SMALL LETTER OLD COPTIC HAT
test(0x2CD5, 0x2CD4); // COPTIC SMALL LETTER OLD COPTIC HAT, COPTIC CAPITAL LETTER OLD COPTIC HAT
test(0x2CD6, 0x2CD7); // COPTIC CAPITAL LETTER OLD COPTIC GANGIA, COPTIC SMALL LETTER OLD COPTIC GANGIA
test(0x2CD7, 0x2CD6); // COPTIC SMALL LETTER OLD COPTIC GANGIA, COPTIC CAPITAL LETTER OLD COPTIC GANGIA
test(0x2CD8, 0x2CD9); // COPTIC CAPITAL LETTER OLD COPTIC DJA, COPTIC SMALL LETTER OLD COPTIC DJA
test(0x2CD9, 0x2CD8); // COPTIC SMALL LETTER OLD COPTIC DJA, COPTIC CAPITAL LETTER OLD COPTIC DJA
test(0x2CDA, 0x2CDB); // COPTIC CAPITAL LETTER OLD COPTIC SHIMA, COPTIC SMALL LETTER OLD COPTIC SHIMA
test(0x2CDB, 0x2CDA); // COPTIC SMALL LETTER OLD COPTIC SHIMA, COPTIC CAPITAL LETTER OLD COPTIC SHIMA
test(0x2CDC, 0x2CDD); // COPTIC CAPITAL LETTER OLD NUBIAN SHIMA, COPTIC SMALL LETTER OLD NUBIAN SHIMA
test(0x2CDD, 0x2CDC); // COPTIC SMALL LETTER OLD NUBIAN SHIMA, COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
test(0x2CDE, 0x2CDF); // COPTIC CAPITAL LETTER OLD NUBIAN NGI, COPTIC SMALL LETTER OLD NUBIAN NGI
test(0x2CDF, 0x2CDE); // COPTIC SMALL LETTER OLD NUBIAN NGI, COPTIC CAPITAL LETTER OLD NUBIAN NGI
test(0x2CE0, 0x2CE1); // COPTIC CAPITAL LETTER OLD NUBIAN NYI, COPTIC SMALL LETTER OLD NUBIAN NYI
test(0x2CE1, 0x2CE0); // COPTIC SMALL LETTER OLD NUBIAN NYI, COPTIC CAPITAL LETTER OLD NUBIAN NYI
test(0x2CE2, 0x2CE3); // COPTIC CAPITAL LETTER OLD NUBIAN WAU, COPTIC SMALL LETTER OLD NUBIAN WAU
test(0x2CE3, 0x2CE2); // COPTIC SMALL LETTER OLD NUBIAN WAU, COPTIC CAPITAL LETTER OLD NUBIAN WAU
test(0x2CEB, 0x2CEC); // COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI, COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI
test(0x2CEC, 0x2CEB); // COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI, COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
test(0x2CED, 0x2CEE); // COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA, COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
test(0x2CEE, 0x2CED); // COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA, COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
test(0x2CF2, 0x2CF3); // COPTIC CAPITAL LETTER BOHAIRIC KHEI, COPTIC SMALL LETTER BOHAIRIC KHEI
test(0x2CF3, 0x2CF2); // COPTIC SMALL LETTER BOHAIRIC KHEI, COPTIC CAPITAL LETTER BOHAIRIC KHEI
test(0x2D00, 0x10A0); // GEORGIAN SMALL LETTER AN, GEORGIAN CAPITAL LETTER AN
test(0x2D01, 0x10A1); // GEORGIAN SMALL LETTER BAN, GEORGIAN CAPITAL LETTER BAN
test(0x2D02, 0x10A2); // GEORGIAN SMALL LETTER GAN, GEORGIAN CAPITAL LETTER GAN
test(0x2D03, 0x10A3); // GEORGIAN SMALL LETTER DON, GEORGIAN CAPITAL LETTER DON
test(0x2D04, 0x10A4); // GEORGIAN SMALL LETTER EN, GEORGIAN CAPITAL LETTER EN
test(0x2D05, 0x10A5); // GEORGIAN SMALL LETTER VIN, GEORGIAN CAPITAL LETTER VIN
test(0x2D06, 0x10A6); // GEORGIAN SMALL LETTER ZEN, GEORGIAN CAPITAL LETTER ZEN
test(0x2D07, 0x10A7); // GEORGIAN SMALL LETTER TAN, GEORGIAN CAPITAL LETTER TAN
test(0x2D08, 0x10A8); // GEORGIAN SMALL LETTER IN, GEORGIAN CAPITAL LETTER IN
test(0x2D09, 0x10A9); // GEORGIAN SMALL LETTER KAN, GEORGIAN CAPITAL LETTER KAN
test(0x2D0A, 0x10AA); // GEORGIAN SMALL LETTER LAS, GEORGIAN CAPITAL LETTER LAS
test(0x2D0B, 0x10AB); // GEORGIAN SMALL LETTER MAN, GEORGIAN CAPITAL LETTER MAN
test(0x2D0C, 0x10AC); // GEORGIAN SMALL LETTER NAR, GEORGIAN CAPITAL LETTER NAR
test(0x2D0D, 0x10AD); // GEORGIAN SMALL LETTER ON, GEORGIAN CAPITAL LETTER ON
test(0x2D0E, 0x10AE); // GEORGIAN SMALL LETTER PAR, GEORGIAN CAPITAL LETTER PAR
test(0x2D0F, 0x10AF); // GEORGIAN SMALL LETTER ZHAR, GEORGIAN CAPITAL LETTER ZHAR
test(0x2D10, 0x10B0); // GEORGIAN SMALL LETTER RAE, GEORGIAN CAPITAL LETTER RAE
test(0x2D11, 0x10B1); // GEORGIAN SMALL LETTER SAN, GEORGIAN CAPITAL LETTER SAN
test(0x2D12, 0x10B2); // GEORGIAN SMALL LETTER TAR, GEORGIAN CAPITAL LETTER TAR
test(0x2D13, 0x10B3); // GEORGIAN SMALL LETTER UN, GEORGIAN CAPITAL LETTER UN
test(0x2D14, 0x10B4); // GEORGIAN SMALL LETTER PHAR, GEORGIAN CAPITAL LETTER PHAR
test(0x2D15, 0x10B5); // GEORGIAN SMALL LETTER KHAR, GEORGIAN CAPITAL LETTER KHAR
test(0x2D16, 0x10B6); // GEORGIAN SMALL LETTER GHAN, GEORGIAN CAPITAL LETTER GHAN
test(0x2D17, 0x10B7); // GEORGIAN SMALL LETTER QAR, GEORGIAN CAPITAL LETTER QAR
test(0x2D18, 0x10B8); // GEORGIAN SMALL LETTER SHIN, GEORGIAN CAPITAL LETTER SHIN
test(0x2D19, 0x10B9); // GEORGIAN SMALL LETTER CHIN, GEORGIAN CAPITAL LETTER CHIN
test(0x2D1A, 0x10BA); // GEORGIAN SMALL LETTER CAN, GEORGIAN CAPITAL LETTER CAN
test(0x2D1B, 0x10BB); // GEORGIAN SMALL LETTER JIL, GEORGIAN CAPITAL LETTER JIL
test(0x2D1C, 0x10BC); // GEORGIAN SMALL LETTER CIL, GEORGIAN CAPITAL LETTER CIL
test(0x2D1D, 0x10BD); // GEORGIAN SMALL LETTER CHAR, GEORGIAN CAPITAL LETTER CHAR
test(0x2D1E, 0x10BE); // GEORGIAN SMALL LETTER XAN, GEORGIAN CAPITAL LETTER XAN
test(0x2D1F, 0x10BF); // GEORGIAN SMALL LETTER JHAN, GEORGIAN CAPITAL LETTER JHAN
test(0x2D20, 0x10C0); // GEORGIAN SMALL LETTER HAE, GEORGIAN CAPITAL LETTER HAE
test(0x2D21, 0x10C1); // GEORGIAN SMALL LETTER HE, GEORGIAN CAPITAL LETTER HE
test(0x2D22, 0x10C2); // GEORGIAN SMALL LETTER HIE, GEORGIAN CAPITAL LETTER HIE
test(0x2D23, 0x10C3); // GEORGIAN SMALL LETTER WE, GEORGIAN CAPITAL LETTER WE
test(0x2D24, 0x10C4); // GEORGIAN SMALL LETTER HAR, GEORGIAN CAPITAL LETTER HAR
test(0x2D25, 0x10C5); // GEORGIAN SMALL LETTER HOE, GEORGIAN CAPITAL LETTER HOE
test(0x2D27, 0x10C7); // GEORGIAN SMALL LETTER YN, GEORGIAN CAPITAL LETTER YN
test(0x2D2D, 0x10CD); // GEORGIAN SMALL LETTER AEN, GEORGIAN CAPITAL LETTER AEN
test(0xA640, 0xA641); // CYRILLIC CAPITAL LETTER ZEMLYA, CYRILLIC SMALL LETTER ZEMLYA
test(0xA641, 0xA640); // CYRILLIC SMALL LETTER ZEMLYA, CYRILLIC CAPITAL LETTER ZEMLYA
test(0xA642, 0xA643); // CYRILLIC CAPITAL LETTER DZELO, CYRILLIC SMALL LETTER DZELO
test(0xA643, 0xA642); // CYRILLIC SMALL LETTER DZELO, CYRILLIC CAPITAL LETTER DZELO
test(0xA644, 0xA645); // CYRILLIC CAPITAL LETTER REVERSED DZE, CYRILLIC SMALL LETTER REVERSED DZE
test(0xA645, 0xA644); // CYRILLIC SMALL LETTER REVERSED DZE, CYRILLIC CAPITAL LETTER REVERSED DZE
test(0xA646, 0xA647); // CYRILLIC CAPITAL LETTER IOTA, CYRILLIC SMALL LETTER IOTA
test(0xA647, 0xA646); // CYRILLIC SMALL LETTER IOTA, CYRILLIC CAPITAL LETTER IOTA
test(0xA648, 0xA649); // CYRILLIC CAPITAL LETTER DJERV, CYRILLIC SMALL LETTER DJERV
test(0xA649, 0xA648); // CYRILLIC SMALL LETTER DJERV, CYRILLIC CAPITAL LETTER DJERV
test(0xA64A, 0xA64B, 0x1C88); // CYRILLIC CAPITAL LETTER MONOGRAPH UK, CYRILLIC SMALL LETTER MONOGRAPH UK, CYRILLIC SMALL LETTER UNBLENDED UK
test(0xA64B, 0x1C88, 0xA64A); // CYRILLIC SMALL LETTER MONOGRAPH UK, CYRILLIC SMALL LETTER UNBLENDED UK, CYRILLIC CAPITAL LETTER MONOGRAPH UK
test(0xA64C, 0xA64D); // CYRILLIC CAPITAL LETTER BROAD OMEGA, CYRILLIC SMALL LETTER BROAD OMEGA
test(0xA64D, 0xA64C); // CYRILLIC SMALL LETTER BROAD OMEGA, CYRILLIC CAPITAL LETTER BROAD OMEGA
test(0xA64E, 0xA64F); // CYRILLIC CAPITAL LETTER NEUTRAL YER, CYRILLIC SMALL LETTER NEUTRAL YER
test(0xA64F, 0xA64E); // CYRILLIC SMALL LETTER NEUTRAL YER, CYRILLIC CAPITAL LETTER NEUTRAL YER
test(0xA650, 0xA651); // CYRILLIC CAPITAL LETTER YERU WITH BACK YER, CYRILLIC SMALL LETTER YERU WITH BACK YER
test(0xA651, 0xA650); // CYRILLIC SMALL LETTER YERU WITH BACK YER, CYRILLIC CAPITAL LETTER YERU WITH BACK YER
test(0xA652, 0xA653); // CYRILLIC CAPITAL LETTER IOTIFIED YAT, CYRILLIC SMALL LETTER IOTIFIED YAT
test(0xA653, 0xA652); // CYRILLIC SMALL LETTER IOTIFIED YAT, CYRILLIC CAPITAL LETTER IOTIFIED YAT
test(0xA654, 0xA655); // CYRILLIC CAPITAL LETTER REVERSED YU, CYRILLIC SMALL LETTER REVERSED YU
test(0xA655, 0xA654); // CYRILLIC SMALL LETTER REVERSED YU, CYRILLIC CAPITAL LETTER REVERSED YU
test(0xA656, 0xA657); // CYRILLIC CAPITAL LETTER IOTIFIED A, CYRILLIC SMALL LETTER IOTIFIED A
test(0xA657, 0xA656); // CYRILLIC SMALL LETTER IOTIFIED A, CYRILLIC CAPITAL LETTER IOTIFIED A
test(0xA658, 0xA659); // CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS, CYRILLIC SMALL LETTER CLOSED LITTLE YUS
test(0xA659, 0xA658); // CYRILLIC SMALL LETTER CLOSED LITTLE YUS, CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
test(0xA65A, 0xA65B); // CYRILLIC CAPITAL LETTER BLENDED YUS, CYRILLIC SMALL LETTER BLENDED YUS
test(0xA65B, 0xA65A); // CYRILLIC SMALL LETTER BLENDED YUS, CYRILLIC CAPITAL LETTER BLENDED YUS
test(0xA65C, 0xA65D); // CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS, CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS
test(0xA65D, 0xA65C); // CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS, CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
test(0xA65E, 0xA65F); // CYRILLIC CAPITAL LETTER YN, CYRILLIC SMALL LETTER YN
test(0xA65F, 0xA65E); // CYRILLIC SMALL LETTER YN, CYRILLIC CAPITAL LETTER YN
test(0xA660, 0xA661); // CYRILLIC CAPITAL LETTER REVERSED TSE, CYRILLIC SMALL LETTER REVERSED TSE
test(0xA661, 0xA660); // CYRILLIC SMALL LETTER REVERSED TSE, CYRILLIC CAPITAL LETTER REVERSED TSE
test(0xA662, 0xA663); // CYRILLIC CAPITAL LETTER SOFT DE, CYRILLIC SMALL LETTER SOFT DE
test(0xA663, 0xA662); // CYRILLIC SMALL LETTER SOFT DE, CYRILLIC CAPITAL LETTER SOFT DE
test(0xA664, 0xA665); // CYRILLIC CAPITAL LETTER SOFT EL, CYRILLIC SMALL LETTER SOFT EL
test(0xA665, 0xA664); // CYRILLIC SMALL LETTER SOFT EL, CYRILLIC CAPITAL LETTER SOFT EL
test(0xA666, 0xA667); // CYRILLIC CAPITAL LETTER SOFT EM, CYRILLIC SMALL LETTER SOFT EM
test(0xA667, 0xA666); // CYRILLIC SMALL LETTER SOFT EM, CYRILLIC CAPITAL LETTER SOFT EM
test(0xA668, 0xA669); // CYRILLIC CAPITAL LETTER MONOCULAR O, CYRILLIC SMALL LETTER MONOCULAR O
test(0xA669, 0xA668); // CYRILLIC SMALL LETTER MONOCULAR O, CYRILLIC CAPITAL LETTER MONOCULAR O
test(0xA66A, 0xA66B); // CYRILLIC CAPITAL LETTER BINOCULAR O, CYRILLIC SMALL LETTER BINOCULAR O
test(0xA66B, 0xA66A); // CYRILLIC SMALL LETTER BINOCULAR O, CYRILLIC CAPITAL LETTER BINOCULAR O
test(0xA66C, 0xA66D); // CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O, CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
test(0xA66D, 0xA66C); // CYRILLIC SMALL LETTER DOUBLE MONOCULAR O, CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
test(0xA680, 0xA681); // CYRILLIC CAPITAL LETTER DWE, CYRILLIC SMALL LETTER DWE
test(0xA681, 0xA680); // CYRILLIC SMALL LETTER DWE, CYRILLIC CAPITAL LETTER DWE
test(0xA682, 0xA683); // CYRILLIC CAPITAL LETTER DZWE, CYRILLIC SMALL LETTER DZWE
test(0xA683, 0xA682); // CYRILLIC SMALL LETTER DZWE, CYRILLIC CAPITAL LETTER DZWE
test(0xA684, 0xA685); // CYRILLIC CAPITAL LETTER ZHWE, CYRILLIC SMALL LETTER ZHWE
test(0xA685, 0xA684); // CYRILLIC SMALL LETTER ZHWE, CYRILLIC CAPITAL LETTER ZHWE
test(0xA686, 0xA687); // CYRILLIC CAPITAL LETTER CCHE, CYRILLIC SMALL LETTER CCHE
test(0xA687, 0xA686); // CYRILLIC SMALL LETTER CCHE, CYRILLIC CAPITAL LETTER CCHE
test(0xA688, 0xA689); // CYRILLIC CAPITAL LETTER DZZE, CYRILLIC SMALL LETTER DZZE
test(0xA689, 0xA688); // CYRILLIC SMALL LETTER DZZE, CYRILLIC CAPITAL LETTER DZZE
test(0xA68A, 0xA68B); // CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK, CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
test(0xA68B, 0xA68A); // CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK, CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
test(0xA68C, 0xA68D); // CYRILLIC CAPITAL LETTER TWE, CYRILLIC SMALL LETTER TWE
test(0xA68D, 0xA68C); // CYRILLIC SMALL LETTER TWE, CYRILLIC CAPITAL LETTER TWE
test(0xA68E, 0xA68F); // CYRILLIC CAPITAL LETTER TSWE, CYRILLIC SMALL LETTER TSWE
test(0xA68F, 0xA68E); // CYRILLIC SMALL LETTER TSWE, CYRILLIC CAPITAL LETTER TSWE
test(0xA690, 0xA691); // CYRILLIC CAPITAL LETTER TSSE, CYRILLIC SMALL LETTER TSSE
test(0xA691, 0xA690); // CYRILLIC SMALL LETTER TSSE, CYRILLIC CAPITAL LETTER TSSE
test(0xA692, 0xA693); // CYRILLIC CAPITAL LETTER TCHE, CYRILLIC SMALL LETTER TCHE
test(0xA693, 0xA692); // CYRILLIC SMALL LETTER TCHE, CYRILLIC CAPITAL LETTER TCHE
test(0xA694, 0xA695); // CYRILLIC CAPITAL LETTER HWE, CYRILLIC SMALL LETTER HWE
test(0xA695, 0xA694); // CYRILLIC SMALL LETTER HWE, CYRILLIC CAPITAL LETTER HWE
test(0xA696, 0xA697); // CYRILLIC CAPITAL LETTER SHWE, CYRILLIC SMALL LETTER SHWE
test(0xA697, 0xA696); // CYRILLIC SMALL LETTER SHWE, CYRILLIC CAPITAL LETTER SHWE
test(0xA698, 0xA699); // CYRILLIC CAPITAL LETTER DOUBLE O, CYRILLIC SMALL LETTER DOUBLE O
test(0xA699, 0xA698); // CYRILLIC SMALL LETTER DOUBLE O, CYRILLIC CAPITAL LETTER DOUBLE O
test(0xA69A, 0xA69B); // CYRILLIC CAPITAL LETTER CROSSED O, CYRILLIC SMALL LETTER CROSSED O
test(0xA69B, 0xA69A); // CYRILLIC SMALL LETTER CROSSED O, CYRILLIC CAPITAL LETTER CROSSED O
test(0xA722, 0xA723); // LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF, LATIN SMALL LETTER EGYPTOLOGICAL ALEF
test(0xA723, 0xA722); // LATIN SMALL LETTER EGYPTOLOGICAL ALEF, LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
test(0xA724, 0xA725); // LATIN CAPITAL LETTER EGYPTOLOGICAL AIN, LATIN SMALL LETTER EGYPTOLOGICAL AIN
test(0xA725, 0xA724); // LATIN SMALL LETTER EGYPTOLOGICAL AIN, LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
test(0xA726, 0xA727); // LATIN CAPITAL LETTER HENG, LATIN SMALL LETTER HENG
test(0xA727, 0xA726); // LATIN SMALL LETTER HENG, LATIN CAPITAL LETTER HENG
test(0xA728, 0xA729); // LATIN CAPITAL LETTER TZ, LATIN SMALL LETTER TZ
test(0xA729, 0xA728); // LATIN SMALL LETTER TZ, LATIN CAPITAL LETTER TZ
test(0xA72A, 0xA72B); // LATIN CAPITAL LETTER TRESILLO, LATIN SMALL LETTER TRESILLO
test(0xA72B, 0xA72A); // LATIN SMALL LETTER TRESILLO, LATIN CAPITAL LETTER TRESILLO
test(0xA72C, 0xA72D); // LATIN CAPITAL LETTER CUATRILLO, LATIN SMALL LETTER CUATRILLO
test(0xA72D, 0xA72C); // LATIN SMALL LETTER CUATRILLO, LATIN CAPITAL LETTER CUATRILLO
test(0xA72E, 0xA72F); // LATIN CAPITAL LETTER CUATRILLO WITH COMMA, LATIN SMALL LETTER CUATRILLO WITH COMMA
test(0xA72F, 0xA72E); // LATIN SMALL LETTER CUATRILLO WITH COMMA, LATIN CAPITAL LETTER CUATRILLO WITH COMMA
test(0xA732, 0xA733); // LATIN CAPITAL LETTER AA, LATIN SMALL LETTER AA
test(0xA733, 0xA732); // LATIN SMALL LETTER AA, LATIN CAPITAL LETTER AA
test(0xA734, 0xA735); // LATIN CAPITAL LETTER AO, LATIN SMALL LETTER AO
test(0xA735, 0xA734); // LATIN SMALL LETTER AO, LATIN CAPITAL LETTER AO
test(0xA736, 0xA737); // LATIN CAPITAL LETTER AU, LATIN SMALL LETTER AU
test(0xA737, 0xA736); // LATIN SMALL LETTER AU, LATIN CAPITAL LETTER AU
test(0xA738, 0xA739); // LATIN CAPITAL LETTER AV, LATIN SMALL LETTER AV
test(0xA739, 0xA738); // LATIN SMALL LETTER AV, LATIN CAPITAL LETTER AV
test(0xA73A, 0xA73B); // LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR, LATIN SMALL LETTER AV WITH HORIZONTAL BAR
test(0xA73B, 0xA73A); // LATIN SMALL LETTER AV WITH HORIZONTAL BAR, LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
test(0xA73C, 0xA73D); // LATIN CAPITAL LETTER AY, LATIN SMALL LETTER AY
test(0xA73D, 0xA73C); // LATIN SMALL LETTER AY, LATIN CAPITAL LETTER AY
test(0xA73E, 0xA73F); // LATIN CAPITAL LETTER REVERSED C WITH DOT, LATIN SMALL LETTER REVERSED C WITH DOT
test(0xA73F, 0xA73E); // LATIN SMALL LETTER REVERSED C WITH DOT, LATIN CAPITAL LETTER REVERSED C WITH DOT
test(0xA740, 0xA741); // LATIN CAPITAL LETTER K WITH STROKE, LATIN SMALL LETTER K WITH STROKE
test(0xA741, 0xA740); // LATIN SMALL LETTER K WITH STROKE, LATIN CAPITAL LETTER K WITH STROKE
test(0xA742, 0xA743); // LATIN CAPITAL LETTER K WITH DIAGONAL STROKE, LATIN SMALL LETTER K WITH DIAGONAL STROKE
test(0xA743, 0xA742); // LATIN SMALL LETTER K WITH DIAGONAL STROKE, LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
test(0xA744, 0xA745); // LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE, LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE
test(0xA745, 0xA744); // LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE, LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
test(0xA746, 0xA747); // LATIN CAPITAL LETTER BROKEN L, LATIN SMALL LETTER BROKEN L
test(0xA747, 0xA746); // LATIN SMALL LETTER BROKEN L, LATIN CAPITAL LETTER BROKEN L
test(0xA748, 0xA749); // LATIN CAPITAL LETTER L WITH HIGH STROKE, LATIN SMALL LETTER L WITH HIGH STROKE
test(0xA749, 0xA748); // LATIN SMALL LETTER L WITH HIGH STROKE, LATIN CAPITAL LETTER L WITH HIGH STROKE
test(0xA74A, 0xA74B); // LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY, LATIN SMALL LETTER O WITH LONG STROKE OVERLAY
test(0xA74B, 0xA74A); // LATIN SMALL LETTER O WITH LONG STROKE OVERLAY, LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
test(0xA74C, 0xA74D); // LATIN CAPITAL LETTER O WITH LOOP, LATIN SMALL LETTER O WITH LOOP
test(0xA74D, 0xA74C); // LATIN SMALL LETTER O WITH LOOP, LATIN CAPITAL LETTER O WITH LOOP
test(0xA74E, 0xA74F); // LATIN CAPITAL LETTER OO, LATIN SMALL LETTER OO
test(0xA74F, 0xA74E); // LATIN SMALL LETTER OO, LATIN CAPITAL LETTER OO
test(0xA750, 0xA751); // LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER, LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER
test(0xA751, 0xA750); // LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER, LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
test(0xA752, 0xA753); // LATIN CAPITAL LETTER P WITH FLOURISH, LATIN SMALL LETTER P WITH FLOURISH
test(0xA753, 0xA752); // LATIN SMALL LETTER P WITH FLOURISH, LATIN CAPITAL LETTER P WITH FLOURISH
test(0xA754, 0xA755); // LATIN CAPITAL LETTER P WITH SQUIRREL TAIL, LATIN SMALL LETTER P WITH SQUIRREL TAIL
test(0xA755, 0xA754); // LATIN SMALL LETTER P WITH SQUIRREL TAIL, LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
test(0xA756, 0xA757); // LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER, LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER
test(0xA757, 0xA756); // LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER, LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
test(0xA758, 0xA759); // LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE, LATIN SMALL LETTER Q WITH DIAGONAL STROKE
test(0xA759, 0xA758); // LATIN SMALL LETTER Q WITH DIAGONAL STROKE, LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
test(0xA75A, 0xA75B); // LATIN CAPITAL LETTER R ROTUNDA, LATIN SMALL LETTER R ROTUNDA
test(0xA75B, 0xA75A); // LATIN SMALL LETTER R ROTUNDA, LATIN CAPITAL LETTER R ROTUNDA
test(0xA75C, 0xA75D); // LATIN CAPITAL LETTER RUM ROTUNDA, LATIN SMALL LETTER RUM ROTUNDA
test(0xA75D, 0xA75C); // LATIN SMALL LETTER RUM ROTUNDA, LATIN CAPITAL LETTER RUM ROTUNDA
test(0xA75E, 0xA75F); // LATIN CAPITAL LETTER V WITH DIAGONAL STROKE, LATIN SMALL LETTER V WITH DIAGONAL STROKE
test(0xA75F, 0xA75E); // LATIN SMALL LETTER V WITH DIAGONAL STROKE, LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
test(0xA760, 0xA761); // LATIN CAPITAL LETTER VY, LATIN SMALL LETTER VY
test(0xA761, 0xA760); // LATIN SMALL LETTER VY, LATIN CAPITAL LETTER VY
test(0xA762, 0xA763); // LATIN CAPITAL LETTER VISIGOTHIC Z, LATIN SMALL LETTER VISIGOTHIC Z
test(0xA763, 0xA762); // LATIN SMALL LETTER VISIGOTHIC Z, LATIN CAPITAL LETTER VISIGOTHIC Z
test(0xA764, 0xA765); // LATIN CAPITAL LETTER THORN WITH STROKE, LATIN SMALL LETTER THORN WITH STROKE
test(0xA765, 0xA764); // LATIN SMALL LETTER THORN WITH STROKE, LATIN CAPITAL LETTER THORN WITH STROKE
test(0xA766, 0xA767); // LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER, LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER
test(0xA767, 0xA766); // LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER, LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
test(0xA768, 0xA769); // LATIN CAPITAL LETTER VEND, LATIN SMALL LETTER VEND
test(0xA769, 0xA768); // LATIN SMALL LETTER VEND, LATIN CAPITAL LETTER VEND
test(0xA76A, 0xA76B); // LATIN CAPITAL LETTER ET, LATIN SMALL LETTER ET
test(0xA76B, 0xA76A); // LATIN SMALL LETTER ET, LATIN CAPITAL LETTER ET
test(0xA76C, 0xA76D); // LATIN CAPITAL LETTER IS, LATIN SMALL LETTER IS
test(0xA76D, 0xA76C); // LATIN SMALL LETTER IS, LATIN CAPITAL LETTER IS
test(0xA76E, 0xA76F); // LATIN CAPITAL LETTER CON, LATIN SMALL LETTER CON
test(0xA76F, 0xA76E); // LATIN SMALL LETTER CON, LATIN CAPITAL LETTER CON
test(0xA779, 0xA77A); // LATIN CAPITAL LETTER INSULAR D, LATIN SMALL LETTER INSULAR D
test(0xA77A, 0xA779); // LATIN SMALL LETTER INSULAR D, LATIN CAPITAL LETTER INSULAR D
test(0xA77B, 0xA77C); // LATIN CAPITAL LETTER INSULAR F, LATIN SMALL LETTER INSULAR F
test(0xA77C, 0xA77B); // LATIN SMALL LETTER INSULAR F, LATIN CAPITAL LETTER INSULAR F
test(0xA77D, 0x1D79); // LATIN CAPITAL LETTER INSULAR G, LATIN SMALL LETTER INSULAR G
test(0xA77E, 0xA77F); // LATIN CAPITAL LETTER TURNED INSULAR G, LATIN SMALL LETTER TURNED INSULAR G
test(0xA77F, 0xA77E); // LATIN SMALL LETTER TURNED INSULAR G, LATIN CAPITAL LETTER TURNED INSULAR G
test(0xA780, 0xA781); // LATIN CAPITAL LETTER TURNED L, LATIN SMALL LETTER TURNED L
test(0xA781, 0xA780); // LATIN SMALL LETTER TURNED L, LATIN CAPITAL LETTER TURNED L
test(0xA782, 0xA783); // LATIN CAPITAL LETTER INSULAR R, LATIN SMALL LETTER INSULAR R
test(0xA783, 0xA782); // LATIN SMALL LETTER INSULAR R, LATIN CAPITAL LETTER INSULAR R
test(0xA784, 0xA785); // LATIN CAPITAL LETTER INSULAR S, LATIN SMALL LETTER INSULAR S
test(0xA785, 0xA784); // LATIN SMALL LETTER INSULAR S, LATIN CAPITAL LETTER INSULAR S
test(0xA786, 0xA787); // LATIN CAPITAL LETTER INSULAR T, LATIN SMALL LETTER INSULAR T
test(0xA787, 0xA786); // LATIN SMALL LETTER INSULAR T, LATIN CAPITAL LETTER INSULAR T
test(0xA78B, 0xA78C); // LATIN CAPITAL LETTER SALTILLO, LATIN SMALL LETTER SALTILLO
test(0xA78C, 0xA78B); // LATIN SMALL LETTER SALTILLO, LATIN CAPITAL LETTER SALTILLO
test(0xA78D, 0x0265); // LATIN CAPITAL LETTER TURNED H, LATIN SMALL LETTER TURNED H
test(0xA790, 0xA791); // LATIN CAPITAL LETTER N WITH DESCENDER, LATIN SMALL LETTER N WITH DESCENDER
test(0xA791, 0xA790); // LATIN SMALL LETTER N WITH DESCENDER, LATIN CAPITAL LETTER N WITH DESCENDER
test(0xA792, 0xA793); // LATIN CAPITAL LETTER C WITH BAR, LATIN SMALL LETTER C WITH BAR
test(0xA793, 0xA792); // LATIN SMALL LETTER C WITH BAR, LATIN CAPITAL LETTER C WITH BAR
test(0xA794, 0xA7C4); // LATIN SMALL LETTER C WITH PALATAL HOOK, LATIN CAPITAL LETTER C WITH PALATAL HOOK
test(0xA796, 0xA797); // LATIN CAPITAL LETTER B WITH FLOURISH, LATIN SMALL LETTER B WITH FLOURISH
test(0xA797, 0xA796); // LATIN SMALL LETTER B WITH FLOURISH, LATIN CAPITAL LETTER B WITH FLOURISH
test(0xA798, 0xA799); // LATIN CAPITAL LETTER F WITH STROKE, LATIN SMALL LETTER F WITH STROKE
test(0xA799, 0xA798); // LATIN SMALL LETTER F WITH STROKE, LATIN CAPITAL LETTER F WITH STROKE
test(0xA79A, 0xA79B); // LATIN CAPITAL LETTER VOLAPUK AE, LATIN SMALL LETTER VOLAPUK AE
test(0xA79B, 0xA79A); // LATIN SMALL LETTER VOLAPUK AE, LATIN CAPITAL LETTER VOLAPUK AE
test(0xA79C, 0xA79D); // LATIN CAPITAL LETTER VOLAPUK OE, LATIN SMALL LETTER VOLAPUK OE
test(0xA79D, 0xA79C); // LATIN SMALL LETTER VOLAPUK OE, LATIN CAPITAL LETTER VOLAPUK OE
test(0xA79E, 0xA79F); // LATIN CAPITAL LETTER VOLAPUK UE, LATIN SMALL LETTER VOLAPUK UE
test(0xA79F, 0xA79E); // LATIN SMALL LETTER VOLAPUK UE, LATIN CAPITAL LETTER VOLAPUK UE
test(0xA7A0, 0xA7A1); // LATIN CAPITAL LETTER G WITH OBLIQUE STROKE, LATIN SMALL LETTER G WITH OBLIQUE STROKE
test(0xA7A1, 0xA7A0); // LATIN SMALL LETTER G WITH OBLIQUE STROKE, LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
test(0xA7A2, 0xA7A3); // LATIN CAPITAL LETTER K WITH OBLIQUE STROKE, LATIN SMALL LETTER K WITH OBLIQUE STROKE
test(0xA7A3, 0xA7A2); // LATIN SMALL LETTER K WITH OBLIQUE STROKE, LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
test(0xA7A4, 0xA7A5); // LATIN CAPITAL LETTER N WITH OBLIQUE STROKE, LATIN SMALL LETTER N WITH OBLIQUE STROKE
test(0xA7A5, 0xA7A4); // LATIN SMALL LETTER N WITH OBLIQUE STROKE, LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
test(0xA7A6, 0xA7A7); // LATIN CAPITAL LETTER R WITH OBLIQUE STROKE, LATIN SMALL LETTER R WITH OBLIQUE STROKE
test(0xA7A7, 0xA7A6); // LATIN SMALL LETTER R WITH OBLIQUE STROKE, LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
test(0xA7A8, 0xA7A9); // LATIN CAPITAL LETTER S WITH OBLIQUE STROKE, LATIN SMALL LETTER S WITH OBLIQUE STROKE
test(0xA7A9, 0xA7A8); // LATIN SMALL LETTER S WITH OBLIQUE STROKE, LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
test(0xA7AA, 0x0266); // LATIN CAPITAL LETTER H WITH HOOK, LATIN SMALL LETTER H WITH HOOK (LATIN SMALL LETTER H HOOK)
test(0xA7AB, 0x025C); // LATIN CAPITAL LETTER REVERSED OPEN E, LATIN SMALL LETTER REVERSED OPEN E (LATIN SMALL LETTER REVERSED EPSILON)
test(0xA7AC, 0x0261); // LATIN CAPITAL LETTER SCRIPT G, LATIN SMALL LETTER SCRIPT G
test(0xA7AD, 0x026C); // LATIN CAPITAL LETTER L WITH BELT, LATIN SMALL LETTER L WITH BELT (LATIN SMALL LETTER L BELT)
test(0xA7AE, 0x026A); // LATIN CAPITAL LETTER SMALL CAPITAL I, LATIN LETTER SMALL CAPITAL I
test(0xA7B0, 0x029E); // LATIN CAPITAL LETTER TURNED K, LATIN SMALL LETTER TURNED K
test(0xA7B1, 0x0287); // LATIN CAPITAL LETTER TURNED T, LATIN SMALL LETTER TURNED T
test(0xA7B2, 0x029D); // LATIN CAPITAL LETTER J WITH CROSSED-TAIL, LATIN SMALL LETTER J WITH CROSSED-TAIL (LATIN SMALL LETTER CROSSED-TAIL J)
test(0xA7B3, 0xAB53); // LATIN CAPITAL LETTER CHI, LATIN SMALL LETTER CHI
test(0xA7B4, 0xA7B5); // LATIN CAPITAL LETTER BETA, LATIN SMALL LETTER BETA
test(0xA7B5, 0xA7B4); // LATIN SMALL LETTER BETA, LATIN CAPITAL LETTER BETA
test(0xA7B6, 0xA7B7); // LATIN CAPITAL LETTER OMEGA, LATIN SMALL LETTER OMEGA
test(0xA7B7, 0xA7B6); // LATIN SMALL LETTER OMEGA, LATIN CAPITAL LETTER OMEGA
test(0xA7B8, 0xA7B9); // LATIN CAPITAL LETTER U WITH STROKE, LATIN SMALL LETTER U WITH STROKE
test(0xA7B9, 0xA7B8); // LATIN SMALL LETTER U WITH STROKE, LATIN CAPITAL LETTER U WITH STROKE
test(0xA7BA, 0xA7BB); // LATIN CAPITAL LETTER GLOTTAL A, LATIN SMALL LETTER GLOTTAL A
test(0xA7BB, 0xA7BA); // LATIN SMALL LETTER GLOTTAL A, LATIN CAPITAL LETTER GLOTTAL A
test(0xA7BC, 0xA7BD); // LATIN CAPITAL LETTER GLOTTAL I, LATIN SMALL LETTER GLOTTAL I
test(0xA7BD, 0xA7BC); // LATIN SMALL LETTER GLOTTAL I, LATIN CAPITAL LETTER GLOTTAL I
test(0xA7BE, 0xA7BF); // LATIN CAPITAL LETTER GLOTTAL U, LATIN SMALL LETTER GLOTTAL U
test(0xA7BF, 0xA7BE); // LATIN SMALL LETTER GLOTTAL U, LATIN CAPITAL LETTER GLOTTAL U
test(0xA7C0, 0xA7C1); // LATIN CAPITAL LETTER OLD POLISH O, LATIN SMALL LETTER OLD POLISH O
test(0xA7C1, 0xA7C0); // LATIN SMALL LETTER OLD POLISH O, LATIN CAPITAL LETTER OLD POLISH O
test(0xA7C2, 0xA7C3); // LATIN CAPITAL LETTER ANGLICANA W, LATIN SMALL LETTER ANGLICANA W
test(0xA7C3, 0xA7C2); // LATIN SMALL LETTER ANGLICANA W, LATIN CAPITAL LETTER ANGLICANA W
test(0xA7C4, 0xA794); // LATIN CAPITAL LETTER C WITH PALATAL HOOK, LATIN SMALL LETTER C WITH PALATAL HOOK
test(0xA7C5, 0x0282); // LATIN CAPITAL LETTER S WITH HOOK, LATIN SMALL LETTER S WITH HOOK (LATIN SMALL LETTER S HOOK)
test(0xA7C6, 0x1D8E); // LATIN CAPITAL LETTER Z WITH PALATAL HOOK, LATIN SMALL LETTER Z WITH PALATAL HOOK
test(0xA7C7, 0xA7C8); // LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY, LATIN SMALL LETTER D WITH SHORT STROKE OVERLAY
test(0xA7C8, 0xA7C7); // LATIN SMALL LETTER D WITH SHORT STROKE OVERLAY, LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY
test(0xA7C9, 0xA7CA); // LATIN CAPITAL LETTER S WITH SHORT STROKE OVERLAY, LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY
test(0xA7CA, 0xA7C9); // LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY, LATIN CAPITAL LETTER S WITH SHORT STROKE OVERLAY
test(0xA7CB, 0x0264); // LATIN CAPITAL LETTER RAMS HORN, LATIN SMALL LETTER RAMS HORN (LATIN SMALL LETTER BABY GAMMA)
test(0xA7CC, 0xA7CD); // LATIN CAPITAL LETTER S WITH DIAGONAL STROKE, LATIN SMALL LETTER S WITH DIAGONAL STROKE
test(0xA7CD, 0xA7CC); // LATIN SMALL LETTER S WITH DIAGONAL STROKE, LATIN CAPITAL LETTER S WITH DIAGONAL STROKE
test(0xA7CE, 0xA7CF); // LATIN CAPITAL LETTER PHARYNGEAL VOICED FRICATIVE, LATIN SMALL LETTER PHARYNGEAL VOICED FRICATIVE
test(0xA7CF, 0xA7CE); // LATIN SMALL LETTER PHARYNGEAL VOICED FRICATIVE, LATIN CAPITAL LETTER PHARYNGEAL VOICED FRICATIVE
test(0xA7D0, 0xA7D1); // LATIN CAPITAL LETTER CLOSED INSULAR G, LATIN SMALL LETTER CLOSED INSULAR G
test(0xA7D1, 0xA7D0); // LATIN SMALL LETTER CLOSED INSULAR G, LATIN CAPITAL LETTER CLOSED INSULAR G
test(0xA7D2, 0xA7D3); // LATIN CAPITAL LETTER DOUBLE THORN, LATIN SMALL LETTER DOUBLE THORN
test(0xA7D3, 0xA7D2); // LATIN SMALL LETTER DOUBLE THORN, LATIN CAPITAL LETTER DOUBLE THORN
test(0xA7D4, 0xA7D5); // LATIN CAPITAL LETTER DOUBLE WYNN, LATIN SMALL LETTER DOUBLE WYNN
test(0xA7D5, 0xA7D4); // LATIN SMALL LETTER DOUBLE WYNN, LATIN CAPITAL LETTER DOUBLE WYNN
test(0xA7D6, 0xA7D7); // LATIN CAPITAL LETTER MIDDLE SCOTS S, LATIN SMALL LETTER MIDDLE SCOTS S
test(0xA7D7, 0xA7D6); // LATIN SMALL LETTER MIDDLE SCOTS S, LATIN CAPITAL LETTER MIDDLE SCOTS S
test(0xA7D8, 0xA7D9); // LATIN CAPITAL LETTER SIGMOID S, LATIN SMALL LETTER SIGMOID S
test(0xA7D9, 0xA7D8); // LATIN SMALL LETTER SIGMOID S, LATIN CAPITAL LETTER SIGMOID S
test(0xA7DA, 0xA7DB); // LATIN CAPITAL LETTER LAMBDA, LATIN SMALL LETTER LAMBDA
test(0xA7DB, 0xA7DA); // LATIN SMALL LETTER LAMBDA, LATIN CAPITAL LETTER LAMBDA
test(0xA7DC, 0x019B); // LATIN CAPITAL LETTER LAMBDA WITH STROKE, LATIN SMALL LETTER LAMBDA WITH STROKE (LATIN SMALL LETTER BARRED LAMBDA)
test(0xA7F5, 0xA7F6); // LATIN CAPITAL LETTER REVERSED HALF H, LATIN SMALL LETTER REVERSED HALF H
test(0xA7F6, 0xA7F5); // LATIN SMALL LETTER REVERSED HALF H, LATIN CAPITAL LETTER REVERSED HALF H
test(0xAB53, 0xA7B3); // LATIN SMALL LETTER CHI, LATIN CAPITAL LETTER CHI
test(0xAB70, 0x13A0); // CHEROKEE SMALL LETTER A, CHEROKEE LETTER A
test(0xAB71, 0x13A1); // CHEROKEE SMALL LETTER E, CHEROKEE LETTER E
test(0xAB72, 0x13A2); // CHEROKEE SMALL LETTER I, CHEROKEE LETTER I
test(0xAB73, 0x13A3); // CHEROKEE SMALL LETTER O, CHEROKEE LETTER O
test(0xAB74, 0x13A4); // CHEROKEE SMALL LETTER U, CHEROKEE LETTER U
test(0xAB75, 0x13A5); // CHEROKEE SMALL LETTER V, CHEROKEE LETTER V
test(0xAB76, 0x13A6); // CHEROKEE SMALL LETTER GA, CHEROKEE LETTER GA
test(0xAB77, 0x13A7); // CHEROKEE SMALL LETTER KA, CHEROKEE LETTER KA
test(0xAB78, 0x13A8); // CHEROKEE SMALL LETTER GE, CHEROKEE LETTER GE
test(0xAB79, 0x13A9); // CHEROKEE SMALL LETTER GI, CHEROKEE LETTER GI
test(0xAB7A, 0x13AA); // CHEROKEE SMALL LETTER GO, CHEROKEE LETTER GO
test(0xAB7B, 0x13AB); // CHEROKEE SMALL LETTER GU, CHEROKEE LETTER GU
test(0xAB7C, 0x13AC); // CHEROKEE SMALL LETTER GV, CHEROKEE LETTER GV
test(0xAB7D, 0x13AD); // CHEROKEE SMALL LETTER HA, CHEROKEE LETTER HA
test(0xAB7E, 0x13AE); // CHEROKEE SMALL LETTER HE, CHEROKEE LETTER HE
test(0xAB7F, 0x13AF); // CHEROKEE SMALL LETTER HI, CHEROKEE LETTER HI
test(0xAB80, 0x13B0); // CHEROKEE SMALL LETTER HO, CHEROKEE LETTER HO
test(0xAB81, 0x13B1); // CHEROKEE SMALL LETTER HU, CHEROKEE LETTER HU
test(0xAB82, 0x13B2); // CHEROKEE SMALL LETTER HV, CHEROKEE LETTER HV
test(0xAB83, 0x13B3); // CHEROKEE SMALL LETTER LA, CHEROKEE LETTER LA
test(0xAB84, 0x13B4); // CHEROKEE SMALL LETTER LE, CHEROKEE LETTER LE
test(0xAB85, 0x13B5); // CHEROKEE SMALL LETTER LI, CHEROKEE LETTER LI
test(0xAB86, 0x13B6); // CHEROKEE SMALL LETTER LO, CHEROKEE LETTER LO
test(0xAB87, 0x13B7); // CHEROKEE SMALL LETTER LU, CHEROKEE LETTER LU
test(0xAB88, 0x13B8); // CHEROKEE SMALL LETTER LV, CHEROKEE LETTER LV
test(0xAB89, 0x13B9); // CHEROKEE SMALL LETTER MA, CHEROKEE LETTER MA
test(0xAB8A, 0x13BA); // CHEROKEE SMALL LETTER ME, CHEROKEE LETTER ME
test(0xAB8B, 0x13BB); // CHEROKEE SMALL LETTER MI, CHEROKEE LETTER MI
test(0xAB8C, 0x13BC); // CHEROKEE SMALL LETTER MO, CHEROKEE LETTER MO
test(0xAB8D, 0x13BD); // CHEROKEE SMALL LETTER MU, CHEROKEE LETTER MU
test(0xAB8E, 0x13BE); // CHEROKEE SMALL LETTER NA, CHEROKEE LETTER NA
test(0xAB8F, 0x13BF); // CHEROKEE SMALL LETTER HNA, CHEROKEE LETTER HNA
test(0xAB90, 0x13C0); // CHEROKEE SMALL LETTER NAH, CHEROKEE LETTER NAH
test(0xAB91, 0x13C1); // CHEROKEE SMALL LETTER NE, CHEROKEE LETTER NE
test(0xAB92, 0x13C2); // CHEROKEE SMALL LETTER NI, CHEROKEE LETTER NI
test(0xAB93, 0x13C3); // CHEROKEE SMALL LETTER NO, CHEROKEE LETTER NO
test(0xAB94, 0x13C4); // CHEROKEE SMALL LETTER NU, CHEROKEE LETTER NU
test(0xAB95, 0x13C5); // CHEROKEE SMALL LETTER NV, CHEROKEE LETTER NV
test(0xAB96, 0x13C6); // CHEROKEE SMALL LETTER QUA, CHEROKEE LETTER QUA
test(0xAB97, 0x13C7); // CHEROKEE SMALL LETTER QUE, CHEROKEE LETTER QUE
test(0xAB98, 0x13C8); // CHEROKEE SMALL LETTER QUI, CHEROKEE LETTER QUI
test(0xAB99, 0x13C9); // CHEROKEE SMALL LETTER QUO, CHEROKEE LETTER QUO
test(0xAB9A, 0x13CA); // CHEROKEE SMALL LETTER QUU, CHEROKEE LETTER QUU
test(0xAB9B, 0x13CB); // CHEROKEE SMALL LETTER QUV, CHEROKEE LETTER QUV
test(0xAB9C, 0x13CC); // CHEROKEE SMALL LETTER SA, CHEROKEE LETTER SA
test(0xAB9D, 0x13CD); // CHEROKEE SMALL LETTER S, CHEROKEE LETTER S
test(0xAB9E, 0x13CE); // CHEROKEE SMALL LETTER SE, CHEROKEE LETTER SE
test(0xAB9F, 0x13CF); // CHEROKEE SMALL LETTER SI, CHEROKEE LETTER SI
test(0xABA0, 0x13D0); // CHEROKEE SMALL LETTER SO, CHEROKEE LETTER SO
test(0xABA1, 0x13D1); // CHEROKEE SMALL LETTER SU, CHEROKEE LETTER SU
test(0xABA2, 0x13D2); // CHEROKEE SMALL LETTER SV, CHEROKEE LETTER SV
test(0xABA3, 0x13D3); // CHEROKEE SMALL LETTER DA, CHEROKEE LETTER DA
test(0xABA4, 0x13D4); // CHEROKEE SMALL LETTER TA, CHEROKEE LETTER TA
test(0xABA5, 0x13D5); // CHEROKEE SMALL LETTER DE, CHEROKEE LETTER DE
test(0xABA6, 0x13D6); // CHEROKEE SMALL LETTER TE, CHEROKEE LETTER TE
test(0xABA7, 0x13D7); // CHEROKEE SMALL LETTER DI, CHEROKEE LETTER DI
test(0xABA8, 0x13D8); // CHEROKEE SMALL LETTER TI, CHEROKEE LETTER TI
test(0xABA9, 0x13D9); // CHEROKEE SMALL LETTER DO, CHEROKEE LETTER DO
test(0xABAA, 0x13DA); // CHEROKEE SMALL LETTER DU, CHEROKEE LETTER DU
test(0xABAB, 0x13DB); // CHEROKEE SMALL LETTER DV, CHEROKEE LETTER DV
test(0xABAC, 0x13DC); // CHEROKEE SMALL LETTER DLA, CHEROKEE LETTER DLA
test(0xABAD, 0x13DD); // CHEROKEE SMALL LETTER TLA, CHEROKEE LETTER TLA
test(0xABAE, 0x13DE); // CHEROKEE SMALL LETTER TLE, CHEROKEE LETTER TLE
test(0xABAF, 0x13DF); // CHEROKEE SMALL LETTER TLI, CHEROKEE LETTER TLI
test(0xABB0, 0x13E0); // CHEROKEE SMALL LETTER TLO, CHEROKEE LETTER TLO
test(0xABB1, 0x13E1); // CHEROKEE SMALL LETTER TLU, CHEROKEE LETTER TLU
test(0xABB2, 0x13E2); // CHEROKEE SMALL LETTER TLV, CHEROKEE LETTER TLV
test(0xABB3, 0x13E3); // CHEROKEE SMALL LETTER TSA, CHEROKEE LETTER TSA
test(0xABB4, 0x13E4); // CHEROKEE SMALL LETTER TSE, CHEROKEE LETTER TSE
test(0xABB5, 0x13E5); // CHEROKEE SMALL LETTER TSI, CHEROKEE LETTER TSI
test(0xABB6, 0x13E6); // CHEROKEE SMALL LETTER TSO, CHEROKEE LETTER TSO
test(0xABB7, 0x13E7); // CHEROKEE SMALL LETTER TSU, CHEROKEE LETTER TSU
test(0xABB8, 0x13E8); // CHEROKEE SMALL LETTER TSV, CHEROKEE LETTER TSV
test(0xABB9, 0x13E9); // CHEROKEE SMALL LETTER WA, CHEROKEE LETTER WA
test(0xABBA, 0x13EA); // CHEROKEE SMALL LETTER WE, CHEROKEE LETTER WE
test(0xABBB, 0x13EB); // CHEROKEE SMALL LETTER WI, CHEROKEE LETTER WI
test(0xABBC, 0x13EC); // CHEROKEE SMALL LETTER WO, CHEROKEE LETTER WO
test(0xABBD, 0x13ED); // CHEROKEE SMALL LETTER WU, CHEROKEE LETTER WU
test(0xABBE, 0x13EE); // CHEROKEE SMALL LETTER WV, CHEROKEE LETTER WV
test(0xABBF, 0x13EF); // CHEROKEE SMALL LETTER YA, CHEROKEE LETTER YA
test(0xFB05, 0xFB06); // LATIN SMALL LIGATURE LONG S T, LATIN SMALL LIGATURE ST
test(0xFB06, 0xFB05); // LATIN SMALL LIGATURE ST, LATIN SMALL LIGATURE LONG S T
test(0xFF21, 0xFF41); // FULLWIDTH LATIN CAPITAL LETTER A, FULLWIDTH LATIN SMALL LETTER A
test(0xFF22, 0xFF42); // FULLWIDTH LATIN CAPITAL LETTER B, FULLWIDTH LATIN SMALL LETTER B
test(0xFF23, 0xFF43); // FULLWIDTH LATIN CAPITAL LETTER C, FULLWIDTH LATIN SMALL LETTER C
test(0xFF24, 0xFF44); // FULLWIDTH LATIN CAPITAL LETTER D, FULLWIDTH LATIN SMALL LETTER D
test(0xFF25, 0xFF45); // FULLWIDTH LATIN CAPITAL LETTER E, FULLWIDTH LATIN SMALL LETTER E
test(0xFF26, 0xFF46); // FULLWIDTH LATIN CAPITAL LETTER F, FULLWIDTH LATIN SMALL LETTER F
test(0xFF27, 0xFF47); // FULLWIDTH LATIN CAPITAL LETTER G, FULLWIDTH LATIN SMALL LETTER G
test(0xFF28, 0xFF48); // FULLWIDTH LATIN CAPITAL LETTER H, FULLWIDTH LATIN SMALL LETTER H
test(0xFF29, 0xFF49); // FULLWIDTH LATIN CAPITAL LETTER I, FULLWIDTH LATIN SMALL LETTER I
test(0xFF2A, 0xFF4A); // FULLWIDTH LATIN CAPITAL LETTER J, FULLWIDTH LATIN SMALL LETTER J
test(0xFF2B, 0xFF4B); // FULLWIDTH LATIN CAPITAL LETTER K, FULLWIDTH LATIN SMALL LETTER K
test(0xFF2C, 0xFF4C); // FULLWIDTH LATIN CAPITAL LETTER L, FULLWIDTH LATIN SMALL LETTER L
test(0xFF2D, 0xFF4D); // FULLWIDTH LATIN CAPITAL LETTER M, FULLWIDTH LATIN SMALL LETTER M
test(0xFF2E, 0xFF4E); // FULLWIDTH LATIN CAPITAL LETTER N, FULLWIDTH LATIN SMALL LETTER N
test(0xFF2F, 0xFF4F); // FULLWIDTH LATIN CAPITAL LETTER O, FULLWIDTH LATIN SMALL LETTER O
test(0xFF30, 0xFF50); // FULLWIDTH LATIN CAPITAL LETTER P, FULLWIDTH LATIN SMALL LETTER P
test(0xFF31, 0xFF51); // FULLWIDTH LATIN CAPITAL LETTER Q, FULLWIDTH LATIN SMALL LETTER Q
test(0xFF32, 0xFF52); // FULLWIDTH LATIN CAPITAL LETTER R, FULLWIDTH LATIN SMALL LETTER R
test(0xFF33, 0xFF53); // FULLWIDTH LATIN CAPITAL LETTER S, FULLWIDTH LATIN SMALL LETTER S
test(0xFF34, 0xFF54); // FULLWIDTH LATIN CAPITAL LETTER T, FULLWIDTH LATIN SMALL LETTER T
test(0xFF35, 0xFF55); // FULLWIDTH LATIN CAPITAL LETTER U, FULLWIDTH LATIN SMALL LETTER U
test(0xFF36, 0xFF56); // FULLWIDTH LATIN CAPITAL LETTER V, FULLWIDTH LATIN SMALL LETTER V
test(0xFF37, 0xFF57); // FULLWIDTH LATIN CAPITAL LETTER W, FULLWIDTH LATIN SMALL LETTER W
test(0xFF38, 0xFF58); // FULLWIDTH LATIN CAPITAL LETTER X, FULLWIDTH LATIN SMALL LETTER X
test(0xFF39, 0xFF59); // FULLWIDTH LATIN CAPITAL LETTER Y, FULLWIDTH LATIN SMALL LETTER Y
test(0xFF3A, 0xFF5A); // FULLWIDTH LATIN CAPITAL LETTER Z, FULLWIDTH LATIN SMALL LETTER Z
test(0xFF41, 0xFF21); // FULLWIDTH LATIN SMALL LETTER A, FULLWIDTH LATIN CAPITAL LETTER A
test(0xFF42, 0xFF22); // FULLWIDTH LATIN SMALL LETTER B, FULLWIDTH LATIN CAPITAL LETTER B
test(0xFF43, 0xFF23); // FULLWIDTH LATIN SMALL LETTER C, FULLWIDTH LATIN CAPITAL LETTER C
test(0xFF44, 0xFF24); // FULLWIDTH LATIN SMALL LETTER D, FULLWIDTH LATIN CAPITAL LETTER D
test(0xFF45, 0xFF25); // FULLWIDTH LATIN SMALL LETTER E, FULLWIDTH LATIN CAPITAL LETTER E
test(0xFF46, 0xFF26); // FULLWIDTH LATIN SMALL LETTER F, FULLWIDTH LATIN CAPITAL LETTER F
test(0xFF47, 0xFF27); // FULLWIDTH LATIN SMALL LETTER G, FULLWIDTH LATIN CAPITAL LETTER G
test(0xFF48, 0xFF28); // FULLWIDTH LATIN SMALL LETTER H, FULLWIDTH LATIN CAPITAL LETTER H
test(0xFF49, 0xFF29); // FULLWIDTH LATIN SMALL LETTER I, FULLWIDTH LATIN CAPITAL LETTER I
test(0xFF4A, 0xFF2A); // FULLWIDTH LATIN SMALL LETTER J, FULLWIDTH LATIN CAPITAL LETTER J
test(0xFF4B, 0xFF2B); // FULLWIDTH LATIN SMALL LETTER K, FULLWIDTH LATIN CAPITAL LETTER K
test(0xFF4C, 0xFF2C); // FULLWIDTH LATIN SMALL LETTER L, FULLWIDTH LATIN CAPITAL LETTER L
test(0xFF4D, 0xFF2D); // FULLWIDTH LATIN SMALL LETTER M, FULLWIDTH LATIN CAPITAL LETTER M
test(0xFF4E, 0xFF2E); // FULLWIDTH LATIN SMALL LETTER N, FULLWIDTH LATIN CAPITAL LETTER N
test(0xFF4F, 0xFF2F); // FULLWIDTH LATIN SMALL LETTER O, FULLWIDTH LATIN CAPITAL LETTER O
test(0xFF50, 0xFF30); // FULLWIDTH LATIN SMALL LETTER P, FULLWIDTH LATIN CAPITAL LETTER P
test(0xFF51, 0xFF31); // FULLWIDTH LATIN SMALL LETTER Q, FULLWIDTH LATIN CAPITAL LETTER Q
test(0xFF52, 0xFF32); // FULLWIDTH LATIN SMALL LETTER R, FULLWIDTH LATIN CAPITAL LETTER R
test(0xFF53, 0xFF33); // FULLWIDTH LATIN SMALL LETTER S, FULLWIDTH LATIN CAPITAL LETTER S
test(0xFF54, 0xFF34); // FULLWIDTH LATIN SMALL LETTER T, FULLWIDTH LATIN CAPITAL LETTER T
test(0xFF55, 0xFF35); // FULLWIDTH LATIN SMALL LETTER U, FULLWIDTH LATIN CAPITAL LETTER U
test(0xFF56, 0xFF36); // FULLWIDTH LATIN SMALL LETTER V, FULLWIDTH LATIN CAPITAL LETTER V
test(0xFF57, 0xFF37); // FULLWIDTH LATIN SMALL LETTER W, FULLWIDTH LATIN CAPITAL LETTER W
test(0xFF58, 0xFF38); // FULLWIDTH LATIN SMALL LETTER X, FULLWIDTH LATIN CAPITAL LETTER X
test(0xFF59, 0xFF39); // FULLWIDTH LATIN SMALL LETTER Y, FULLWIDTH LATIN CAPITAL LETTER Y
test(0xFF5A, 0xFF3A); // FULLWIDTH LATIN SMALL LETTER Z, FULLWIDTH LATIN CAPITAL LETTER Z
test(0x10400, 0x10428); // DESERET CAPITAL LETTER LONG I, DESERET SMALL LETTER LONG I
test(0x10401, 0x10429); // DESERET CAPITAL LETTER LONG E, DESERET SMALL LETTER LONG E
test(0x10402, 0x1042A); // DESERET CAPITAL LETTER LONG A, DESERET SMALL LETTER LONG A
test(0x10403, 0x1042B); // DESERET CAPITAL LETTER LONG AH, DESERET SMALL LETTER LONG AH
test(0x10404, 0x1042C); // DESERET CAPITAL LETTER LONG O, DESERET SMALL LETTER LONG O
test(0x10405, 0x1042D); // DESERET CAPITAL LETTER LONG OO, DESERET SMALL LETTER LONG OO
test(0x10406, 0x1042E); // DESERET CAPITAL LETTER SHORT I, DESERET SMALL LETTER SHORT I
test(0x10407, 0x1042F); // DESERET CAPITAL LETTER SHORT E, DESERET SMALL LETTER SHORT E
test(0x10408, 0x10430); // DESERET CAPITAL LETTER SHORT A, DESERET SMALL LETTER SHORT A
test(0x10409, 0x10431); // DESERET CAPITAL LETTER SHORT AH, DESERET SMALL LETTER SHORT AH
test(0x1040A, 0x10432); // DESERET CAPITAL LETTER SHORT O, DESERET SMALL LETTER SHORT O
test(0x1040B, 0x10433); // DESERET CAPITAL LETTER SHORT OO, DESERET SMALL LETTER SHORT OO
test(0x1040C, 0x10434); // DESERET CAPITAL LETTER AY, DESERET SMALL LETTER AY
test(0x1040D, 0x10435); // DESERET CAPITAL LETTER OW, DESERET SMALL LETTER OW
test(0x1040E, 0x10436); // DESERET CAPITAL LETTER WU, DESERET SMALL LETTER WU
test(0x1040F, 0x10437); // DESERET CAPITAL LETTER YEE, DESERET SMALL LETTER YEE
test(0x10410, 0x10438); // DESERET CAPITAL LETTER H, DESERET SMALL LETTER H
test(0x10411, 0x10439); // DESERET CAPITAL LETTER PEE, DESERET SMALL LETTER PEE
test(0x10412, 0x1043A); // DESERET CAPITAL LETTER BEE, DESERET SMALL LETTER BEE
test(0x10413, 0x1043B); // DESERET CAPITAL LETTER TEE, DESERET SMALL LETTER TEE
test(0x10414, 0x1043C); // DESERET CAPITAL LETTER DEE, DESERET SMALL LETTER DEE
test(0x10415, 0x1043D); // DESERET CAPITAL LETTER CHEE, DESERET SMALL LETTER CHEE
test(0x10416, 0x1043E); // DESERET CAPITAL LETTER JEE, DESERET SMALL LETTER JEE
test(0x10417, 0x1043F); // DESERET CAPITAL LETTER KAY, DESERET SMALL LETTER KAY
test(0x10418, 0x10440); // DESERET CAPITAL LETTER GAY, DESERET SMALL LETTER GAY
test(0x10419, 0x10441); // DESERET CAPITAL LETTER EF, DESERET SMALL LETTER EF
test(0x1041A, 0x10442); // DESERET CAPITAL LETTER VEE, DESERET SMALL LETTER VEE
test(0x1041B, 0x10443); // DESERET CAPITAL LETTER ETH, DESERET SMALL LETTER ETH
test(0x1041C, 0x10444); // DESERET CAPITAL LETTER THEE, DESERET SMALL LETTER THEE
test(0x1041D, 0x10445); // DESERET CAPITAL LETTER ES, DESERET SMALL LETTER ES
test(0x1041E, 0x10446); // DESERET CAPITAL LETTER ZEE, DESERET SMALL LETTER ZEE
test(0x1041F, 0x10447); // DESERET CAPITAL LETTER ESH, DESERET SMALL LETTER ESH
test(0x10420, 0x10448); // DESERET CAPITAL LETTER ZHEE, DESERET SMALL LETTER ZHEE
test(0x10421, 0x10449); // DESERET CAPITAL LETTER ER, DESERET SMALL LETTER ER
test(0x10422, 0x1044A); // DESERET CAPITAL LETTER EL, DESERET SMALL LETTER EL
test(0x10423, 0x1044B); // DESERET CAPITAL LETTER EM, DESERET SMALL LETTER EM
test(0x10424, 0x1044C); // DESERET CAPITAL LETTER EN, DESERET SMALL LETTER EN
test(0x10425, 0x1044D); // DESERET CAPITAL LETTER ENG, DESERET SMALL LETTER ENG
test(0x10426, 0x1044E); // DESERET CAPITAL LETTER OI, DESERET SMALL LETTER OI
test(0x10427, 0x1044F); // DESERET CAPITAL LETTER EW, DESERET SMALL LETTER EW
test(0x10428, 0x10400); // DESERET SMALL LETTER LONG I, DESERET CAPITAL LETTER LONG I
test(0x10429, 0x10401); // DESERET SMALL LETTER LONG E, DESERET CAPITAL LETTER LONG E
test(0x1042A, 0x10402); // DESERET SMALL LETTER LONG A, DESERET CAPITAL LETTER LONG A
test(0x1042B, 0x10403); // DESERET SMALL LETTER LONG AH, DESERET CAPITAL LETTER LONG AH
test(0x1042C, 0x10404); // DESERET SMALL LETTER LONG O, DESERET CAPITAL LETTER LONG O
test(0x1042D, 0x10405); // DESERET SMALL LETTER LONG OO, DESERET CAPITAL LETTER LONG OO
test(0x1042E, 0x10406); // DESERET SMALL LETTER SHORT I, DESERET CAPITAL LETTER SHORT I
test(0x1042F, 0x10407); // DESERET SMALL LETTER SHORT E, DESERET CAPITAL LETTER SHORT E
test(0x10430, 0x10408); // DESERET SMALL LETTER SHORT A, DESERET CAPITAL LETTER SHORT A
test(0x10431, 0x10409); // DESERET SMALL LETTER SHORT AH, DESERET CAPITAL LETTER SHORT AH
test(0x10432, 0x1040A); // DESERET SMALL LETTER SHORT O, DESERET CAPITAL LETTER SHORT O
test(0x10433, 0x1040B); // DESERET SMALL LETTER SHORT OO, DESERET CAPITAL LETTER SHORT OO
test(0x10434, 0x1040C); // DESERET SMALL LETTER AY, DESERET CAPITAL LETTER AY
test(0x10435, 0x1040D); // DESERET SMALL LETTER OW, DESERET CAPITAL LETTER OW
test(0x10436, 0x1040E); // DESERET SMALL LETTER WU, DESERET CAPITAL LETTER WU
test(0x10437, 0x1040F); // DESERET SMALL LETTER YEE, DESERET CAPITAL LETTER YEE
test(0x10438, 0x10410); // DESERET SMALL LETTER H, DESERET CAPITAL LETTER H
test(0x10439, 0x10411); // DESERET SMALL LETTER PEE, DESERET CAPITAL LETTER PEE
test(0x1043A, 0x10412); // DESERET SMALL LETTER BEE, DESERET CAPITAL LETTER BEE
test(0x1043B, 0x10413); // DESERET SMALL LETTER TEE, DESERET CAPITAL LETTER TEE
test(0x1043C, 0x10414); // DESERET SMALL LETTER DEE, DESERET CAPITAL LETTER DEE
test(0x1043D, 0x10415); // DESERET SMALL LETTER CHEE, DESERET CAPITAL LETTER CHEE
test(0x1043E, 0x10416); // DESERET SMALL LETTER JEE, DESERET CAPITAL LETTER JEE
test(0x1043F, 0x10417); // DESERET SMALL LETTER KAY, DESERET CAPITAL LETTER KAY
test(0x10440, 0x10418); // DESERET SMALL LETTER GAY, DESERET CAPITAL LETTER GAY
test(0x10441, 0x10419); // DESERET SMALL LETTER EF, DESERET CAPITAL LETTER EF
test(0x10442, 0x1041A); // DESERET SMALL LETTER VEE, DESERET CAPITAL LETTER VEE
test(0x10443, 0x1041B); // DESERET SMALL LETTER ETH, DESERET CAPITAL LETTER ETH
test(0x10444, 0x1041C); // DESERET SMALL LETTER THEE, DESERET CAPITAL LETTER THEE
test(0x10445, 0x1041D); // DESERET SMALL LETTER ES, DESERET CAPITAL LETTER ES
test(0x10446, 0x1041E); // DESERET SMALL LETTER ZEE, DESERET CAPITAL LETTER ZEE
test(0x10447, 0x1041F); // DESERET SMALL LETTER ESH, DESERET CAPITAL LETTER ESH
test(0x10448, 0x10420); // DESERET SMALL LETTER ZHEE, DESERET CAPITAL LETTER ZHEE
test(0x10449, 0x10421); // DESERET SMALL LETTER ER, DESERET CAPITAL LETTER ER
test(0x1044A, 0x10422); // DESERET SMALL LETTER EL, DESERET CAPITAL LETTER EL
test(0x1044B, 0x10423); // DESERET SMALL LETTER EM, DESERET CAPITAL LETTER EM
test(0x1044C, 0x10424); // DESERET SMALL LETTER EN, DESERET CAPITAL LETTER EN
test(0x1044D, 0x10425); // DESERET SMALL LETTER ENG, DESERET CAPITAL LETTER ENG
test(0x1044E, 0x10426); // DESERET SMALL LETTER OI, DESERET CAPITAL LETTER OI
test(0x1044F, 0x10427); // DESERET SMALL LETTER EW, DESERET CAPITAL LETTER EW
test(0x104B0, 0x104D8); // OSAGE CAPITAL LETTER A, OSAGE SMALL LETTER A
test(0x104B1, 0x104D9); // OSAGE CAPITAL LETTER AI, OSAGE SMALL LETTER AI
test(0x104B2, 0x104DA); // OSAGE CAPITAL LETTER AIN, OSAGE SMALL LETTER AIN
test(0x104B3, 0x104DB); // OSAGE CAPITAL LETTER AH, OSAGE SMALL LETTER AH
test(0x104B4, 0x104DC); // OSAGE CAPITAL LETTER BRA, OSAGE SMALL LETTER BRA
test(0x104B5, 0x104DD); // OSAGE CAPITAL LETTER CHA, OSAGE SMALL LETTER CHA
test(0x104B6, 0x104DE); // OSAGE CAPITAL LETTER EHCHA, OSAGE SMALL LETTER EHCHA
test(0x104B7, 0x104DF); // OSAGE CAPITAL LETTER E, OSAGE SMALL LETTER E
test(0x104B8, 0x104E0); // OSAGE CAPITAL LETTER EIN, OSAGE SMALL LETTER EIN
test(0x104B9, 0x104E1); // OSAGE CAPITAL LETTER HA, OSAGE SMALL LETTER HA
test(0x104BA, 0x104E2); // OSAGE CAPITAL LETTER HYA, OSAGE SMALL LETTER HYA
test(0x104BB, 0x104E3); // OSAGE CAPITAL LETTER I, OSAGE SMALL LETTER I
test(0x104BC, 0x104E4); // OSAGE CAPITAL LETTER KA, OSAGE SMALL LETTER KA
test(0x104BD, 0x104E5); // OSAGE CAPITAL LETTER EHKA, OSAGE SMALL LETTER EHKA
test(0x104BE, 0x104E6); // OSAGE CAPITAL LETTER KYA, OSAGE SMALL LETTER KYA
test(0x104BF, 0x104E7); // OSAGE CAPITAL LETTER LA, OSAGE SMALL LETTER LA
test(0x104C0, 0x104E8); // OSAGE CAPITAL LETTER MA, OSAGE SMALL LETTER MA
test(0x104C1, 0x104E9); // OSAGE CAPITAL LETTER NA, OSAGE SMALL LETTER NA
test(0x104C2, 0x104EA); // OSAGE CAPITAL LETTER O, OSAGE SMALL LETTER O
test(0x104C3, 0x104EB); // OSAGE CAPITAL LETTER OIN, OSAGE SMALL LETTER OIN
test(0x104C4, 0x104EC); // OSAGE CAPITAL LETTER PA, OSAGE SMALL LETTER PA
test(0x104C5, 0x104ED); // OSAGE CAPITAL LETTER EHPA, OSAGE SMALL LETTER EHPA
test(0x104C6, 0x104EE); // OSAGE CAPITAL LETTER SA, OSAGE SMALL LETTER SA
test(0x104C7, 0x104EF); // OSAGE CAPITAL LETTER SHA, OSAGE SMALL LETTER SHA
test(0x104C8, 0x104F0); // OSAGE CAPITAL LETTER TA, OSAGE SMALL LETTER TA
test(0x104C9, 0x104F1); // OSAGE CAPITAL LETTER EHTA, OSAGE SMALL LETTER EHTA
test(0x104CA, 0x104F2); // OSAGE CAPITAL LETTER TSA, OSAGE SMALL LETTER TSA
test(0x104CB, 0x104F3); // OSAGE CAPITAL LETTER EHTSA, OSAGE SMALL LETTER EHTSA
test(0x104CC, 0x104F4); // OSAGE CAPITAL LETTER TSHA, OSAGE SMALL LETTER TSHA
test(0x104CD, 0x104F5); // OSAGE CAPITAL LETTER DHA, OSAGE SMALL LETTER DHA
test(0x104CE, 0x104F6); // OSAGE CAPITAL LETTER U, OSAGE SMALL LETTER U
test(0x104CF, 0x104F7); // OSAGE CAPITAL LETTER WA, OSAGE SMALL LETTER WA
test(0x104D0, 0x104F8); // OSAGE CAPITAL LETTER KHA, OSAGE SMALL LETTER KHA
test(0x104D1, 0x104F9); // OSAGE CAPITAL LETTER GHA, OSAGE SMALL LETTER GHA
test(0x104D2, 0x104FA); // OSAGE CAPITAL LETTER ZA, OSAGE SMALL LETTER ZA
test(0x104D3, 0x104FB); // OSAGE CAPITAL LETTER ZHA, OSAGE SMALL LETTER ZHA
test(0x104D8, 0x104B0); // OSAGE SMALL LETTER A, OSAGE CAPITAL LETTER A
test(0x104D9, 0x104B1); // OSAGE SMALL LETTER AI, OSAGE CAPITAL LETTER AI
test(0x104DA, 0x104B2); // OSAGE SMALL LETTER AIN, OSAGE CAPITAL LETTER AIN
test(0x104DB, 0x104B3); // OSAGE SMALL LETTER AH, OSAGE CAPITAL LETTER AH
test(0x104DC, 0x104B4); // OSAGE SMALL LETTER BRA, OSAGE CAPITAL LETTER BRA
test(0x104DD, 0x104B5); // OSAGE SMALL LETTER CHA, OSAGE CAPITAL LETTER CHA
test(0x104DE, 0x104B6); // OSAGE SMALL LETTER EHCHA, OSAGE CAPITAL LETTER EHCHA
test(0x104DF, 0x104B7); // OSAGE SMALL LETTER E, OSAGE CAPITAL LETTER E
test(0x104E0, 0x104B8); // OSAGE SMALL LETTER EIN, OSAGE CAPITAL LETTER EIN
test(0x104E1, 0x104B9); // OSAGE SMALL LETTER HA, OSAGE CAPITAL LETTER HA
test(0x104E2, 0x104BA); // OSAGE SMALL LETTER HYA, OSAGE CAPITAL LETTER HYA
test(0x104E3, 0x104BB); // OSAGE SMALL LETTER I, OSAGE CAPITAL LETTER I
test(0x104E4, 0x104BC); // OSAGE SMALL LETTER KA, OSAGE CAPITAL LETTER KA
test(0x104E5, 0x104BD); // OSAGE SMALL LETTER EHKA, OSAGE CAPITAL LETTER EHKA
test(0x104E6, 0x104BE); // OSAGE SMALL LETTER KYA, OSAGE CAPITAL LETTER KYA
test(0x104E7, 0x104BF); // OSAGE SMALL LETTER LA, OSAGE CAPITAL LETTER LA
test(0x104E8, 0x104C0); // OSAGE SMALL LETTER MA, OSAGE CAPITAL LETTER MA
test(0x104E9, 0x104C1); // OSAGE SMALL LETTER NA, OSAGE CAPITAL LETTER NA
test(0x104EA, 0x104C2); // OSAGE SMALL LETTER O, OSAGE CAPITAL LETTER O
test(0x104EB, 0x104C3); // OSAGE SMALL LETTER OIN, OSAGE CAPITAL LETTER OIN
test(0x104EC, 0x104C4); // OSAGE SMALL LETTER PA, OSAGE CAPITAL LETTER PA
test(0x104ED, 0x104C5); // OSAGE SMALL LETTER EHPA, OSAGE CAPITAL LETTER EHPA
test(0x104EE, 0x104C6); // OSAGE SMALL LETTER SA, OSAGE CAPITAL LETTER SA
test(0x104EF, 0x104C7); // OSAGE SMALL LETTER SHA, OSAGE CAPITAL LETTER SHA
test(0x104F0, 0x104C8); // OSAGE SMALL LETTER TA, OSAGE CAPITAL LETTER TA
test(0x104F1, 0x104C9); // OSAGE SMALL LETTER EHTA, OSAGE CAPITAL LETTER EHTA
test(0x104F2, 0x104CA); // OSAGE SMALL LETTER TSA, OSAGE CAPITAL LETTER TSA
test(0x104F3, 0x104CB); // OSAGE SMALL LETTER EHTSA, OSAGE CAPITAL LETTER EHTSA
test(0x104F4, 0x104CC); // OSAGE SMALL LETTER TSHA, OSAGE CAPITAL LETTER TSHA
test(0x104F5, 0x104CD); // OSAGE SMALL LETTER DHA, OSAGE CAPITAL LETTER DHA
test(0x104F6, 0x104CE); // OSAGE SMALL LETTER U, OSAGE CAPITAL LETTER U
test(0x104F7, 0x104CF); // OSAGE SMALL LETTER WA, OSAGE CAPITAL LETTER WA
test(0x104F8, 0x104D0); // OSAGE SMALL LETTER KHA, OSAGE CAPITAL LETTER KHA
test(0x104F9, 0x104D1); // OSAGE SMALL LETTER GHA, OSAGE CAPITAL LETTER GHA
test(0x104FA, 0x104D2); // OSAGE SMALL LETTER ZA, OSAGE CAPITAL LETTER ZA
test(0x104FB, 0x104D3); // OSAGE SMALL LETTER ZHA, OSAGE CAPITAL LETTER ZHA
test(0x10570, 0x10597); // VITHKUQI CAPITAL LETTER A, VITHKUQI SMALL LETTER A
test(0x10571, 0x10598); // VITHKUQI CAPITAL LETTER BBE, VITHKUQI SMALL LETTER BBE
test(0x10572, 0x10599); // VITHKUQI CAPITAL LETTER BE, VITHKUQI SMALL LETTER BE
test(0x10573, 0x1059A); // VITHKUQI CAPITAL LETTER CE, VITHKUQI SMALL LETTER CE
test(0x10574, 0x1059B); // VITHKUQI CAPITAL LETTER CHE, VITHKUQI SMALL LETTER CHE
test(0x10575, 0x1059C); // VITHKUQI CAPITAL LETTER DE, VITHKUQI SMALL LETTER DE
test(0x10576, 0x1059D); // VITHKUQI CAPITAL LETTER DHE, VITHKUQI SMALL LETTER DHE
test(0x10577, 0x1059E); // VITHKUQI CAPITAL LETTER EI, VITHKUQI SMALL LETTER EI
test(0x10578, 0x1059F); // VITHKUQI CAPITAL LETTER E, VITHKUQI SMALL LETTER E
test(0x10579, 0x105A0); // VITHKUQI CAPITAL LETTER FE, VITHKUQI SMALL LETTER FE
test(0x1057A, 0x105A1); // VITHKUQI CAPITAL LETTER GA, VITHKUQI SMALL LETTER GA
test(0x1057C, 0x105A3); // VITHKUQI CAPITAL LETTER HA, VITHKUQI SMALL LETTER HA
test(0x1057D, 0x105A4); // VITHKUQI CAPITAL LETTER HHA, VITHKUQI SMALL LETTER HHA
test(0x1057E, 0x105A5); // VITHKUQI CAPITAL LETTER I, VITHKUQI SMALL LETTER I
test(0x1057F, 0x105A6); // VITHKUQI CAPITAL LETTER IJE, VITHKUQI SMALL LETTER IJE
test(0x10580, 0x105A7); // VITHKUQI CAPITAL LETTER JE, VITHKUQI SMALL LETTER JE
test(0x10581, 0x105A8); // VITHKUQI CAPITAL LETTER KA, VITHKUQI SMALL LETTER KA
test(0x10582, 0x105A9); // VITHKUQI CAPITAL LETTER LA, VITHKUQI SMALL LETTER LA
test(0x10583, 0x105AA); // VITHKUQI CAPITAL LETTER LLA, VITHKUQI SMALL LETTER LLA
test(0x10584, 0x105AB); // VITHKUQI CAPITAL LETTER ME, VITHKUQI SMALL LETTER ME
test(0x10585, 0x105AC); // VITHKUQI CAPITAL LETTER NE, VITHKUQI SMALL LETTER NE
test(0x10586, 0x105AD); // VITHKUQI CAPITAL LETTER NJE, VITHKUQI SMALL LETTER NJE
test(0x10587, 0x105AE); // VITHKUQI CAPITAL LETTER O, VITHKUQI SMALL LETTER O
test(0x10588, 0x105AF); // VITHKUQI CAPITAL LETTER PE, VITHKUQI SMALL LETTER PE
test(0x10589, 0x105B0); // VITHKUQI CAPITAL LETTER QA, VITHKUQI SMALL LETTER QA
test(0x1058A, 0x105B1); // VITHKUQI CAPITAL LETTER RE, VITHKUQI SMALL LETTER RE
test(0x1058C, 0x105B3); // VITHKUQI CAPITAL LETTER SE, VITHKUQI SMALL LETTER SE
test(0x1058D, 0x105B4); // VITHKUQI CAPITAL LETTER SHE, VITHKUQI SMALL LETTER SHE
test(0x1058E, 0x105B5); // VITHKUQI CAPITAL LETTER TE, VITHKUQI SMALL LETTER TE
test(0x1058F, 0x105B6); // VITHKUQI CAPITAL LETTER THE, VITHKUQI SMALL LETTER THE
test(0x10590, 0x105B7); // VITHKUQI CAPITAL LETTER U, VITHKUQI SMALL LETTER U
test(0x10591, 0x105B8); // VITHKUQI CAPITAL LETTER VE, VITHKUQI SMALL LETTER VE
test(0x10592, 0x105B9); // VITHKUQI CAPITAL LETTER XE, VITHKUQI SMALL LETTER XE
test(0x10594, 0x105BB); // VITHKUQI CAPITAL LETTER Y, VITHKUQI SMALL LETTER Y
test(0x10595, 0x105BC); // VITHKUQI CAPITAL LETTER ZE, VITHKUQI SMALL LETTER ZE
test(0x10597, 0x10570); // VITHKUQI SMALL LETTER A, VITHKUQI CAPITAL LETTER A
test(0x10598, 0x10571); // VITHKUQI SMALL LETTER BBE, VITHKUQI CAPITAL LETTER BBE
test(0x10599, 0x10572); // VITHKUQI SMALL LETTER BE, VITHKUQI CAPITAL LETTER BE
test(0x1059A, 0x10573); // VITHKUQI SMALL LETTER CE, VITHKUQI CAPITAL LETTER CE
test(0x1059B, 0x10574); // VITHKUQI SMALL LETTER CHE, VITHKUQI CAPITAL LETTER CHE
test(0x1059C, 0x10575); // VITHKUQI SMALL LETTER DE, VITHKUQI CAPITAL LETTER DE
test(0x1059D, 0x10576); // VITHKUQI SMALL LETTER DHE, VITHKUQI CAPITAL LETTER DHE
test(0x1059E, 0x10577); // VITHKUQI SMALL LETTER EI, VITHKUQI CAPITAL LETTER EI
test(0x1059F, 0x10578); // VITHKUQI SMALL LETTER E, VITHKUQI CAPITAL LETTER E
test(0x105A0, 0x10579); // VITHKUQI SMALL LETTER FE, VITHKUQI CAPITAL LETTER FE
test(0x105A1, 0x1057A); // VITHKUQI SMALL LETTER GA, VITHKUQI CAPITAL LETTER GA
test(0x105A3, 0x1057C); // VITHKUQI SMALL LETTER HA, VITHKUQI CAPITAL LETTER HA
test(0x105A4, 0x1057D); // VITHKUQI SMALL LETTER HHA, VITHKUQI CAPITAL LETTER HHA
test(0x105A5, 0x1057E); // VITHKUQI SMALL LETTER I, VITHKUQI CAPITAL LETTER I
test(0x105A6, 0x1057F); // VITHKUQI SMALL LETTER IJE, VITHKUQI CAPITAL LETTER IJE
test(0x105A7, 0x10580); // VITHKUQI SMALL LETTER JE, VITHKUQI CAPITAL LETTER JE
test(0x105A8, 0x10581); // VITHKUQI SMALL LETTER KA, VITHKUQI CAPITAL LETTER KA
test(0x105A9, 0x10582); // VITHKUQI SMALL LETTER LA, VITHKUQI CAPITAL LETTER LA
test(0x105AA, 0x10583); // VITHKUQI SMALL LETTER LLA, VITHKUQI CAPITAL LETTER LLA
test(0x105AB, 0x10584); // VITHKUQI SMALL LETTER ME, VITHKUQI CAPITAL LETTER ME
test(0x105AC, 0x10585); // VITHKUQI SMALL LETTER NE, VITHKUQI CAPITAL LETTER NE
test(0x105AD, 0x10586); // VITHKUQI SMALL LETTER NJE, VITHKUQI CAPITAL LETTER NJE
test(0x105AE, 0x10587); // VITHKUQI SMALL LETTER O, VITHKUQI CAPITAL LETTER O
test(0x105AF, 0x10588); // VITHKUQI SMALL LETTER PE, VITHKUQI CAPITAL LETTER PE
test(0x105B0, 0x10589); // VITHKUQI SMALL LETTER QA, VITHKUQI CAPITAL LETTER QA
test(0x105B1, 0x1058A); // VITHKUQI SMALL LETTER RE, VITHKUQI CAPITAL LETTER RE
test(0x105B3, 0x1058C); // VITHKUQI SMALL LETTER SE, VITHKUQI CAPITAL LETTER SE
test(0x105B4, 0x1058D); // VITHKUQI SMALL LETTER SHE, VITHKUQI CAPITAL LETTER SHE
test(0x105B5, 0x1058E); // VITHKUQI SMALL LETTER TE, VITHKUQI CAPITAL LETTER TE
test(0x105B6, 0x1058F); // VITHKUQI SMALL LETTER THE, VITHKUQI CAPITAL LETTER THE
test(0x105B7, 0x10590); // VITHKUQI SMALL LETTER U, VITHKUQI CAPITAL LETTER U
test(0x105B8, 0x10591); // VITHKUQI SMALL LETTER VE, VITHKUQI CAPITAL LETTER VE
test(0x105B9, 0x10592); // VITHKUQI SMALL LETTER XE, VITHKUQI CAPITAL LETTER XE
test(0x105BB, 0x10594); // VITHKUQI SMALL LETTER Y, VITHKUQI CAPITAL LETTER Y
test(0x105BC, 0x10595); // VITHKUQI SMALL LETTER ZE, VITHKUQI CAPITAL LETTER ZE
test(0x10C80, 0x10CC0); // OLD HUNGARIAN CAPITAL LETTER A, OLD HUNGARIAN SMALL LETTER A
test(0x10C81, 0x10CC1); // OLD HUNGARIAN CAPITAL LETTER AA, OLD HUNGARIAN SMALL LETTER AA
test(0x10C82, 0x10CC2); // OLD HUNGARIAN CAPITAL LETTER EB, OLD HUNGARIAN SMALL LETTER EB
test(0x10C83, 0x10CC3); // OLD HUNGARIAN CAPITAL LETTER AMB, OLD HUNGARIAN SMALL LETTER AMB
test(0x10C84, 0x10CC4); // OLD HUNGARIAN CAPITAL LETTER EC, OLD HUNGARIAN SMALL LETTER EC
test(0x10C85, 0x10CC5); // OLD HUNGARIAN CAPITAL LETTER ENC, OLD HUNGARIAN SMALL LETTER ENC
test(0x10C86, 0x10CC6); // OLD HUNGARIAN CAPITAL LETTER ECS, OLD HUNGARIAN SMALL LETTER ECS
test(0x10C87, 0x10CC7); // OLD HUNGARIAN CAPITAL LETTER ED, OLD HUNGARIAN SMALL LETTER ED
test(0x10C88, 0x10CC8); // OLD HUNGARIAN CAPITAL LETTER AND, OLD HUNGARIAN SMALL LETTER AND
test(0x10C89, 0x10CC9); // OLD HUNGARIAN CAPITAL LETTER E, OLD HUNGARIAN SMALL LETTER E
test(0x10C8A, 0x10CCA); // OLD HUNGARIAN CAPITAL LETTER CLOSE E, OLD HUNGARIAN SMALL LETTER CLOSE E
test(0x10C8B, 0x10CCB); // OLD HUNGARIAN CAPITAL LETTER EE, OLD HUNGARIAN SMALL LETTER EE
test(0x10C8C, 0x10CCC); // OLD HUNGARIAN CAPITAL LETTER EF, OLD HUNGARIAN SMALL LETTER EF
test(0x10C8D, 0x10CCD); // OLD HUNGARIAN CAPITAL LETTER EG, OLD HUNGARIAN SMALL LETTER EG
test(0x10C8E, 0x10CCE); // OLD HUNGARIAN CAPITAL LETTER EGY, OLD HUNGARIAN SMALL LETTER EGY
test(0x10C8F, 0x10CCF); // OLD HUNGARIAN CAPITAL LETTER EH, OLD HUNGARIAN SMALL LETTER EH
test(0x10C90, 0x10CD0); // OLD HUNGARIAN CAPITAL LETTER I, OLD HUNGARIAN SMALL LETTER I
test(0x10C91, 0x10CD1); // OLD HUNGARIAN CAPITAL LETTER II, OLD HUNGARIAN SMALL LETTER II
test(0x10C92, 0x10CD2); // OLD HUNGARIAN CAPITAL LETTER EJ, OLD HUNGARIAN SMALL LETTER EJ
test(0x10C93, 0x10CD3); // OLD HUNGARIAN CAPITAL LETTER EK, OLD HUNGARIAN SMALL LETTER EK
test(0x10C94, 0x10CD4); // OLD HUNGARIAN CAPITAL LETTER AK, OLD HUNGARIAN SMALL LETTER AK
test(0x10C95, 0x10CD5); // OLD HUNGARIAN CAPITAL LETTER UNK, OLD HUNGARIAN SMALL LETTER UNK
test(0x10C96, 0x10CD6); // OLD HUNGARIAN CAPITAL LETTER EL, OLD HUNGARIAN SMALL LETTER EL
test(0x10C97, 0x10CD7); // OLD HUNGARIAN CAPITAL LETTER ELY, OLD HUNGARIAN SMALL LETTER ELY
test(0x10C98, 0x10CD8); // OLD HUNGARIAN CAPITAL LETTER EM, OLD HUNGARIAN SMALL LETTER EM
test(0x10C99, 0x10CD9); // OLD HUNGARIAN CAPITAL LETTER EN, OLD HUNGARIAN SMALL LETTER EN
test(0x10C9A, 0x10CDA); // OLD HUNGARIAN CAPITAL LETTER ENY, OLD HUNGARIAN SMALL LETTER ENY
test(0x10C9B, 0x10CDB); // OLD HUNGARIAN CAPITAL LETTER O, OLD HUNGARIAN SMALL LETTER O
test(0x10C9C, 0x10CDC); // OLD HUNGARIAN CAPITAL LETTER OO, OLD HUNGARIAN SMALL LETTER OO
test(0x10C9D, 0x10CDD); // OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OE, OLD HUNGARIAN SMALL LETTER NIKOLSBURG OE
test(0x10C9E, 0x10CDE); // OLD HUNGARIAN CAPITAL LETTER RUDIMENTA OE, OLD HUNGARIAN SMALL LETTER RUDIMENTA OE
test(0x10C9F, 0x10CDF); // OLD HUNGARIAN CAPITAL LETTER OEE, OLD HUNGARIAN SMALL LETTER OEE
test(0x10CA0, 0x10CE0); // OLD HUNGARIAN CAPITAL LETTER EP, OLD HUNGARIAN SMALL LETTER EP
test(0x10CA1, 0x10CE1); // OLD HUNGARIAN CAPITAL LETTER EMP, OLD HUNGARIAN SMALL LETTER EMP
test(0x10CA2, 0x10CE2); // OLD HUNGARIAN CAPITAL LETTER ER, OLD HUNGARIAN SMALL LETTER ER
test(0x10CA3, 0x10CE3); // OLD HUNGARIAN CAPITAL LETTER SHORT ER, OLD HUNGARIAN SMALL LETTER SHORT ER
test(0x10CA4, 0x10CE4); // OLD HUNGARIAN CAPITAL LETTER ES, OLD HUNGARIAN SMALL LETTER ES
test(0x10CA5, 0x10CE5); // OLD HUNGARIAN CAPITAL LETTER ESZ, OLD HUNGARIAN SMALL LETTER ESZ
test(0x10CA6, 0x10CE6); // OLD HUNGARIAN CAPITAL LETTER ET, OLD HUNGARIAN SMALL LETTER ET
test(0x10CA7, 0x10CE7); // OLD HUNGARIAN CAPITAL LETTER ENT, OLD HUNGARIAN SMALL LETTER ENT
test(0x10CA8, 0x10CE8); // OLD HUNGARIAN CAPITAL LETTER ETY, OLD HUNGARIAN SMALL LETTER ETY
test(0x10CA9, 0x10CE9); // OLD HUNGARIAN CAPITAL LETTER ECH, OLD HUNGARIAN SMALL LETTER ECH
test(0x10CAA, 0x10CEA); // OLD HUNGARIAN CAPITAL LETTER U, OLD HUNGARIAN SMALL LETTER U
test(0x10CAB, 0x10CEB); // OLD HUNGARIAN CAPITAL LETTER UU, OLD HUNGARIAN SMALL LETTER UU
test(0x10CAC, 0x10CEC); // OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UE, OLD HUNGARIAN SMALL LETTER NIKOLSBURG UE
test(0x10CAD, 0x10CED); // OLD HUNGARIAN CAPITAL LETTER RUDIMENTA UE, OLD HUNGARIAN SMALL LETTER RUDIMENTA UE
test(0x10CAE, 0x10CEE); // OLD HUNGARIAN CAPITAL LETTER EV, OLD HUNGARIAN SMALL LETTER EV
test(0x10CAF, 0x10CEF); // OLD HUNGARIAN CAPITAL LETTER EZ, OLD HUNGARIAN SMALL LETTER EZ
test(0x10CB0, 0x10CF0); // OLD HUNGARIAN CAPITAL LETTER EZS, OLD HUNGARIAN SMALL LETTER EZS
test(0x10CB1, 0x10CF1); // OLD HUNGARIAN CAPITAL LETTER ENT-SHAPED SIGN, OLD HUNGARIAN SMALL LETTER ENT-SHAPED SIGN
test(0x10CB2, 0x10CF2); // OLD HUNGARIAN CAPITAL LETTER US, OLD HUNGARIAN SMALL LETTER US
test(0x10CC0, 0x10C80); // OLD HUNGARIAN SMALL LETTER A, OLD HUNGARIAN CAPITAL LETTER A
test(0x10CC1, 0x10C81); // OLD HUNGARIAN SMALL LETTER AA, OLD HUNGARIAN CAPITAL LETTER AA
test(0x10CC2, 0x10C82); // OLD HUNGARIAN SMALL LETTER EB, OLD HUNGARIAN CAPITAL LETTER EB
test(0x10CC3, 0x10C83); // OLD HUNGARIAN SMALL LETTER AMB, OLD HUNGARIAN CAPITAL LETTER AMB
test(0x10CC4, 0x10C84); // OLD HUNGARIAN SMALL LETTER EC, OLD HUNGARIAN CAPITAL LETTER EC
test(0x10CC5, 0x10C85); // OLD HUNGARIAN SMALL LETTER ENC, OLD HUNGARIAN CAPITAL LETTER ENC
test(0x10CC6, 0x10C86); // OLD HUNGARIAN SMALL LETTER ECS, OLD HUNGARIAN CAPITAL LETTER ECS
test(0x10CC7, 0x10C87); // OLD HUNGARIAN SMALL LETTER ED, OLD HUNGARIAN CAPITAL LETTER ED
test(0x10CC8, 0x10C88); // OLD HUNGARIAN SMALL LETTER AND, OLD HUNGARIAN CAPITAL LETTER AND
test(0x10CC9, 0x10C89); // OLD HUNGARIAN SMALL LETTER E, OLD HUNGARIAN CAPITAL LETTER E
test(0x10CCA, 0x10C8A); // OLD HUNGARIAN SMALL LETTER CLOSE E, OLD HUNGARIAN CAPITAL LETTER CLOSE E
test(0x10CCB, 0x10C8B); // OLD HUNGARIAN SMALL LETTER EE, OLD HUNGARIAN CAPITAL LETTER EE
test(0x10CCC, 0x10C8C); // OLD HUNGARIAN SMALL LETTER EF, OLD HUNGARIAN CAPITAL LETTER EF
test(0x10CCD, 0x10C8D); // OLD HUNGARIAN SMALL LETTER EG, OLD HUNGARIAN CAPITAL LETTER EG
test(0x10CCE, 0x10C8E); // OLD HUNGARIAN SMALL LETTER EGY, OLD HUNGARIAN CAPITAL LETTER EGY
test(0x10CCF, 0x10C8F); // OLD HUNGARIAN SMALL LETTER EH, OLD HUNGARIAN CAPITAL LETTER EH
test(0x10CD0, 0x10C90); // OLD HUNGARIAN SMALL LETTER I, OLD HUNGARIAN CAPITAL LETTER I
test(0x10CD1, 0x10C91); // OLD HUNGARIAN SMALL LETTER II, OLD HUNGARIAN CAPITAL LETTER II
test(0x10CD2, 0x10C92); // OLD HUNGARIAN SMALL LETTER EJ, OLD HUNGARIAN CAPITAL LETTER EJ
test(0x10CD3, 0x10C93); // OLD HUNGARIAN SMALL LETTER EK, OLD HUNGARIAN CAPITAL LETTER EK
test(0x10CD4, 0x10C94); // OLD HUNGARIAN SMALL LETTER AK, OLD HUNGARIAN CAPITAL LETTER AK
test(0x10CD5, 0x10C95); // OLD HUNGARIAN SMALL LETTER UNK, OLD HUNGARIAN CAPITAL LETTER UNK
test(0x10CD6, 0x10C96); // OLD HUNGARIAN SMALL LETTER EL, OLD HUNGARIAN CAPITAL LETTER EL
test(0x10CD7, 0x10C97); // OLD HUNGARIAN SMALL LETTER ELY, OLD HUNGARIAN CAPITAL LETTER ELY
test(0x10CD8, 0x10C98); // OLD HUNGARIAN SMALL LETTER EM, OLD HUNGARIAN CAPITAL LETTER EM
test(0x10CD9, 0x10C99); // OLD HUNGARIAN SMALL LETTER EN, OLD HUNGARIAN CAPITAL LETTER EN
test(0x10CDA, 0x10C9A); // OLD HUNGARIAN SMALL LETTER ENY, OLD HUNGARIAN CAPITAL LETTER ENY
test(0x10CDB, 0x10C9B); // OLD HUNGARIAN SMALL LETTER O, OLD HUNGARIAN CAPITAL LETTER O
test(0x10CDC, 0x10C9C); // OLD HUNGARIAN SMALL LETTER OO, OLD HUNGARIAN CAPITAL LETTER OO
test(0x10CDD, 0x10C9D); // OLD HUNGARIAN SMALL LETTER NIKOLSBURG OE, OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OE
test(0x10CDE, 0x10C9E); // OLD HUNGARIAN SMALL LETTER RUDIMENTA OE, OLD HUNGARIAN CAPITAL LETTER RUDIMENTA OE
test(0x10CDF, 0x10C9F); // OLD HUNGARIAN SMALL LETTER OEE, OLD HUNGARIAN CAPITAL LETTER OEE
test(0x10CE0, 0x10CA0); // OLD HUNGARIAN SMALL LETTER EP, OLD HUNGARIAN CAPITAL LETTER EP
test(0x10CE1, 0x10CA1); // OLD HUNGARIAN SMALL LETTER EMP, OLD HUNGARIAN CAPITAL LETTER EMP
test(0x10CE2, 0x10CA2); // OLD HUNGARIAN SMALL LETTER ER, OLD HUNGARIAN CAPITAL LETTER ER
test(0x10CE3, 0x10CA3); // OLD HUNGARIAN SMALL LETTER SHORT ER, OLD HUNGARIAN CAPITAL LETTER SHORT ER
test(0x10CE4, 0x10CA4); // OLD HUNGARIAN SMALL LETTER ES, OLD HUNGARIAN CAPITAL LETTER ES
test(0x10CE5, 0x10CA5); // OLD HUNGARIAN SMALL LETTER ESZ, OLD HUNGARIAN CAPITAL LETTER ESZ
test(0x10CE6, 0x10CA6); // OLD HUNGARIAN SMALL LETTER ET, OLD HUNGARIAN CAPITAL LETTER ET
test(0x10CE7, 0x10CA7); // OLD HUNGARIAN SMALL LETTER ENT, OLD HUNGARIAN CAPITAL LETTER ENT
test(0x10CE8, 0x10CA8); // OLD HUNGARIAN SMALL LETTER ETY, OLD HUNGARIAN CAPITAL LETTER ETY
test(0x10CE9, 0x10CA9); // OLD HUNGARIAN SMALL LETTER ECH, OLD HUNGARIAN CAPITAL LETTER ECH
test(0x10CEA, 0x10CAA); // OLD HUNGARIAN SMALL LETTER U, OLD HUNGARIAN CAPITAL LETTER U
test(0x10CEB, 0x10CAB); // OLD HUNGARIAN SMALL LETTER UU, OLD HUNGARIAN CAPITAL LETTER UU
test(0x10CEC, 0x10CAC); // OLD HUNGARIAN SMALL LETTER NIKOLSBURG UE, OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UE
test(0x10CED, 0x10CAD); // OLD HUNGARIAN SMALL LETTER RUDIMENTA UE, OLD HUNGARIAN CAPITAL LETTER RUDIMENTA UE
test(0x10CEE, 0x10CAE); // OLD HUNGARIAN SMALL LETTER EV, OLD HUNGARIAN CAPITAL LETTER EV
test(0x10CEF, 0x10CAF); // OLD HUNGARIAN SMALL LETTER EZ, OLD HUNGARIAN CAPITAL LETTER EZ
test(0x10CF0, 0x10CB0); // OLD HUNGARIAN SMALL LETTER EZS, OLD HUNGARIAN CAPITAL LETTER EZS
test(0x10CF1, 0x10CB1); // OLD HUNGARIAN SMALL LETTER ENT-SHAPED SIGN, OLD HUNGARIAN CAPITAL LETTER ENT-SHAPED SIGN
test(0x10CF2, 0x10CB2); // OLD HUNGARIAN SMALL LETTER US, OLD HUNGARIAN CAPITAL LETTER US
test(0x10D50, 0x10D70); // GARAY CAPITAL LETTER A, GARAY SMALL LETTER A
test(0x10D51, 0x10D71); // GARAY CAPITAL LETTER CA, GARAY SMALL LETTER CA
test(0x10D52, 0x10D72); // GARAY CAPITAL LETTER MA, GARAY SMALL LETTER MA
test(0x10D53, 0x10D73); // GARAY CAPITAL LETTER KA, GARAY SMALL LETTER KA
test(0x10D54, 0x10D74); // GARAY CAPITAL LETTER BA, GARAY SMALL LETTER BA
test(0x10D55, 0x10D75); // GARAY CAPITAL LETTER JA, GARAY SMALL LETTER JA
test(0x10D56, 0x10D76); // GARAY CAPITAL LETTER SA, GARAY SMALL LETTER SA
test(0x10D57, 0x10D77); // GARAY CAPITAL LETTER WA, GARAY SMALL LETTER WA
test(0x10D58, 0x10D78); // GARAY CAPITAL LETTER LA, GARAY SMALL LETTER LA
test(0x10D59, 0x10D79); // GARAY CAPITAL LETTER GA, GARAY SMALL LETTER GA
test(0x10D5A, 0x10D7A); // GARAY CAPITAL LETTER DA, GARAY SMALL LETTER DA
test(0x10D5B, 0x10D7B); // GARAY CAPITAL LETTER XA, GARAY SMALL LETTER XA
test(0x10D5C, 0x10D7C); // GARAY CAPITAL LETTER YA, GARAY SMALL LETTER YA
test(0x10D5D, 0x10D7D); // GARAY CAPITAL LETTER TA, GARAY SMALL LETTER TA
test(0x10D5E, 0x10D7E); // GARAY CAPITAL LETTER RA, GARAY SMALL LETTER RA
test(0x10D5F, 0x10D7F); // GARAY CAPITAL LETTER NYA, GARAY SMALL LETTER NYA
test(0x10D60, 0x10D80); // GARAY CAPITAL LETTER FA, GARAY SMALL LETTER FA
test(0x10D61, 0x10D81); // GARAY CAPITAL LETTER NA, GARAY SMALL LETTER NA
test(0x10D62, 0x10D82); // GARAY CAPITAL LETTER PA, GARAY SMALL LETTER PA
test(0x10D63, 0x10D83); // GARAY CAPITAL LETTER HA, GARAY SMALL LETTER HA
test(0x10D64, 0x10D84); // GARAY CAPITAL LETTER OLD KA, GARAY SMALL LETTER OLD KA
test(0x10D65, 0x10D85); // GARAY CAPITAL LETTER OLD NA, GARAY SMALL LETTER OLD NA
test(0x10D70, 0x10D50); // GARAY SMALL LETTER A, GARAY CAPITAL LETTER A
test(0x10D71, 0x10D51); // GARAY SMALL LETTER CA, GARAY CAPITAL LETTER CA
test(0x10D72, 0x10D52); // GARAY SMALL LETTER MA, GARAY CAPITAL LETTER MA
test(0x10D73, 0x10D53); // GARAY SMALL LETTER KA, GARAY CAPITAL LETTER KA
test(0x10D74, 0x10D54); // GARAY SMALL LETTER BA, GARAY CAPITAL LETTER BA
test(0x10D75, 0x10D55); // GARAY SMALL LETTER JA, GARAY CAPITAL LETTER JA
test(0x10D76, 0x10D56); // GARAY SMALL LETTER SA, GARAY CAPITAL LETTER SA
test(0x10D77, 0x10D57); // GARAY SMALL LETTER WA, GARAY CAPITAL LETTER WA
test(0x10D78, 0x10D58); // GARAY SMALL LETTER LA, GARAY CAPITAL LETTER LA
test(0x10D79, 0x10D59); // GARAY SMALL LETTER GA, GARAY CAPITAL LETTER GA
test(0x10D7A, 0x10D5A); // GARAY SMALL LETTER DA, GARAY CAPITAL LETTER DA
test(0x10D7B, 0x10D5B); // GARAY SMALL LETTER XA, GARAY CAPITAL LETTER XA
test(0x10D7C, 0x10D5C); // GARAY SMALL LETTER YA, GARAY CAPITAL LETTER YA
test(0x10D7D, 0x10D5D); // GARAY SMALL LETTER TA, GARAY CAPITAL LETTER TA
test(0x10D7E, 0x10D5E); // GARAY SMALL LETTER RA, GARAY CAPITAL LETTER RA
test(0x10D7F, 0x10D5F); // GARAY SMALL LETTER NYA, GARAY CAPITAL LETTER NYA
test(0x10D80, 0x10D60); // GARAY SMALL LETTER FA, GARAY CAPITAL LETTER FA
test(0x10D81, 0x10D61); // GARAY SMALL LETTER NA, GARAY CAPITAL LETTER NA
test(0x10D82, 0x10D62); // GARAY SMALL LETTER PA, GARAY CAPITAL LETTER PA
test(0x10D83, 0x10D63); // GARAY SMALL LETTER HA, GARAY CAPITAL LETTER HA
test(0x10D84, 0x10D64); // GARAY SMALL LETTER OLD KA, GARAY CAPITAL LETTER OLD KA
test(0x10D85, 0x10D65); // GARAY SMALL LETTER OLD NA, GARAY CAPITAL LETTER OLD NA
test(0x118A0, 0x118C0); // WARANG CITI CAPITAL LETTER NGAA, WARANG CITI SMALL LETTER NGAA
test(0x118A1, 0x118C1); // WARANG CITI CAPITAL LETTER A, WARANG CITI SMALL LETTER A
test(0x118A2, 0x118C2); // WARANG CITI CAPITAL LETTER WI, WARANG CITI SMALL LETTER WI
test(0x118A3, 0x118C3); // WARANG CITI CAPITAL LETTER YU, WARANG CITI SMALL LETTER YU
test(0x118A4, 0x118C4); // WARANG CITI CAPITAL LETTER YA, WARANG CITI SMALL LETTER YA
test(0x118A5, 0x118C5); // WARANG CITI CAPITAL LETTER YO, WARANG CITI SMALL LETTER YO
test(0x118A6, 0x118C6); // WARANG CITI CAPITAL LETTER II, WARANG CITI SMALL LETTER II
test(0x118A7, 0x118C7); // WARANG CITI CAPITAL LETTER UU, WARANG CITI SMALL LETTER UU
test(0x118A8, 0x118C8); // WARANG CITI CAPITAL LETTER E, WARANG CITI SMALL LETTER E
test(0x118A9, 0x118C9); // WARANG CITI CAPITAL LETTER O, WARANG CITI SMALL LETTER O
test(0x118AA, 0x118CA); // WARANG CITI CAPITAL LETTER ANG, WARANG CITI SMALL LETTER ANG
test(0x118AB, 0x118CB); // WARANG CITI CAPITAL LETTER GA, WARANG CITI SMALL LETTER GA
test(0x118AC, 0x118CC); // WARANG CITI CAPITAL LETTER KO, WARANG CITI SMALL LETTER KO
test(0x118AD, 0x118CD); // WARANG CITI CAPITAL LETTER ENY, WARANG CITI SMALL LETTER ENY
test(0x118AE, 0x118CE); // WARANG CITI CAPITAL LETTER YUJ, WARANG CITI SMALL LETTER YUJ
test(0x118AF, 0x118CF); // WARANG CITI CAPITAL LETTER UC, WARANG CITI SMALL LETTER UC
test(0x118B0, 0x118D0); // WARANG CITI CAPITAL LETTER ENN, WARANG CITI SMALL LETTER ENN
test(0x118B1, 0x118D1); // WARANG CITI CAPITAL LETTER ODD, WARANG CITI SMALL LETTER ODD
test(0x118B2, 0x118D2); // WARANG CITI CAPITAL LETTER TTE, WARANG CITI SMALL LETTER TTE
test(0x118B3, 0x118D3); // WARANG CITI CAPITAL LETTER NUNG, WARANG CITI SMALL LETTER NUNG
test(0x118B4, 0x118D4); // WARANG CITI CAPITAL LETTER DA, WARANG CITI SMALL LETTER DA
test(0x118B5, 0x118D5); // WARANG CITI CAPITAL LETTER AT, WARANG CITI SMALL LETTER AT
test(0x118B6, 0x118D6); // WARANG CITI CAPITAL LETTER AM, WARANG CITI SMALL LETTER AM
test(0x118B7, 0x118D7); // WARANG CITI CAPITAL LETTER BU, WARANG CITI SMALL LETTER BU
test(0x118B8, 0x118D8); // WARANG CITI CAPITAL LETTER PU, WARANG CITI SMALL LETTER PU
test(0x118B9, 0x118D9); // WARANG CITI CAPITAL LETTER HIYO, WARANG CITI SMALL LETTER HIYO
test(0x118BA, 0x118DA); // WARANG CITI CAPITAL LETTER HOLO, WARANG CITI SMALL LETTER HOLO
test(0x118BB, 0x118DB); // WARANG CITI CAPITAL LETTER HORR, WARANG CITI SMALL LETTER HORR
test(0x118BC, 0x118DC); // WARANG CITI CAPITAL LETTER HAR, WARANG CITI SMALL LETTER HAR
test(0x118BD, 0x118DD); // WARANG CITI CAPITAL LETTER SSUU, WARANG CITI SMALL LETTER SSUU
test(0x118BE, 0x118DE); // WARANG CITI CAPITAL LETTER SII, WARANG CITI SMALL LETTER SII
test(0x118BF, 0x118DF); // WARANG CITI CAPITAL LETTER VIYO, WARANG CITI SMALL LETTER VIYO
test(0x118C0, 0x118A0); // WARANG CITI SMALL LETTER NGAA, WARANG CITI CAPITAL LETTER NGAA
test(0x118C1, 0x118A1); // WARANG CITI SMALL LETTER A, WARANG CITI CAPITAL LETTER A
test(0x118C2, 0x118A2); // WARANG CITI SMALL LETTER WI, WARANG CITI CAPITAL LETTER WI
test(0x118C3, 0x118A3); // WARANG CITI SMALL LETTER YU, WARANG CITI CAPITAL LETTER YU
test(0x118C4, 0x118A4); // WARANG CITI SMALL LETTER YA, WARANG CITI CAPITAL LETTER YA
test(0x118C5, 0x118A5); // WARANG CITI SMALL LETTER YO, WARANG CITI CAPITAL LETTER YO
test(0x118C6, 0x118A6); // WARANG CITI SMALL LETTER II, WARANG CITI CAPITAL LETTER II
test(0x118C7, 0x118A7); // WARANG CITI SMALL LETTER UU, WARANG CITI CAPITAL LETTER UU
test(0x118C8, 0x118A8); // WARANG CITI SMALL LETTER E, WARANG CITI CAPITAL LETTER E
test(0x118C9, 0x118A9); // WARANG CITI SMALL LETTER O, WARANG CITI CAPITAL LETTER O
test(0x118CA, 0x118AA); // WARANG CITI SMALL LETTER ANG, WARANG CITI CAPITAL LETTER ANG
test(0x118CB, 0x118AB); // WARANG CITI SMALL LETTER GA, WARANG CITI CAPITAL LETTER GA
test(0x118CC, 0x118AC); // WARANG CITI SMALL LETTER KO, WARANG CITI CAPITAL LETTER KO
test(0x118CD, 0x118AD); // WARANG CITI SMALL LETTER ENY, WARANG CITI CAPITAL LETTER ENY
test(0x118CE, 0x118AE); // WARANG CITI SMALL LETTER YUJ, WARANG CITI CAPITAL LETTER YUJ
test(0x118CF, 0x118AF); // WARANG CITI SMALL LETTER UC, WARANG CITI CAPITAL LETTER UC
test(0x118D0, 0x118B0); // WARANG CITI SMALL LETTER ENN, WARANG CITI CAPITAL LETTER ENN
test(0x118D1, 0x118B1); // WARANG CITI SMALL LETTER ODD, WARANG CITI CAPITAL LETTER ODD
test(0x118D2, 0x118B2); // WARANG CITI SMALL LETTER TTE, WARANG CITI CAPITAL LETTER TTE
test(0x118D3, 0x118B3); // WARANG CITI SMALL LETTER NUNG, WARANG CITI CAPITAL LETTER NUNG
test(0x118D4, 0x118B4); // WARANG CITI SMALL LETTER DA, WARANG CITI CAPITAL LETTER DA
test(0x118D5, 0x118B5); // WARANG CITI SMALL LETTER AT, WARANG CITI CAPITAL LETTER AT
test(0x118D6, 0x118B6); // WARANG CITI SMALL LETTER AM, WARANG CITI CAPITAL LETTER AM
test(0x118D7, 0x118B7); // WARANG CITI SMALL LETTER BU, WARANG CITI CAPITAL LETTER BU
test(0x118D8, 0x118B8); // WARANG CITI SMALL LETTER PU, WARANG CITI CAPITAL LETTER PU
test(0x118D9, 0x118B9); // WARANG CITI SMALL LETTER HIYO, WARANG CITI CAPITAL LETTER HIYO
test(0x118DA, 0x118BA); // WARANG CITI SMALL LETTER HOLO, WARANG CITI CAPITAL LETTER HOLO
test(0x118DB, 0x118BB); // WARANG CITI SMALL LETTER HORR, WARANG CITI CAPITAL LETTER HORR
test(0x118DC, 0x118BC); // WARANG CITI SMALL LETTER HAR, WARANG CITI CAPITAL LETTER HAR
test(0x118DD, 0x118BD); // WARANG CITI SMALL LETTER SSUU, WARANG CITI CAPITAL LETTER SSUU
test(0x118DE, 0x118BE); // WARANG CITI SMALL LETTER SII, WARANG CITI CAPITAL LETTER SII
test(0x118DF, 0x118BF); // WARANG CITI SMALL LETTER VIYO, WARANG CITI CAPITAL LETTER VIYO
test(0x16E40, 0x16E60); // MEDEFAIDRIN CAPITAL LETTER M, MEDEFAIDRIN SMALL LETTER M
test(0x16E41, 0x16E61); // MEDEFAIDRIN CAPITAL LETTER S, MEDEFAIDRIN SMALL LETTER S
test(0x16E42, 0x16E62); // MEDEFAIDRIN CAPITAL LETTER V, MEDEFAIDRIN SMALL LETTER V
test(0x16E43, 0x16E63); // MEDEFAIDRIN CAPITAL LETTER W, MEDEFAIDRIN SMALL LETTER W
test(0x16E44, 0x16E64); // MEDEFAIDRIN CAPITAL LETTER ATIU, MEDEFAIDRIN SMALL LETTER ATIU
test(0x16E45, 0x16E65); // MEDEFAIDRIN CAPITAL LETTER Z, MEDEFAIDRIN SMALL LETTER Z
test(0x16E46, 0x16E66); // MEDEFAIDRIN CAPITAL LETTER KP, MEDEFAIDRIN SMALL LETTER KP
test(0x16E47, 0x16E67); // MEDEFAIDRIN CAPITAL LETTER P, MEDEFAIDRIN SMALL LETTER P
test(0x16E48, 0x16E68); // MEDEFAIDRIN CAPITAL LETTER T, MEDEFAIDRIN SMALL LETTER T
test(0x16E49, 0x16E69); // MEDEFAIDRIN CAPITAL LETTER G, MEDEFAIDRIN SMALL LETTER G
test(0x16E4A, 0x16E6A); // MEDEFAIDRIN CAPITAL LETTER F, MEDEFAIDRIN SMALL LETTER F
test(0x16E4B, 0x16E6B); // MEDEFAIDRIN CAPITAL LETTER I, MEDEFAIDRIN SMALL LETTER I
test(0x16E4C, 0x16E6C); // MEDEFAIDRIN CAPITAL LETTER K, MEDEFAIDRIN SMALL LETTER K
test(0x16E4D, 0x16E6D); // MEDEFAIDRIN CAPITAL LETTER A, MEDEFAIDRIN SMALL LETTER A
test(0x16E4E, 0x16E6E); // MEDEFAIDRIN CAPITAL LETTER J, MEDEFAIDRIN SMALL LETTER J
test(0x16E4F, 0x16E6F); // MEDEFAIDRIN CAPITAL LETTER E, MEDEFAIDRIN SMALL LETTER E
test(0x16E50, 0x16E70); // MEDEFAIDRIN CAPITAL LETTER B, MEDEFAIDRIN SMALL LETTER B
test(0x16E51, 0x16E71); // MEDEFAIDRIN CAPITAL LETTER C, MEDEFAIDRIN SMALL LETTER C
test(0x16E52, 0x16E72); // MEDEFAIDRIN CAPITAL LETTER U, MEDEFAIDRIN SMALL LETTER U
test(0x16E53, 0x16E73); // MEDEFAIDRIN CAPITAL LETTER YU, MEDEFAIDRIN SMALL LETTER YU
test(0x16E54, 0x16E74); // MEDEFAIDRIN CAPITAL LETTER L, MEDEFAIDRIN SMALL LETTER L
test(0x16E55, 0x16E75); // MEDEFAIDRIN CAPITAL LETTER Q, MEDEFAIDRIN SMALL LETTER Q
test(0x16E56, 0x16E76); // MEDEFAIDRIN CAPITAL LETTER HP, MEDEFAIDRIN SMALL LETTER HP
test(0x16E57, 0x16E77); // MEDEFAIDRIN CAPITAL LETTER NY, MEDEFAIDRIN SMALL LETTER NY
test(0x16E58, 0x16E78); // MEDEFAIDRIN CAPITAL LETTER X, MEDEFAIDRIN SMALL LETTER X
test(0x16E59, 0x16E79); // MEDEFAIDRIN CAPITAL LETTER D, MEDEFAIDRIN SMALL LETTER D
test(0x16E5A, 0x16E7A); // MEDEFAIDRIN CAPITAL LETTER OE, MEDEFAIDRIN SMALL LETTER OE
test(0x16E5B, 0x16E7B); // MEDEFAIDRIN CAPITAL LETTER N, MEDEFAIDRIN SMALL LETTER N
test(0x16E5C, 0x16E7C); // MEDEFAIDRIN CAPITAL LETTER R, MEDEFAIDRIN SMALL LETTER R
test(0x16E5D, 0x16E7D); // MEDEFAIDRIN CAPITAL LETTER O, MEDEFAIDRIN SMALL LETTER O
test(0x16E5E, 0x16E7E); // MEDEFAIDRIN CAPITAL LETTER AI, MEDEFAIDRIN SMALL LETTER AI
test(0x16E5F, 0x16E7F); // MEDEFAIDRIN CAPITAL LETTER Y, MEDEFAIDRIN SMALL LETTER Y
test(0x16E60, 0x16E40); // MEDEFAIDRIN SMALL LETTER M, MEDEFAIDRIN CAPITAL LETTER M
test(0x16E61, 0x16E41); // MEDEFAIDRIN SMALL LETTER S, MEDEFAIDRIN CAPITAL LETTER S
test(0x16E62, 0x16E42); // MEDEFAIDRIN SMALL LETTER V, MEDEFAIDRIN CAPITAL LETTER V
test(0x16E63, 0x16E43); // MEDEFAIDRIN SMALL LETTER W, MEDEFAIDRIN CAPITAL LETTER W
test(0x16E64, 0x16E44); // MEDEFAIDRIN SMALL LETTER ATIU, MEDEFAIDRIN CAPITAL LETTER ATIU
test(0x16E65, 0x16E45); // MEDEFAIDRIN SMALL LETTER Z, MEDEFAIDRIN CAPITAL LETTER Z
test(0x16E66, 0x16E46); // MEDEFAIDRIN SMALL LETTER KP, MEDEFAIDRIN CAPITAL LETTER KP
test(0x16E67, 0x16E47); // MEDEFAIDRIN SMALL LETTER P, MEDEFAIDRIN CAPITAL LETTER P
test(0x16E68, 0x16E48); // MEDEFAIDRIN SMALL LETTER T, MEDEFAIDRIN CAPITAL LETTER T
test(0x16E69, 0x16E49); // MEDEFAIDRIN SMALL LETTER G, MEDEFAIDRIN CAPITAL LETTER G
test(0x16E6A, 0x16E4A); // MEDEFAIDRIN SMALL LETTER F, MEDEFAIDRIN CAPITAL LETTER F
test(0x16E6B, 0x16E4B); // MEDEFAIDRIN SMALL LETTER I, MEDEFAIDRIN CAPITAL LETTER I
test(0x16E6C, 0x16E4C); // MEDEFAIDRIN SMALL LETTER K, MEDEFAIDRIN CAPITAL LETTER K
test(0x16E6D, 0x16E4D); // MEDEFAIDRIN SMALL LETTER A, MEDEFAIDRIN CAPITAL LETTER A
test(0x16E6E, 0x16E4E); // MEDEFAIDRIN SMALL LETTER J, MEDEFAIDRIN CAPITAL LETTER J
test(0x16E6F, 0x16E4F); // MEDEFAIDRIN SMALL LETTER E, MEDEFAIDRIN CAPITAL LETTER E
test(0x16E70, 0x16E50); // MEDEFAIDRIN SMALL LETTER B, MEDEFAIDRIN CAPITAL LETTER B
test(0x16E71, 0x16E51); // MEDEFAIDRIN SMALL LETTER C, MEDEFAIDRIN CAPITAL LETTER C
test(0x16E72, 0x16E52); // MEDEFAIDRIN SMALL LETTER U, MEDEFAIDRIN CAPITAL LETTER U
test(0x16E73, 0x16E53); // MEDEFAIDRIN SMALL LETTER YU, MEDEFAIDRIN CAPITAL LETTER YU
test(0x16E74, 0x16E54); // MEDEFAIDRIN SMALL LETTER L, MEDEFAIDRIN CAPITAL LETTER L
test(0x16E75, 0x16E55); // MEDEFAIDRIN SMALL LETTER Q, MEDEFAIDRIN CAPITAL LETTER Q
test(0x16E76, 0x16E56); // MEDEFAIDRIN SMALL LETTER HP, MEDEFAIDRIN CAPITAL LETTER HP
test(0x16E77, 0x16E57); // MEDEFAIDRIN SMALL LETTER NY, MEDEFAIDRIN CAPITAL LETTER NY
test(0x16E78, 0x16E58); // MEDEFAIDRIN SMALL LETTER X, MEDEFAIDRIN CAPITAL LETTER X
test(0x16E79, 0x16E59); // MEDEFAIDRIN SMALL LETTER D, MEDEFAIDRIN CAPITAL LETTER D
test(0x16E7A, 0x16E5A); // MEDEFAIDRIN SMALL LETTER OE, MEDEFAIDRIN CAPITAL LETTER OE
test(0x16E7B, 0x16E5B); // MEDEFAIDRIN SMALL LETTER N, MEDEFAIDRIN CAPITAL LETTER N
test(0x16E7C, 0x16E5C); // MEDEFAIDRIN SMALL LETTER R, MEDEFAIDRIN CAPITAL LETTER R
test(0x16E7D, 0x16E5D); // MEDEFAIDRIN SMALL LETTER O, MEDEFAIDRIN CAPITAL LETTER O
test(0x16E7E, 0x16E5E); // MEDEFAIDRIN SMALL LETTER AI, MEDEFAIDRIN CAPITAL LETTER AI
test(0x16E7F, 0x16E5F); // MEDEFAIDRIN SMALL LETTER Y, MEDEFAIDRIN CAPITAL LETTER Y
test(0x16EA0, 0x16EBB); // BERIA ERFE CAPITAL LETTER ARKAB, BERIA ERFE SMALL LETTER ARKAB
test(0x16EA1, 0x16EBC); // BERIA ERFE CAPITAL LETTER BASIGNA, BERIA ERFE SMALL LETTER BASIGNA
test(0x16EA2, 0x16EBD); // BERIA ERFE CAPITAL LETTER DARBAI, BERIA ERFE SMALL LETTER DARBAI
test(0x16EA3, 0x16EBE); // BERIA ERFE CAPITAL LETTER EH, BERIA ERFE SMALL LETTER EH
test(0x16EA4, 0x16EBF); // BERIA ERFE CAPITAL LETTER FITKO, BERIA ERFE SMALL LETTER FITKO
test(0x16EA5, 0x16EC0); // BERIA ERFE CAPITAL LETTER GOWAY, BERIA ERFE SMALL LETTER GOWAY
test(0x16EA6, 0x16EC1); // BERIA ERFE CAPITAL LETTER HIRDEABO, BERIA ERFE SMALL LETTER HIRDEABO
test(0x16EA7, 0x16EC2); // BERIA ERFE CAPITAL LETTER I, BERIA ERFE SMALL LETTER I
test(0x16EA8, 0x16EC3); // BERIA ERFE CAPITAL LETTER DJAI, BERIA ERFE SMALL LETTER DJAI
test(0x16EA9, 0x16EC4); // BERIA ERFE CAPITAL LETTER KOBO, BERIA ERFE SMALL LETTER KOBO
test(0x16EAA, 0x16EC5); // BERIA ERFE CAPITAL LETTER LAKKO, BERIA ERFE SMALL LETTER LAKKO
test(0x16EAB, 0x16EC6); // BERIA ERFE CAPITAL LETTER MERI, BERIA ERFE SMALL LETTER MERI
test(0x16EAC, 0x16EC7); // BERIA ERFE CAPITAL LETTER NINI, BERIA ERFE SMALL LETTER NINI
test(0x16EAD, 0x16EC8); // BERIA ERFE CAPITAL LETTER GNA, BERIA ERFE SMALL LETTER GNA
test(0x16EAE, 0x16EC9); // BERIA ERFE CAPITAL LETTER NGAY, BERIA ERFE SMALL LETTER NGAY
test(0x16EAF, 0x16ECA); // BERIA ERFE CAPITAL LETTER OI, BERIA ERFE SMALL LETTER OI
test(0x16EB0, 0x16ECB); // BERIA ERFE CAPITAL LETTER PI, BERIA ERFE SMALL LETTER PI
test(0x16EB1, 0x16ECC); // BERIA ERFE CAPITAL LETTER ERIGO, BERIA ERFE SMALL LETTER ERIGO
test(0x16EB2, 0x16ECD); // BERIA ERFE CAPITAL LETTER ERIGO TAMURA, BERIA ERFE SMALL LETTER ERIGO TAMURA
test(0x16EB3, 0x16ECE); // BERIA ERFE CAPITAL LETTER SERI, BERIA ERFE SMALL LETTER SERI
test(0x16EB4, 0x16ECF); // BERIA ERFE CAPITAL LETTER SHEP, BERIA ERFE SMALL LETTER SHEP
test(0x16EB5, 0x16ED0); // BERIA ERFE CAPITAL LETTER TATASOUE, BERIA ERFE SMALL LETTER TATASOUE
test(0x16EB6, 0x16ED1); // BERIA ERFE CAPITAL LETTER UI, BERIA ERFE SMALL LETTER UI
test(0x16EB7, 0x16ED2); // BERIA ERFE CAPITAL LETTER WASSE, BERIA ERFE SMALL LETTER WASSE
test(0x16EB8, 0x16ED3); // BERIA ERFE CAPITAL LETTER AY, BERIA ERFE SMALL LETTER AY
test(0x16EBB, 0x16EA0); // BERIA ERFE SMALL LETTER ARKAB, BERIA ERFE CAPITAL LETTER ARKAB
test(0x16EBC, 0x16EA1); // BERIA ERFE SMALL LETTER BASIGNA, BERIA ERFE CAPITAL LETTER BASIGNA
test(0x16EBD, 0x16EA2); // BERIA ERFE SMALL LETTER DARBAI, BERIA ERFE CAPITAL LETTER DARBAI
test(0x16EBE, 0x16EA3); // BERIA ERFE SMALL LETTER EH, BERIA ERFE CAPITAL LETTER EH
test(0x16EBF, 0x16EA4); // BERIA ERFE SMALL LETTER FITKO, BERIA ERFE CAPITAL LETTER FITKO
test(0x16EC0, 0x16EA5); // BERIA ERFE SMALL LETTER GOWAY, BERIA ERFE CAPITAL LETTER GOWAY
test(0x16EC1, 0x16EA6); // BERIA ERFE SMALL LETTER HIRDEABO, BERIA ERFE CAPITAL LETTER HIRDEABO
test(0x16EC2, 0x16EA7); // BERIA ERFE SMALL LETTER I, BERIA ERFE CAPITAL LETTER I
test(0x16EC3, 0x16EA8); // BERIA ERFE SMALL LETTER DJAI, BERIA ERFE CAPITAL LETTER DJAI
test(0x16EC4, 0x16EA9); // BERIA ERFE SMALL LETTER KOBO, BERIA ERFE CAPITAL LETTER KOBO
test(0x16EC5, 0x16EAA); // BERIA ERFE SMALL LETTER LAKKO, BERIA ERFE CAPITAL LETTER LAKKO
test(0x16EC6, 0x16EAB); // BERIA ERFE SMALL LETTER MERI, BERIA ERFE CAPITAL LETTER MERI
test(0x16EC7, 0x16EAC); // BERIA ERFE SMALL LETTER NINI, BERIA ERFE CAPITAL LETTER NINI
test(0x16EC8, 0x16EAD); // BERIA ERFE SMALL LETTER GNA, BERIA ERFE CAPITAL LETTER GNA
test(0x16EC9, 0x16EAE); // BERIA ERFE SMALL LETTER NGAY, BERIA ERFE CAPITAL LETTER NGAY
test(0x16ECA, 0x16EAF); // BERIA ERFE SMALL LETTER OI, BERIA ERFE CAPITAL LETTER OI
test(0x16ECB, 0x16EB0); // BERIA ERFE SMALL LETTER PI, BERIA ERFE CAPITAL LETTER PI
test(0x16ECC, 0x16EB1); // BERIA ERFE SMALL LETTER ERIGO, BERIA ERFE CAPITAL LETTER ERIGO
test(0x16ECD, 0x16EB2); // BERIA ERFE SMALL LETTER ERIGO TAMURA, BERIA ERFE CAPITAL LETTER ERIGO TAMURA
test(0x16ECE, 0x16EB3); // BERIA ERFE SMALL LETTER SERI, BERIA ERFE CAPITAL LETTER SERI
test(0x16ECF, 0x16EB4); // BERIA ERFE SMALL LETTER SHEP, BERIA ERFE CAPITAL LETTER SHEP
test(0x16ED0, 0x16EB5); // BERIA ERFE SMALL LETTER TATASOUE, BERIA ERFE CAPITAL LETTER TATASOUE
test(0x16ED1, 0x16EB6); // BERIA ERFE SMALL LETTER UI, BERIA ERFE CAPITAL LETTER UI
test(0x16ED2, 0x16EB7); // BERIA ERFE SMALL LETTER WASSE, BERIA ERFE CAPITAL LETTER WASSE
test(0x16ED3, 0x16EB8); // BERIA ERFE SMALL LETTER AY, BERIA ERFE CAPITAL LETTER AY
test(0x1E900, 0x1E922); // ADLAM CAPITAL LETTER ALIF, ADLAM SMALL LETTER ALIF
test(0x1E901, 0x1E923); // ADLAM CAPITAL LETTER DAALI, ADLAM SMALL LETTER DAALI
test(0x1E902, 0x1E924); // ADLAM CAPITAL LETTER LAAM, ADLAM SMALL LETTER LAAM
test(0x1E903, 0x1E925); // ADLAM CAPITAL LETTER MIIM, ADLAM SMALL LETTER MIIM
test(0x1E904, 0x1E926); // ADLAM CAPITAL LETTER BA, ADLAM SMALL LETTER BA
test(0x1E905, 0x1E927); // ADLAM CAPITAL LETTER SINNYIIYHE, ADLAM SMALL LETTER SINNYIIYHE
test(0x1E906, 0x1E928); // ADLAM CAPITAL LETTER PE, ADLAM SMALL LETTER PE
test(0x1E907, 0x1E929); // ADLAM CAPITAL LETTER BHE, ADLAM SMALL LETTER BHE
test(0x1E908, 0x1E92A); // ADLAM CAPITAL LETTER RA, ADLAM SMALL LETTER RA
test(0x1E909, 0x1E92B); // ADLAM CAPITAL LETTER E, ADLAM SMALL LETTER E
test(0x1E90A, 0x1E92C); // ADLAM CAPITAL LETTER FA, ADLAM SMALL LETTER FA
test(0x1E90B, 0x1E92D); // ADLAM CAPITAL LETTER I, ADLAM SMALL LETTER I
test(0x1E90C, 0x1E92E); // ADLAM CAPITAL LETTER O, ADLAM SMALL LETTER O
test(0x1E90D, 0x1E92F); // ADLAM CAPITAL LETTER DHA, ADLAM SMALL LETTER DHA
test(0x1E90E, 0x1E930); // ADLAM CAPITAL LETTER YHE, ADLAM SMALL LETTER YHE
test(0x1E90F, 0x1E931); // ADLAM CAPITAL LETTER WAW, ADLAM SMALL LETTER WAW
test(0x1E910, 0x1E932); // ADLAM CAPITAL LETTER NUN, ADLAM SMALL LETTER NUN
test(0x1E911, 0x1E933); // ADLAM CAPITAL LETTER KAF, ADLAM SMALL LETTER KAF
test(0x1E912, 0x1E934); // ADLAM CAPITAL LETTER YA, ADLAM SMALL LETTER YA
test(0x1E913, 0x1E935); // ADLAM CAPITAL LETTER U, ADLAM SMALL LETTER U
test(0x1E914, 0x1E936); // ADLAM CAPITAL LETTER JIIM, ADLAM SMALL LETTER JIIM
test(0x1E915, 0x1E937); // ADLAM CAPITAL LETTER CHI, ADLAM SMALL LETTER CHI
test(0x1E916, 0x1E938); // ADLAM CAPITAL LETTER HA, ADLAM SMALL LETTER HA
test(0x1E917, 0x1E939); // ADLAM CAPITAL LETTER QAAF, ADLAM SMALL LETTER QAAF
test(0x1E918, 0x1E93A); // ADLAM CAPITAL LETTER GA, ADLAM SMALL LETTER GA
test(0x1E919, 0x1E93B); // ADLAM CAPITAL LETTER NYA, ADLAM SMALL LETTER NYA
test(0x1E91A, 0x1E93C); // ADLAM CAPITAL LETTER TU, ADLAM SMALL LETTER TU
test(0x1E91B, 0x1E93D); // ADLAM CAPITAL LETTER NHA, ADLAM SMALL LETTER NHA
test(0x1E91C, 0x1E93E); // ADLAM CAPITAL LETTER VA, ADLAM SMALL LETTER VA
test(0x1E91D, 0x1E93F); // ADLAM CAPITAL LETTER KHA, ADLAM SMALL LETTER KHA
test(0x1E91E, 0x1E940); // ADLAM CAPITAL LETTER GBE, ADLAM SMALL LETTER GBE
test(0x1E91F, 0x1E941); // ADLAM CAPITAL LETTER ZAL, ADLAM SMALL LETTER ZAL
test(0x1E920, 0x1E942); // ADLAM CAPITAL LETTER KPO, ADLAM SMALL LETTER KPO
test(0x1E921, 0x1E943); // ADLAM CAPITAL LETTER SHA, ADLAM SMALL LETTER SHA
test(0x1E922, 0x1E900); // ADLAM SMALL LETTER ALIF, ADLAM CAPITAL LETTER ALIF
test(0x1E923, 0x1E901); // ADLAM SMALL LETTER DAALI, ADLAM CAPITAL LETTER DAALI
test(0x1E924, 0x1E902); // ADLAM SMALL LETTER LAAM, ADLAM CAPITAL LETTER LAAM
test(0x1E925, 0x1E903); // ADLAM SMALL LETTER MIIM, ADLAM CAPITAL LETTER MIIM
test(0x1E926, 0x1E904); // ADLAM SMALL LETTER BA, ADLAM CAPITAL LETTER BA
test(0x1E927, 0x1E905); // ADLAM SMALL LETTER SINNYIIYHE, ADLAM CAPITAL LETTER SINNYIIYHE
test(0x1E928, 0x1E906); // ADLAM SMALL LETTER PE, ADLAM CAPITAL LETTER PE
test(0x1E929, 0x1E907); // ADLAM SMALL LETTER BHE, ADLAM CAPITAL LETTER BHE
test(0x1E92A, 0x1E908); // ADLAM SMALL LETTER RA, ADLAM CAPITAL LETTER RA
test(0x1E92B, 0x1E909); // ADLAM SMALL LETTER E, ADLAM CAPITAL LETTER E
test(0x1E92C, 0x1E90A); // ADLAM SMALL LETTER FA, ADLAM CAPITAL LETTER FA
test(0x1E92D, 0x1E90B); // ADLAM SMALL LETTER I, ADLAM CAPITAL LETTER I
test(0x1E92E, 0x1E90C); // ADLAM SMALL LETTER O, ADLAM CAPITAL LETTER O
test(0x1E92F, 0x1E90D); // ADLAM SMALL LETTER DHA, ADLAM CAPITAL LETTER DHA
test(0x1E930, 0x1E90E); // ADLAM SMALL LETTER YHE, ADLAM CAPITAL LETTER YHE
test(0x1E931, 0x1E90F); // ADLAM SMALL LETTER WAW, ADLAM CAPITAL LETTER WAW
test(0x1E932, 0x1E910); // ADLAM SMALL LETTER NUN, ADLAM CAPITAL LETTER NUN
test(0x1E933, 0x1E911); // ADLAM SMALL LETTER KAF, ADLAM CAPITAL LETTER KAF
test(0x1E934, 0x1E912); // ADLAM SMALL LETTER YA, ADLAM CAPITAL LETTER YA
test(0x1E935, 0x1E913); // ADLAM SMALL LETTER U, ADLAM CAPITAL LETTER U
test(0x1E936, 0x1E914); // ADLAM SMALL LETTER JIIM, ADLAM CAPITAL LETTER JIIM
test(0x1E937, 0x1E915); // ADLAM SMALL LETTER CHI, ADLAM CAPITAL LETTER CHI
test(0x1E938, 0x1E916); // ADLAM SMALL LETTER HA, ADLAM CAPITAL LETTER HA
test(0x1E939, 0x1E917); // ADLAM SMALL LETTER QAAF, ADLAM CAPITAL LETTER QAAF
test(0x1E93A, 0x1E918); // ADLAM SMALL LETTER GA, ADLAM CAPITAL LETTER GA
test(0x1E93B, 0x1E919); // ADLAM SMALL LETTER NYA, ADLAM CAPITAL LETTER NYA
test(0x1E93C, 0x1E91A); // ADLAM SMALL LETTER TU, ADLAM CAPITAL LETTER TU
test(0x1E93D, 0x1E91B); // ADLAM SMALL LETTER NHA, ADLAM CAPITAL LETTER NHA
test(0x1E93E, 0x1E91C); // ADLAM SMALL LETTER VA, ADLAM CAPITAL LETTER VA
test(0x1E93F, 0x1E91D); // ADLAM SMALL LETTER KHA, ADLAM CAPITAL LETTER KHA
test(0x1E940, 0x1E91E); // ADLAM SMALL LETTER GBE, ADLAM CAPITAL LETTER GBE
test(0x1E941, 0x1E91F); // ADLAM SMALL LETTER ZAL, ADLAM CAPITAL LETTER ZAL
test(0x1E942, 0x1E920); // ADLAM SMALL LETTER KPO, ADLAM CAPITAL LETTER KPO
test(0x1E943, 0x1E921); // ADLAM SMALL LETTER SHA, ADLAM CAPITAL LETTER SHA

if (typeof reportCompare === "function")
    reportCompare(true, true);
